/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.relate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.relate.WTCRelatePanelSetFactory;
import kd.wtc.wtbs.common.cache.relate.WTCAppCache;
import kd.wtc.wtbs.common.cache.relate.WTCPageCache;
import kd.wtc.wtbs.common.enums.AttFileRelateEnum;
import kd.wtc.wtbs.common.model.relate.RelatePageInfo;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCLeftRelateService {
    private static final Log logger = LogFactory.getLog(WTCLeftRelateService.class);
    private static final List<String> ATTPERSONPERMLIST = Arrays.asList("wtp_attendperson", "wtp_managescope", "wtp_depempjob");

    public static boolean isShowTopCommonSearch(IFormView view) {
        Object flag = view.getFormShowParameter().getCustomParams().get("is_show_top_common_search");
        return flag != null && Boolean.parseBoolean(flag.toString());
    }

    public static void buildLeft(LoadCustomControlMetasArgs args) {
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        String relateEntityTypeId = (String)showParameter.getCustomParam("wtbs_entitytype_id");
        String appNumber = (String)showParameter.getCustomParam("appName");
        logger.info("createRelatePageInfoPanelAp1,appNumber={}", (Object)appNumber);
        FlexPanelAp headPanelAp = WTCLeftRelateService.createRelatePageInfoPanelAp(appNumber, relateEntityTypeId);
        HashMap mapHead = Maps.newHashMapWithExpectedSize((int)16);
        mapHead.put("id", "flexpanelrelateinfo");
        mapHead.put("items", headPanelAp.createControl().get("items"));
        args.getItems().add(mapHead);
    }

    public static void setSelectRelatePageLabelStyle(IFormView view, String labelNumber, Map<String, String> pageIconMap) {
        String relateEntityTypeId = (String)view.getFormShowParameter().getCustomParam("wtbs_entitytype_id");
        String appNumber = (String)view.getFormShowParameter().getCustomParam("appName");
        WTCLeftRelateService.clearNotSelected(view, labelNumber, pageIconMap, appNumber, relateEntityTypeId);
        RelatePageInfo relatePageInfo = WTCRelatePanelSetFactory.getRelatePageInfo(appNumber, relateEntityTypeId, labelNumber);
        if (relatePageInfo == null) {
            return;
        }
        LabelAp selectLabelAp = WTCLeftRelateService.assembleSelectRelatePageLabelAp(relatePageInfo);
        view.updateControlMetadata(selectLabelAp.getKey(), selectLabelAp.createControl());
        FlexPanelAp selectFlexPanelAp = WTCLeftRelateService.assembleSelectRelatePanelAp(relatePageInfo.getPageNumber() + "panel");
        selectFlexPanelAp.getItems().add(selectLabelAp);
        if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(relatePageInfo.getPageNumber())) {
            ImageAp pageIconAp = WTCLeftRelateService.assembleImageAp(relatePageInfo.getPageNumber(), pageIconMap);
            selectFlexPanelAp.getItems().add(pageIconAp);
        }
        view.updateControlMetadata(selectFlexPanelAp.getKey(), selectFlexPanelAp.createControl());
    }

    private static void clearNotSelected(IFormView view, String labelNumber, Map<String, String> pageIconMap, String appNumber, String relateEntityTypeId) {
        List<RelatePageInfo> pageInfoList = WTCRelatePanelSetFactory.getRelatePageInfoList(appNumber, relateEntityTypeId);
        for (RelatePageInfo pageInfo : pageInfoList) {
            RelatePageInfo relatePageInfo = pageInfo;
            if (labelNumber.equals(relatePageInfo.getPageNumber())) continue;
            LabelAp relateLabelPanelAp = WTCLeftRelateService.assembleRelatePageLabelAp(relatePageInfo);
            view.updateControlMetadata(relateLabelPanelAp.getKey(), relateLabelPanelAp.createControl());
            FlexPanelAp relatePanelAp = WTCLeftRelateService.assembleRelatePanelAp(relatePageInfo.getPageNumber() + "panel");
            relatePanelAp.getItems().add(relateLabelPanelAp);
            if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(relatePageInfo.getPageNumber())) {
                ImageAp pageIconAp = WTCLeftRelateService.assembleImageAp(relatePageInfo.getPageNumber(), pageIconMap);
                relatePanelAp.getItems().add(pageIconAp);
            }
            relatePanelAp.setBackColor("#ffffff");
            view.updateControlMetadata(relatePanelAp.getKey(), relatePanelAp.createControl());
        }
    }

    public static void showRelatedPageInContainer(IFormView view, String pageId, boolean isShowTopCommonSearch) {
        String originalRelatedPageId = pageId;
        String relateEntityTypeId = (String)view.getFormShowParameter().getCustomParam("wtbs_entitytype_id");
        String appNumber = (String)view.getFormShowParameter().getCustomParam("appName");
        RelatePageInfo relatePageInfo = WTCRelatePanelSetFactory.getRelatePageInfo(appNumber, relateEntityTypeId, pageId);
        String panelKey = "mainpagepanel";
        if (relatePageInfo == null) {
            return;
        }
        long userId = RequestContext.get().getCurrUserId();
        Set allShellPageIdList = AttFileRelateEnum.getAllShellPageIdList();
        if (allShellPageIdList.contains(pageId)) {
            String targetPageIdBy = AttFileRelateEnum.getTargetPageIdBy((String)pageId);
            targetPageIdBy = "wtp_attfilebasevertime".equals(targetPageIdBy) ? ("wtam".equals(appNumber) ? "wtp_attfilebasevertime" : "wtp_vafilebasevertime") : targetPageIdBy;
            boolean hasViewPermission = true;
            if ("wtp_attendperson".equals(targetPageIdBy)) {
                long count = ATTPERSONPERMLIST.stream().filter(attPersonPermPage -> PermissionServiceHelper.hasViewPermission((long)userId, (String)appNumber, (String)attPersonPermPage)).count();
                if (count == 0L) {
                    hasViewPermission = false;
                }
            } else {
                hasViewPermission = PermissionServiceHelper.hasViewPermission((long)userId, (String)appNumber, (String)targetPageIdBy);
            }
            if (!hasViewPermission) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                formShowParameter.setFormId("wtp_filenoperminfo");
                formShowParameter.setCustomParam("tipslabelap", (Object)relatePageInfo.getPageName());
                view.showForm(formShowParameter);
                return;
            }
        }
        view.getFormShowParameter().setCustomParam("currentRelatePage", (Object)relatePageInfo.getPageNumber());
        String url = relatePageInfo.getUrl();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            pageId = url;
        }
        BaseShowParameter showParameter = null;
        switch (relatePageInfo.getPageType()) {
            case "1": {
                QFilter[] objFilterArray;
                DynamicObject[] relatePageObjArray;
                String customPKFilterStr;
                BaseShowParameter formShowParameter;
                showParameter = formShowParameter = new BaseShowParameter();
                formShowParameter.setFormId(pageId);
                formShowParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageId);
                String currentObjId = (String)view.getFormShowParameter().getCustomParam("currentObjectPKId");
                QFilter mainObjFilter = new QFilter(relatePageInfo.getMainPropName(), "=", (Object)Long.valueOf(currentObjId));
                Map customPKFilterMap = (Map)view.getFormShowParameter().getCustomParam("customPKFilter");
                if (customPKFilterMap != null && (customPKFilterStr = (String)customPKFilterMap.get(pageId)) != null) {
                    QFilter customPKFilter = QFilter.fromSerializedString((String)customPKFilterStr);
                    mainObjFilter.and(customPKFilter);
                }
                if ((relatePageObjArray = serviceHelper.query("id", objFilterArray = new QFilter[]{mainObjFilter})) != null && relatePageObjArray.length > 0) {
                    formShowParameter.setPkId(relatePageObjArray[0].get("id"));
                    formShowParameter.setBillStatus(BillOperationStatus.VIEW);
                    formShowParameter.setStatus(OperationStatus.VIEW);
                } else {
                    formShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
                    formShowParameter.setStatus(OperationStatus.ADDNEW);
                }
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                view.showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "2": {
                showParameter = WTCLeftRelateService.getShowParameter(view, panelKey, "wtp_attfileschedulenosear", pageId, isShowTopCommonSearch);
                break;
            }
            case "4": {
                showParameter = WTCLeftRelateService.getShowParameter(view, panelKey, "hsbp_cardviewtpl", pageId, isShowTopCommonSearch);
                break;
            }
            case "3": {
                FormShowParameter formShowParameter = new FormShowParameter();
                showParameter = formShowParameter;
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                formShowParameter.setFormId(pageId);
                formShowParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
                view.showForm(formShowParameter);
                break;
            }
        }
        if (showParameter != null) {
            WTCPageCache pageCache = new WTCPageCache(view);
            pageCache.put("SUB_PAGE_" + originalRelatedPageId, (Object)showParameter.getPageId());
        }
    }

    public static ListShowParameter getShowParameter(IFormView view, String panelKey, String coverPageId, String pageId, boolean isShowTopCommonSearch) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(panelKey);
        if (isShowTopCommonSearch) {
            formShowParameter.setFormId("hr_list");
            formShowParameter.setBillFormId(pageId);
        } else {
            formShowParameter.setFormId(coverPageId);
            formShowParameter.setBillFormId(pageId);
            formShowParameter.setLookUp(false);
        }
        formShowParameter.setCustomParam("type", (Object)"list");
        formShowParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
        view.showForm((FormShowParameter)formShowParameter);
        return formShowParameter;
    }

    public static FlexPanelAp createRelatePageInfoPanelAp(String appNumber, String relateEntityTypeId) {
        logger.info("createRelatePageInfoPanelAp2,appNumber={}", (Object)appNumber);
        FlexPanelAp relatePanelAp = WTCLeftRelateService.assembleRelatePanelAp("relatePageflexpanellistap");
        List<RelatePageInfo> pageInfoList = WTCRelatePanelSetFactory.getRelatePageInfoList(appNumber, relateEntityTypeId);
        pageInfoList = WTCLeftRelateService.filterPageInfoList(appNumber, pageInfoList);
        if (CollectionUtils.isNotEmpty(pageInfoList)) {
            String currShowPageNumber = pageInfoList.get(0).getPageNumber();
            WTCAppCache.get((String)"currShowPageNumber").put("currShowPageNumber", (Object)currShowPageNumber);
        }
        WTCLeftRelateService.addAllPageLabelForRelatePanel(relatePanelAp, pageInfoList);
        logger.info("createRelatePageInfoPanelAp,appNumber={},pageInfoList={}", (Object)appNumber, pageInfoList);
        return relatePanelAp;
    }

    public static List<RelatePageInfo> filterPageInfoList(String appNumber, List<RelatePageInfo> pageInfoList) {
        long userId = RequestContext.get().getCurrUserId();
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)pageInfoList.size());
        Set allShellPageIdList = AttFileRelateEnum.getAllShellPageIdList();
        for (RelatePageInfo relatePageInfo : pageInfoList) {
            String pageId = relatePageInfo.getPageNumber();
            if (allShellPageIdList.contains(pageId)) {
                String targetPageIdBy = AttFileRelateEnum.getTargetPageIdBy((String)pageId);
                targetPageIdBy = "wtp_attfilebasevertime".equals(targetPageIdBy) ? ("wtam".equals(appNumber) ? "wtp_attfilebasevertime" : "wtp_vafilebasevertime") : targetPageIdBy;
                boolean hasViewPermission = true;
                if ("wtp_attendperson".equals(targetPageIdBy)) {
                    long count = ATTPERSONPERMLIST.stream().filter(attPersonPermPage -> PermissionServiceHelper.hasViewPermission((long)userId, (String)appNumber, (String)attPersonPermPage)).count();
                    if (count == 0L) {
                        hasViewPermission = false;
                    }
                } else {
                    hasViewPermission = PermissionServiceHelper.hasViewPermission((long)userId, (String)appNumber, (String)targetPageIdBy);
                }
                if (!hasViewPermission) continue;
                resultList.add(relatePageInfo);
                continue;
            }
            resultList.add(relatePageInfo);
        }
        return resultList;
    }

    public static void addAllPageLabelForRelatePanel(FlexPanelAp relatePanelAp, List<RelatePageInfo> pageInfoList) {
        Iterator<RelatePageInfo> iterator = pageInfoList.iterator();
        while (iterator.hasNext()) {
            RelatePageInfo relatePageInfo;
            RelatePageInfo pageInfo = relatePageInfo = iterator.next();
            LabelAp lblRelatePageAp = WTCLeftRelateService.assembleRelatePageLabelAp(pageInfo);
            FlexPanelAp relateLabelPanelAp = WTCLeftRelateService.assembleRelatePanelAp(pageInfo.getPageNumber() + "panel");
            relateLabelPanelAp.getItems().add(lblRelatePageAp);
            relatePanelAp.getItems().add(relateLabelPanelAp);
        }
    }

    public static ImageAp assembleImageAp(String number, Map<String, String> pageIconMap) {
        String imageKey = pageIconMap.get(number);
        ImageAp pageIconAp = new ImageAp();
        pageIconAp.setKey("pageIcon" + number);
        pageIconAp.setImgHeight("5px");
        pageIconAp.setImgWidth("5px");
        pageIconAp.setGrow(0);
        pageIconAp.setShrink(1);
        pageIconAp.setRadius("30px");
        pageIconAp.setImageKey(imageKey);
        Margin margin = new Margin();
        new Margin().setTop("10px");
        Style style = new Style();
        style.setMargin(margin);
        pageIconAp.setStyle(style);
        pageIconAp.setClickable(true);
        return pageIconAp;
    }

    public static FlexPanelAp assembleRelatePanelAp(String relatePanelName) {
        logger.info("createRelatePageInfoPanelAp3,relatePanelName = {}", (Object)relatePanelName);
        FlexPanelAp relatePanelAp = new FlexPanelAp();
        relatePanelAp.setKey(relatePanelName);
        relatePanelAp.setWrap(true);
        relatePanelAp.setDirection("row");
        relatePanelAp.setAlignItems("flex-start");
        relatePanelAp.setJustifyContent("flex-start");
        relatePanelAp.setHeight(new LocaleString("34px"));
        Style style = new Style();
        Border border = new Border();
        style.setBorder(border);
        relatePanelAp.setStyle(style);
        logger.info("createRelatePageInfoPanelAp4");
        return relatePanelAp;
    }

    public static FlexPanelAp assembleSelectRelatePanelAp(String relatePanelName) {
        FlexPanelAp relatePanelAp = WTCLeftRelateService.assembleRelatePanelAp(relatePanelName);
        Style style = new Style();
        Border border = new Border();
        String borderStyle = "2px_solid_themeColor";
        border.setLeft(borderStyle);
        style.setBorder(border);
        relatePanelAp.setStyle(style);
        relatePanelAp.setBackColor("themeColor|10");
        return relatePanelAp;
    }

    public static LabelAp assembleRelatePageLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = WTCLeftRelateService.assembleBaseLabelAp(relatePageInfo);
        lblRelatePageAp.setForeColor("#333333");
        Style style = new Style();
        Border border = new Border();
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft("20px");
        style.setPadding(padding);
        Margin margin = new Margin();
        margin.setTop("10px");
        style.setMargin(margin);
        lblRelatePageAp.setStyle(style);
        return lblRelatePageAp;
    }

    public static LabelAp assembleSelectRelatePageLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = WTCLeftRelateService.assembleBaseLabelAp(relatePageInfo);
        lblRelatePageAp.setForeColor("themeColor");
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("16px");
        style.setPadding(padding);
        Margin margin = new Margin();
        margin.setTop("8px");
        style.setMargin(margin);
        lblRelatePageAp.setStyle(style);
        lblRelatePageAp.setWidth(new LocaleString("230px"));
        return lblRelatePageAp;
    }

    public static LabelAp assembleBaseLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = new LabelAp();
        lblRelatePageAp.setId(relatePageInfo.getPageNumber());
        lblRelatePageAp.setKey(relatePageInfo.getPageNumber());
        lblRelatePageAp.setName(new LocaleString(relatePageInfo.getPageName()));
        lblRelatePageAp.setFontSize(14);
        lblRelatePageAp.setClickable(true);
        return lblRelatePageAp;
    }

    public static void showPartTwoPanel(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"flexpanelparttwo"});
        view.setVisible(Boolean.FALSE, new String[]{"flexpaneldownarrow"});
    }

    public static void hidePartTwoPanel(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"flexpanelparttwo"});
        view.setVisible(Boolean.TRUE, new String[]{"flexpaneldownarrow"});
    }
}

