/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.relate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.wtc.wtbs.common.cache.relate.WTCAppCache;
import kd.wtc.wtbs.common.model.relate.RelatePageInfo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCRelatePanelSetFactory {
    private static final Log logger = LogFactory.getLog(WTCRelatePanelSetFactory.class);
    private static final String APPID_WTC_WTBS = "appid_wtc_wtbs";
    private static final String RELATEPAGE_PRE = "relatePage_";

    public static List<RelatePageInfo> getRelatePageInfoList(String appNumber, String relateEntityTypeId) {
        logger.info("createRelatePageInfoPanelAp5,appNumber = {}", (Object)appNumber);
        String lang = RequestContext.get().getLang().getLocale().toString();
        String cacheKey = RELATEPAGE_PRE + relateEntityTypeId + lang;
        Map<String, List<RelatePageInfo>> pageMap = WTCRelatePanelSetFactory.queryRelatePageInfoList(appNumber, relateEntityTypeId);
        List<RelatePageInfo> relatePageInfos = pageMap.get(cacheKey);
        if (WTCCollections.isEmpty(relatePageInfos)) {
            cacheKey = RELATEPAGE_PRE + relateEntityTypeId + Lang.zh_CN;
            relatePageInfos = pageMap.get(cacheKey);
        }
        return relatePageInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPageSetMapByEntityType(String appNumber, String relateEntityTypeId) {
        Class<WTCRelatePanelSetFactory> clazz = WTCRelatePanelSetFactory.class;
        synchronized (WTCRelatePanelSetFactory.class) {
            Map<String, List<RelatePageInfo>> pageMap = WTCRelatePanelSetFactory.queryRelatePageInfoList(appNumber, relateEntityTypeId);
            pageMap.forEach((key, value) -> {
                if (!CollectionUtils.isEmpty((Collection)value)) {
                    WTCAppCache.get((String)APPID_WTC_WTBS).put(key, (Object)SerializationUtils.toJsonString((Object)value));
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Map<String, List<RelatePageInfo>> queryRelatePageInfoList(String appNumber, String relateEntityTypeId) {
        String selectFields = "number,entitytype.id,pageinfo,name,pagetype,mainPropName,filterCondition,enable,status,url";
        Long relateEntityTypeLongId = Long.valueOf(relateEntityTypeId);
        QFilter typeFilter = new QFilter("entitytype.id", "=", (Object)relateEntityTypeLongId);
        typeFilter.and("enable", "=", (Object)"1");
        typeFilter.and("status", "=", (Object)"C");
        QFilter[] filterArray = new QFilter[]{typeFilter};
        String order = "index,number";
        DynamicObject[] pageArr = BusinessDataServiceHelper.load((String)"wtbs_relatepanelset", (String)selectFields, (QFilter[])filterArray, (String)order);
        logger.info("\u6570\u636e\u5e93\u67e5\u8be2\u6240\u5f97,appNumber={},size={}", (Object)appNumber, (Object)pageArr.length);
        HashMap pageMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap hasViewPermissionMap = Maps.newHashMapWithExpectedSize((int)pageArr.length);
        long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject pageDynObj : pageArr) {
            String pageId = pageDynObj.getString("pageinfo.number");
            boolean hasViewPermission = PermissionServiceHelper.hasViewPermission((long)userId, (String)appNumber, (String)pageId);
            hasViewPermissionMap.put(pageId, hasViewPermission);
        }
        String cachePre = RELATEPAGE_PRE + relateEntityTypeId;
        for (Lang lang : Lang.values()) {
            ArrayList<RelatePageInfo> pageList = new ArrayList<RelatePageInfo>();
            String tempLang = lang.toString();
            String cacheKey = cachePre + tempLang;
            for (DynamicObject pageDynObj : pageArr) {
                String pageId = pageDynObj.getString("pageinfo.number");
                if (!((Boolean)hasViewPermissionMap.get(pageId)).booleanValue()) continue;
                LocaleDynamicObjectCollection localeColl = (LocaleDynamicObjectCollection)pageDynObj.get("multilanguagetext");
                WTCRelatePanelSetFactory.addPageList(pageList, tempLang, pageDynObj, localeColl);
            }
            pageMap.put(cacheKey, pageList);
        }
        logger.info("\u6570\u636e\u5e93\u67e5\u8be2\u6240\u5f973,pageMap={}", (Object)pageMap);
        return pageMap;
    }

    private static void addPageList(List<RelatePageInfo> pageList, String tempLang, DynamicObject pageDynObj, LocaleDynamicObjectCollection localeColl) {
        for (DynamicObject dynamicObject : localeColl) {
            if (!tempLang.equals(dynamicObject.getString("localeid"))) continue;
            if (StringUtils.isNotBlank((CharSequence)pageDynObj.getString("url"))) {
                RelatePageInfo relatePageInfo = new RelatePageInfo(pageDynObj.getString("number").toUpperCase(), pageDynObj.getString("pageinfo_id"), dynamicObject.getString("name"), pageDynObj.getString("pagetype"), pageDynObj.getString("mainPropName"), pageDynObj.getString("filterCondition"), pageDynObj.getString("url"));
                pageList.add(relatePageInfo);
                break;
            }
            RelatePageInfo relatePageInfo = new RelatePageInfo(pageDynObj.getString("number").toUpperCase(), pageDynObj.getString("pageinfo_id"), dynamicObject.getString("name"), pageDynObj.getString("pagetype"), pageDynObj.getString("mainPropName"), pageDynObj.getString("filterCondition"));
            pageList.add(relatePageInfo);
            break;
        }
    }

    public static RelatePageInfo getRelatePageInfo(String appNumber, String relateEntityTypeId, String pageId) {
        RelatePageInfo relatePageInfo = null;
        List<RelatePageInfo> pageList = WTCRelatePanelSetFactory.getRelatePageInfoList(appNumber, relateEntityTypeId);
        for (RelatePageInfo pageInfo : pageList) {
            if (!pageId.equals(pageInfo.getPageNumber())) continue;
            relatePageInfo = pageInfo;
            break;
        }
        return relatePageInfo;
    }
}

