/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.relate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.wtc.wtbs.business.relate.WTCLeftRelateService;
import kd.wtc.wtbs.business.relate.WTCRelatePanelSetFactory;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.relate.RelatePageInfo;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WtcRightRelateService {
    public static void showRelatedPage(String currentRelatePageName, IFormView view) {
        String currentObjectPKId;
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter) {
            BaseShowParameter baseShowParameter = (BaseShowParameter)formShowParameter;
            currentObjectPKId = baseShowParameter.getPkId().toString();
        } else {
            currentObjectPKId = (String)formShowParameter.getCustomParam("currentObjectPKId");
        }
        DynamicObject dynamicObject = AttFileQueryServiceImpl.getInstance().queryOneAttFile(AttFileQueryParam.baseProperties, Long.parseLong(currentObjectPKId));
        String relateEntityTypeId = (String)formShowParameter.getCustomParam("wtbs_entitytype_id");
        String caption = (String)formShowParameter.getCustomParam("caption");
        Map pageIconMap = (Map)formShowParameter.getCustomParam("pageIcons");
        Map customVariablesMap = (Map)formShowParameter.getCustomParam("customvariables");
        Map customPKFilterMap = (Map)formShowParameter.getCustomParam("customPKFilter");
        FormShowParameter pageFormShowParameter = new FormShowParameter();
        String appNumber = (String)view.getFormShowParameter().getCustomParams().get("appName");
        pageFormShowParameter.setCustomParam("appName", (Object)appNumber);
        pageFormShowParameter.setCustomParam("currentRelatePage", (Object)currentRelatePageName);
        pageFormShowParameter.setCustomParam("currentObjectPKId", (Object)String.valueOf(dynamicObject.get("boid")));
        pageFormShowParameter.setCustomParam("wtbs_entitytype_id", (Object)relateEntityTypeId);
        pageFormShowParameter.setCustomParam("pageIcons", (Object)pageIconMap);
        pageFormShowParameter.setCustomParam("customvariables", (Object)customVariablesMap);
        pageFormShowParameter.setCustomParam("customPKFilter", (Object)customPKFilterMap);
        pageFormShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_entitytype");
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(relateEntityTypeId));
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        DynamicObject entityTypeDynamicObj = serviceHelper.queryOne("id,name,relatepageinfo", idFilterArray);
        String relatePageName = entityTypeDynamicObj.getString("relatepageinfo");
        pageFormShowParameter.setFormId(relatePageName);
        pageFormShowParameter.setPageId(view.getPageId() + relatePageName + currentRelatePageName);
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            pageFormShowParameter.setCaption(caption);
        }
        view.showForm(pageFormShowParameter);
    }

    public static void buildRight(LoadCustomControlMetasArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String relateEntityTypeId = (String)showParameter.getCustomParam("wtbs_entitytype_id");
        String currentObjectPKId = (String)showParameter.getCustomParam("currentObjectPKId");
        String appNumber = (String)showParameter.getCustomParam("appName");
        Map pageIconMap = (Map)showParameter.getCustomParam("pageIcons");
        if (StringUtils.isNotBlank((CharSequence)relateEntityTypeId) && StringUtils.isNotBlank((CharSequence)currentObjectPKId)) {
            FlexPanelAp headPanelAp = WtcRightRelateService.createRelatePageInfoPanelAp(appNumber, relateEntityTypeId, pageIconMap);
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", "flexpanelrelateinfo");
            mapHead.put("items", (String)headPanelAp.createControl().get("items"));
            e.getItems().add(mapHead);
        }
    }

    public static FlexPanelAp createRelatePageInfoPanelAp(String appNumber, String relateEntityTypeId, Map<String, String> pageIconMap) {
        FlexPanelAp relatePanelAp = WtcRightRelateService.assembleRelatePanelAp();
        List<RelatePageInfo> pageInfoList = WTCRelatePanelSetFactory.getRelatePageInfoList(appNumber, relateEntityTypeId);
        pageInfoList = WTCLeftRelateService.filterPageInfoList(appNumber, pageInfoList);
        WtcRightRelateService.addAllPagePanels(relatePanelAp, pageInfoList, pageIconMap);
        return relatePanelAp;
    }

    public static void addAllPagePanels(FlexPanelAp relatePanelAp, List<RelatePageInfo> pageInfoList, Map<String, String> pageIconMap) {
        String setCustomeStyles = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbi8qKlxuJCA+IGRpdiA+IGE6aG92ZXIge1xuIGNvbG9yOiMwRTVGRDghaW1wb3J0YW50O1xuICBmb250LXNpemU6IDE0cHghaW1wb3J0YW50O1xuICBcdGJvcmRlci1ib3R0b206IDExMTFweCBzb2xpZCAjMEU1RkQ4IWltcG9ydGFudDtcbn1cbiQgPiBhID4gc3Bhbjpob3ZlciB7XG4gIGNvbG9yOiMwRTVGRDghaW1wb3J0YW50O1xuICBmb250LXNpemU6IDE0cHghaW1wb3J0YW50O1xuICB0ZXh0LWRlY29yYXRpb246dW5kZXJsaW5lIWltcG9ydGFudDtcbn0gXG4qL1xuXG4kID4gYSA+IHNwYW46aG92ZXIge1xuICB0ZXh0LWRlY29yYXRpb246dW5kZXJsaW5lIWltcG9ydGFudDtcbiAgY29sb3I6IzBFNUZEOCFpbXBvcnRhbnQ7XG4gIGZvbnQtc2l6ZTogMTRweCFpbXBvcnRhbnQ7XG59ICJ9";
        int size = pageInfoList.size();
        for (int i = 0; i < size; ++i) {
            FlexPanelAp pagePanelAp = WtcRightRelateService.assemblePagePanelAp(i);
            RelatePageInfo pageInfo = pageInfoList.get(i);
            FlexPanelAp lblRelatePageAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("butap" + pageInfo.getPageNumber()).setWidth("100%").setHeight("32px").setGrow(0).setShrink(0).setMarginBottom("10px")).build();
            lblRelatePageAp.setCustomeStyles(setCustomeStyles);
            lblRelatePageAp.getItems().add(WtcRightRelateService.buildButtonLink(pageInfo.getPageNumber(), pageInfo.getPageName()));
            pagePanelAp.getItems().add(lblRelatePageAp);
            if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(pageInfo.getPageNumber())) {
                ImageAp pageIconAp = WtcRightRelateService.assembleImageAp(pageInfo.getPageNumber(), pageIconMap);
                pagePanelAp.getItems().add(pageIconAp);
            }
            relatePanelAp.getItems().add(pagePanelAp);
        }
    }

    private static ButtonAp buildButtonLink(String pageKey, String groupName) {
        ButtonAp buttonAp = new ButtonAp();
        buttonAp.setKey(pageKey);
        buttonAp.setId(pageKey);
        buttonAp.setButtonStyle(2);
        buttonAp.setName(new LocaleString(groupName));
        buttonAp.setForeColor("#0E5FD8");
        buttonAp.setFontSize(14);
        buttonAp.setHeight(new LocaleString("21px"));
        return buttonAp;
    }

    public static FlexPanelAp assemblePagePanelAp(int index) {
        FlexPanelAp pagePanelAp = new FlexPanelAp();
        pagePanelAp.setKey("pagepanelap" + index);
        pagePanelAp.setWrap(true);
        pagePanelAp.setDirection("row");
        pagePanelAp.setAlignContent("flex-start");
        pagePanelAp.setAlignItems("flex-start");
        pagePanelAp.setJustifyContent("center");
        return pagePanelAp;
    }

    public static FlexPanelAp assembleRelatePanelAp() {
        FlexPanelAp relatePanelAp = new FlexPanelAp();
        relatePanelAp.setKey("relatePageflexpanellistap");
        relatePanelAp.setWrap(true);
        relatePanelAp.setDirection("column");
        relatePanelAp.setAlignContent("flex-start");
        relatePanelAp.setAlignItems("flex-start");
        relatePanelAp.setJustifyContent("center");
        return relatePanelAp;
    }

    public static ImageAp assembleImageAp(String number, Map<String, String> pageIconMap) {
        String imageKey = pageIconMap.get(number);
        ImageAp pageIconAp = new ImageAp();
        pageIconAp.setKey("pageIcon" + number);
        pageIconAp.setImgHeight("5px");
        pageIconAp.setImgWidth("5px");
        pageIconAp.setGrow(0);
        pageIconAp.setShrink(1);
        pageIconAp.setRadius("30px");
        pageIconAp.setImageKey(imageKey);
        pageIconAp.setClickable(true);
        return pageIconAp;
    }
}

