/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.report.calreport;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kd.wtc.wtbs.business.report.calreport.Label;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;

public class ReportNode
implements Serializable,
AutoCloseable {
    private static final long serialVersionUID = 2533395630769776685L;
    private long id;
    private long parentId;
    private String group;
    private List<Label> labels;
    private Integer index = 1;
    private ConcurrentLinkedQueue<ReportNode> children = new ConcurrentLinkedQueue();
    private String color;
    private Long startTime;
    private Long endTime;
    private String remark;
    private String version;
    private Long createId;

    public ReportNode(String group) {
        this.group = group;
    }

    public ReportNode() {
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setIndex() {
        ReportNode reportNode = this;
        Integer n = reportNode.index;
        Integer n2 = reportNode.index = Integer.valueOf(reportNode.index + 1);
    }

    public List<ReportNode> getChildren() {
        return new LinkedList<ReportNode>(this.children);
    }

    public void setChildren(List<ReportNode> children) {
        this.children = new ConcurrentLinkedQueue<ReportNode>(children);
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Long getCreateId() {
        return this.createId;
    }

    public void setCreateId(Long createId) {
        this.createId = createId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public void appendChildren(ReportNode childrenReportNode) {
        int index = this.children.size();
        childrenReportNode.setIndex(++index);
        this.children.add(childrenReportNode);
    }

    public void appendLabel(Label childrenLabel) {
        if (null == this.labels) {
            this.labels = Lists.newArrayList();
        } else {
            int index = this.labels.size();
            childrenLabel.setIndex(++index);
        }
        this.labels.add(childrenLabel);
    }

    public Long getElapsedMilliSecond() {
        if (null != this.endTime && null != this.startTime) {
            return this.endTime - this.startTime;
        }
        return null;
    }

    @Override
    public void close() {
        this.endTime = System.currentTimeMillis();
        long elapsedMilliSec = this.getElapsedMilliSecond();
        if (elapsedMilliSec >= 1000L) {
            this.appendLabel(new Label(CalcReportConstants.ELAPSED, WTCDateUtils.secondToTime((long)(elapsedMilliSec / 1000L), (String)"h : m : s"), null));
        } else {
            this.appendLabel(new Label(CalcReportConstants.ELAPSED_MILLISECOND, elapsedMilliSec, null));
        }
    }
}

