/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.report.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.report.TieReportSaveRequest;
import kd.wtc.wtbs.business.report.calreport.Label;
import kd.wtc.wtbs.business.report.calreport.LabelTypeEnum;
import kd.wtc.wtbs.business.report.calreport.ReportNode;
import kd.wtc.wtbs.business.report.service.ICalculateReportLabelService;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtes.common.calreport.CalculateReportConstants;

public class CalculateReportLabelServiceImpl
implements ICalculateReportLabelService {
    private static final Log logger = LogFactory.getLog(CalculateReportLabelServiceImpl.class);
    private static final String LABEL_PROPERTIES = "id ,labelinfo_tag ,labelinfo";
    private final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreportex");

    @Override
    public Long saveLabel(String labelText) {
        DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject("wtbs_taskreportex");
        dynamicObject.set("labelinfo_tag", (Object)labelText);
        dynamicObject.set("labelinfo", (Object)labelText.substring(Math.min(CalculateReportConstants.FILE_TEXT_TAG_LENGTH, labelText.length())));
        DynamicObject saveOne = (DynamicObject)this.serviceHelper.saveOne(dynamicObject);
        return (Long)saveOne.getPkValue();
    }

    @Override
    public Integer saveLabelList(List<DynamicObject> list) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreportex");
        Object[] save = serviceHelper.save(list.toArray(new DynamicObject[0]));
        return save.length;
    }

    @Override
    public String queryLabelOne(Long fid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreportex");
        QFilter qFilter = new QFilter("id", "=", (Object)fid);
        DynamicObject dynamicObject = serviceHelper.queryOne(LABEL_PROPERTIES, new QFilter[]{qFilter});
        return null == dynamicObject ? "" : dynamicObject.getString("labelinfo_tag");
    }

    @Override
    public Map<Long, String> queryLabelList(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreportex");
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObject = serviceHelper.query(LABEL_PROPERTIES, new QFilter[]{qFilter});
        return Arrays.stream(dynamicObject).collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getString("labelinfo_tag")));
    }

    @Override
    public Long saveCalculateReport(TieReportSaveRequest reportSaveRequest) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreport");
        long reportId = ORM.create().genLongId("wtbs_taskreport");
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject("wtbs_taskreport");
        dynamicObject.set("name", (Object)reportSaveRequest.getTaskVersion());
        dynamicObject.set("totaltaskid", (Object)reportSaveRequest.getTaskId());
        dynamicObject.set("subtaskid", (Object)reportSaveRequest.getSubTaskId());
        dynamicObject.set("serialnum", (Object)reportSaveRequest.getShardingIndex());
        dynamicObject.set("id", (Object)reportId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)reportSaveRequest.getCreatorId());
        dynamicObject.set("category", (Object)reportSaveRequest.getCategory());
        ArrayList saveLabels = Lists.newArrayList();
        this.process(reportSaveRequest.getReportNode(), saveLabels, reportId);
        String jsonString = JSONObject.toJSONString((Object)reportSaveRequest.getReportNode());
        dynamicObject.set("jsontext_tag", (Object)jsonString);
        try (TXHandle txHandle = TX.required();){
            DynamicObject saveOne = (DynamicObject)serviceHelper.saveOne(dynamicObject);
            this.saveLabelList(saveLabels);
            Long l = (Long)saveOne.getPkValue();
            return l;
        }
    }

    @Override
    public String queryReportOne(Long fid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreport");
        String properties = "id ,jsontext_tag";
        QFilter qFilter = new QFilter("id", "=", (Object)fid);
        DynamicObject dynamicObject = serviceHelper.queryOne(properties, new QFilter[]{qFilter});
        if (null != dynamicObject && dynamicObject.containsProperty("jsontext_tag")) {
            return dynamicObject.getString("jsontext_tag");
        }
        return "";
    }

    private void process(ReportNode reportNode, List<DynamicObject> saveLabels, long reportId) {
        this.processLabel(reportNode, saveLabels, reportId);
        if (WTCCollections.isNotEmpty(reportNode.getChildren())) {
            for (ReportNode childNode : reportNode.getChildren()) {
                this.process(childNode, saveLabels, reportId);
            }
        }
    }

    private void processLabel(ReportNode reportNode, List<DynamicObject> saveLabels, long reportId) {
        List<Label> labels = reportNode.getLabels();
        if (WTCCollections.isNotEmpty(labels)) {
            long[] ids = ORM.create().genLongIds("wtbs_taskreportex", labels.size());
            int index = 0;
            for (Label label : labels) {
                Object value = label.getValue();
                if (null == value) continue;
                String valueStr = value.toString();
                if (HRStringUtils.isNotEmpty((String)valueStr) && valueStr.length() > CalculateReportConstants.LABEL_LENGTH) {
                    DynamicObject dynamicObject = this.serviceHelper.generateEmptyDynamicObject("wtbs_taskreportex");
                    dynamicObject.set("labelinfo_tag", (Object)valueStr);
                    dynamicObject.set("id", (Object)ids[index]);
                    dynamicObject.set("calreportid", (Object)reportId);
                    dynamicObject.set("labelinfo", (Object)valueStr.substring(Math.max(CalculateReportConstants.FILE_TEXT_TAG_LENGTH, valueStr.length())));
                    saveLabels.add(dynamicObject);
                    label.setType(LabelTypeEnum.CLICK.getType());
                    label.setVid(String.valueOf(ids[index]));
                    label.setValue(valueStr.substring(0, CalculateReportConstants.LABEL_LENGTH));
                    ++index;
                    continue;
                }
                label.setValue(valueStr);
            }
        }
    }
}

