/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.round;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.RoundResultVo;
import kd.wtc.wtbs.business.round.IRoundCalculateService;
import kd.wtc.wtbs.common.model.evaluation.Round;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RoundCalCulateServiceImpl
implements IRoundCalculateService {
    private static final String ROUND_LOWERLIMITVALUE = "lowerlimitvalue";
    private static final String ROUND_UPPERLIMITVALUE = "upperlimitvalue";
    private static final String ROUND_CONTAINLOWER = "containlower";
    private static final String ROUND_CONTAINUPPER = "containupper";
    private static final String ROUND_CIRCULATE = "circulate";
    private static final String ROUND_TARGETVALUE = "targetvalue";
    private static final String FIELD_ISORIGINVALUE = "isoriginvalue";
    private static final BigDecimal ROUNDADD = new BigDecimal(1);
    private static final BigDecimal ROUNDSUBTRACT = new BigDecimal(-1);
    private static final EnumMap<RoundCalEnum, COMPAIROP> MAP = Maps.newEnumMap(RoundCalEnum.class);

    public static RoundCalCulateServiceImpl getInstance() {
        return SingletonInstance.SINGLETON;
    }

    @Override
    public BigDecimal roundCalculate(Long id, BigDecimal num) {
        RoundResultVo resultVo = this.roundCalculateWithStatus(id, num);
        return resultVo.getResultValue();
    }

    private DynamicObject queryRoundDate(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_roundrule");
        QFilter publicInfoQFilter = new QFilter("id", "=", (Object)id);
        return serviceHelper.loadDynamicObject(new QFilter[]{publicInfoQFilter});
    }

    @Override
    public RoundResultVo roundCalculateWithStatus(Long id, BigDecimal num) {
        DynamicObject roundDyn = this.queryRoundDate(id);
        if (HRStringUtils.equals((String)roundDyn.getString("settingmode"), (String)"1")) {
            BigDecimal res = this.calculateByFunc(num, roundDyn.getString("function"), roundDyn.getInt("accuracy"));
            return new RoundResultVo(true, "", res);
        }
        DynamicObjectCollection dys = roundDyn.getDynamicObjectCollection("entryentity");
        this.sortRound(dys);
        return this.calculate(this.transDyToRoundWrapper(dys), num);
    }

    @Override
    public BigDecimal roundCalculate(RoundWrapper roundWrapper, BigDecimal num) {
        if (HRStringUtils.equals((String)roundWrapper.getSettingMode(), (String)"1")) {
            return this.calculateByFunc(num, roundWrapper.getFunctionMode(), roundWrapper.getAccuracy());
        }
        ArrayList<Round> roundList = new ArrayList<Round>(roundWrapper.getRoundList());
        this.sortRound(roundList);
        RoundResultVo resultVo = this.calculate(roundList, num);
        return resultVo.getResultValue();
    }

    private BigDecimal calculateByFunc(BigDecimal num, String roundMode, Integer accuary) {
        return num.setScale((int)accuary, Integer.parseInt(roundMode));
    }

    private RoundResultVo calculate(List<Round> roundList, BigDecimal num) {
        boolean flag = true;
        if (num.compareTo(BigDecimal.ZERO) < 0) {
            flag = false;
            num = num.negate();
        }
        String msg = ResManager.loadKDString((String)"\u820d\u5165\u8ba1\u7b97\u51fa\u9519\u3002\u672a\u627e\u5230\u5339\u914d\u7684\u820d\u5165\u89c4\u5219\u9879", (String)"RoundCalculateService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
        for (int i = roundList.size() - 1; i >= 0; --i) {
            BigDecimal apply;
            BigDecimal roundValue = num;
            BigDecimal cycleIndex = BigDecimal.ZERO;
            Round round = roundList.get(i);
            BigDecimal lowerValue = round.getLowerLimitValue();
            BigDecimal upperValue = round.getUpperLimitValue();
            boolean containlower = round.isContainLower();
            boolean containupper = round.isContainUpper();
            boolean circulate = round.isCirculate();
            BigDecimal targetValue = round.getTargetValue();
            BigDecimal interValue = upperValue.subtract(lowerValue);
            boolean isOriginalValue = round.isOriginValue();
            if (roundValue.compareTo(lowerValue) < 0 || roundValue.compareTo(lowerValue) == 0 && !containlower) {
                if (i != 0) continue;
                return new RoundResultVo(false, msg, flag ? num : num.negate());
            }
            if (roundValue.compareTo(upperValue) > 0 || roundValue.compareTo(upperValue) == 0 && !containupper) {
                if (!circulate) continue;
                cycleIndex = roundValue.subtract(lowerValue).divide(interValue, 0, 1);
                roundValue = roundValue.subtract(cycleIndex.multiply(interValue));
            }
            if ((apply = MAP.get((Object)RoundCalEnum.getEnum(containupper, containlower)).apply(lowerValue, upperValue, roundValue)) == null) continue;
            if (isOriginalValue) {
                return new RoundResultVo(true, "", flag ? num : num.negate());
            }
            BigDecimal resultValue = targetValue.add(interValue.multiply(cycleIndex.add(apply)));
            return new RoundResultVo(true, "", flag ? resultValue : resultValue.negate());
        }
        return new RoundResultVo(false, msg, num);
    }

    private void sortRound(List<Round> roundList) {
        roundList.sort(Comparator.comparing(Round::getLowerLimitValue));
    }

    private List<Round> transDyToRoundWrapper(DynamicObjectCollection dys) {
        ArrayList<Round> list = new ArrayList<Round>(dys.size());
        for (DynamicObject dy : dys) {
            Round round = new Round();
            round.setLowerLimitValue(dy.getBigDecimal(ROUND_LOWERLIMITVALUE));
            round.setUpperLimitValue(dy.getBigDecimal(ROUND_UPPERLIMITVALUE));
            round.setContainLower(dy.getBoolean(ROUND_CONTAINLOWER));
            round.setContainUpper(dy.getBoolean(ROUND_CONTAINUPPER));
            round.setCirculate(dy.getBoolean(ROUND_CIRCULATE));
            round.setTargetValue(dy.getBigDecimal(ROUND_TARGETVALUE));
            round.setOriginValue(dy.getBoolean(FIELD_ISORIGINVALUE));
            list.add(round);
        }
        return list;
    }

    private void sortRound(DynamicObjectCollection entryDys) {
        entryDys.sort(Comparator.comparingInt(dy -> dy.getInt(ROUND_LOWERLIMITVALUE)));
    }

    static {
        MAP.put(RoundCalEnum.UPPERANDLOWER, (lower, upper, num) -> lower.compareTo(num) <= 0 && upper.compareTo(num) >= 0 ? BigDecimal.ZERO : null);
        MAP.put(RoundCalEnum.UPPER, (lower, upper, num) -> {
            if (lower.compareTo(num) < 0 && upper.compareTo(num) >= 0) {
                return BigDecimal.ZERO;
            }
            return null;
        });
        MAP.put(RoundCalEnum.LOWER, (lower, upper, num) -> {
            if (lower.compareTo(num) <= 0 && upper.compareTo(num) > 0) {
                return BigDecimal.ZERO;
            }
            return null;
        });
        MAP.put(RoundCalEnum.NON, (lower, upper, num) -> {
            if (lower.compareTo(num) < 0 && upper.compareTo(num) > 0) {
                return BigDecimal.ZERO;
            }
            return null;
        });
    }

    private static enum RoundCalEnum {
        UPPERANDLOWER(true, true),
        UPPER(true, false),
        LOWER(false, true),
        NON(false, false);

        private final boolean upper;
        private final boolean lower;

        private RoundCalEnum(boolean upper, boolean lower) {
            this.upper = upper;
            this.lower = lower;
        }

        public static RoundCalEnum getEnum(boolean upper, boolean lower) {
            RoundCalEnum[] values = RoundCalEnum.values();
            return Arrays.stream(values).filter(value -> value.isUpper() == upper && value.isLower() == lower).findFirst().orElse(NON);
        }

        public boolean isUpper() {
            return this.upper;
        }

        public boolean isLower() {
            return this.lower;
        }
    }

    private static interface COMPAIROP {
        public BigDecimal apply(BigDecimal var1, BigDecimal var2, BigDecimal var3);
    }

    private static class SingletonInstance {
        private static final RoundCalCulateServiceImpl SINGLETON = new RoundCalCulateServiceImpl();

        private SingletonInstance() {
        }
    }
}

