/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecondition;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.business.personfilter.enums.RuleParamTypeEnum;
import kd.wtc.wtbs.business.rulecondition.ThreeFunction;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class RuleConditionResultMatchService {
    private static final Log LOG = LogFactory.getLog(RuleConditionResultMatchService.class);
    private static final Map<String, ThreeFunction<ConditionDto, Object, Map<String, Boolean>>> PARAMTYPE_FUNCTION_MAP = Maps.newHashMapWithExpectedSize((int)10);

    public static ThreeFunction<ConditionDto, Object, Map<String, Boolean>> getParamMatchFunc(String paramType) {
        if (HRStringUtils.isEmpty((String)paramType)) {
            return null;
        }
        if (RuleParamTypeEnum.ADMINORG.getValue().equals(paramType) || RuleParamTypeEnum.BASEDATA.getValue().equals(paramType)) {
            paramType = RuleParamTypeEnum.DYNAMICOBJECT.getValue();
        } else if (RuleParamTypeEnum.MUL_ADMINORG.getValue().equals(paramType)) {
            paramType = RuleParamTypeEnum.MUL_DYNAMICOBJECT.getValue();
        } else if (RuleParamTypeEnum.OTHER.getValue().equals(paramType)) {
            paramType = RuleParamTypeEnum.STRING.getValue();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionResultMatchService.getParamMatchFunc,\u6570\u636e\u7c7b\u578b\uff1a{}", (Object)paramType);
        }
        return PARAMTYPE_FUNCTION_MAP.get(paramType);
    }

    public static boolean getMatchResult(String conditionExpressStr, Map<String, Boolean> resultMap) {
        boolean result;
        conditionExpressStr = conditionExpressStr.replaceAll(" +", "").replaceAll("and", "&").replace("or", "|");
        Set<Map.Entry<String, Boolean>> entrySet = resultMap.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            conditionExpressStr = conditionExpressStr.replace(entry.getKey(), entry.getValue() != false ? "1" : "0");
        }
        int pro = RuleConditionResultMatchService.pro(conditionExpressStr.toCharArray(), 0);
        boolean bl = result = (pro & 0x8000000) != 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionResultMatchService.getMatchResult,\u8868\u8fbe\u5f0f\uff1a{},\u6574\u4f53\u7ed3\u679c\uff1a{}", (Object)conditionExpressStr, (Object)result);
        }
        return result;
    }

    public static void matchDynamicObject(ConditionDto dto, Object param, Map<String, Boolean> resultMap) {
        String convertParam;
        String string = convertParam = param == null ? null : String.valueOf(param);
        if ("0".equals(convertParam)) {
            convertParam = null;
        }
        RuleConditionResultMatchService.strCommonMatch(dto, convertParam, resultMap);
    }

    public static void matchMulDynamicObject(ConditionDto dto, Object params, Map<String, Boolean> resultMap) {
        Set<Object> convertParams = new HashSet(16);
        if (params instanceof List) {
            ArrayList list = (ArrayList)params;
            if (WTCCollections.isNotEmpty((Collection)list)) {
                convertParams = list.stream().map(String::valueOf).collect(Collectors.toSet());
            }
        } else if (params != null) {
            String paramStr = String.valueOf(params);
            convertParams = Sets.newHashSet((Object[])paramStr.split(","));
        }
        RuleConditionResultMatchService.mulCommonMatch(dto, convertParams, resultMap);
    }

    public static void matchBoolean(ConditionDto dto, Object param, Map<String, Boolean> resultMap) {
        String convertParams = param == null ? Boolean.FALSE.toString() : RuleConditionResultMatchService.getBooleanString(param);
        RuleConditionResultMatchService.strCommonMatch(dto, convertParams, resultMap);
    }

    public static void matchDate(ConditionDto dto, Object param, Map<String, Boolean> resultMap) {
        String name = dto.getName();
        String operators = dto.getOperators();
        RuleOperatorEnum op = RuleOperatorEnum.getEnum(operators);
        String value = dto.getValue();
        String dateFormat = dto.getDateFormat();
        Date valueDate = RuleConditionResultMatchService.getParamOfDate(value, dateFormat);
        Date paramDate = RuleConditionResultMatchService.getParamOfDate(param, dateFormat);
        if (paramDate == null) {
            if (op == RuleOperatorEnum.IS_NULL || op == RuleOperatorEnum.NOT_EQUAL) {
                resultMap.put(name, true);
            } else {
                resultMap.put(name, false);
            }
            return;
        }
        Date paramDateZero = WTCDateUtils.getZeroDate((Date)paramDate);
        Date todayDateZero = WTCDateUtils.getZeroDate((Date)new Date());
        switch (op) {
            case EQUAL: {
                resultMap.put(name, Objects.equals(paramDate, valueDate));
                break;
            }
            case NOT_EQUAL: {
                resultMap.put(name, !Objects.equals(paramDate, valueDate));
                break;
            }
            case IS_NULL: {
                resultMap.put(name, false);
                break;
            }
            case IS_NOT_NULL: {
                resultMap.put(name, true);
                break;
            }
            case LESS_THAN: {
                resultMap.put(name, valueDate == null || valueDate.after(paramDate));
                break;
            }
            case LESS_OR_EQUAL: {
                resultMap.put(name, valueDate == null || !valueDate.before(paramDate));
                break;
            }
            case LESS_OR_EQUALS_TODAY: {
                resultMap.put(name, !todayDateZero.before(paramDateZero));
                break;
            }
            case GREATER_THAN: {
                resultMap.put(name, valueDate == null || paramDate.after(valueDate));
                break;
            }
            case GREATER_OR_EQUAL: {
                resultMap.put(name, valueDate == null || !paramDate.before(valueDate));
                break;
            }
            case GREATER_OR_EQUALS_TODAY: {
                resultMap.put(name, !paramDateZero.before(todayDateZero));
                break;
            }
            case TODAY: {
                resultMap.put(name, todayDateZero.equals(paramDateZero));
                break;
            }
            case YESTERDAY: {
                Date valueDateZero = WTCDateUtils.getBeforeDate((Date)todayDateZero);
                resultMap.put(name, valueDateZero.equals(paramDateZero));
                break;
            }
            case TOMORROW: {
                Date valueDateZero = WTCDateUtils.getNextDate((Date)todayDateZero);
                resultMap.put(name, valueDateZero.equals(paramDateZero));
                break;
            }
            case THIS_WEEK: {
                Date beginDayOfWeek = WTCDateUtils.getBeginDayOfWeek((Date)todayDateZero);
                Date endDayOfWeek = WTCDateUtils.getEndDayOfWeek((Date)todayDateZero);
                resultMap.put(name, beginDayOfWeek.compareTo(paramDateZero) <= 0 && endDayOfWeek.compareTo(paramDateZero) >= 0);
                break;
            }
            case LAST_WEEK: {
                Date valueDateZero = WTCDateUtils.getCustomDate((Date)todayDateZero, (Integer)-7);
                Date beginDayOfWeek = WTCDateUtils.getBeginDayOfWeek((Date)valueDateZero);
                Date endDayOfWeek = WTCDateUtils.getEndDayOfWeek((Date)valueDateZero);
                resultMap.put(name, beginDayOfWeek.compareTo(paramDateZero) <= 0 && endDayOfWeek.compareTo(paramDateZero) >= 0);
                break;
            }
            case NEXT_WEEK: {
                Date valueDateZero = WTCDateUtils.getCustomDate((Date)todayDateZero, (Integer)7);
                Date beginDayOfWeek = WTCDateUtils.getBeginDayOfWeek((Date)valueDateZero);
                Date endDayOfWeek = WTCDateUtils.getEndDayOfWeek((Date)valueDateZero);
                resultMap.put(name, beginDayOfWeek.compareTo(paramDateZero) <= 0 && endDayOfWeek.compareTo(paramDateZero) >= 0);
                break;
            }
            case THIS_MONTH: {
                Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)todayDateZero);
                Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)todayDateZero);
                resultMap.put(name, beginDayOfMonth.compareTo(paramDateZero) <= 0 && endDayOfMonth.compareTo(paramDateZero) >= 0);
                break;
            }
            case LAST_MONTH: {
                Date valueDateZero = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)-1);
                Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)valueDateZero);
                Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)valueDateZero);
                resultMap.put(name, beginDayOfMonth.compareTo(paramDateZero) <= 0 && endDayOfMonth.compareTo(paramDateZero) >= 0);
                break;
            }
            case NEXT_MONTH: {
                Date valueDateZero = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)1);
                Date beginDayOfMonth = WTCDateUtils.getBeginDayOfMonth((Date)valueDateZero);
                Date endDayOfMonth = WTCDateUtils.getEndDayOfMonth((Date)valueDateZero);
                resultMap.put(name, beginDayOfMonth.compareTo(paramDateZero) <= 0 && endDayOfMonth.compareTo(paramDateZero) >= 0);
                break;
            }
            case LAST3MONTH: {
                Date customMouth = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)-3);
                resultMap.put(name, customMouth.compareTo(paramDateZero) <= 0 && todayDateZero.compareTo(paramDateZero) >= 0);
                break;
            }
            case NEXT3MONTH: {
                Date customMouth = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)3);
                resultMap.put(name, customMouth.compareTo(paramDateZero) > 0 && todayDateZero.compareTo(paramDateZero) <= 0);
                break;
            }
            case THIS_QUARTER: {
                Date startDayOfQuarter = WTCDateUtils.getStartDayOfQuarter((Date)todayDateZero);
                Date endDayOfQuarter = WTCDateUtils.getEndDayOfQuarter((Date)todayDateZero);
                resultMap.put(name, startDayOfQuarter.compareTo(paramDateZero) <= 0 && endDayOfQuarter.compareTo(paramDateZero) >= 0);
                break;
            }
            case LAST_QUARTER: {
                Date valueDateZero = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)-3);
                Date startDayOfQuarter = WTCDateUtils.getStartDayOfQuarter((Date)valueDateZero);
                Date endDayOfQuarter = WTCDateUtils.getEndDayOfQuarter((Date)valueDateZero);
                resultMap.put(name, startDayOfQuarter.compareTo(paramDateZero) <= 0 && endDayOfQuarter.compareTo(paramDateZero) >= 0);
                break;
            }
            case NEXT_QUARTER: {
                Date valueDateZero = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)3);
                Date startDayOfQuarter = WTCDateUtils.getStartDayOfQuarter((Date)valueDateZero);
                Date endDayOfQuarter = WTCDateUtils.getEndDayOfQuarter((Date)valueDateZero);
                resultMap.put(name, startDayOfQuarter.compareTo(paramDateZero) <= 0 && endDayOfQuarter.compareTo(paramDateZero) >= 0);
                break;
            }
            case THIS_YEAR: {
                Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)todayDateZero);
                Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)todayDateZero);
                resultMap.put(name, beginDayOfYear.compareTo(paramDateZero) <= 0 && endDayOfYear.compareTo(paramDateZero) >= 0);
                break;
            }
            case LAST_YEAR: {
                Date valueDateZero = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)-12);
                Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)valueDateZero);
                Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)valueDateZero);
                resultMap.put(name, beginDayOfYear.compareTo(paramDateZero) <= 0 && endDayOfYear.compareTo(paramDateZero) >= 0);
                break;
            }
            case NEXT_YEAR: {
                Date valueDateZero = WTCDateUtils.getCustomMouth((Date)todayDateZero, (Integer)12);
                Date beginDayOfYear = WTCDateUtils.getBeginDayOfYear((Date)valueDateZero);
                Date endDayOfYear = WTCDateUtils.getEndDayOfYear((Date)valueDateZero);
                resultMap.put(name, beginDayOfYear.compareTo(paramDateZero) <= 0 && endDayOfYear.compareTo(paramDateZero) >= 0);
                break;
            }
            default: {
                RuleConditionResultMatchService.defaultResult(name, resultMap);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionResultMatchService.matchDate,displayParam:{},value:{};param:{},operators:{},result:{}", new Object[]{dto.getDisplayParam(), value, param, operators, resultMap.get(name)});
        }
    }

    public static void matchString(ConditionDto dto, Object param, Map<String, Boolean> resultMap) {
        String convertParam = param == null ? "" : String.valueOf(param);
        String name = dto.getName();
        String operators = dto.getOperators();
        RuleOperatorEnum op = RuleOperatorEnum.getEnum(operators);
        String value = dto.getValue();
        switch (op) {
            case CONTAINS: {
                resultMap.put(name, convertParam.contains(value));
                break;
            }
            case NOT_CONTAINS: {
                resultMap.put(name, !convertParam.contains(value));
                break;
            }
            case STARTS_WITH: {
                resultMap.put(name, convertParam.startsWith(value));
                break;
            }
            case ENDS_WITH: {
                resultMap.put(name, convertParam.endsWith(value));
                break;
            }
            default: {
                RuleConditionResultMatchService.strCommonMatch(dto, convertParam, resultMap);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionResultMatchService.matchString,displayParam:{},value:{};param:{},operators:{},result:{}", new Object[]{dto.getDisplayParam(), value, param, operators, resultMap.get(name)});
        }
    }

    public static void matchNumber(ConditionDto dto, Object param, Map<String, Boolean> resultMap) {
        BigDecimal convertParam = param == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(param));
        String name = dto.getName();
        String operators = dto.getOperators();
        RuleOperatorEnum op = RuleOperatorEnum.getEnum(operators);
        String value = dto.getValue();
        BigDecimal valueDecimal = HRStringUtils.isEmpty((String)value) ? BigDecimal.ZERO : new BigDecimal(value);
        switch (op) {
            case EQUAL: {
                resultMap.put(name, convertParam.compareTo(valueDecimal) == 0);
                break;
            }
            case NOT_EQUAL: {
                resultMap.put(name, convertParam.compareTo(valueDecimal) != 0);
                break;
            }
            case LESS_THAN: {
                resultMap.put(name, convertParam.compareTo(valueDecimal) < 0);
                break;
            }
            case GREATER_THAN: {
                resultMap.put(name, convertParam.compareTo(valueDecimal) > 0);
                break;
            }
            case LESS_OR_EQUAL: {
                resultMap.put(name, convertParam.compareTo(valueDecimal) <= 0);
                break;
            }
            case GREATER_OR_EQUAL: {
                resultMap.put(name, convertParam.compareTo(valueDecimal) >= 0);
                break;
            }
            default: {
                RuleConditionResultMatchService.defaultResult(name, resultMap);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionResultMatchService.matchNumber,displayParam:{},value:{};param:{},operators:{},result:{}", new Object[]{dto.getDisplayParam(), value, param, operators, resultMap.get(name)});
        }
    }

    public static void matchEnum(ConditionDto dto, Object param, Map<String, Boolean> resultMap) {
        String convertParam = param == null ? "" : String.valueOf(param);
        RuleConditionResultMatchService.strCommonMatch(dto, convertParam, resultMap);
    }

    public static void matchMulEnum(ConditionDto dto, Object param, Map<String, Boolean> resultMap) {
        Set<String> convertParams = new HashSet<String>(16);
        if (param instanceof String) {
            String str = (String)param;
            if (HRStringUtils.isNotEmpty((String)str)) {
                convertParams = RuleConditionResultMatchService.convertStr2ListByComma(str);
            }
            RuleConditionResultMatchService.mulCommonMatch(dto, convertParams, resultMap);
        }
    }

    private static void strCommonMatch(ConditionDto dto, String convertParam, Map<String, Boolean> resultMap) {
        String name = dto.getName();
        String operators = dto.getOperators();
        RuleOperatorEnum op = RuleOperatorEnum.getEnum(operators);
        String value = dto.getValue();
        switch (op) {
            case EQUAL: {
                resultMap.put(name, HRStringUtils.equals((String)value, (String)convertParam));
                break;
            }
            case NOT_EQUAL: {
                resultMap.put(name, !HRStringUtils.equals((String)value, (String)convertParam));
                break;
            }
            case IN: {
                Set<String> valueSet = RuleConditionResultMatchService.convertStr2ListByComma(dto);
                resultMap.put(name, valueSet.contains(convertParam));
                break;
            }
            case NOT_IN: {
                Set<String> valueSet = RuleConditionResultMatchService.convertStr2ListByComma(dto);
                resultMap.put(name, !valueSet.contains(convertParam));
                break;
            }
            case IS_NULL: {
                resultMap.put(name, HRStringUtils.isEmpty((String)convertParam));
                break;
            }
            case IS_NOT_NULL: {
                resultMap.put(name, HRStringUtils.isNotEmpty((String)convertParam));
                break;
            }
            default: {
                RuleConditionResultMatchService.defaultResult(name, resultMap);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionResultMatchService.strCommonMatch,displayParam:{},value:{};param:{},operators:{},result:{}", new Object[]{dto.getDisplayParam(), value, convertParam, operators, resultMap.get(name)});
        }
    }

    private static void mulCommonMatch(ConditionDto dto, Set<String> convertParams, Map<String, Boolean> resultMap) {
        String name = dto.getName();
        String operators = dto.getOperators();
        RuleOperatorEnum op = RuleOperatorEnum.getEnum(operators);
        String value = dto.getValue();
        switch (op) {
            case IN: {
                Set<String> list = RuleConditionResultMatchService.convertStr2ListByComma(dto);
                boolean containsAll = WTCCollections.isNotEmpty(convertParams) && list.containsAll(convertParams);
                resultMap.put(name, containsAll);
                break;
            }
            case NOT_IN: {
                Set<String> list = RuleConditionResultMatchService.convertStr2ListByComma(dto);
                boolean noneMatch = convertParams.stream().noneMatch(list::contains);
                resultMap.put(name, noneMatch);
                break;
            }
            case MUL_EQUAL: 
            case MUL_NOT_EQUAL: {
                Set<String> list = RuleConditionResultMatchService.convertStr2ListByComma(dto);
                resultMap.put(name, RuleConditionResultMatchService.listEqual(list, convertParams));
                break;
            }
            case IS_NULL: {
                resultMap.put(name, WTCCollections.isEmpty(convertParams));
                break;
            }
            case IS_NOT_NULL: {
                resultMap.put(name, WTCCollections.isNotEmpty(convertParams));
                break;
            }
            default: {
                RuleConditionResultMatchService.defaultResult(name, resultMap);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionResultMatchService.mulCommonMatch,displayParam:{},value:{};param:{},operators:{},result:{}", new Object[]{dto.getDisplayParam(), value, convertParams, operators, resultMap.get(name)});
        }
    }

    private static Set<String> convertStr2ListByComma(ConditionDto dto) {
        String value = dto.getValue();
        if (HRStringUtils.isEmpty((String)value)) {
            return Collections.emptySet();
        }
        Set<String> valueList = dto.getValueList();
        if (WTCCollections.isEmpty(valueList)) {
            valueList = RuleConditionResultMatchService.convertStr2ListByComma(value);
            dto.setValueList(valueList);
        }
        return valueList;
    }

    private static Set<String> convertStr2ListByComma(String param) {
        if (HRStringUtils.isEmpty((String)param)) {
            return Collections.emptySet();
        }
        Object[] split = param.split(",");
        return Sets.newHashSet((Object[])split);
    }

    private static void defaultResult(String name, Map<String, Boolean> resultMap) {
        resultMap.put(name, true);
    }

    private static boolean listEqual(Set<String> list, Set<String> compareList) {
        boolean same;
        boolean bl = same = compareList.size() == list.size();
        if (same) {
            same = same && list.containsAll(compareList);
        }
        return same;
    }

    private static String getBooleanString(Object param) {
        String str = String.valueOf(param);
        if ("0".equals(str)) {
            str = Boolean.FALSE.toString();
        } else if ("1".equals(str)) {
            str = Boolean.TRUE.toString();
        }
        return str;
    }

    private static Date getParamOfDate(Object param, String dateFormat) {
        Date date = null;
        if (HRStringUtils.isEmpty((String)dateFormat)) {
            dateFormat = "yyyy-MM-dd";
        }
        if (param instanceof String) {
            date = WTCDateUtils.str2Date((String)((String)param), (String)dateFormat);
        } else if (param instanceof Date) {
            date = WTCDateUtils.date2date((Date)((Date)param), (String)dateFormat);
        }
        LOG.info("RuleConditionResultMatchService.getParamOfDate str2Date,param:{},dateFormat:{},result:{}", new Object[]{param, dateFormat, date});
        return date;
    }

    private static int pro(char[] arr, int beginIdx) {
        int idx;
        int culResult = 0x8000000;
        int preSign = 38;
        int len = arr.length;
        for (idx = beginIdx; idx < len; ++idx) {
            int cdi = arr[idx];
            if (cdi == 41) {
                return idx | culResult;
            }
            if (cdi == 40) {
                int pro = RuleConditionResultMatchService.pro(arr, idx + 1);
                int subAns = pro & 0x8000000;
                int newIdx = pro & 0xF7FFFFFF;
                cdi = subAns == 0 ? 48 : 49;
                idx = newIdx;
            }
            if (cdi == 124) {
                preSign = cdi;
                if (culResult == 0) continue;
                idx = RuleConditionResultMatchService.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (cdi == 38) {
                preSign = cdi;
                if (culResult != 0) continue;
                idx = RuleConditionResultMatchService.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (cdi == 49) {
                if (preSign != 124) continue;
                culResult = 0x8000000;
                continue;
            }
            if (cdi != 48 || preSign != 38) continue;
            culResult = 0;
        }
        return idx | culResult;
    }

    private static int getIdx4CurLevel(char[] arr, int beginIdx) {
        int idx;
        int len = arr.length;
        int count = 0;
        for (idx = beginIdx; idx < len; ++idx) {
            char cdi = arr[idx];
            if (cdi == '(') {
                ++count;
                continue;
            }
            if (cdi != ')') continue;
            if (count == 0) {
                return idx;
            }
            --count;
        }
        return idx;
    }

    static {
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.DYNAMICOBJECT.getValue(), RuleConditionResultMatchService::matchDynamicObject);
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.MUL_DYNAMICOBJECT.getValue(), RuleConditionResultMatchService::matchMulDynamicObject);
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.BOOLEAN.getValue(), RuleConditionResultMatchService::matchBoolean);
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.DATE.getValue(), RuleConditionResultMatchService::matchDate);
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.STRING.getValue(), RuleConditionResultMatchService::matchString);
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.NUMBER.getValue(), RuleConditionResultMatchService::matchNumber);
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.ENUM.getValue(), RuleConditionResultMatchService::matchEnum);
        PARAMTYPE_FUNCTION_MAP.put(RuleParamTypeEnum.MUL_ENUM.getValue(), RuleConditionResultMatchService::matchMulEnum);
    }
}

