/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecondition.bill;

import com.alibaba.fastjson.JSON;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.model.attendperson.HRPIEntityPropertyConst;
import kd.wtc.wtbs.business.rulecondition.IRuleConditionMatchService;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.RuleConditionStandardRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.DateRangeDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillDateRangeDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillLimitDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillNoDateLimitDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionCommonService;
import kd.wtc.wtbs.business.rulecontrol.ConditionValidateService;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.enums.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtbs.common.enums.TimeBucketPositionEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.TimeInterval;
import kd.wtc.wtbs.common.model.TimeIntervalResult;
import kd.wtc.wtbs.common.model.bill.unifybill.MatchRuleCal;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.retrieval.RetrievalTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class RuleConditionBillMatchService {
    private static final Log LOG = LogFactory.getLog(RuleConditionBillMatchService.class);
    private static final String I_SHIFT_SPLIT_SERVICE = "IShiftSplitService";
    private static final String SHIFT_SPLIT_SIMPLE = "shiftSplitSimple";
    private static final Map<String, Function<Object, Object>> LIMITRETRIEVALFUNCMAP = new HashMap<String, Function<Object, Object>>(16);
    private static final Map<String, Function<Object, Object>> DATERANGERETRIEVALFUNCMAP;

    public static List<RuleConditionRetrieval> billLimitMatch(RuleConditionBillLimitDto billLimitDto) {
        UnifyBillInfoContext unifyBillInfoContext = billLimitDto.getUnifyBillInfoContext();
        List billResults = unifyBillInfoContext.getBillResult();
        ArrayList<RuleConditionRetrieval> ruleConditionRetrievals = new ArrayList<RuleConditionRetrieval>(16);
        HashSet attPersonIds = Sets.newHashSetWithExpectedSize((int)billResults.size());
        for (UnifyBillResult billResult : billResults) {
            for (UnifyBillEntryResult entryResult : billResult.getEntryResultList()) {
                List<RuleConditionRetrieval> retrievalList = RuleConditionBillMatchService.buildRuleConditionRetrieval(billResult, entryResult, billLimitDto, attPersonIds);
                ruleConditionRetrievals.addAll(retrievalList);
            }
        }
        RuleConditionBillMatchService.fillStandardRetrieval(ruleConditionRetrievals, attPersonIds);
        RuleConditionBillMatchService.beginRetrievalMatch(ruleConditionRetrievals);
        return ruleConditionRetrievals;
    }

    public static List<RuleConditionRetrieval> billDateRangeMatch(List<RuleConditionBillDateRangeDto> dateRangeDtos) {
        Map<Long, DynamicObject> dataTypePatternMap = RuleConditionBillMatchService.queryDateTypePattern(dateRangeDtos);
        RuleConditionBillMatchService.initDateTypePatternResult(dataTypePatternMap, dateRangeDtos);
        Map<Long, DynamicObject> attFileMap = RuleConditionBillMatchService.queryAttFileMap(dateRangeDtos);
        ArrayList<RuleConditionRetrieval> ruleConditionRetrievals = new ArrayList<RuleConditionRetrieval>(16);
        for (RuleConditionBillDateRangeDto matchBillDateRangeDto : dateRangeDtos) {
            DynamicObject attFile;
            TimeInterval timeInterval = matchBillDateRangeDto.getTimeInterval();
            String condition = matchBillDateRangeDto.getCondition();
            if (timeInterval == null || HRStringUtils.isEmpty((String)condition)) continue;
            List timeIntervalResultList = Lists.newArrayListWithExpectedSize((int)16);
            if (!RuleConditionBillMatchService.isNeedQueryShiftSplitSimple(timeInterval, condition)) {
                TimeIntervalResult timeIntervalResult = new TimeIntervalResult();
                Shift shiftSpec = timeInterval.getShiftSpec();
                timeIntervalResult.setShiftSpec(shiftSpec);
                timeIntervalResult.setDateType(timeInterval.getDateType());
                timeIntervalResult.setDateAttribute(timeInterval.getDateAttribute());
                if (shiftSpec.getOffNonPlan() && shiftSpec.isOff()) {
                    timeIntervalResult.setTimeBucketPosition(TimeBucketPositionEnum.NON_PLAN_TIME.getCode());
                    timeIntervalResult.setShiftTimeBucketProperty(ShiftTimeBucketPropertyEnum.NON_PLAN_TIME.getCode());
                }
                timeIntervalResultList.add(timeIntervalResult);
            } else if (timeInterval.getStartDate() != null && timeInterval.getEndDate() != null && (timeInterval.getOtStartDate() != null || timeInterval.getOtEndDate() != null)) {
                timeIntervalResultList = (List)WTCServiceHelper.invokeBizService("wtc", "wtes", I_SHIFT_SPLIT_SERVICE, SHIFT_SPLIT_SIMPLE, timeInterval);
            }
            boolean matchResult = true;
            List<TimeIntervalResult> afterFilterOTTime = RuleConditionBillMatchService.filterNotInOTTime(timeIntervalResultList, timeInterval);
            if (WTCCollections.isEmpty(afterFilterOTTime)) {
                matchResult = false;
            }
            if ((attFile = matchBillDateRangeDto.getAttFileV()) == null) {
                long attFileVId = matchBillDateRangeDto.getBillDy().getLong("attfilebasef7.id");
                attFile = attFileMap.get(attFileVId);
            }
            if (!matchResult) {
                RuleConditionRetrieval ruleConditionRetrieval = new RuleConditionRetrieval();
                ruleConditionRetrieval.setDimensionKey(matchBillDateRangeDto.getDimensionKey());
                ruleConditionRetrieval.setNeedExecuteMatch(false);
                ruleConditionRetrieval.setMatchResult(false);
                ruleConditionRetrievals.add(ruleConditionRetrieval);
                continue;
            }
            for (TimeIntervalResult timeIntervalResult : afterFilterOTTime) {
                RuleConditionRetrieval ruleConditionRetrieval = new RuleConditionRetrieval();
                AccessDto accessDto = matchBillDateRangeDto.getAccessDto();
                if (accessDto == null || WTCCollections.isEmpty(accessDto.getConditionList())) {
                    ruleConditionRetrieval.setNeedExecuteMatch(false);
                } else {
                    ruleConditionRetrieval.setAccessDto(accessDto);
                }
                ruleConditionRetrieval.setDimensionKey(matchBillDateRangeDto.getDimensionKey());
                if (ruleConditionRetrieval.isNeedExecuteMatch() && accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
                    RuleConditionBillMatchService.setRetrievalBillInfo(ruleConditionRetrieval, matchBillDateRangeDto);
                    DateRangeDto dateRangeDto = new DateRangeDto();
                    dateRangeDto.setTimeInterval(timeInterval);
                    dateRangeDto.setTimeIntervalResult(timeIntervalResult);
                    RuleConditionBillMatchService.billDateRangeMatchStandardRetrievals(accessDto, dateRangeDto, matchBillDateRangeDto, ruleConditionRetrieval);
                    ruleConditionRetrieval.setBillBusType(matchBillDateRangeDto.getBillBusType());
                    RuleConditionBillMatchService.setAttFilePersonInfo(attFile, ruleConditionRetrieval);
                }
                ruleConditionRetrievals.add(ruleConditionRetrieval);
            }
        }
        RuleConditionBillMatchService.beginRetrievalMatch(ruleConditionRetrievals);
        return ruleConditionRetrievals;
    }

    public static List<RuleConditionRetrieval> billLimitMatchForType(List<RuleConditionBillNoDateLimitDto> noDateLimitDtos) {
        ArrayList<RuleConditionRetrieval> ruleConditionRetrievals = new ArrayList<RuleConditionRetrieval>(16);
        HashSet attPersonIds = Sets.newHashSetWithExpectedSize((int)noDateLimitDtos.size());
        for (RuleConditionBillNoDateLimitDto noDateLimitDto : noDateLimitDtos) {
            RuleConditionRetrieval ruleConditionRetrieval = new RuleConditionRetrieval();
            AccessDto accessDto = noDateLimitDto.getAccessDto();
            if (accessDto == null || WTCCollections.isEmpty(accessDto.getConditionList())) {
                ruleConditionRetrieval.setNeedExecuteMatch(false);
            }
            ruleConditionRetrieval.setAccessDto(accessDto);
            ruleConditionRetrieval.setDimensionKey(noDateLimitDto.getDimensionKey());
            if (ruleConditionRetrieval.isNeedExecuteMatch()) {
                ruleConditionRetrieval.setBillDy(noDateLimitDto.getBillDy());
                ruleConditionRetrieval.setEntryKey(noDateLimitDto.getEntryKey());
                ruleConditionRetrieval.setIndex(noDateLimitDto.getIndex());
                if (noDateLimitDto.getDutyDate() != null) {
                    ruleConditionRetrieval.setOwnDate(noDateLimitDto.getDutyDate());
                } else {
                    ruleConditionRetrieval.setOwnDate(WTCDateUtils.toDate((LocalDate)LocalDate.now()));
                }
                DynamicObject attFileV = noDateLimitDto.getAttFileV();
                if (attFileV != null) {
                    RuleConditionBillMatchService.setAttFilePersonInfo(attFileV, ruleConditionRetrieval);
                }
                ruleConditionRetrieval.setAttPersonId(noDateLimitDto.getAttPersonId());
                ruleConditionRetrieval.setBillBusType(noDateLimitDto.getBillBusType());
                RuleConditionBillMatchService.collectQueryAgePersonIds(attPersonIds, ruleConditionRetrieval);
            }
            ruleConditionRetrievals.add(ruleConditionRetrieval);
        }
        RuleConditionBillMatchService.fillStandardRetrieval(ruleConditionRetrievals, attPersonIds);
        RuleConditionBillMatchService.beginRetrievalMatch(ruleConditionRetrievals);
        return ruleConditionRetrievals;
    }

    private static List<RuleConditionRetrieval> buildRuleConditionRetrieval(UnifyBillResult billResult, UnifyBillEntryResult entryResult, RuleConditionBillLimitDto billLimitDto, Set<Long> attPersonIds) {
        UnifyBillInfoContext unifyBillInfoContext = billLimitDto.getUnifyBillInfoContext();
        Map<UnifyBillDutyInfoResult, List<MatchRuleCal>> ruleCalIdAndMatchRuleCalMap = billLimitDto.getRuleCalIdAndMatchRuleCalMap();
        List dutyInfos = entryResult.getDutyInfos();
        ArrayList<RuleConditionRetrieval> ruleConditionRetrievals = new ArrayList<RuleConditionRetrieval>(16);
        for (UnifyBillDutyInfoResult dutyInfoResult : dutyInfos) {
            List<MatchRuleCal> matchRuleCals = ruleCalIdAndMatchRuleCalMap.get(dutyInfoResult);
            if (WTCCollections.isEmpty(matchRuleCals)) continue;
            for (MatchRuleCal matchRuleCal : matchRuleCals) {
                boolean typeEquals;
                RuleConditionRetrieval billRetrieval = new RuleConditionRetrieval();
                AccessDto accessDto = (AccessDto)matchRuleCal.getAccessDto();
                if (accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
                    billRetrieval.setAccessDto(accessDto);
                } else {
                    billRetrieval.setNeedExecuteMatch(false);
                }
                billRetrieval.setDimensionKey(matchRuleCal.getDimensionKey());
                boolean bl = typeEquals = matchRuleCal.getRuleCalTypeId() == matchRuleCal.getNeedMatchTypeId().longValue();
                if (!typeEquals) {
                    billRetrieval.setMatchResult(false);
                    billRetrieval.setNeedExecuteMatch(false);
                }
                if (billRetrieval.isNeedExecuteMatch()) {
                    billRetrieval.setBillDy(billResult.getBillDy());
                    billRetrieval.setEntryKey(entryResult.getEntryKey());
                    billRetrieval.setIndex(entryResult.getEntryIndex());
                    DynamicObject attFileVersionDy = matchRuleCal.getAttFileVersionDy();
                    if (attFileVersionDy != null) {
                        RuleConditionBillMatchService.setAttFilePersonInfo(attFileVersionDy, billRetrieval);
                    }
                    RuleConditionBillMatchService.collectQueryAgePersonIds(attPersonIds, billRetrieval);
                    Date dutyDate = dutyInfoResult.getDutyDate();
                    if (dutyDate == null) {
                        dutyDate = entryResult.getDutyDateQueryStartTime();
                    }
                    billRetrieval.setOwnDate(dutyDate);
                    billRetrieval.setBillBusType(unifyBillInfoContext.getBillType().name());
                }
                ruleConditionRetrievals.add(billRetrieval);
            }
        }
        return ruleConditionRetrievals;
    }

    private static void billDateRangeMatchStandardRetrievals(AccessDto accessDto, DateRangeDto dateRangeDto, RuleConditionBillDateRangeDto matchBillDateRangeDto, RuleConditionRetrieval ruleConditionRetrieval) {
        ArrayList<RuleConditionStandardRetrieval> standardRetrievals = new ArrayList<RuleConditionStandardRetrieval>(accessDto.getConditionList().size());
        for (ConditionDto conditionDto : accessDto.getConditionList()) {
            String paramUniqueKey;
            Boolean result;
            String retrievalWay = conditionDto.getRetrievalWay();
            if (!HRStringUtils.isEmpty((String)retrievalWay) && !RetrievalTypeEnum.STANDARD.getValue().equals(retrievalWay)) continue;
            String paramNoPrefix = RuleConditionCommonService.getParamNoPrefix(conditionDto.getParam());
            Function<Object, Object> function = DATERANGERETRIEVALFUNCMAP.get(paramNoPrefix);
            if (function != null) {
                RuleConditionStandardRetrieval standardRetrieval = new RuleConditionStandardRetrieval();
                standardRetrieval.setConditionParamKey(conditionDto.getParam());
                standardRetrieval.setRetrievalObj(dateRangeDto);
                standardRetrieval.setRetrievalFunc(function);
                standardRetrievals.add(standardRetrieval);
                continue;
            }
            Map<String, Boolean> dateTypePatternMatchResult = matchBillDateRangeDto.getDateTypePatternMatchResult();
            if (!WTCCollections.isNotEmpty(dateTypePatternMatchResult) || (result = dateTypePatternMatchResult.get(paramUniqueKey = RuleConditionCommonService.getConditionParamUniqueKey(conditionDto))) == null) continue;
            ruleConditionRetrieval.addParamResult(paramUniqueKey, result);
        }
        ruleConditionRetrieval.setStandardRetrievals(standardRetrievals);
    }

    public static void fillStandardRetrieval(List<RuleConditionRetrieval> ruleConditionRetrievals, Set<Long> attPersonIds) {
        if (WTCCollections.isNotEmpty(ruleConditionRetrievals)) {
            Map<Long, Map<String, Object>> pernontspropMap = RuleConditionBillMatchService.getPernontsprop(attPersonIds);
            Map<Long, DynamicObject> trialPeriodMap = RuleConditionBillMatchService.getTrialPeriod(attPersonIds);
            Map<Long, DynamicObject> empJobRelMap = RuleConditionBillMatchService.getEmpJobRel(attPersonIds);
            for (RuleConditionRetrieval retrieval : ruleConditionRetrievals) {
                DynamicObject attFileV;
                if (!retrieval.isNeedExecuteMatch() || (attFileV = retrieval.getAttFileV()) == null) continue;
                long attPersonId = retrieval.getAttPersonId();
                Map<String, Object> pernontsprop = pernontspropMap.get(attPersonId);
                DynamicObject trialPeriodDynamicObject = trialPeriodMap.get(attPersonId);
                DynamicObject empJobRelDynamicObject = empJobRelMap.get(attPersonId);
                RuleConditionBillMatchService.initRetrievalFunc(retrieval, attFileV, pernontsprop, trialPeriodDynamicObject, empJobRelDynamicObject);
            }
        }
    }

    public static void beginRetrievalMatch(List<RuleConditionRetrieval> ruleConditionRetrievals) {
        try {
            String classPath = "kd.wtc.wtbd.business.rulecondition.RuleConditionMatchService";
            IRuleConditionMatchService matchService = (IRuleConditionMatchService)WTCAppContextHelper.getBean((String)classPath, IRuleConditionMatchService.class);
            matchService.matchRuleCondition(ruleConditionRetrievals);
        }
        catch (KDBizException exception) {
            throw exception;
        }
        catch (Exception exception) {
            LOG.warn("RuleConditionBillMatchService.beginRetrievalMatch exception", (Throwable)exception);
            throw new KDBizException("Retrieval Fail");
        }
    }

    private static void setRetrievalBillInfo(RuleConditionRetrieval ruleConditionRetrieval, RuleConditionBillDateRangeDto matchBillDateRangeDto) {
        ruleConditionRetrieval.setBillDy(matchBillDateRangeDto.getBillDy());
        ruleConditionRetrieval.setEntryKey(matchBillDateRangeDto.getEntryKey());
        ruleConditionRetrieval.setIndex(matchBillDateRangeDto.getIndex());
        ruleConditionRetrieval.setDimensionKey(matchBillDateRangeDto.getDimensionKey());
        ruleConditionRetrieval.setOwnDate(matchBillDateRangeDto.getDutyDate());
    }

    private static void setAttFilePersonInfo(DynamicObject attFile, RuleConditionRetrieval retrieval) {
        if (attFile != null && retrieval != null) {
            long attPersonId = WTCDynamicObjectUtils.getBaseDataId(attFile, "attperson");
            retrieval.setAttFileVId(attFile.getLong("id"));
            retrieval.setAttPersonId(attPersonId);
            retrieval.setAttFileBoId(attFile.getLong("boid"));
            retrieval.setPersonId(attFile.getLong("person.id"));
            retrieval.setEmployeeId(attFile.getLong("employee.id"));
            retrieval.setDempempId(attFile.getLong("depemp.id"));
            retrieval.setAttFileV(attFile);
        }
    }

    private static Map<Long, DynamicObject> queryAttFileMap(List<RuleConditionBillDateRangeDto> dateRangeDtos) {
        Set<Long> attFileIds = dateRangeDtos.stream().filter(item -> item.getAttFileV() == null).map(item -> item.getBillDy().getLong("attfilebasef7.id")).collect(Collectors.toSet());
        return RuleConditionBillMatchService.getAttFileByIds(attFileIds);
    }

    private static void initDateTypePatternResult(Map<Long, DynamicObject> dataTypePatternMap, List<RuleConditionBillDateRangeDto> dateRangeDtos) {
        for (RuleConditionBillDateRangeDto billDateRangeDto : dateRangeDtos) {
            String condition = billDateRangeDto.getCondition();
            TimeInterval timeInterval = billDateRangeDto.getTimeInterval();
            AccessDto ruleConditionInfo = ConditionValidateService.getRuleConditionInfo(condition);
            if (ruleConditionInfo == null || WTCCollections.isEmpty(ruleConditionInfo.getConditionList())) continue;
            List<ConditionDto> conditionList = ruleConditionInfo.getConditionList();
            List dateTypePatternParams = conditionList.stream().filter(item -> item.getParam().contains("datetypepattern")).collect(Collectors.toList());
            for (ConditionDto conditionDto : dateTypePatternParams) {
                String strIds = conditionDto.getValue();
                String[] split = strIds.split(",");
                boolean matchResult = false;
                for (String strId : split) {
                    long longId = Long.parseLong(strId);
                    DynamicObject dataTypePatternDy = dataTypePatternMap.get(longId);
                    if (dataTypePatternDy == null) continue;
                    String datatype = dataTypePatternDy.getString("datatype");
                    LocalDate shiftDate = WTCDateUtils.toLocalDate((Date)timeInterval.getRosterDate());
                    LocalDateTime startTime = WTCDateUtils.toLocalDateTime((Date)timeInterval.getOtStartDate());
                    LocalDateTime endTime = WTCDateUtils.toLocalDateTime((Date)timeInterval.getOtEndDate());
                    if (HRStringUtils.equals((String)datatype, (String)"2")) {
                        matchResult = RuleConditionBillMatchService.fixIntersect(startTime, endTime, shiftDate, dataTypePatternDy);
                    } else if (HRStringUtils.equals((String)datatype, (String)"3")) {
                        matchResult = RuleConditionBillMatchService.weekIntersect(startTime, endTime, shiftDate, dataTypePatternDy);
                    }
                    if (matchResult) break;
                }
                billDateRangeDto.addDateTypePatternMatchResult(RuleConditionCommonService.getConditionParamUniqueKey(conditionDto), matchResult);
            }
        }
    }

    private static Map<Long, DynamicObject> queryDateTypePattern(List<RuleConditionBillDateRangeDto> dateRangeDtos) {
        ArrayList dateTypePatternIds = new ArrayList(dateRangeDtos.size());
        for (RuleConditionBillDateRangeDto billDateRangeDto : dateRangeDtos) {
            String condition = billDateRangeDto.getCondition();
            AccessDto ruleConditionInfo = ConditionValidateService.getRuleConditionInfo(condition);
            if (ruleConditionInfo == null || !WTCCollections.isNotEmpty(ruleConditionInfo.getConditionList())) continue;
            List<ConditionDto> conditionList = ruleConditionInfo.getConditionList();
            List strIds = conditionList.stream().filter(item -> item.getParam().contains("datetypepattern")).map(ConditionDto::getValue).collect(Collectors.toList());
            for (String id : strIds) {
                String[] split = id.split(",");
                dateTypePatternIds.addAll(Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList()));
            }
        }
        if (WTCCollections.isNotEmpty(dateTypePatternIds)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_datetypeper");
            DynamicObject[] dateTypePatternDys = serviceHelper.loadDynamicObjectArray(new QFilter("id", "in", dateTypePatternIds).toArray());
            return Arrays.stream(dateTypePatternDys).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (o1, o2) -> o1));
        }
        return Maps.newHashMap();
    }

    private static void initRetrievalFunc(RuleConditionRetrieval retrieval, DynamicObject attFile, Map<String, Object> pernontsprop, DynamicObject trialPeriodDynamicObject, DynamicObject empJobRelDynamicObject) {
        AccessDto accessDto = retrieval.getAccessDto();
        if (accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
            AttfileLimitScope attfileLimitScope = RuleConditionBillMatchService.initAttfileLimitScope(attFile, pernontsprop, trialPeriodDynamicObject, empJobRelDynamicObject);
            ArrayList<RuleConditionStandardRetrieval> standardRetrievals = new ArrayList<RuleConditionStandardRetrieval>(accessDto.getConditionList().size());
            for (ConditionDto conditionDto : accessDto.getConditionList()) {
                String retrievalWay = conditionDto.getRetrievalWay();
                if (!HRStringUtils.isEmpty((String)retrievalWay) && !RetrievalTypeEnum.STANDARD.getValue().equals(retrievalWay)) continue;
                String param = conditionDto.getParam();
                String paramNoPrefix = RuleConditionCommonService.getParamNoPrefix(param);
                Function<Object, Object> func = LIMITRETRIEVALFUNCMAP.get(paramNoPrefix);
                RuleConditionStandardRetrieval standardRetrieval = new RuleConditionStandardRetrieval();
                standardRetrieval.setRetrievalObj(attfileLimitScope);
                standardRetrieval.setRetrievalFunc(func);
                standardRetrieval.setConditionParamKey(param);
                standardRetrievals.add(standardRetrieval);
            }
            retrieval.setExtData(attfileLimitScope);
            retrieval.setStandardRetrievals(standardRetrievals);
        }
    }

    private static void collectQueryAgePersonIds(Set<Long> attPersonIds, RuleConditionRetrieval billRetrieval) {
        boolean needExecuteMatch = billRetrieval.isNeedExecuteMatch();
        AccessDto accessDto = billRetrieval.getAccessDto();
        if (needExecuteMatch && accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
            for (ConditionDto conditionDto : accessDto.getConditionList()) {
                String param = conditionDto.getParam();
                if (!HRStringUtils.isNotEmpty((String)param) || !param.contains("age")) continue;
                attPersonIds.add(billRetrieval.getPersonId());
            }
        }
    }

    private static AttfileLimitScope initAttfileLimitScope(DynamicObject attFile, Map<String, Object> pernontsprop, DynamicObject trialPeriodDynamicObject, DynamicObject empJobRelDynamicObject) {
        if (attFile == null) {
            return new AttfileLimitScope();
        }
        AttfileLimitScope attfileLimitScope = new AttfileLimitScope();
        attfileLimitScope.setGender(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("attperson.gender.id")));
        attfileLimitScope.setAge(pernontsprop == null ? null : RuleConditionBillMatchService.getIntegerDefaultValue(pernontsprop.get("age")));
        attfileLimitScope.setBeginservicedate(attFile.getDate("attperson.beginservicedate"));
        if (trialPeriodDynamicObject != null) {
            attfileLimitScope.setEntrydate(trialPeriodDynamicObject.getDate("entrydate"));
            attfileLimitScope.setRegulardate(trialPeriodDynamicObject.getDate("realregulardate"));
        }
        attfileLimitScope.setLaborrelstatus(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("attperson.laborrelstatus.id")));
        if (empJobRelDynamicObject != null) {
            attfileLimitScope.setJoblevel(RuleConditionBillMatchService.getLongDefaultValue(empJobRelDynamicObject.get("joblevel.id")));
            attfileLimitScope.setJobgrade(RuleConditionBillMatchService.getLongDefaultValue(empJobRelDynamicObject.get("jobgrade.id")));
        }
        attfileLimitScope.setObseq(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("attperson.jobhr.jobseq.id")));
        attfileLimitScope.setWorkplace(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("workplace.id")));
        attfileLimitScope.setDependencytype(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("dependencytype.id")));
        attfileLimitScope.setDependency(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("dependency.id")));
        attfileLimitScope.setEmpGroup(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("empgroup.id")));
        attfileLimitScope.setOrg(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("org.id")));
        attfileLimitScope.setAffiliateadminorg(RuleConditionBillMatchService.getLongDefaultValue(attFile.get("affiliateadminorg.id")));
        if (LOG.isDebugEnabled()) {
            LOG.debug("RuleConditionBillMatchService.initAttfileLimitScope,SCOPE:{}", (Object)JSON.toJSONString((Object)attfileLimitScope));
        }
        return attfileLimitScope;
    }

    public static Map<Long, DynamicObject> getAttFileByIds(Set<Long> attFileVIds) {
        if (WTCCollections.isEmpty(attFileVIds)) {
            return Collections.emptyMap();
        }
        String queryProp = "id,boid,attperson,attperson.gender.id,attperson.beginservicedate,attperson.entrydate,attperson.laborrelstatus.id,attperson.joblevel.id,attperson.jobgrade.id,attperson.jobhr.jobseq.id,attperson.regulardate,workplace.id,dependencytype.id,person.id,employee.id,depemp.id,dependency.id,empgroup.id,org.id,affiliateadminorg.id";
        List<DynamicObject> attFiles = AttFileQueryHelper.queryAttFileByIds(queryProp, Lists.newArrayList(attFileVIds));
        return attFiles.stream().collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (o1, o2) -> o2));
    }

    private static Map<Long, DynamicObject> getTrialPeriod(Set<Long> personIds) {
        if (WTCCollections.isEmpty(personIds)) {
            return Collections.emptyMap();
        }
        QFilter personQFilter = new QFilter("person", "in", personIds);
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        DynamicObject[] trialPeriodArr = hrpimService.listFieldsFilterInfo(StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.TRIALPERIOD_FIELDS), (String)","), personQFilter, "hrpi_trialperiod");
        Map<Long, DynamicObject> trialPeriodGroupBy = Arrays.stream(trialPeriodArr).collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        return trialPeriodGroupBy;
    }

    private static Map<Long, Map<String, Object>> getPernontsprop(Set<Long> personIds) {
        if (WTCCollections.isEmpty(personIds)) {
            return Collections.emptyMap();
        }
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        List<Map<String, Object>> perNotProp = hrpimService.listBatchPersonAttachs(Lists.newArrayList(personIds), null, "hrpi_pernontsprop");
        return perNotProp.stream().filter(info -> info.get("person_id") != null).collect(Collectors.toMap(info -> (Long)info.get("person_id"), Function.identity(), (a1, b1) -> a1));
    }

    private static Map<Long, DynamicObject> getEmpJobRel(Set<Long> personIds) {
        if (WTCCollections.isEmpty(personIds)) {
            return Collections.emptyMap();
        }
        QFilter personQFilter = new QFilter("person", "in", personIds);
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        DynamicObject[] empJobRelArr = hrpimService.listFieldsFilterInfo(StringUtils.join(Arrays.asList(HRPIEntityPropertyConst.EMPJOBREL_FIELDS), (String)","), personQFilter, "hrpi_empjobrel");
        Map<Long, DynamicObject> empJobRelGroupBy = Arrays.stream(empJobRelArr).filter(d -> "1".equals(d.getString("businessstatus"))).collect(Collectors.toMap(d -> d.getLong("person.id"), Function.identity(), (item1, item2) -> item1.getDate("bsed").compareTo(item2.getDate("bsed")) >= 0 ? item1 : item2));
        return empJobRelGroupBy;
    }

    private static Integer getIntegerDefaultValue(Object obj) {
        return obj == null || (Integer)obj == 0 ? null : (Integer)obj;
    }

    private static Long getLongDefaultValue(Object obj) {
        return obj == null || (Long)obj == 0L ? null : (Long)obj;
    }

    private static boolean isNeedQueryShiftSplitSimple(TimeInterval interval, String conditionJson) {
        if (interval.getStartDate() == null || interval.getEndDate() == null || interval.getOtStartDate() == null && interval.getOtEndDate() == null) {
            return false;
        }
        Optional<AccessDto> optional = RuleConditionBillMatchService.getAccessDto(conditionJson);
        if (!optional.isPresent()) {
            return false;
        }
        List<ConditionDto> conditionList = optional.get().getConditionList();
        if (WTCCollections.isEmpty(conditionList)) {
            return false;
        }
        List result = conditionList.stream().filter(dto -> dto.getParam().contains("timebucketposition") || dto.getParam().contains("shifttimebucketproperty")).collect(Collectors.toList());
        return !WTCCollections.isEmpty(result);
    }

    private static Optional<AccessDto> getAccessDto(String conditionJson) {
        try {
            return Optional.of(SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class));
        }
        catch (Exception exception) {
            LOG.warn("\u89c4\u5219\u6761\u4ef6\u8f6c\u6362\u5931\u8d25\uff0cconditionJson\uff1a{}\uff0cexception:{}", (Object)conditionJson, (Object)exception.getMessage());
            return Optional.empty();
        }
    }

    private static List<TimeIntervalResult> filterNotInOTTime(List<TimeIntervalResult> timeIntervalResultList, TimeInterval interval) {
        ArrayList intervalResults = Lists.newArrayListWithExpectedSize((int)10);
        intervalResults.addAll(timeIntervalResultList);
        Date otStartDate = interval.getOtStartDate();
        Date otEndDate = interval.getOtEndDate();
        Iterator iterator = intervalResults.iterator();
        while (iterator.hasNext()) {
            TimeIntervalResult timeIntervalResult = (TimeIntervalResult)iterator.next();
            Date startDate = timeIntervalResult.getIntervalStartDate();
            Date endDate = timeIntervalResult.getIntervalEndDate();
            if (startDate == null || endDate == null || endDate.getTime() > otStartDate.getTime() && startDate.getTime() < otEndDate.getTime()) continue;
            iterator.remove();
        }
        return intervalResults;
    }

    private static boolean fixIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDate shiftDate, DynamicObject dynamicObject) {
        boolean flag = false;
        DynamicObjectCollection fixtimeentity = dynamicObject.getDynamicObjectCollection("fixtimeentity");
        for (DynamicObject fixtime : fixtimeentity) {
            String stagdate = fixtime.getString("stagdate");
            int begintime = fixtime.getInt("begintime");
            String etagdate = fixtime.getString("etagdate");
            int endtime = fixtime.getInt("endtime");
            LocalDateTime enableStart = shiftDate.atStartOfDay().plusSeconds(begintime);
            LocalDateTime enableEnd = shiftDate.atStartOfDay().plusSeconds(endtime);
            if ("C".equals(stagdate)) {
                enableStart = enableStart.plusDays(1L);
            } else if ("Q".equals(stagdate)) {
                enableStart = enableStart.plusDays(-1L);
            }
            if ("C".equals(etagdate)) {
                enableEnd = enableEnd.plusDays(1L);
            } else if ("Q".equals(etagdate)) {
                enableEnd = enableEnd.plusDays(-1L);
            }
            if (!(flag = RuleConditionBillMatchService.timeIntersect(enableStart, enableEnd, startTime, endTime))) continue;
            break;
        }
        return flag;
    }

    private static boolean weekIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDate shiftDate, DynamicObject dynamicObject) {
        boolean flag = false;
        DayOfWeek dayOfWeek = shiftDate.getDayOfWeek();
        DynamicObjectCollection weekentry = dynamicObject.getDynamicObjectCollection("weekentry");
        List dayenable = weekentry.stream().filter(item -> item.getBoolean("dayenable") && item.getString("weekday").equals(String.valueOf(dayOfWeek.getValue()))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dayenable)) {
            DynamicObject currentWeekDay = (DynamicObject)dayenable.get(0);
            String timetype = currentWeekDay.getString("timetype");
            if (timetype.equals("1")) {
                LocalDateTime enableStart = shiftDate.atStartOfDay();
                LocalDateTime enableEnd = WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getDayLastDate((Date)WTCDateUtils.toDate((LocalDate)shiftDate)));
                flag = RuleConditionBillMatchService.timeIntersect(enableStart, enableEnd, startTime, endTime);
            } else {
                flag = RuleConditionBillMatchService.defineIntersect(startTime, endTime, shiftDate, currentWeekDay);
            }
        }
        return flag;
    }

    private static boolean defineIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDate shiftDate, DynamicObject currentWeekDay) {
        boolean flag = false;
        for (int i = 1; i <= 5; ++i) {
            LocalDateTime enableEnd;
            LocalDateTime enableStart;
            int startSecond = currentWeekDay.getInt("start" + i);
            int endSecond = currentWeekDay.getInt("end" + i);
            if ((startSecond > 0 || endSecond > 0) && (flag = RuleConditionBillMatchService.timeIntersect(enableStart = shiftDate.atTime(startSecond / 3600, startSecond % 3600 / 60, startSecond % 3600 % 60), enableEnd = shiftDate.atTime(endSecond / 3600, endSecond % 3600 / 60, endSecond % 3600 % 60), startTime, endTime))) break;
        }
        return flag;
    }

    private static boolean timeIntersect(LocalDateTime startTime, LocalDateTime endTime, LocalDateTime otStartTime, LocalDateTime otendTime) {
        return startTime != null && endTime != null && otStartTime != null && otendTime != null && startTime.isBefore(otendTime) && !endTime.isBefore(otStartTime);
    }

    static {
        LIMITRETRIEVALFUNCMAP.put("gender.id", item -> ((AttfileLimitScope)item).getGender());
        LIMITRETRIEVALFUNCMAP.put("age", item -> ((AttfileLimitScope)item).getAge());
        LIMITRETRIEVALFUNCMAP.put("beginservicedate", item -> ((AttfileLimitScope)item).getBeginservicedate());
        LIMITRETRIEVALFUNCMAP.put("entrydate", item -> ((AttfileLimitScope)item).getEntrydate());
        LIMITRETRIEVALFUNCMAP.put("regulardate", item -> ((AttfileLimitScope)item).getRegulardate());
        LIMITRETRIEVALFUNCMAP.put("realregulardate", item -> ((AttfileLimitScope)item).getRegulardate());
        LIMITRETRIEVALFUNCMAP.put("laborrelstatus.id", item -> ((AttfileLimitScope)item).getLaborrelstatus());
        LIMITRETRIEVALFUNCMAP.put("joblevel.id", item -> ((AttfileLimitScope)item).getJoblevel());
        LIMITRETRIEVALFUNCMAP.put("jobgrade.id", item -> ((AttfileLimitScope)item).getJobgrade());
        LIMITRETRIEVALFUNCMAP.put("obseq.id", item -> ((AttfileLimitScope)item).getObseq());
        LIMITRETRIEVALFUNCMAP.put("jobseq.id", item -> ((AttfileLimitScope)item).getObseq());
        LIMITRETRIEVALFUNCMAP.put("workplace.id", item -> ((AttfileLimitScope)item).getWorkplace());
        LIMITRETRIEVALFUNCMAP.put("dependencytype.id", item -> ((AttfileLimitScope)item).getDependencytype());
        LIMITRETRIEVALFUNCMAP.put("dependency.id", item -> ((AttfileLimitScope)item).getDependency());
        LIMITRETRIEVALFUNCMAP.put("empgroup.id", item -> ((AttfileLimitScope)item).getEmpGroup());
        LIMITRETRIEVALFUNCMAP.put("org.id", item -> ((AttfileLimitScope)item).getOrg());
        LIMITRETRIEVALFUNCMAP.put("affiliateadminorg.id", item -> ((AttfileLimitScope)item).getAffiliateadminorg());
        DATERANGERETRIEVALFUNCMAP = new HashMap<String, Function<Object, Object>>(16);
        DATERANGERETRIEVALFUNCMAP.put("datetype.id", item -> ((DateRangeDto)item).getTimeInterval().getDateType());
        DATERANGERETRIEVALFUNCMAP.put("shifttimebucketproperty", item -> ((DateRangeDto)item).getTimeIntervalResult().getShiftTimeBucketProperty());
        DATERANGERETRIEVALFUNCMAP.put("timebucketposition", item -> ((DateRangeDto)item).getTimeIntervalResult().getTimeBucketPosition());
        DATERANGERETRIEVALFUNCMAP.put("off", item -> {
            TimeInterval timeInterval = ((DateRangeDto)item).getTimeInterval();
            Shift shiftSpec = timeInterval.getShiftSpec();
            return shiftSpec == null ? Boolean.FALSE : Boolean.valueOf(shiftSpec.isOff());
        });
        DATERANGERETRIEVALFUNCMAP.put("shiftspec.id", item -> {
            TimeInterval timeInterval = ((DateRangeDto)item).getTimeInterval();
            Shift shiftSpec = timeInterval.getShiftSpec();
            return shiftSpec.getBoId();
        });
        DATERANGERETRIEVALFUNCMAP.put("dateattribute", item -> ((DateRangeDto)item).getTimeInterval().getDateAttribute());
    }
}

