/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecondition.bill;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.rulecondition.RuleConditionResultMatchService;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.business.rulecondition.ThreeFunction;
import kd.wtc.wtbs.common.util.WTCCollections;

public class RuleConditionCommonService {
    private static final Log LOG = LogFactory.getLog(RuleConditionCommonService.class);

    public static String getBillEntrySeqKey(DynamicObject billDy, String entryKey, int seq) {
        if (billDy == null) {
            return "";
        }
        long pkId = billDy.getLong("id");
        if (pkId == 0L) {
            pkId = ID.genLongId();
            billDy.set("id", (Object)pkId);
        }
        return pkId + "_" + entryKey + "_" + seq;
    }

    public static String getConditionParamUniqueKey(ConditionDto conditionDto) {
        if (conditionDto != null) {
            return conditionDto.getName() + "_" + conditionDto.getParam();
        }
        return "";
    }

    public static String getParamNoPrefix(String param) {
        String noPrefixParam = "";
        if (HRStringUtils.isNotEmpty((String)param)) {
            int fi = param.indexOf(".");
            noPrefixParam = fi != -1 ? param.substring(param.indexOf(".", fi + 1) + 1) : param;
        }
        return noPrefixParam;
    }

    public static Map<String, List<RuleConditionRetrieval>> groupByRetrievalResult(List<RuleConditionRetrieval> retrievals) {
        if (WTCCollections.isNotEmpty(retrievals)) {
            return retrievals.stream().collect(Collectors.groupingBy(RuleConditionRetrieval::getDimensionKey));
        }
        return Collections.emptyMap();
    }

    public static void configItemRetrieval(ConditionDto dto, Map<String, Boolean> map, RuleConditionValues retrievalDimension) {
        String paramType;
        ThreeFunction<ConditionDto, Object, Map<String, Boolean>> paramMatchFunc;
        if (retrievalDimension == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("AttfileLimitScopeServiceImpl.configItemRetrieval,\u53c2\u6570\u540d\u79f0\uff1a{}\uff0c\u53c2\u6570\u6807\u8bc6\uff1a{}\uff0citemUnicodeValues is empty", (Object)dto.getDisplayParam(), (Object)dto.getParam());
            }
            map.put(dto.getName(), true);
            return;
        }
        String uniqueCode = dto.getUniqueCode();
        Object uniqueCodeValue = null;
        if (!retrievalDimension.isValueExist(uniqueCode)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("AttfileLimitScopeServiceImpl.configItemRetrieval,\u53c2\u6570\u540d\u79f0\uff1a{}\uff0c\u53c2\u6570\u6807\u8bc6\uff1a{}\uff0citemUnicodeValues not containsKey", (Object)dto.getDisplayParam(), (Object)dto.getParam());
            }
        } else {
            uniqueCodeValue = retrievalDimension.getValue(uniqueCode);
        }
        if ((paramMatchFunc = RuleConditionResultMatchService.getParamMatchFunc(paramType = dto.getParamType())) != null) {
            paramMatchFunc.apply(dto, uniqueCodeValue, map);
            if (LOG.isInfoEnabled()) {
                LOG.info("AttfileLimitScopeServiceImpl.configItemRetrieval,\u53c2\u6570\u540d\u79f0\uff1a{}\uff0c\u53c2\u6570\u6807\u8bc6\uff1a{}\uff0c\u53c2\u6570\u503c\uff1a{}", new Object[]{dto.getDisplayParam(), dto.getParam(), uniqueCodeValue});
            }
        } else {
            map.put(dto.getName(), true);
        }
    }
}

