/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecontrol;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.daterange.access.ExpressType;
import kd.wtc.wtbs.business.personfilter.enums.RuleParamTypeEnum;
import kd.wtc.wtbs.business.rulecontrol.entity.RuleValidateInfo;
import kd.wtc.wtbs.common.rulecontrol.RuleCusControlConstants;
import kd.wtc.wtbs.common.util.WTCCollections;

public class ConditionValidateService
implements RuleCusControlConstants {
    private static final String[] PATTERNS = new String[]{"^[+-]*\\dd$", "^[+-]*\\dw$", "^[+-]*\\dm$", "^[+-]*\\dq$", "^[+-]*\\dy$", "^[+-]*\\d+~[+-]*\\dm", "^<=\\dd$", "^>=\\dd$", "is_null", "is_not_null"};
    private static final String EXPRESS_PATTERN = "^\\(*T[0-9]+\\)*((and|or)\\(*T[0-9]+\\)*)*$";

    private ConditionValidateService() {
    }

    public static RuleValidateInfo validCondition(String conditionJson) {
        return ConditionValidateService.validCondition(conditionJson, false);
    }

    public static RuleValidateInfo validCondition(String conditionJson, boolean ignoreEmpty) {
        RuleValidateInfo info = new RuleValidateInfo();
        AccessDto ruleConditionInfo = ConditionValidateService.getRuleConditionInfo(conditionJson);
        if (ruleConditionInfo == null || WTCCollections.isEmpty(ruleConditionInfo.getConditionList())) {
            if (!ignoreEmpty) {
                info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6\u90e8\u5206\u3002", (String)"RuleValidateService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            return info;
        }
        List<ConditionDto> conditionList = ruleConditionInfo.getConditionList();
        for (ConditionDto conditionInfo : conditionList) {
            String value;
            String operators;
            if (HRStringUtils.isEmpty((String)conditionInfo.getParam())) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u53c2\u6570\u3002", (String)"RuleValidateService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), conditionInfo.getName()));
            }
            if (HRStringUtils.isEmpty((String)(operators = conditionInfo.getOperators()))) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u6bd4\u8f83\u7b26\u3002", (String)"RuleValidateService_2", (String)"wtc-wtbs-business", (Object[])new Object[0]), conditionInfo.getName()));
            }
            if (!ConditionValidateService.isNeedValue(operators)) continue;
            if (HRStringUtils.isEmpty((String)conditionInfo.getValueType()) || "0".equals(conditionInfo.getValueType())) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u503c\u7c7b\u578b\u3002", (String)"RuleValidateService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]), conditionInfo.getName()));
            }
            if (HRStringUtils.isEmpty((String)(value = ConditionValidateService.trim(conditionInfo.getValue())))) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u503c\u3002", (String)"RuleValidateService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]), conditionInfo.getName()));
                continue;
            }
            if (!"2".equals(conditionInfo.getValueType()) || !RuleParamTypeEnum.NUMBER.getValue().equals(conditionInfo.getParamType())) continue;
            ConditionValidateService.validNumber(info, value, "ruleCondition", 0, conditionInfo.getName());
        }
        ConditionValidateService.validExpression(ruleConditionInfo, info);
        return info;
    }

    private static void validExpression(AccessDto ruleConditionInfo, RuleValidateInfo info) {
        List<ExpressType> expressList = ruleConditionInfo.getConditionExpressList();
        Set expressNameList = expressList.stream().map(ExpressType::getName).collect(Collectors.toSet());
        String expressStr = ruleConditionInfo.getConditionExpressStr();
        if (!Pattern.matches(EXPRESS_PATTERN, expressStr.replaceAll(" ", ""))) {
            info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\u3002", (String)"RuleValidateService_5", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
        String[] str = expressStr.split(" ");
        int leftBracket = 0;
        int rightBracket = 0;
        for (String s : str) {
            if (HRStringUtils.isEmpty((String)s) || "and".equals(s) || "or".equals(s)) continue;
            if ("(".equals(s)) {
                ++leftBracket;
                continue;
            }
            if (")".equals(s)) {
                ++rightBracket;
                continue;
            }
            if (Pattern.matches("^T\\d{2,}$", s)) {
                if (expressNameList.contains(s)) continue;
                info.addMsg(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6761\u4ef6%s\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u540e\u518d\u91cd\u65b0\u914d\u7f6e\u3002", (String)"RuleValidateService_6", (String)"wtc-wtbs-business", (Object[])new Object[0]), s));
                continue;
            }
            info.addMsg(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u4e2d\u5b58\u5728\u65e0\u6548\u5b57\u7b26%s\u3002", (String)"RuleValidateService_7", (String)"wtc-wtbs-business", (Object[])new Object[0]), s));
        }
        if (leftBracket != rightBracket) {
            info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u62ec\u53f7\u4e2a\u6570\u4e0d\u5339\u914d\u3002", (String)"RuleValidateService_8", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        }
    }

    public static boolean isNumeric(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static void validNumber(RuleValidateInfo info, String number, String key, int index, String title) {
        BigDecimal num;
        if (!ConditionValidateService.isNumeric(number)) {
            String numberTypeMsg = String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57\u3002", (String)"RuleValidateService_9", (String)"wtc-wtbs-business", (Object[])new Object[0]), title);
            info.addMsg(numberTypeMsg);
            return;
        }
        if (number.contains(".") && number.length() - number.indexOf(46) > 11) {
            String numberDecimalPlacesMsg = String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d\u3002", (String)"RuleValidateService_10", (String)"wtc-wtbs-business", (Object[])new Object[0]), title);
            info.addMsg(numberDecimalPlacesMsg);
        }
        if ((num = new BigDecimal(number)).compareTo(new BigDecimal(Long.MIN_VALUE)) <= 0 || num.compareTo(new BigDecimal(Long.MAX_VALUE)) >= 0) {
            String numberScopeMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u6761\u4ef6%s\u7684\u503c\u8303\u56f4\u5728-9223372036854775808~9223372036854775807\u4e4b\u95f4", (String)"RuleValidateService_11", (String)"wtc-wtbs-business", (Object[])new Object[0]), title);
            info.addMsg(numberScopeMsg);
        }
    }

    private static String trim(String str) {
        return HRStringUtils.isNotEmpty((String)str) ? str.trim() : str;
    }

    public static boolean isNeedValue(String opt) {
        for (String pattern : PATTERNS) {
            if (!HRStringUtils.isNotEmpty((String)opt) || !Pattern.matches(pattern, opt)) continue;
            return false;
        }
        return true;
    }

    public static AccessDto getRuleConditionInfo(String condition) {
        if (HRStringUtils.isEmpty((String)condition)) {
            return new AccessDto();
        }
        return (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
    }
}

