/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecontrol;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.rulecontrol.RuleCusCacheService;
import kd.wtc.wtbs.business.rulecontrol.RuleCusControlService;
import kd.wtc.wtbs.business.rulecontrol.entity.RuleControlCfgInfo;
import kd.wtc.wtbs.common.rulecontrol.RuleCusControlConstants;

public class RuleConditionService
implements RuleCusControlConstants {
    private IFormView view;
    private String wtcKey;

    public static RuleConditionService getInstance(String wtcKey) {
        return new RuleConditionService(wtcKey);
    }

    public RuleConditionService setView(IFormView view) {
        this.view = view;
        boolean useCfgInited = RuleCusCacheService.isUseCfgInited(view);
        if (!useCfgInited) {
            RuleCusCacheService.initSceneUseCfg(view);
        }
        return this;
    }

    private RuleConditionService(String wtcKey) {
        this.wtcKey = wtcKey;
    }

    public void setValue(String express) {
        TargetCondition targetCondition;
        RuleControlCfgInfo sceneUseCfg = RuleCusCacheService.getSceneUseCfgByKey(this.view, this.wtcKey);
        if (sceneUseCfg == null) {
            return;
        }
        if (sceneUseCfg.isEnable()) {
            boolean inited = RuleCusCacheService.isInited(this.view, this.wtcKey);
            express = RuleCusCacheService.replaceText(this.view, this.wtcKey, express);
            if (inited) {
                RuleCusControlService.updateControlData(this.view, sceneUseCfg.getWtcControlNumber(), "value", express);
            }
            RuleCusCacheService.cacheControlValue(this.view, this.wtcKey, express);
        } else if (HRStringUtils.isNotEmpty((String)sceneUseCfg.getHrControlNumber()) && (targetCondition = (TargetCondition)this.view.getControl(sceneUseCfg.getHrControlNumber())) != null) {
            targetCondition.setValue(express);
        }
    }

    public String getValue() {
        TargetCondition targetCondition;
        RuleControlCfgInfo sceneUseCfg = RuleCusCacheService.getSceneUseCfgByKey(this.view, this.wtcKey);
        String express = "";
        if (sceneUseCfg == null) {
            return express;
        }
        if (sceneUseCfg.isEnable()) {
            express = RuleCusCacheService.getControlValue(this.view, this.wtcKey);
        } else if (HRStringUtils.isNotEmpty((String)sceneUseCfg.getHrControlNumber()) && (targetCondition = (TargetCondition)this.view.getControl(sceneUseCfg.getHrControlNumber())) != null) {
            express = targetCondition.getValue();
        }
        return express;
    }

    public void setReplaceText(Map<String, String> replaceMap) {
        RuleCusCacheService.cacheReplaceText(this.view, this.wtcKey, replaceMap);
    }

    public void setCusComparisonOperators(Map<String, List<Map<String, String>>> operators) {
        RuleCusCacheService.cacheCusComparisonOperators(this.view, this.wtcKey, operators);
    }

    public void setDate(String date) {
        TargetCondition targetCondition;
        RuleControlCfgInfo sceneUseCfg = RuleCusCacheService.getSceneUseCfgByKey(this.view, this.wtcKey);
        if (sceneUseCfg == null) {
            return;
        }
        if (sceneUseCfg.isEnable()) {
            RuleCusControlService.updateControlData(this.view, this.wtcKey, "date", date);
        } else if (HRStringUtils.isNotEmpty((String)sceneUseCfg.getHrControlNumber()) && (targetCondition = (TargetCondition)this.view.getControl(sceneUseCfg.getHrControlNumber())) != null) {
            targetCondition.setDate(date);
        }
    }

    public void setPageState(String pageState) {
        TargetCondition targetCondition;
        RuleControlCfgInfo sceneUseCfg = RuleCusCacheService.getSceneUseCfgByKey(this.view, this.wtcKey);
        if (sceneUseCfg == null) {
            return;
        }
        if (sceneUseCfg.isEnable()) {
            pageState = pageState.toUpperCase(Locale.ROOT);
            boolean inited = RuleCusCacheService.isInited(this.view, this.wtcKey);
            if (!inited) {
                RuleCusCacheService.cachePageState(this.view, sceneUseCfg.getWtcControlNumber(), pageState);
            } else {
                RuleCusControlService.updateControlData(this.view, this.wtcKey, "pageState", pageState);
            }
        } else if (HRStringUtils.isNotEmpty((String)sceneUseCfg.getHrControlNumber()) && (targetCondition = (TargetCondition)this.view.getControl(sceneUseCfg.getHrControlNumber())) != null) {
            targetCondition.setPageState(pageState);
        }
    }

    public void setCusAssignLogicType(List<String> logicTypes) {
        RuleCusCacheService.cacheCusAssignLogicType(this.view, this.wtcKey, logicTypes);
    }

    public void clear() {
        this.setValue("");
    }
}

