/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecontrol;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.rulecontrol.RuleCusControlHelper;
import kd.wtc.wtbs.business.rulecontrol.entity.RuleControlCfgInfo;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.rulecontrol.RuleCusControlConstants;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class RuleCusCacheService
implements RuleCusControlConstants {
    public static String getCacheKey(String ... args) {
        return WTCStringUtils.join((List)Lists.newArrayList((Object[])args), (String)"_");
    }

    public static void cacheSceneUseCfg(IFormView view, List<RuleControlCfgInfo> cfgInfos) {
        if (CollectionUtils.isNotEmpty(cfgInfos)) {
            view.getPageCache().put("configItemArgs", SerializationUtils.toJsonString(cfgInfos));
        }
    }

    public static List<RuleControlCfgInfo> getSceneUseCfg(IFormView view) {
        String cfgInfoStr = view.getPageCache().get("configItemArgs");
        if (HRStringUtils.isNotEmpty((String)cfgInfoStr)) {
            return SerializationUtils.fromJsonStringToList((String)cfgInfoStr, RuleControlCfgInfo.class);
        }
        return Collections.emptyList();
    }

    public static RuleControlCfgInfo getSceneUseCfgByKey(IFormView view, String wtcControlKey) {
        List<RuleControlCfgInfo> sceneUseCfg = RuleCusCacheService.getSceneUseCfg(view);
        RuleControlCfgInfo cfgInfo = null;
        Optional<RuleControlCfgInfo> first = sceneUseCfg.stream().filter(item -> wtcControlKey.equals(item.getWtcControlNumber())).findFirst();
        if (first.isPresent()) {
            cfgInfo = first.get();
        }
        return cfgInfo;
    }

    public static void cacheControlValue(IFormView view, String controlKey, String express) {
        String cacheKey = RuleCusCacheService.getCacheKey("expressValue_", controlKey);
        view.getPageCache().put(cacheKey, express);
    }

    public static String getControlValue(IFormView view, String controlKey) {
        String cacheKey = RuleCusCacheService.getCacheKey("expressValue_", controlKey);
        return view.getPageCache().get(cacheKey);
    }

    public static void cacheReplaceText(IFormView view, String controlKey, Map<String, String> replaceMap) {
        String cacheKey = RuleCusCacheService.getCacheKey("replaceText_", controlKey);
        if (replaceMap != null && replaceMap.size() > 0) {
            String replaceText = SerializationUtils.toJsonString(replaceMap);
            view.getPageCache().put(cacheKey, replaceText);
        }
    }

    public static Map<String, String> getReplaceText(IFormView view, String controlKey) {
        String cacheKey = RuleCusCacheService.getCacheKey("replaceText_", controlKey);
        String replaceText = view.getPageCache().get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)replaceText)) {
            Map replaceMap = (Map)SerializationUtils.fromJsonString((String)replaceText, Map.class);
            return replaceMap;
        }
        return Collections.emptyMap();
    }

    public static void cacheCusComparisonOperators(IFormView view, String controlKey, Map<String, List<Map<String, String>>> operators) {
        String operatorStr;
        if (operators != null && operators.size() > 0 && HRStringUtils.isNotEmpty((String)(operatorStr = SerializationUtils.toJsonString(operators)))) {
            String cacheKey = RuleCusCacheService.getCacheKey("comparisonOperators_", controlKey);
            view.getPageCache().put(cacheKey, operatorStr);
        }
    }

    public static Map<String, List<Map<String, String>>> getCusComparisonOperators(IFormView view, String controlKey) {
        String cacheKey = RuleCusCacheService.getCacheKey("comparisonOperators_", controlKey);
        String operators = view.getPageCache().get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)operators)) {
            return (Map)SerializationUtils.fromJsonString((String)operators, Map.class);
        }
        return Collections.emptyMap();
    }

    public static String replaceText(IFormView view, String controlKey, String expressValue) {
        if (HRStringUtils.isEmpty((String)expressValue)) {
            return expressValue;
        }
        Map<String, String> replaceMap = RuleCusCacheService.getReplaceText(view, controlKey);
        if (replaceMap != null && replaceMap.size() > 0) {
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                expressValue = expressValue.replace(entry.getKey(), entry.getValue());
            }
        }
        return expressValue;
    }

    public static void cacheShowDateControlKey(IFormView view, String controlKey) {
        String cacheKey = "cusRuleControlKey";
        view.getPageCache().put(cacheKey, controlKey);
    }

    public static String getShowDateControlKey(IFormView view) {
        String cacheKey = "cusRuleControlKey";
        return view.getPageCache().get(cacheKey);
    }

    public static void cacheInitStatus(IFormView view, String controlKey, boolean isInited) {
        String cacheKey = RuleCusCacheService.getCacheKey("inited", controlKey);
        view.getPageCache().put(cacheKey, String.valueOf(isInited));
    }

    public static boolean isInited(IFormView view, String controlKey) {
        String cacheKey = RuleCusCacheService.getCacheKey("inited", controlKey);
        String initStatus = view.getPageCache().get(cacheKey);
        return Boolean.parseBoolean(initStatus);
    }

    public static void cacheUseCfgInitStatus(IFormView view, boolean isInited) {
        String cacheKey = "scene_usecfg_init";
        view.getPageCache().put(cacheKey, String.valueOf(isInited));
    }

    public static boolean isUseCfgInited(IFormView view) {
        String cacheKey = "scene_usecfg_init";
        String initStatus = view.getPageCache().get(cacheKey);
        return Boolean.parseBoolean(initStatus);
    }

    public static void cachePageState(IFormView view, String controlKey, String pageState) {
        String cacheKey = RuleCusCacheService.getCacheKey("pageState", controlKey);
        view.getPageCache().put(cacheKey, pageState);
    }

    public static String getPageState(IFormView view, String controlKey) {
        String cacheKey = RuleCusCacheService.getCacheKey("pageState", controlKey);
        return view.getPageCache().get(cacheKey);
    }

    public static void initSceneUseCfg(IFormView view) {
        String entityId = view.getEntityId();
        List<RuleControlCfgInfo> ruleControlCfgInfos = RuleCusControlHelper.getRuleControlCfgInfo(entityId);
        HashSet needUpdateUseCfgEnableIds = Sets.newHashSetWithExpectedSize((int)ruleControlCfgInfos.size());
        for (RuleControlCfgInfo cfgInfo : ruleControlCfgInfos) {
            if (cfgInfo.isEnable()) continue;
            String hrControlNumber = cfgInfo.getHrControlNumber();
            if (HRStringUtils.isNotEmpty((String)hrControlNumber)) {
                Control control = view.getControl(hrControlNumber);
                if (!(control instanceof RuleControl)) {
                    needUpdateUseCfgEnableIds.add(cfgInfo.getId());
                    cfgInfo.setEnable(true);
                    continue;
                }
                boolean isExpand = WTCDynamicObjectUtils.metaEntityIsExpand(entityId);
                if (isExpand) continue;
                needUpdateUseCfgEnableIds.add(cfgInfo.getId());
                cfgInfo.setEnable(true);
                continue;
            }
            needUpdateUseCfgEnableIds.add(cfgInfo.getId());
            cfgInfo.setEnable(true);
        }
        RuleCusCacheService.cacheSceneUseCfg(view, ruleControlCfgInfos);
        RuleCusControlHelper.updateUseCfgEnable(needUpdateUseCfgEnableIds);
        RuleCusCacheService.cacheUseCfgInitStatus(view, true);
    }

    public static void cacheCusAssignLogicType(IFormView view, String controlKey, List<String> logicTypeList) {
        if (WTCCollections.isNotEmpty(logicTypeList)) {
            String cacheKey = RuleCusCacheService.getCacheKey("cusAssignLogicType", controlKey);
            IPageCache pageCache = view.getPageCache();
            String loginTypes = JSON.toJSONString(logicTypeList);
            pageCache.put(cacheKey, loginTypes);
        }
    }

    public static List<String> getCusAssignLogicType(IFormView view, String controlKey) {
        String cacheKey = RuleCusCacheService.getCacheKey("cusAssignLogicType", controlKey);
        IPageCache pageCache = view.getPageCache();
        String logicTypes = pageCache.get(cacheKey);
        if (HRStringUtils.isNotEmpty((String)logicTypes)) {
            return JSON.parseArray((String)logicTypes, String.class);
        }
        return Collections.emptyList();
    }
}

