/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.rulecontrol.RuleCusControlService;
import kd.wtc.wtbs.common.rulecontrol.RuleCusControlConstants;
import kd.wtc.wtbs.common.rulecontrol.RuleCusControlF7Params;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RuleCusControlF7Service
implements RuleCusControlConstants {
    private RuleCusControlF7Service() {
    }

    public static ListShowParameter getOpenF7Parameter(Map<String, Object> argsJson) {
        String entityNumber = argsJson.get("entityNumber").toString();
        boolean isMulti = Boolean.parseBoolean(argsJson.get("isMulti").toString());
        String selectedIdStr = null == argsJson.get("value") ? "" : argsJson.get("value").toString();
        String filterStr = (String)argsJson.get("filters");
        String[] entities = entityNumber.split("\\.");
        RuleCusControlF7Params f7Param = RuleCusControlF7Service.getF7Param(entities);
        entityNumber = f7Param.getEntityNumber();
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)isMulti, (int)2);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        fsp.setCustomParam("orgFuncId", (Object)f7Param.getOrgFunId());
        fsp.setCustomParam("orgViewSchemeNumber", (Object)f7Param.getOrgViewSchemeNumber());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List<QFilter> qFilters = RuleCusControlF7Service.getQFilters(mainEntityType, filterStr, entityNumber);
        if (WTCStringUtils.equals((String)entityNumber, (String)"haos_adminorghr")) {
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)true));
        }
        fsp.setListFilterParameter(new ListFilterParameter(qFilters, null));
        if (isMulti && HRStringUtils.isNotEmpty((String)selectedIdStr)) {
            Object[] selectedIdArr = selectedIdStr.split(",");
            if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                fsp.setSelectedRows(Arrays.stream(selectedIdArr).map(Long::parseLong).toArray());
            } else {
                fsp.setSelectedRows(selectedIdArr);
            }
        }
        return fsp;
    }

    public static Map<String, Object> getF7CallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedCol = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (null == selectedCol) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)16);
        for (ListSelectedRow select : selectedCol) {
            idList.add(select.getPrimaryKeyValue().toString());
            nameList.add(HRStringUtils.isEmpty((String)select.getName()) ? select.getPrimaryKeyValue().toString() : select.getName());
            numberList.add(select.getNumber());
        }
        String actionId = closedCallBackEvent.getActionId();
        String[] split = actionId.split("\\.");
        String entityNumber = split[3];
        if (RuleCusControlService.isAdminOrg(entityNumber)) {
            numberList.clear();
            Map<String, String> result = RuleCusControlService.getStructNumber(idList.stream().map(Long::parseLong).collect(Collectors.toList()));
            for (String id : idList) {
                numberList.add(result.get(id));
            }
        }
        resultMap.put("idList", idList);
        resultMap.put("nameList", nameList);
        resultMap.put("numberList", numberList);
        resultMap.put("valueIdIsString", (WTCCollectionIndexUtil.getEleFromList((List)selectedCol, (int)0).isPresent() ? ((ListSelectedRow)WTCCollectionIndexUtil.getEleFromList((List)selectedCol, (int)0).get()).getPrimaryKeyValue() : null) instanceof String);
        resultMap.put("index", split[2]);
        return resultMap;
    }

    private static RuleCusControlF7Params getF7Param(String entityNumber, String field) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DynamicProperty prop = (DynamicProperty)mainEntityType.getAllFields().get(field);
        if (prop instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)prop;
            OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
            return new RuleCusControlF7Params(orgProp.getBaseEntityId(), orgProp.getOrgFunc(), orgViewScheme == null ? null : orgViewScheme.getNumber());
        }
        if (prop instanceof BasedataProp) {
            return new RuleCusControlF7Params(((BasedataProp)prop).getBaseEntityId());
        }
        if (prop instanceof MulBasedataProp) {
            return new RuleCusControlF7Params(((MulBasedataProp)prop).getBaseEntityId());
        }
        return new RuleCusControlF7Params();
    }

    private static RuleCusControlF7Params getF7Param(String[] entities) {
        RuleCusControlF7Params f7Param;
        if (entities.length == 6) {
            f7Param = RuleCusControlF7Service.getF7Param(entities[3], entities[4]);
        } else if (entities.length == 5) {
            String entityNumber = "";
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entities[1]);
            DynamicProperty prop = (DynamicProperty)mainEntityType.getAllFields().get(entities[2]);
            if (prop instanceof BasedataProp) {
                entityNumber = ((BasedataProp)prop).getBaseEntityId();
            } else if (prop instanceof MulBasedataProp) {
                entityNumber = ((MulBasedataProp)prop).getBaseEntityId();
            }
            f7Param = RuleCusControlF7Service.getF7Param(entityNumber, entities[3]);
        } else {
            f7Param = entities.length == 4 ? RuleCusControlF7Service.getF7Param(entities[1], entities[2]) : (entities.length == 3 ? new RuleCusControlF7Params(entities[1]) : new RuleCusControlF7Params(entities[0]));
        }
        return f7Param;
    }

    private static List<QFilter> getQFilters(MainEntityType mainEntityType, String filterStr, String entityNumber) {
        List qFilterList;
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        if (null != mainEntityType.findProperty("enable")) {
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if (null != mainEntityType.findProperty("status")) {
            qFilters.add(new QFilter("status", "=", (Object)"C"));
        }
        if (HRStringUtils.isNotEmpty((String)filterStr) && !CollectionUtils.isEmpty((Collection)(qFilterList = SerializationUtils.fromJsonStringToList((String)filterStr, QFilter.class)))) {
            qFilters.addAll(qFilterList);
        }
        Optional<QFilter> dataFilterOpl = HRAuthService.getInstance().getF7PermQFilterByDataRule(entityNumber, "ruleConditionF7AuthEnable");
        dataFilterOpl.ifPresent(qFilters::add);
        return qFilters;
    }
}

