/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.rulecontrol.entity.RuleControlCfgInfo;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class RuleCusControlHelper {
    public static List<RuleControlCfgInfo> getRuleControlCfgInfo(String entityId) {
        HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)"wtbd_sceneusecfg");
        QFilter qFilter = new QFilter("applyentity", "=", (Object)entityId);
        DynamicObject[] useCfgDys = serviceHelper.loadDynamicObjectArray(qFilter.toArray());
        ArrayList<RuleControlCfgInfo> cfgInfos = new ArrayList<RuleControlCfgInfo>(useCfgDys.length);
        for (DynamicObject dy : useCfgDys) {
            RuleControlCfgInfo cfgInfo = new RuleControlCfgInfo();
            cfgInfo.setId(dy.getLong("id"));
            cfgInfo.setSceneId(WTCDynamicObjectUtils.getBaseDataId(dy, "scenerule"));
            cfgInfo.setDefaultRows(dy.getInt("defaultrows"));
            cfgInfo.setOnlyOneShowDelete(dy.getBoolean("onlyioneshowdelete"));
            cfgInfo.setShowValueTypeColumn(dy.getBoolean("showvaluetypecell"));
            cfgInfo.setEnable(dy.getBoolean("isenable"));
            cfgInfo.setWtcControlNumber(dy.getString("number"));
            cfgInfo.setHrControlNumber(dy.getString("hrcontrolnumber"));
            cfgInfos.add(cfgInfo);
        }
        return cfgInfos;
    }

    public static void updateUseCfgEnable(Set<Long> needUpdateUseCfgEnableIds) {
        QFilter qFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] useCfgDys;
        if (CollectionUtils.isNotEmpty(needUpdateUseCfgEnableIds) && (useCfgDys = (serviceHelper = HRBaseServiceHelper.create((String)"wtbd_sceneusecfg")).query("id,isenable", (qFilter = new QFilter("id", "in", needUpdateUseCfgEnableIds)).toArray())) != null && useCfgDys.length > 0) {
            for (DynamicObject dy : useCfgDys) {
                dy.set("isenable", (Object)"1");
            }
            serviceHelper.update(useCfgDys);
        }
    }

    public static List<DynamicObject> getRetrievalItemsById(Collection<Long> ids) {
        if (WTCCollections.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String queryProp = "id,name,number,uniquecode,numberx,belongobj.id,belongobj.number,type,way,combofield,dateformat";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_scenefieldcfg");
        QFilter qFilter = new QFilter("id", "in", ids);
        Object[] dynamicObjects = serviceHelper.queryOriginalArray(queryProp, qFilter.toArray());
        return Lists.newArrayList((Object[])dynamicObjects);
    }
}

