/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecontrol;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.personfilter.enums.RuleParamTypeEnum;
import kd.wtc.wtbs.business.rulecontrol.RuleCusControlHelper;
import kd.wtc.wtbs.business.rulecontrol.entity.RuleControlInitParamTypeVo;
import kd.wtc.wtbs.common.rulecontrol.RuleCusControlConstants;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class RuleCusControlService
implements RuleCusControlConstants {
    private static final Log LOG = LogFactory.getLog(RuleCusControlService.class);
    private static final String DOT = ".";
    private static final Set<String> TYPE_STRING_SET = Sets.newHashSet((Object[])new String[]{String.class.getName(), Byte.class.getName(), Character.class.getName(), ILocaleString.class.getName()});
    private static final Set<String> TYPE_NUMBER_SET = Sets.newHashSet((Object[])new String[]{Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), BigDecimal.class.getName()});
    private static final Set<String> TYPE_BOOLEAN_SET = Sets.newHashSet((Object[])new String[]{Boolean.class.getName(), "boolean"});
    private static final Map<String, ArrayList<Long>> entityToRetrievalRuleMap = new HashMap<String, ArrayList<Long>>(){
        {
            this.put("wtp_qtdygenconfigdetail", Lists.newArrayList((Object[])new Long[]{1991398471189410816L}));
            this.put("wtp_qtgenconfigdetail", Lists.newArrayList((Object[])new Long[]{1991398471189410816L}));
        }
    };

    private RuleCusControlService() {
    }

    public static DynamicObjectCollection querySceneInputParams(long sceneId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_scenerulecfg");
        QFilter qFilter = new QFilter("id", "=", (Object)sceneId);
        DynamicObject dynamicObject = serviceHelper.loadDynamicObject(qFilter);
        if (dynamicObject != null) {
            return dynamicObject.getDynamicObjectCollection("entryentity");
        }
        return null;
    }

    public static List<Map<String, String>> getInputParam(long sceneId) {
        DynamicObjectCollection dynamicObjects = RuleCusControlService.querySceneInputParams(sceneId);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            return RuleCusControlService.getInputParam(dynamicObjects, -1L, null);
        }
        return Collections.emptyList();
    }

    public static List<Map<String, String>> getInputParam(DynamicObjectCollection inputParams) {
        return RuleCusControlService.getInputParam(inputParams, -1L, null);
    }

    public static List<Map<String, String>> getInputParam(DynamicObjectCollection inputParams, long createOrgId) {
        return RuleCusControlService.getInputParam(inputParams, createOrgId, null);
    }

    public static List<Map<String, String>> getInputParam(DynamicObjectCollection inputParams, long createOrgId, String conditionValue) {
        ArrayList rootList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        List<Long> curAndAllSuperOrgIds = RuleCusControlService.getCurAndAllSuperOrgs(createOrgId);
        Map<Long, DynamicObject> rtvlItemMap = RuleCusControlService.getRtvlItemMapByInputParams(inputParams);
        for (DynamicObject obj : inputParams) {
            if (obj == null || !RuleParamTypeEnum.DYNAMICOBJECT.getValue().equals(obj.getString("inputparamstype"))) continue;
            if (null == obj.get("inputobject")) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\u3002", (String)"RuleCusControlService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), obj.get("inputnumber")));
            }
            HashMap rootMap = Maps.newHashMapWithExpectedSize((int)2);
            rootMap.put("text", obj.getString("inputname"));
            List<Map<String, String>> paramAndType = RuleCusControlService.initParamAndType(rtvlItemMap, obj, curAndAllSuperOrgIds, conditionValue);
            if (WTCCollections.isEmpty(paramAndType)) continue;
            rootMap.put("children", SerializationUtils.toJsonString(paramAndType));
            rootMap.put("level", "1");
            dynamicObjectList.add(rootMap);
        }
        if (!dynamicObjectList.isEmpty()) {
            rootList.addAll(dynamicObjectList);
        }
        return rootList;
    }

    private static List<Long> getCurAndAllSuperOrgs(long createOrgId) {
        if (-1L == createOrgId) {
            return Collections.emptyList();
        }
        List supOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"26", (long)createOrgId);
        supOrgIds.add(createOrgId);
        return supOrgIds;
    }

    private static Map<Long, DynamicObject> getRtvlItemMapByInputParams(DynamicObjectCollection inputParams) {
        HashSet rtvlItemIds = Sets.newHashSetWithExpectedSize((int)inputParams.size());
        for (DynamicObject inputParamDy : inputParams) {
            DynamicObjectCollection inputFields = inputParamDy.getDynamicObjectCollection("subentryentity");
            for (DynamicObject inputFieldDy : inputFields) {
                long fieldId = inputFieldDy.getLong("fieldid.id");
                rtvlItemIds.add(fieldId);
            }
        }
        List<DynamicObject> retrievalItems = RuleCusControlHelper.getRetrievalItemsById(rtvlItemIds);
        return retrievalItems.stream().collect(Collectors.toMap(item -> item.getLong("id"), Function.identity(), (o1, o2) -> o2));
    }

    private static List<Map<String, String>> initParamAndType(Map<Long, DynamicObject> rtvlItemMap, DynamicObject inputParam, List<Long> curAndAllSuperOrgIds, String conditionValue) {
        DynamicObjectCollection inputFields = inputParam.getDynamicObjectCollection("subentryentity");
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        String paramNumber = inputParam.getString("inputnumber");
        for (DynamicObject inputFieldDy : inputFields) {
            long fieldId = inputFieldDy.getLong("fieldid.id");
            DynamicObject rtvlItemDy = rtvlItemMap.get(fieldId);
            RuleControlInitParamTypeVo initParamTypeVo = RuleCusControlService.initRuleControlInitParamTypeVo(inputParam, inputFieldDy, rtvlItemDy);
            initParamTypeVo.setParamNumber(paramNumber);
            String paramFieldKey = null == initParamTypeVo.getObjNumber() ? paramNumber + DOT + initParamTypeVo.getFieldNumber() : paramNumber + DOT + initParamTypeVo.getObjNumber() + DOT + initParamTypeVo.getFieldNumber();
            initParamTypeVo.setParamFieldKey(paramFieldKey);
            boolean needHide = false;
            if (null != rtvlItemDy && WTCCollections.isNotEmpty(curAndAllSuperOrgIds)) {
                String assignType = inputFieldDy.getString("fieldid.assigntype");
                Long applyOrgId = inputFieldDy.getLong("fieldid.applyorg.id");
                needHide = HRStringUtils.equals((String)"2", (String)assignType) && !curAndAllSuperOrgIds.contains(applyOrgId);
            }
            RuleCusControlService.initParamType(paramList, initParamTypeVo, needHide, conditionValue);
        }
        return paramList;
    }

    private static boolean isParamKeyExistInDb(String paramFieldKey, String conditionValue) {
        JSONObject jsObj;
        if (HRStringUtils.isNotEmpty((String)conditionValue) && (jsObj = JSON.parseObject((String)conditionValue)).containsKey((Object)"conditionList")) {
            JSONArray conditionList = jsObj.getJSONArray("conditionList");
            for (int i = 0; i < conditionList.size(); ++i) {
                String conditionParam = conditionList.getJSONObject(i).getString("param");
                if (!HRStringUtils.equals((String)paramFieldKey, (String)conditionParam)) continue;
                return true;
            }
        }
        return false;
    }

    private static RuleControlInitParamTypeVo initRuleControlInitParamTypeVo(DynamicObject inputParam, DynamicObject inputFieldDy, DynamicObject rtvlItemDy) {
        RuleControlInitParamTypeVo ruleControlInitParamTypeVo = new RuleControlInitParamTypeVo();
        if (rtvlItemDy != null) {
            String belongObjNumber = rtvlItemDy.getString("belongobj.number");
            String fieldNumber = rtvlItemDy.getString("number");
            String displayName = inputFieldDy.getString("fielddisplayname");
            if (HRStringUtils.isEmpty((String)displayName)) {
                displayName = rtvlItemDy.getString("name");
            }
            String uniqueCode = rtvlItemDy.getString("uniqueCode");
            ruleControlInitParamTypeVo.setObjNumber(belongObjNumber);
            ruleControlInitParamTypeVo.setFieldNumber(fieldNumber);
            ruleControlInitParamTypeVo.setDisplayName(displayName);
            ruleControlInitParamTypeVo.setUniqueCode(uniqueCode);
            ruleControlInitParamTypeVo.setRetrievalWay(rtvlItemDy.getString("way"));
            ruleControlInitParamTypeVo.setType(rtvlItemDy.getString("type"));
            ruleControlInitParamTypeVo.setComboValue(rtvlItemDy.getString("combofield"));
            ruleControlInitParamTypeVo.setDateFormat(rtvlItemDy.getString("dateformat"));
        } else {
            IDataEntityProperty property;
            MainEntityType dataEntityType;
            String belongObjNumber = inputParam.getString("inputobject.number");
            String fieldNumber = inputFieldDy.getString("fieldnumber");
            String displayName = inputFieldDy.getString("fielddisplayname");
            if (HRStringUtils.isEmpty((String)displayName) && HRStringUtils.isNotEmpty((String)belongObjNumber) && (dataEntityType = RuleCusControlService.getDataEntityType(belongObjNumber)) != null && (property = (IDataEntityProperty)dataEntityType.getProperties().get((Object)fieldNumber)) != null) {
                displayName = property.getDisplayName().getLocaleValue();
            }
            ruleControlInitParamTypeVo.setObjNumber(belongObjNumber);
            ruleControlInitParamTypeVo.setFieldNumber(fieldNumber);
            String uniqueCode = "";
            ruleControlInitParamTypeVo.setDisplayName(displayName);
            ruleControlInitParamTypeVo.setUniqueCode(uniqueCode);
            ruleControlInitParamTypeVo.setRetrievalWay("3");
        }
        return ruleControlInitParamTypeVo;
    }

    private static void initParamType(List<Map<String, String>> paramList, RuleControlInitParamTypeVo initParamTypeVo, boolean needHide, String conditionValue) {
        String fieldNumber = initParamTypeVo.getFieldNumber();
        String belongObjNumber = initParamTypeVo.getObjNumber();
        String paramFieldKey = initParamTypeVo.getParamFieldKey();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)5);
        paramMap.put("id", paramFieldKey);
        paramMap.put("number", paramFieldKey);
        paramMap.put("level", "3");
        String displayName = initParamTypeVo.getDisplayName();
        paramMap.put("text", displayName);
        paramMap.put("name", displayName);
        String uniqueCode = initParamTypeVo.getUniqueCode();
        paramMap.put("uniqueCode", uniqueCode);
        paramMap.put("retrievalWay", initParamTypeVo.getRetrievalWay());
        if (!RuleCusControlService.fillTypeInfo(belongObjNumber, fieldNumber, paramFieldKey, initParamTypeVo, paramMap)) {
            return;
        }
        if (needHide && !RuleCusControlService.isParamKeyExistInDb((String)paramMap.get("number"), conditionValue)) {
            return;
        }
        paramList.add(paramMap);
    }

    private static boolean fillTypeInfo(String belongObjNumber, String fieldNumber, String paramFieldKey, RuleControlInitParamTypeVo initParamTypeVo, Map<String, String> paramMap) {
        if (HRStringUtils.isEmpty((String)belongObjNumber)) {
            String type = initParamTypeVo.getType();
            if (HRStringUtils.isEmpty((String)type)) {
                return false;
            }
            if (HRStringUtils.equals((String)"string", (String)type)) {
                paramMap.put("type", RuleParamTypeEnum.STRING.getValue());
                paramMap.put("typeDetail", RuleParamTypeEnum.STRING.getValue());
            } else if (HRStringUtils.equals((String)"enum", (String)type)) {
                List mapItemList;
                if (HRStringUtils.isEmpty((String)initParamTypeVo.getComboValue())) {
                    return false;
                }
                paramMap.put("type", RuleParamTypeEnum.STRING.getValue());
                paramMap.put("typeDetail", RuleParamTypeEnum.ENUM.getValue());
                try {
                    mapItemList = SerializationUtils.fromJsonStringToList((String)initParamTypeVo.getComboValue(), ValueMapItem.class);
                }
                catch (Exception ignore) {
                    mapItemList = Collections.emptyList();
                }
                if (WTCCollections.isEmpty((Collection)mapItemList)) {
                    return false;
                }
                paramMap.put("enumList", SerializationUtils.toJsonString((Object)mapItemList));
            } else if (HRStringUtils.equals((String)"date", (String)type)) {
                paramMap.put("type", RuleParamTypeEnum.DATE.getValue());
                paramMap.put("typeDetail", RuleParamTypeEnum.DATE.getValue());
                paramMap.put("dateFormat", HRStringUtils.isNotEmpty((String)initParamTypeVo.getDateFormat()) ? initParamTypeVo.getDateFormat() : "yyyy-MM-dd");
            } else if (HRStringUtils.equals((String)"number", (String)type)) {
                paramMap.put("type", RuleParamTypeEnum.NUMBER.getValue());
                paramMap.put("typeDetail", RuleParamTypeEnum.NUMBER.getValue());
            } else if (HRStringUtils.equals((String)"boolean", (String)type)) {
                paramMap.put("type", RuleParamTypeEnum.BOOLEAN.getValue());
                paramMap.put("typeDetail", RuleParamTypeEnum.BOOLEAN.getValue());
                paramMap.put("enumList", SerializationUtils.toJsonString(RuleCusControlService.getBoolean()));
            } else {
                return false;
            }
            return true;
        }
        MainEntityType dataEntityType = RuleCusControlService.getDataEntityType(belongObjNumber);
        if (dataEntityType == null) {
            return false;
        }
        IDataEntityProperty iproperty = (IDataEntityProperty)dataEntityType.getProperties().get((Object)fieldNumber);
        if (iproperty == null) {
            return false;
        }
        DynamicProperty property = (DynamicProperty)iproperty;
        String type = property.getPropertyType().getTypeName();
        if (TYPE_STRING_SET.contains(type)) {
            paramMap.put("type", RuleParamTypeEnum.STRING.getValue());
            paramMap.put("typeDetail", RuleParamTypeEnum.STRING.getValue());
            RuleCusControlService.setEnumList(property, paramMap);
        } else if (Date.class.getName().equals(type)) {
            paramMap.put("type", RuleParamTypeEnum.DATE.getValue());
            paramMap.put("typeDetail", RuleParamTypeEnum.DATE.getValue());
            paramMap.put("dateFormat", "yyyy-MM-dd");
        } else if (TYPE_NUMBER_SET.contains(type)) {
            paramMap.put("type", RuleParamTypeEnum.NUMBER.getValue());
            paramMap.put("typeDetail", RuleParamTypeEnum.NUMBER.getValue());
        } else if (TYPE_BOOLEAN_SET.contains(type)) {
            paramMap.put("type", RuleParamTypeEnum.BOOLEAN.getValue());
            paramMap.put("typeDetail", RuleParamTypeEnum.BOOLEAN.getValue());
            paramMap.put("enumList", SerializationUtils.toJsonString(RuleCusControlService.getBoolean()));
        } else if (DynamicObject.class.getName().equals(type) || "id".equals(initParamTypeVo.getFieldNumber()) && property instanceof LongProp) {
            String category;
            String entityNumber;
            if ("id".equals(initParamTypeVo.getFieldNumber()) && property instanceof LongProp) {
                entityNumber = belongObjNumber;
                category = RuleCusControlService.getCategory(entityNumber);
                paramMap.put("id", paramFieldKey);
                paramMap.put("number", paramFieldKey);
            } else {
                entityNumber = RuleCusControlService.getEntityNumber(property);
                category = RuleCusControlService.getCategory(entityNumber);
                paramMap.put("id", paramFieldKey + ".id");
                paramMap.put("number", paramFieldKey + ".id");
            }
            paramMap.put("type", RuleParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put("typeDetail", "adminOrg".equals(category) ? RuleParamTypeEnum.ADMINORG.getValue() : RuleParamTypeEnum.DYNAMICOBJECT.getValue());
            paramMap.put("entityNumber", entityNumber);
            paramMap.put("category", category);
            if (property instanceof MulBasedataProp) {
                paramMap.put("multiple", "1");
                paramMap.put("typeDetail", "adminOrg".equals(category) ? RuleParamTypeEnum.MUL_ADMINORG.getValue() : RuleParamTypeEnum.MUL_DYNAMICOBJECT.getValue());
            }
        } else {
            paramMap.put("type", RuleParamTypeEnum.STRING.getValue());
            paramMap.put("typeDetail", RuleParamTypeEnum.STRING.getValue());
        }
        return true;
    }

    private static MainEntityType getDataEntityType(String entityNumber) {
        try {
            return EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (Exception exp) {
            LOG.warn("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25\uff01", (Throwable)exp);
            return null;
        }
    }

    private static String getEntityNumber(Object property) {
        String entityNumber = "";
        if (property instanceof BasedataProp) {
            entityNumber = ((BasedataProp)property).getBaseEntityId();
        } else if (property instanceof MulBasedataProp) {
            entityNumber = ((MulBasedataProp)property).getBaseEntityId();
        } else if (property instanceof String) {
            entityNumber = (String)property;
        }
        return entityNumber;
    }

    private static String getCategory(String entityNumber) {
        if (RuleCusControlService.isAdminOrg(entityNumber)) {
            return "adminOrg";
        }
        if (RuleCusControlService.isPerson(entityNumber)) {
            return "person";
        }
        return "";
    }

    public static boolean isAdminOrg(String entityNumber) {
        return "haos_adminorghr".equals(entityNumber);
    }

    private static boolean isPerson(String entityNumber) {
        return "hsas_personhr".equals(entityNumber) || "bos_user".equals(entityNumber);
    }

    private static void setEnumList(DynamicProperty property, Map<String, String> paramMap) {
        String controlType = ((FieldProp)property).getFilterControlType();
        if (RuleParamTypeEnum.ENUM.getValue().equals(controlType)) {
            List mapItemList = ((ComboProp)property).getComboItems();
            paramMap.put("enumList", SerializationUtils.toJsonString((Object)mapItemList));
            paramMap.put("typeDetail", RuleParamTypeEnum.ENUM.getValue());
            if (property instanceof MulComboProp) {
                paramMap.put("multiple", "1");
                paramMap.put("typeDetail", RuleParamTypeEnum.MUL_ENUM.getValue());
            }
        }
    }

    private static List<Map<String, Object>> getBoolean() {
        ArrayList booleanList = Lists.newArrayListWithExpectedSize((int)2);
        HashMap trueMap = Maps.newHashMapWithExpectedSize((int)2);
        LocaleString trueString = new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"RuleCusControlService_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        trueMap.put("name", trueString);
        trueMap.put("value", Boolean.TRUE);
        booleanList.add(trueMap);
        HashMap falseMap = Maps.newHashMapWithExpectedSize((int)2);
        LocaleString falseString = new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"RuleCusControlService_4", (String)"wtc-wtbs-business", (Object[])new Object[0]));
        falseMap.put("name", falseString);
        falseMap.put("value", Boolean.FALSE);
        booleanList.add(falseMap);
        return booleanList;
    }

    private static Map<String, String> getParamMap(DynamicObject param) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)5);
        paramMap.put("id", param.getString("inputnumber"));
        paramMap.put("number", param.getString("inputnumber"));
        paramMap.put("text", param.getString("inputname"));
        paramMap.put("name", param.getString("inputname"));
        paramMap.put("type", param.getString("inputparamstype"));
        paramMap.put("typeDetail", param.getString("inputparamstype"));
        paramMap.put("dateFormat", "yyyy-MM-dd");
        paramMap.put("level", "2");
        return paramMap;
    }

    public static String getActionId(String ... keys) {
        return WTCStringUtils.joinOnDot((String[])keys);
    }

    public static Map<String, String> getStructNumber(List<Long> ids) {
        HashMap idStructNumMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        QFilter filter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection adminOrgColl = QueryServiceHelper.query((String)"haos_adminorgdetail", (String)"id,structnumber", (QFilter[])filters);
        for (DynamicObject adminOrgDy : adminOrgColl) {
            idStructNumMap.put(adminOrgDy.getString("id"), adminOrgDy.getString("structnumber"));
        }
        return idStructNumMap;
    }

    public static JSONObject getRequestParams(String eventArgs) {
        JSONObject jsonObject = new JSONObject();
        if (HRStringUtils.isNotEmpty((String)eventArgs)) {
            jsonObject = JSON.parseObject((String)eventArgs);
        }
        return jsonObject;
    }

    public static void updateControlData(IFormView view, String controlKey, String actionKey, Object value) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put(actionKey, value);
        RuleCusControlService.updateControlData(view, controlKey, data);
    }

    public static void updateControlData(IFormView view, String controlKey, Object data) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(controlKey, "updateData", new Object[]{data});
    }

    public static Map<String, List<Map<String, String>>> getInputValueParam(long sceneId) {
        return Collections.emptyMap();
    }

    @Deprecated
    public static Map<String, List<Map<String, String>>> getInputValueParam(DynamicObjectCollection inputParams) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)100);
        return paramMap;
    }

    public static String getConvertArgValue(String entityNumber, String conditionStr) {
        if (!entityToRetrievalRuleMap.containsKey(entityNumber) || HRStringUtils.isEmpty((String)conditionStr)) {
            return conditionStr;
        }
        Map<String, String> paramToParam1Map = RuleCusControlService.getParamToParam1KeyMap((List<Long>)entityToRetrievalRuleMap.get(entityNumber));
        if (WTCCollections.isEmpty(paramToParam1Map)) {
            return conditionStr;
        }
        JSONObject jsObj = JSON.parseObject((String)conditionStr);
        if (jsObj.containsKey((Object)"conditionList")) {
            JSONArray conditionList = jsObj.getJSONArray("conditionList");
            for (int i = 0; i < conditionList.size(); ++i) {
                String conditionParam = conditionList.getJSONObject(i).getString("param");
                if (!HRStringUtils.isNotEmpty((String)conditionParam) || !paramToParam1Map.containsKey(conditionParam)) continue;
                conditionList.getJSONObject(i).put("param1", (Object)paramToParam1Map.get(conditionParam));
            }
        }
        return jsObj.toString();
    }

    private static Map<String, String> getParamToParam1KeyMap(List<Long> ruleIds) {
        HashMap<String, String> paramKeyMap = new HashMap<String, String>(16);
        DynamicObject[] ruleDys = new HRBaseServiceHelper("wtbd_scenerulecfg").loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ruleIds)});
        if (null == ruleDys || ruleDys.length == 0) {
            return Collections.emptyMap();
        }
        for (DynamicObject ruleDy : ruleDys) {
            DynamicObjectCollection entryColls = ruleDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryColls) {
                String inputNumber = entry.getString("inputnumber");
                DynamicObjectCollection subEntryEntity = entry.getDynamicObjectCollection("subentryentity");
                if (WTCCollections.isEmpty((Collection)subEntryEntity)) continue;
                subEntryEntity.forEach(subEntry -> {
                    String belongObjNumber = subEntry.getString("fieldid.belongobj.number");
                    String fieldNumber = subEntry.getString("fieldid.number");
                    String fieldType = subEntry.getString("fieldid.type");
                    StringBuilder paramKeyBuffer = new StringBuilder();
                    paramKeyBuffer.append(inputNumber);
                    if (HRStringUtils.isNotEmpty((String)belongObjNumber)) {
                        paramKeyBuffer.append(DOT).append(belongObjNumber);
                    }
                    paramKeyBuffer.append(DOT).append(fieldNumber);
                    if (HRStringUtils.equals((String)"dynamicObject", (String)fieldType) && !paramKeyBuffer.toString().endsWith(".id")) {
                        paramKeyBuffer.append(".id");
                    }
                    if (HRStringUtils.isNotEmpty((String)subEntry.getString("param1"))) {
                        paramKeyMap.put(paramKeyBuffer.toString(), subEntry.getString("param1"));
                    }
                });
            }
        }
        return paramKeyMap;
    }
}

