/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.rulecontrol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.business.personfilter.enums.RuleParamTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class RuleOperatorsTypeService {
    private static final Log LOG = LogFactory.getLog(RuleOperatorsTypeService.class);
    private static Map<String, Map<String, List<Map<String, String>>>> optMap = Maps.newConcurrentMap();

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMapNoCache() {
        List<Map<String, String>> objectOptList = RuleOperatorsTypeService.getObjectComparisonOperators();
        HashMap comparisonOperatorsMap = Maps.newHashMapWithExpectedSize((int)16);
        comparisonOperatorsMap.put(RuleParamTypeEnum.BOOLEAN.getValue(), RuleOperatorsTypeService.getBooleanComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.DATE.getValue(), RuleOperatorsTypeService.getDateComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.STRING.getValue(), RuleOperatorsTypeService.getStringComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.NUMBER.getValue(), RuleOperatorsTypeService.getNumberComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.DYNAMICOBJECT.getValue(), objectOptList);
        comparisonOperatorsMap.put(RuleParamTypeEnum.MUL_DYNAMICOBJECT.getValue(), RuleOperatorsTypeService.getMulObjectComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.BASEDATA.getValue(), objectOptList);
        comparisonOperatorsMap.put(RuleParamTypeEnum.ADMINORG.getValue(), RuleOperatorsTypeService.getAdminOrgComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.MUL_ADMINORG.getValue(), RuleOperatorsTypeService.getMulAdminOrgComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.ENUM.getValue(), RuleOperatorsTypeService.getEnumComparisonOperators());
        comparisonOperatorsMap.put(RuleParamTypeEnum.MUL_ENUM.getValue(), RuleOperatorsTypeService.getMulEnumComparisonOperators());
        return comparisonOperatorsMap;
    }

    public static Map<String, List<Map<String, String>>> getComparisonOperatorsMap() {
        Lang lang = RequestContext.get().getLang();
        if (lang == null) {
            LOG.info("RuleOperatorsTypeService.RequestContext.get().getLang() is null");
            lang = Lang.get();
        }
        String langTag = lang.getLangTag();
        LOG.info("RuleOperatorsTypeService.langTag:{}", (Object)langTag);
        Map<String, List<Map<String, String>>> comparisonOperatorsMap = optMap.get(langTag);
        if (null != comparisonOperatorsMap) {
            return comparisonOperatorsMap;
        }
        comparisonOperatorsMap = RuleOperatorsTypeService.getComparisonOperatorsMapNoCache();
        optMap.put(langTag, comparisonOperatorsMap);
        return comparisonOperatorsMap;
    }

    public static List<Map<String, String>> getBooleanComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)8);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getDateComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)32);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_OR_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_OR_EQUALS_TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_OR_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_OR_EQUALS_TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.TODAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.YESTERDAY.getOperatorMap());
        paramList.add(RuleOperatorEnum.TOMORROW.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_WEEK.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_WEEK.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_WEEK.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST3MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT3MONTH.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_QUARTER.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_QUARTER.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_QUARTER.getOperatorMap());
        paramList.add(RuleOperatorEnum.THIS_YEAR.getOperatorMap());
        paramList.add(RuleOperatorEnum.LAST_YEAR.getOperatorMap());
        paramList.add(RuleOperatorEnum.NEXT_YEAR.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getStringComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.CONTAINS.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_CONTAINS.getOperatorMap());
        paramList.add(RuleOperatorEnum.STARTS_WITH.getOperatorMap());
        paramList.add(RuleOperatorEnum.ENDS_WITH.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getObjectComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getMulObjectComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.MUL_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.MUL_NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getNumberComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_THAN.getOperatorMap());
        paramList.add(RuleOperatorEnum.LESS_OR_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.GREATER_OR_EQUAL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getEnumComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getMulEnumComparisonOperators() {
        ArrayList paramList = Lists.newArrayListWithCapacity((int)16);
        paramList.add(RuleOperatorEnum.MUL_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.MUL_NOT_EQUAL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.NOT_IN.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NULL.getOperatorMap());
        paramList.add(RuleOperatorEnum.IS_NOT_NULL.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getAdminOrgComparisonOperators() {
        List<Map<String, String>> paramList = RuleOperatorsTypeService.getObjectComparisonOperators();
        paramList.add(RuleOperatorEnum.IS_OR_IS_SUB.getOperatorMap());
        return paramList;
    }

    public static List<Map<String, String>> getMulAdminOrgComparisonOperators() {
        List<Map<String, String>> paramList = RuleOperatorsTypeService.getMulObjectComparisonOperators();
        return paramList;
    }

    static {
        optMap.put(Lang.get().getLangTag(), RuleOperatorsTypeService.getComparisonOperatorsMapNoCache());
    }
}

