/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.shift;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.shift.ShiftService;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class DutyShiftQueryResponse
implements DutyShiftResponse {
    private static final Log LOG = LogFactory.getLog(DutyShiftQueryResponse.class);
    private Date startDate;
    private Date endDate;
    protected Map<Long, List<DutyShift>> dutyShiftMap;
    private Map<Long, Shift> shiftDetailMap;
    private Map<Long, Map<Long, DutyShift>> dutyShiftDateMap;
    private Map<Long, Shift> shiftHisMap;
    private boolean initOfTakeRuleVersion = false;

    public DutyShiftQueryResponse() {
    }

    public DutyShiftQueryResponse(Map<Long, List<DutyShift>> dutyShiftMap) {
        this.setDutyShiftMap(dutyShiftMap);
    }

    public Map<Long, Shift> getShiftDetailMap() {
        if (this.shiftDetailMap == null) {
            Set<Long> shiftBoIdSet = this.dutyShiftMap.values().stream().flatMap(Collection::stream).map(DutyShift::getShiftId).collect(Collectors.toSet());
            this.shiftDetailMap = ShiftService.getInstance().getShiftEvalVoMapByVids(shiftBoIdSet);
        }
        return this.shiftDetailMap;
    }

    @Deprecated
    public Map<Long, List<DutyShift>> getDutyShiftMap() {
        return this.dutyShiftMap;
    }

    @Deprecated
    public Optional<Shift> getShift(Long id, Date date) {
        return this.getShiftByAttFileBoId(id, date);
    }

    public Optional<Shift> getShiftByAttFileBoId(Long attFileBaseBoId, Date date) {
        List<DutyShift> dutyShifts = this.dutyShiftMap.get(attFileBaseBoId);
        if (dutyShifts == null || dutyShifts.isEmpty()) {
            return Optional.empty();
        }
        List matchDateData = dutyShifts.stream().filter(ds -> WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd").equals(WTCDateUtils.date2Str((Date)ds.getRosterDate(), (String)"yyyy-MM-dd"))).collect(Collectors.toList());
        if (matchDateData.isEmpty()) {
            return Optional.empty();
        }
        if (matchDateData.size() > 1) {
            Optional<DutyShift> any = matchDateData.stream().filter(ds -> "1".equals(ds.getRosterType())).findAny();
            if (!any.isPresent()) {
                Shift shift = this.getShiftDetailMap().get(((DutyShift)matchDateData.get(0)).getShiftId());
                if (shift == null) {
                    return Optional.empty();
                }
                return Optional.of(shift);
            }
            Shift shift = this.getShiftDetailMap().get(any.get().getShiftId());
            if (shift == null) {
                return Optional.empty();
            }
            return Optional.of(shift);
        }
        Shift shift = this.getShiftDetailMap().get(((DutyShift)matchDateData.get(0)).getShiftId());
        if (shift == null) {
            return Optional.empty();
        }
        return Optional.of(shift);
    }

    public final void setDutyShiftMap(Map<Long, List<DutyShift>> dutyShiftMap) {
        if (dutyShiftMap == null) {
            dutyShiftMap = new HashMap<Long, List<DutyShift>>(0);
        }
        if (dutyShiftMap.size() == 1 && PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            LOG.info("setDutyShiftMap.infos:{}", dutyShiftMap);
        }
        this.dutyShiftMap = dutyShiftMap;
        this.startDate = dutyShiftMap.values().stream().flatMap(Collection::stream).map(DutyShift::getRosterDate).min(Date::compareTo).orElse(null);
        this.endDate = dutyShiftMap.values().stream().flatMap(Collection::stream).map(DutyShift::getRosterDate).max(Date::compareTo).orElse(null);
    }

    public Optional<DutyShift> getDutyShift(Long id, Date date) {
        Map<Long, DutyShift> dateMap;
        if (this.dutyShiftDateMap == null) {
            this.initDateMap();
        }
        if ((dateMap = this.dutyShiftDateMap.get(id)) != null) {
            long time = date.getTime();
            return Optional.ofNullable(dateMap.get(time - time % 3600L));
        }
        return Optional.empty();
    }

    public Optional<Shift> getCurrShiftHis(Long id, Date date) {
        Optional<DutyShift> dutyShift = this.getDutyShift(id, date);
        if (dutyShift.isPresent()) {
            return this.getShiftHisData(dutyShift.get().getShiftVid());
        }
        return Optional.empty();
    }

    public Optional<Shift> getShiftHisData(Long vid) {
        if (this.shiftHisMap == null) {
            this.initDateMap();
            this.initShiftHisMap();
        }
        return Optional.ofNullable(this.shiftHisMap.get(vid));
    }

    public Map<Long, Map<Long, DutyShift>> getDutyShiftOfFileMap() {
        if (this.dutyShiftDateMap == null) {
            this.initDateMap();
        }
        return this.dutyShiftDateMap;
    }

    public Map<Long, Shift> getAllShiftHisVersionMap() {
        if (this.shiftHisMap == null) {
            this.initShiftHisMap();
        }
        return this.shiftHisMap;
    }

    public void loadAll() {
        this.initShiftHisMap();
        this.initTakeRuleVId();
    }

    public long getTakeCardRuleVid(Long id, Date date) {
        Optional<DutyShift> dutyShift;
        if (!this.initOfTakeRuleVersion) {
            this.initTakeRuleVId();
        }
        if ((dutyShift = this.getDutyShift(id, date)).isPresent()) {
            return dutyShift.get().getTakeCardRuleVId();
        }
        return 0L;
    }

    public Set<Long> getAllTakeCardRuleIds() {
        this.initTakeRuleVId();
        HashSet<Long> ids = new HashSet<Long>();
        this.dutyShiftDateMap.values().stream().flatMap(map -> map.values().stream()).forEach(dutyShift -> {
            ids.add(dutyShift.getTakeCardRuleId());
            ids.add(dutyShift.getTakeCardRuleVId());
        });
        return ids;
    }

    private void initTakeRuleVId() {
        if (this.initOfTakeRuleVersion) {
            return;
        }
        if (this.dutyShiftDateMap == null) {
            this.initDateMap();
        }
        HashSet ruleBoIdSet = Sets.newHashSet();
        for (Map.Entry<Long, List<DutyShift>> entry : this.dutyShiftMap.entrySet()) {
            ruleBoIdSet.addAll(entry.getValue().stream().map(DutyShift::getTakeCardRuleId).collect(Collectors.toSet()));
        }
        Map<Long, List<DynamicObject>> ruleHisDyMap = this.getRosterTakeCardRuleVersionMap(ruleBoIdSet, this.startDate, this.endDate);
        this.dutyShiftDateMap.values().stream().map(Map::values).flatMap(Collection::stream).forEach(ds -> {
            DynamicObject currVersionDy = WTCHisServiceHelper.getCurrVersionDy(ruleHisDyMap, ds.getTakeCardRuleId(), ds.getRosterDate());
            if (currVersionDy != null) {
                ds.setTakeCardRuleVId(Long.valueOf(currVersionDy.getLong("id")));
            }
        });
        this.initOfTakeRuleVersion = true;
    }

    private void initShiftHisMap() {
        if (this.dutyShiftDateMap == null) {
            this.initDateMap();
        }
        Set<Long> shiftVidSet = this.dutyShiftDateMap.values().stream().map(Map::values).flatMap(Collection::stream).map(DutyShift::getShiftVid).collect(Collectors.toSet());
        this.shiftHisMap = ShiftService.getInstance().getShiftEvalVoMapByVids(shiftVidSet);
    }

    private void initDateMap() {
        if (this.dutyShiftDateMap != null) {
            return;
        }
        this.dutyShiftDateMap = Maps.newHashMapWithExpectedSize((int)this.dutyShiftMap.size());
        HashSet shiftBoIdSet = Sets.newHashSet();
        for (Map.Entry<Long, List<DutyShift>> entry : this.dutyShiftMap.entrySet()) {
            this.dutyShiftDateMap.put(entry.getKey(), entry.getValue().stream().collect(Collectors.toMap(ds -> ds.getRosterDate().getTime(), Function.identity(), (ds1, ds2) -> "1".equals(ds1.getRosterType()) ? ds1 : ds2)));
            shiftBoIdSet.addAll(entry.getValue().stream().map(DutyShift::getShiftId).collect(Collectors.toSet()));
        }
        Map<Long, List<DynamicObject>> shiftHisDyMap = this.getRosterShiftBOHisVersionMap(shiftBoIdSet, this.startDate, this.endDate);
        this.dutyShiftDateMap.values().stream().map(Map::values).flatMap(Collection::stream).forEach(ds -> {
            DynamicObject currVersionDy = WTCHisServiceHelper.getCurrVersionDy(shiftHisDyMap, ds.getShiftId(), ds.getRosterDate());
            if (currVersionDy != null) {
                ds.setShiftVid(Long.valueOf(currVersionDy.getLong("id")));
                ds.setTakeCardRuleId(Long.valueOf(currVersionDy.getLong("clockrule.id")));
            }
        });
        if (this.dutyShiftDateMap.size() == 1 && PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            LOG.info("DutyShiftQueryResponse.dutyShiftDateMap.infos:{}", this.dutyShiftDateMap);
        }
    }

    public Map<Long, List<DynamicObject>> getRosterShiftBOHisVersionMap(Collection<Long> boIds, Date startDate, Date endDate) {
        return WTCHisServiceHelper.queryHisVersionDyMap("wtbd_shift", boIds, startDate, endDate, "clockrule.id,bsed");
    }

    private Map<Long, List<DynamicObject>> getRosterTakeCardRuleVersionMap(Collection<Long> boIds, Date startDate, Date endDate) {
        return WTCHisServiceHelper.queryHisVersionDyMap("wtbd_takecardrule", boIds, startDate, endDate, "bsed");
    }
}

