/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.subject;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCAssert;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class AttSubject
implements Iterable<AttSubjectEntry> {
    private static final Log logger = LogFactory.getLog(AttSubject.class);
    private final long attPersonId;
    private final List<AttFileBo> attFileBos;
    private final LocalDate startDate;
    private final LocalDate endDate;

    public AttSubject(long attPersonId, List<AttFileBo> attFileBos) {
        WTCAssert.isTrue((!WTCCollections.isEmpty(attFileBos) ? 1 : 0) != 0, (String)"attFileBos could not be null or empty");
        attFileBos.sort(Comparator.comparing(AttFileBo::getStartDate));
        for (AttFileBo attFileBo : attFileBos) {
            attFileBo.attSubject = this;
            for (AttFileVersion attFileVersion : attFileBo.attFileVersions) {
                attFileVersion.attFileBo = attFileBo;
            }
        }
        this.attPersonId = attPersonId;
        this.attFileBos = attFileBos;
        this.startDate = WTCCollectionIndexUtil.getEleFromList(attFileBos, (int)0).isPresent() ? ((AttFileBo)WTCCollectionIndexUtil.getEleFromList(attFileBos, (int)0).get()).startDate : null;
        this.endDate = attFileBos.get(attFileBos.size() - 1).endDate;
    }

    public long getAttPersonId() {
        return this.attPersonId;
    }

    public Long getAttFileBoId(LocalDate currentDate) {
        for (AttFileBo attFileBo : this.attFileBos) {
            LocalDate startDate = attFileBo.getStartDate();
            LocalDate endDate = attFileBo.getEndDate();
            if (!WTCDateUtils.betweenDay((Date)WTCDateUtils.toDate((LocalDate)currentDate), (Date)WTCDateUtils.toDate((LocalDate)startDate), (Date)WTCDateUtils.toDate((LocalDate)endDate))) continue;
            return attFileBo.getAttFileBoid();
        }
        return 0L;
    }

    public List<AttFileBo> getAttFileBos() {
        return WTCCollections.unmodifiableList(this.attFileBos);
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Override
    public Iterator<AttSubjectEntry> iterator() {
        return new AttSubjectIterator(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttSubject that = (AttSubject)obj;
        return this.attPersonId == that.attPersonId;
    }

    public int hashCode() {
        return Objects.hash(this.attPersonId);
    }

    public String toString() {
        return "AttSubject{attPersonId=" + this.attPersonId + ", attFileBos=" + this.attFileBos + ", startDate=" + this.startDate + ", endDate=" + this.endDate + '}';
    }

    public static class AttFileVersion {
        private final long attFileVid;
        private final LocalDate startDate;
        private final LocalDate endDate;
        private final boolean hasPermission;
        private AttFileBo attFileBo;
        private boolean excludeEnable = false;
        private boolean includeEnable = false;
        private List<Tuple<LocalDate, LocalDate>> excludeDateRangeList;
        private List<Tuple<Date, Date>> includeDateRangeList;

        public AttFileVersion(long attFileVid, LocalDate startDate, LocalDate endDate, boolean hasPermission) {
            WTCAssert.nonNull((Object)startDate, (String)"startDate");
            WTCAssert.nonNull((Object)endDate, (String)"endDate");
            this.attFileVid = attFileVid;
            this.startDate = startDate;
            this.endDate = endDate;
            this.hasPermission = hasPermission;
        }

        public AttFileVersion(long attFileVid, LocalDate startDate, LocalDate endDate, Boolean hasPermission, List<Tuple<Date, Date>> billAccountRange) {
            WTCAssert.nonNull((Object)startDate, (String)"startDate");
            WTCAssert.nonNull((Object)endDate, (String)"endDate");
            this.attFileVid = attFileVid;
            this.startDate = startDate;
            this.endDate = endDate;
            this.hasPermission = hasPermission;
            this.includeDateRangeList = billAccountRange;
            this.includeEnable = true;
        }

        public long getAttFileVid() {
            return this.attFileVid;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public boolean isHasPermission() {
            return this.hasPermission;
        }

        private void setAttFileBo(AttFileBo attFileBo) {
            this.attFileBo = attFileBo;
        }

        public AttFileBo getAttFileBo() {
            return this.attFileBo;
        }

        public List<Tuple<LocalDate, LocalDate>> getExcludeDateRangeList() {
            return this.excludeDateRangeList;
        }

        public void setExcludeDateRangeList(List<Tuple<LocalDate, LocalDate>> excludeDateRangeList) {
            this.excludeDateRangeList = excludeDateRangeList;
        }

        public boolean isExclude(LocalDate currentDate) {
            if (!this.excludeEnable) {
                return false;
            }
            if (this.excludeDateRangeList == null) {
                return false;
            }
            for (Tuple<LocalDate, LocalDate> excludeDateRangeTuple : this.excludeDateRangeList) {
                if (!WTCDateUtils.betweenDate((LocalDate)currentDate, (LocalDate)((LocalDate)excludeDateRangeTuple.getKey()), (LocalDate)((LocalDate)excludeDateRangeTuple.getValue()))) continue;
                return true;
            }
            return false;
        }

        public boolean isInclude(LocalDate currentDate) {
            if (!this.includeEnable) {
                return true;
            }
            if (this.includeDateRangeList == null) {
                logger.debug("attFileVid={},includeDateRangeList is null", (Object)this.attFileVid);
                return false;
            }
            for (Tuple<Date, Date> includeDateRangeTuple : this.includeDateRangeList) {
                if (!WTCDateUtils.betweenDate((LocalDate)currentDate, (LocalDate)WTCDateUtils.toLocalDate((Date)((Date)includeDateRangeTuple.getKey())), (LocalDate)WTCDateUtils.toLocalDate((Date)((Date)includeDateRangeTuple.getValue())))) continue;
                return true;
            }
            logger.debug("attFileVid={},includeDateRangeList do not include date = [{}] ", (Object)this.attFileVid, (Object)currentDate);
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AttFileVersion that = (AttFileVersion)obj;
            return this.attFileVid == that.attFileVid && this.hasPermission == that.hasPermission && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
        }

        public int hashCode() {
            return Objects.hash(this.attFileVid, this.startDate, this.endDate, this.hasPermission);
        }

        public String toString() {
            return "AttFileVersion{attFileVid=" + this.attFileVid + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", hasPermission=" + this.hasPermission + '}';
        }
    }

    public static class AttFileBo {
        private final long attFileBoid;
        private final LocalDate startDate;
        private final LocalDate endDate;
        private final List<AttFileVersion> attFileVersions;
        private AttSubject attSubject;

        public AttFileBo(long attFileBoid, List<AttFileVersion> attFileVersions) {
            WTCAssert.isTrue((!WTCCollections.isEmpty(attFileVersions) ? 1 : 0) != 0, (String)"attFileVersions could not be null or empty");
            attFileVersions.sort(Comparator.comparing(AttFileVersion::getStartDate));
            this.attFileBoid = attFileBoid;
            this.startDate = WTCCollectionIndexUtil.getEleFromList(attFileVersions, (int)0).isPresent() ? ((AttFileVersion)WTCCollectionIndexUtil.getEleFromList(attFileVersions, (int)0).get()).startDate : null;
            this.endDate = attFileVersions.get(attFileVersions.size() - 1).endDate;
            this.attFileVersions = attFileVersions;
        }

        public long getAttFileBoid() {
            return this.attFileBoid;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        private void setAttSubject(AttSubject attSubject) {
            this.attSubject = attSubject;
        }

        public AttSubject getAttSubject() {
            return this.attSubject;
        }

        public List<AttFileVersion> getAttFileVersions() {
            return WTCCollections.unmodifiableList(this.attFileVersions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AttFileBo attFileBo = (AttFileBo)obj;
            return this.attFileBoid == attFileBo.attFileBoid && this.startDate.equals(attFileBo.startDate) && this.endDate.equals(attFileBo.endDate);
        }

        public int hashCode() {
            return Objects.hash(this.attFileBoid, this.startDate, this.endDate);
        }

        public String toString() {
            return "AttFileBo{attFileBoid=" + this.attFileBoid + ", startDate=" + this.startDate + ", endDate=" + this.endDate + '}';
        }
    }

    private static class AttSubjectIterator
    implements Iterator<AttSubjectEntry> {
        final Iterator<AttSubjectEntry> attSubjectEntryIterator;

        public AttSubjectIterator(AttSubject attSubject) {
            LinkedList<AttSubjectEntry> attSubjectEntries = new LinkedList<AttSubjectEntry>();
            AttSubjectIterator.buildSubjectEntries(attSubject, attSubjectEntries);
            this.attSubjectEntryIterator = attSubjectEntries.iterator();
        }

        private static void buildSubjectEntries(AttSubject attSubject, List<AttSubjectEntry> attSubjectEntries) {
            for (AttFileBo attFileBo : attSubject.attFileBos) {
                for (AttFileVersion attFileVersion : attFileBo.attFileVersions) {
                    LocalDate currentDate = attFileVersion.startDate;
                    AttSubjectEntry preAttSubjectEntry = null;
                    do {
                        if (attFileVersion.isExclude(currentDate)) {
                            currentDate = currentDate.plusDays(1L);
                            continue;
                        }
                        if (!attFileVersion.isInclude(currentDate)) {
                            currentDate = currentDate.plusDays(1L);
                            continue;
                        }
                        AttSubjectEntry attSubjectEntry = new AttSubjectEntry(attSubject, attFileBo, attFileVersion, currentDate);
                        attSubjectEntry.setPreEntry(preAttSubjectEntry);
                        attSubjectEntries.add(attSubjectEntry);
                        currentDate = currentDate.plusDays(1L);
                        if (preAttSubjectEntry != null) {
                            preAttSubjectEntry.setNextEntry(attSubjectEntry);
                        }
                        preAttSubjectEntry = attSubjectEntry;
                    } while (!currentDate.isAfter(attFileVersion.endDate));
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.attSubjectEntryIterator.hasNext();
        }

        @Override
        public AttSubjectEntry next() {
            return this.attSubjectEntryIterator.next();
        }
    }

    public static class AttSubjectEntry {
        private final long attPersonId;
        private final AttFileBo attFileBo;
        private final AttFileVersion attFileVersion;
        private final LocalDate currentDate;
        private final LocalDate startDate;
        private final LocalDate endDate;
        private AttSubjectEntry preEntry;
        private AttSubjectEntry nextEntry;

        private AttSubjectEntry(AttSubject attSubject, AttFileBo attFileBo, AttFileVersion attFileVersion, LocalDate currentDate) {
            this.attPersonId = attSubject.attPersonId;
            this.attFileBo = attFileBo;
            this.attFileVersion = attFileVersion;
            this.currentDate = currentDate;
            this.startDate = attSubject.getStartDate();
            this.endDate = attSubject.getEndDate();
        }

        public long getAttPersonId() {
            return this.attPersonId;
        }

        public long getAttFileBoid() {
            return this.attFileBo.getAttFileBoid();
        }

        public LocalDate getStartDateOfAttFileBo() {
            return this.attFileBo.getStartDate();
        }

        public LocalDate getEndDateOfAttFileBo() {
            return this.attFileBo.getEndDate();
        }

        public long getAttFileVid() {
            return this.attFileVersion.getAttFileVid();
        }

        public LocalDate getStartDateOfAttFileVer() {
            return this.attFileVersion.getStartDate();
        }

        public LocalDate getEndDateOfAttFileVer() {
            return this.attFileVersion.getEndDate();
        }

        public boolean isHasPermissionOfAttFileVer() {
            return this.attFileVersion.isHasPermission();
        }

        public LocalDate getCurrentDate() {
            return this.currentDate;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public List<Tuple<LocalDate, LocalDate>> getExcludeDateRangeList() {
            return this.attFileVersion.getExcludeDateRangeList();
        }

        public String toString() {
            return "AttSubjectEntry{attPersonId=" + this.attPersonId + ", attFileBo=" + this.attFileBo + ", attFileVersion=" + this.attFileVersion + ", currentDate=" + this.currentDate + ", startDate=" + this.startDate + ", endDate=" + this.endDate + '}';
        }

        public AttSubjectEntry getNextEntry() {
            return this.nextEntry;
        }

        private void setNextEntry(AttSubjectEntry nextEntry) {
            this.nextEntry = nextEntry;
        }

        public AttSubjectEntry getPreEntry() {
            return this.preEntry;
        }

        private void setPreEntry(AttSubjectEntry preEntry) {
            this.preEntry = preEntry;
        }
    }
}

