/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.task.WTCDistributeTaskPreHandler;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.converter.WTCTaskConverter;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;
import kd.wtc.wtbs.business.task.sharding.WTCTaskShardingService;

public class WTCDistributeTaskPreHandlerImpl
implements WTCDistributeTaskPreHandler {
    private static final Log LOGGER = LogFactory.getLog(WTCDistributeTaskPreHandlerImpl.class);
    private WTCTaskEntity task;
    private WTCTaskRequest request;
    private WTCTaskShardingService shardingService;
    private WTCTaskRepository repository;
    private WTCTaskConverter converter;
    private List<WTCTaskDispatchRequest> dispatchRequests;

    @Override
    public void prepareEvnForDispatch() {
        try (TXHandle handle = TX.required();){
            try {
                this.task = this.converter.convert2Task(this.request);
                this.repository.saveTask(this.task);
                List<WTCShardingTask> shardingTaskList = this.shard();
                this.logInfo(ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7247\u6210\u529f:{}", (String)"WTCDistributeTaskPreHandlerImpl_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), shardingTaskList);
                List<WTCSubTaskEntity> subTaskList = this.shardingList2SubTaskList(shardingTaskList);
                this.setDispatchRequests(this.shardingList2dispatchRequestList(shardingTaskList));
                this.beforeBatchSaveSubTask(shardingTaskList, subTaskList);
                this.repository.batchSaveSubTask(subTaskList);
                this.logInfo(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u4fdd\u5b58\u6210\u529f\uff1a{}", (String)"WTCDistributeTaskPreHandlerImpl_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), subTaskList);
                this.task.setTotalSubTask(shardingTaskList.size());
                this.statisticsTask(this.task, this.request, subTaskList);
                this.repository.updateTask(this.task);
                this.logInfo(ResManager.loadKDString((String)"\u4e3b\u4efb\u52a1\u4fdd\u5b58\u6210\u529f\uff1a{}", (String)"WTCDistributeTaskPreHandlerImpl_2", (String)"wtc-wtbs-business", (Object[])new Object[0]), this.task);
            }
            catch (Exception exp) {
                handle.markRollback();
                throw exp;
            }
        }
    }

    private List<WTCSubTaskEntity> shardingList2SubTaskList(List<WTCShardingTask> shardingTaskList) {
        return shardingTaskList.stream().map(shardingTask -> this.getConverter().convert2SubTask((WTCShardingTask)shardingTask)).collect(Collectors.toList());
    }

    private List<WTCTaskDispatchRequest> shardingList2dispatchRequestList(List<WTCShardingTask> shardingTaskList) {
        int size = shardingTaskList.size();
        return shardingTaskList.stream().map(shardingTask -> {
            WTCTaskDispatchRequest dispatchRequest = this.getConverter().convert2WTCTaskDispatchRequest((WTCShardingTask)shardingTask, this.getRequest());
            dispatchRequest.putParam("sharding", Boolean.TRUE);
            dispatchRequest.putParam("numOfSharding", size);
            return dispatchRequest;
        }).collect(Collectors.toList());
    }

    private List<WTCShardingTask> shard() {
        return this.getShardingService().shard();
    }

    public void statisticsTask(WTCTaskEntity task, WTCTaskRequest request, List<WTCSubTaskEntity> subTaskList) {
    }

    public void beforeBatchSaveSubTask(List<WTCShardingTask> shardingTaskList, List<WTCSubTaskEntity> subTaskList) {
    }

    public WTCTaskConverter getConverter() {
        if (this.converter == null) {
            return this.repository.getWTCTaskConverter();
        }
        return this.converter;
    }

    public WTCTaskEntity getTask() {
        return this.task;
    }

    public WTCTaskRequest getRequest() {
        return this.request;
    }

    public WTCTaskShardingService getShardingService() {
        return this.shardingService;
    }

    public WTCTaskRepository getRepository() {
        return this.repository;
    }

    @Override
    public List<WTCTaskDispatchRequest> getDispatchRequests() {
        return this.dispatchRequests;
    }

    @Override
    public void setDispatchRequests(List<WTCTaskDispatchRequest> dispatchRequests) {
        this.dispatchRequests = dispatchRequests;
    }

    @Override
    public void setTask(WTCTaskEntity task) {
        this.task = task;
    }

    @Override
    public void setRequest(WTCTaskRequest request) {
        this.request = request;
    }

    @Override
    public void setShardingService(WTCTaskShardingService shardingService) {
        this.shardingService = shardingService;
    }

    @Override
    public void setRepository(WTCTaskRepository repository) {
        this.repository = repository;
    }

    @Override
    public void setTaskConverter(WTCTaskConverter converter) {
        this.converter = converter;
    }

    private boolean logDetail() {
        return this.request.getParam("LOG_DETAIL") != null;
    }

    protected void logInfo(String msg, Object ... args) {
        if (this.logDetail()) {
            LOGGER.info(msg, args);
        }
    }
}

