/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.WTCDistributeTaskPreHandlerImpl;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.converter.std.WTCCalTaskConverter;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;

public class WTCDistributeTaskPreHandlerStdImpl
extends WTCDistributeTaskPreHandlerImpl {
    @Override
    public void beforeBatchSaveSubTask(List<WTCShardingTask> shardingTaskList, List<WTCSubTaskEntity> subTaskList) {
        ArrayList<WTCCalTaskDetailEntity> taskDetailList = new ArrayList<WTCCalTaskDetailEntity>(shardingTaskList.size());
        for (WTCShardingTask sharding : shardingTaskList) {
            long taskId = sharding.getTaskId();
            long subTaskId = sharding.getSubTaskId();
            List collect = sharding.getTaskShardingDetails().stream().map(shardingDetail -> ((WTCCalTaskConverter)this.getConverter()).convert2TaskDetail(taskId, subTaskId, shardingDetail)).collect(Collectors.toList());
            taskDetailList.addAll(collect);
        }
        ((WTCCalTaskRepository)this.getRepository()).batchSaveTaskDetail(taskDetailList);
    }

    @Override
    public void statisticsTask(WTCTaskEntity task, WTCTaskRequest request, List<WTCSubTaskEntity> subTaskList) {
        WTCCalTaskEntity calTask = (WTCCalTaskEntity)task;
        WTCTaskRequestStd requestStd = (WTCTaskRequestStd)request;
        int totalAttFile = 0;
        int totalAttPerson = 0;
        for (int i = 0; i < subTaskList.size(); ++i) {
            WTCCalSubTaskEntity subTask = (WTCCalSubTaskEntity)subTaskList.get(i);
            totalAttFile += subTask.getTotalAttFile();
            totalAttPerson += subTask.getTotalAttPerson();
        }
        calTask.setTotalAttFile(totalAttFile);
        calTask.setRunAttFile(0);
        calTask.setSucceedAttFile(0);
        calTask.setFailedAttFile(0);
        calTask.setNotRunAttFile(0);
        calTask.setTotalAttPerson(totalAttPerson);
        calTask.setRunAttPerson(0);
        calTask.setSucceedAttPerson(0);
        calTask.setFailedAttPerson(0);
        calTask.setNotRunAttPerson(0);
        calTask.setCalStartDate(requestStd.getStartDate());
        calTask.setCalEndDate(requestStd.getEndDate());
    }
}

