/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.base;

import kd.bos.monitor.service.LivingServiceUtils;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;

public class MainTaskDetectorImpl
implements MainTaskDetector {
    TaskRepository taskRepository;

    public MainTaskDetectorImpl(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    @Override
    public boolean existSameTask(long bizTaskId, String category) {
        return this.taskRepository.loadMT(bizTaskId, category) != null;
    }

    @Override
    public boolean isExecutorAlive(long mainTaskId) {
        MainTaskRunLog mtrl = this.taskRepository.loadEffectiveMTRL(mainTaskId);
        if (mtrl == null) {
            return false;
        }
        String executorId = mtrl.getExecutorId();
        return LivingServiceUtils.isInstanceAlive((String)executorId);
    }

    @Override
    public boolean isExecutorAlive(MainTaskRunLog mtrl) {
        if (mtrl == null) {
            return false;
        }
        String executorId = mtrl.getExecutorId();
        return LivingServiceUtils.isInstanceAlive((String)executorId);
    }

    @Override
    public boolean isEnd(long mainTaskId) {
        MainTask mainTask = this.taskRepository.loadMT(mainTaskId);
        if (mainTask == null) {
            return true;
        }
        WTCTaskStatus taskStatus = mainTask.getTaskStatus();
        return taskStatus == WTCTaskStatus.ALL_FINISHED || taskStatus == WTCTaskStatus.PARTIALLY_FINISHED || taskStatus == WTCTaskStatus.ALL_ERROR || taskStatus == WTCTaskStatus.TERMINATED;
    }

    @Override
    public boolean isStop(long mainTaskId) {
        MainTask mainTask = this.taskRepository.loadMT(mainTaskId);
        WTCTaskStatus taskStatus = mainTask.getTaskStatus();
        return taskStatus == WTCTaskStatus.TERMINATING || taskStatus == WTCTaskStatus.TERMINATED;
    }

    @Override
    public boolean isTerminated(long mainTaskId) {
        WTCTaskStatus wtcTaskStatus = this.taskRepository.loadMTStatus(mainTaskId);
        return WTCTaskStatus.TERMINATED == wtcTaskStatus;
    }

    @Override
    public int getProgress(long mainTaskId) {
        MainTaskRunLog mtRL = this.taskRepository.loadEffectiveMTRL(mainTaskId);
        return mtRL == null ? 0 : mtRL.getProgress();
    }
}

