/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.base;

import kd.bos.monitor.service.LivingServiceUtils;
import kd.wtc.wtbs.business.task.base.ShardingTask;
import kd.wtc.wtbs.business.task.base.ShardingTaskDetector;
import kd.wtc.wtbs.business.task.base.ShardingTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class ShardingTaskDetectorImpl
implements ShardingTaskDetector {
    TaskRepository taskRepository;

    public ShardingTaskDetectorImpl(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    @Override
    public boolean isArriveExecutor(ShardingTaskRunLog stRunLog) {
        return WTCStringUtils.isNotEmpty((String)stRunLog.getExecutorId());
    }

    @Override
    public boolean isEnd(long shardingTaskId) {
        ShardingTask shardingTask = this.taskRepository.loadST(shardingTaskId);
        return this.isEnd(shardingTask);
    }

    @Override
    public boolean isEnd(ShardingTask shardingTask) {
        WTCSubTaskStatus status = shardingTask.getSubTaskStatus();
        return status == WTCSubTaskStatus.FINISHED || status == WTCSubTaskStatus.TERMINATED || status == WTCSubTaskStatus.ERROR;
    }

    @Override
    public boolean isExecutorAlive(ShardingTaskRunLog stRunLog) {
        if (!this.isArriveExecutor(stRunLog)) {
            return true;
        }
        String instanceId = stRunLog.getExecutorId();
        return LivingServiceUtils.isInstanceAlive((String)instanceId);
    }

    @Override
    public boolean isCrash(ShardingTaskRunLog stRunLog) {
        boolean executorAlive = this.isExecutorAlive(stRunLog);
        boolean end = this.isEnd(stRunLog.getShardingTaskId());
        return !end && !executorAlive;
    }
}

