/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.base;

import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskRunLog;
import kd.wtc.wtbs.business.task.base.ShardingTask;
import kd.wtc.wtbs.business.task.base.ShardingTaskExLog;
import kd.wtc.wtbs.business.task.base.ShardingTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.common.util.WTCCacheUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class TaskRepositoryImpl
implements TaskRepository {
    public static final String MT_ENTITY_NUMBER = "wtbs_maintask";
    public static final String ST_ENTITY_NUMBER = "wtbs_shardingtask";
    public static final String MT_RL_ENTITY_NUMBER = "wtbs_mtrunlog";
    public static final String ST_RL_ENTITY_NUMBER = "wtbs_strunlog";
    public static final String ST_EL_ENTITY_NUMBER = "wtbs_stexlog";
    public static final String PREFIX = "reportProgress";
    public static final String MT_CACHE_PREFIX = "wtc_mt_cache";
    public static final String MTRL_CACHE_PREFIX = "wtc_mtrl_cache";
    public static final int SECOND_MILLIS = 1000;
    public static final int MAX_CACHE_SECOND = 120;
    public static final long MAX_CACHE_MILLIS = 120000L;
    private static final HRBaseServiceHelper mtDao = new HRBaseServiceHelper("wtbs_maintask");
    private static final HRBaseServiceHelper stDao = new HRBaseServiceHelper("wtbs_shardingtask");
    private static final HRBaseServiceHelper mtrlDao = new HRBaseServiceHelper("wtbs_mtrunlog");
    private static final HRBaseServiceHelper strlDao = new HRBaseServiceHelper("wtbs_strunlog");
    private static final HRBaseServiceHelper stelDao = new HRBaseServiceHelper("wtbs_stexlog");

    public static TaskRepositoryImpl getInstance() {
        return new TaskRepositoryImpl();
    }

    private static String getCacheKey(String prefix, long id) {
        return WTCCacheUtils.getKey((String)"wtbs", (String)(prefix + id));
    }

    private <T> T loadObjFromCache(String cacheKey) {
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        String mtCacheStr = (String)redis.get(cacheKey);
        if (WTCStringUtils.isNotEmpty((String)mtCacheStr)) {
            return (T)WTCSerializationUtils.deSerializeFromBase64((String)mtCacheStr);
        }
        return null;
    }

    private <T> void updateObjCache(String cacheKey, T obj) {
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        redis.put(cacheKey, (Object)WTCSerializationUtils.serializeToBase64(obj), 120);
    }

    private void clearObjCache(String cacheKey) {
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        redis.remove(cacheKey);
    }

    private void clearObjCacheBatch(String[] cacheKey) {
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        redis.remove(cacheKey);
    }

    @Override
    public void saveMT(MainTask mainTask) {
        DynamicObject mtDyn = TaskRepositoryImpl.newMTDyn();
        this.copyMTAttr(mainTask, mtDyn, false);
        mtDao.saveOne(mtDyn);
        mainTask.setId(mtDyn.getLong("id"));
        this.clearObjCache(TaskRepositoryImpl.getCacheKey(MT_CACHE_PREFIX, mainTask.getId()));
    }

    @Override
    public void updateMT(MainTask mainTask) {
        DynamicObject mtDyn = mtDao.loadSingle((Object)mainTask.getId());
        if (mtDyn == null) {
            return;
        }
        this.copyMTAttr(mainTask, mtDyn, false);
        mtDao.updateOne(mtDyn);
        this.clearObjCache(TaskRepositoryImpl.getCacheKey(MT_CACHE_PREFIX, mainTask.getId()));
    }

    @Override
    public MainTask loadMT(long bizTaskId, String category) {
        QFilter qFilter = new QFilter("biztaskid", "=", (Object)bizTaskId).and("category", "=", (Object)category);
        DynamicObject mtDyn = mtDao.loadDynamicObject(qFilter);
        if (mtDyn == null) {
            return null;
        }
        MainTask mainTask = new MainTask();
        this.copyMTAttr(mtDyn, mainTask, true);
        this.updateObjCache(TaskRepositoryImpl.getCacheKey(MT_CACHE_PREFIX, mainTask.getId()), mainTask);
        return mainTask;
    }

    @Override
    public MainTask loadMT(long mainTaskId) {
        MainTask cacheMT = (MainTask)this.loadObjFromCache(TaskRepositoryImpl.getCacheKey(MT_CACHE_PREFIX, mainTaskId));
        if (cacheMT != null) {
            return cacheMT;
        }
        DynamicObject mtDyn = mtDao.loadSingle((Object)mainTaskId);
        if (mtDyn == null) {
            return null;
        }
        MainTask mainTask = new MainTask();
        this.copyMTAttr(mtDyn, mainTask, true);
        this.updateObjCache(TaskRepositoryImpl.getCacheKey(MT_CACHE_PREFIX, mainTask.getId()), mainTask);
        return mainTask;
    }

    @Override
    public List<MainTask> loadAllNotEndMT() {
        List<String> notEndStatus = Arrays.asList(WTCTaskStatus.NEW.code, WTCTaskStatus.RUNNING.code, WTCTaskStatus.TERMINATING.code);
        QFilter qFilter = new QFilter("taskstatus", "in", notEndStatus);
        DynamicObject[] dynamicObjects = mtDao.loadDynamicObjectArray(new QFilter[]{qFilter});
        return Arrays.stream(dynamicObjects).map(dyn -> {
            MainTask mainTask = new MainTask();
            this.copyMTAttr((DynamicObject)dyn, mainTask, true);
            return mainTask;
        }).collect(Collectors.toList());
    }

    @Override
    public List<MainTask> loadAllNotEndMT(QFilter filter) {
        if (filter == null) {
            return this.loadAllNotEndMT();
        }
        List<String> notEndStatus = Arrays.asList(WTCTaskStatus.NEW.code, WTCTaskStatus.RUNNING.code, WTCTaskStatus.TERMINATING.code);
        QFilter qFilter = new QFilter("taskstatus", "in", notEndStatus);
        DynamicObject[] dynamicObjects = mtDao.loadDynamicObjectArray(new QFilter[]{qFilter, filter});
        return Arrays.stream(dynamicObjects).map(dyn -> {
            MainTask mainTask = new MainTask();
            this.copyMTAttr((DynamicObject)dyn, mainTask, true);
            return mainTask;
        }).collect(Collectors.toList());
    }

    @Override
    public WTCTaskStatus loadMTStatus(long mainTaskId) {
        if (mainTaskId > 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)mainTaskId);
            DynamicObject dynamicObject = mtDao.queryOne("taskstatus", qFilter);
            return WTCTaskStatus.from(dynamicObject.getString("taskstatus"));
        }
        return null;
    }

    @Override
    public void saveST(ShardingTask stTask) {
        DynamicObject stDyn = TaskRepositoryImpl.newSTDyn();
        this.copySTAttr(stTask, stDyn, false);
        stDao.saveOne(stDyn);
        stTask.setId(stDyn.getLong("id"));
    }

    @Override
    public void saveST(List<ShardingTask> stList) {
        int i;
        int len = stList.size();
        DynamicObject[] stDynArr = TaskRepositoryImpl.newSTDyn(len);
        for (i = 0; i < len; ++i) {
            ShardingTask from = stList.get(i);
            DynamicObject target = stDynArr[i];
            this.copySTAttr(from, target, false);
        }
        stDao.save(stDynArr);
        for (i = 0; i < len; ++i) {
            stList.get(i).setId(stDynArr[i].getLong("id"));
        }
    }

    @Override
    public void updateST(ShardingTask stTask) {
        DynamicObject stDyn = stDao.loadSingle((Object)stTask.getId());
        if (stDyn == null) {
            return;
        }
        this.copySTAttr(stTask, stDyn, false);
        stDao.updateOne(stDyn);
    }

    @Override
    public boolean existNotEndST(long mainTaskId) {
        return this.countNotEndST(mainTaskId) != 0;
    }

    @Override
    public int countST(long mainTaskId) {
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId);
        return stDao.count(ST_ENTITY_NUMBER, new QFilter[]{qFilter});
    }

    @Override
    public int countErrorST(long mainTaskId) {
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId).and("subtaskstatus", "=", (Object)WTCSubTaskStatus.ERROR.getCode());
        return stDao.count(ST_ENTITY_NUMBER, new QFilter[]{qFilter});
    }

    @Override
    public boolean existErrorST(long mainTaskId) {
        return this.countErrorST(mainTaskId) != 0;
    }

    @Override
    public int countNotEndST(long mainTaskId) {
        List<String> notEndStatus = Arrays.asList(WTCSubTaskStatus.NEW.getCode(), WTCSubTaskStatus.DISPATCHED.getCode(), WTCSubTaskStatus.RUNNING.getCode(), WTCSubTaskStatus.DISPATCH_FAILED.getCode());
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId).and("subtaskstatus", "in", notEndStatus);
        DynamicObject[] query = stDao.query("id", new QFilter[]{qFilter});
        return query.length;
    }

    @Override
    public ShardingTask loadST(long shardingTaskId) {
        DynamicObject stDyn = stDao.loadSingle((Object)shardingTaskId);
        if (stDyn == null) {
            return null;
        }
        ShardingTask shardingTask = new ShardingTask();
        this.copySTAttr(stDyn, shardingTask, true);
        return shardingTask;
    }

    @Override
    public ShardingTask loadST(long mainTaskId, long bizSubTaskId) {
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId).and("bizsubtaskid", "=", (Object)bizSubTaskId);
        DynamicObject stDyn = stDao.loadDynamicObject(qFilter);
        if (stDyn == null) {
            return null;
        }
        ShardingTask shardingTask = new ShardingTask();
        this.copySTAttr(stDyn, shardingTask, true);
        return shardingTask;
    }

    @Override
    public List<ShardingTask> loadAllSTButNotIn(long mainTaskId, Collection<Long> excludeSTID) {
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId);
        if (!excludeSTID.isEmpty()) {
            qFilter.and("id", "not in", excludeSTID);
        }
        DynamicObject[] stDynArr = stDao.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList<ShardingTask> res = new ArrayList<ShardingTask>(stDynArr.length);
        for (DynamicObject stDyn : stDynArr) {
            ShardingTask shardingTask = new ShardingTask();
            this.copySTAttr(stDyn, shardingTask, true);
            res.add(shardingTask);
        }
        return res;
    }

    @Override
    public List<DynamicObject> queryST(long mainTaskId, QFilter customFilter, String property) {
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId);
        if (customFilter != null) {
            qFilter.and(customFilter);
        }
        DynamicObject[] stDynArr = property == null ? stDao.loadDynamicObjectArray(new QFilter[]{qFilter}) : stDao.query(property, new QFilter[]{qFilter});
        return Arrays.asList(stDynArr);
    }

    @Override
    public void saveMTRL(MainTaskRunLog mtRunLog) {
        DynamicObject mtrlDyn = TaskRepositoryImpl.newMTRLDyn();
        this.copyMTRLAttr(mtRunLog, mtrlDyn, false);
        mtrlDao.saveOne(mtrlDyn);
        mtRunLog.setId(mtrlDyn.getLong("id"));
        this.clearObjCache(TaskRepositoryImpl.getCacheKey(MTRL_CACHE_PREFIX, mtRunLog.getMainTaskId()));
    }

    @Override
    public void updateMTRL(MainTaskRunLog mtRunLog) {
        DynamicObject dyn = mtrlDao.loadDynamicObject(new QFilter("id", "=", (Object)mtRunLog.getId()));
        if (dyn != null) {
            this.copyMTRLAttr(mtRunLog, dyn, false);
            mtrlDao.updateOne(dyn);
            this.clearObjCache(TaskRepositoryImpl.getCacheKey(MTRL_CACHE_PREFIX, mtRunLog.getMainTaskId()));
        }
    }

    @Override
    public void logicDelAllMTRL(long mainTaskId) {
        QFilter and = new QFilter("maintaskid", "=", (Object)mainTaskId).and("iscurrent", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynArr = mtrlDao.loadDynamicObjectArray(new QFilter[]{and});
        if (dynArr.length == 0) {
            return;
        }
        for (DynamicObject dyn : dynArr) {
            dyn.set("iscurrent", (Object)Boolean.FALSE);
        }
        mtrlDao.update(dynArr);
        this.clearObjCache(TaskRepositoryImpl.getCacheKey(MTRL_CACHE_PREFIX, mainTaskId));
    }

    @Override
    public MainTaskRunLog loadEffectiveMTRL(long mainTaskId) {
        MainTaskRunLog cacheObj = (MainTaskRunLog)this.loadObjFromCache(TaskRepositoryImpl.getCacheKey(MTRL_CACHE_PREFIX, mainTaskId));
        if (cacheObj != null) {
            return cacheObj;
        }
        QFilter and = new QFilter("maintaskid", "=", (Object)mainTaskId).and("iscurrent", "=", (Object)Boolean.TRUE);
        DynamicObject dyn = mtrlDao.loadDynamicObject(and);
        if (dyn == null) {
            return null;
        }
        MainTaskRunLog mtrl = new MainTaskRunLog();
        this.copyMTRLAttr(dyn, mtrl, true);
        this.updateObjCache(TaskRepositoryImpl.getCacheKey(MTRL_CACHE_PREFIX, mainTaskId), mtrl);
        return mtrl;
    }

    @Override
    public List<MainTaskRunLog> loadEffectiveMTRL(List<Long> mainTaskIdList) {
        QFilter qFilter = new QFilter("maintaskid", "in", mainTaskIdList);
        DynamicObject[] dynamicObjects = mtrlDao.loadDynamicObjectArray(new QFilter[]{qFilter});
        List<String> cacheKey = mainTaskIdList.stream().map(ele -> TaskRepositoryImpl.getCacheKey(MTRL_CACHE_PREFIX, ele)).collect(Collectors.toList());
        this.clearObjCacheBatch(cacheKey.toArray(new String[0]));
        return Arrays.stream(dynamicObjects).map(dyn -> {
            MainTaskRunLog mainTaskRunLog = new MainTaskRunLog();
            this.copyMTRLAttr((DynamicObject)dyn, mainTaskRunLog, true);
            return mainTaskRunLog;
        }).collect(Collectors.toList());
    }

    @Override
    public void saveSTRL(ShardingTaskRunLog stRunLog) {
        DynamicObject strlDyn = TaskRepositoryImpl.newSTRLDyn();
        this.copySTRLAttr(stRunLog, strlDyn, false);
        strlDao.saveOne(strlDyn);
        stRunLog.setId(strlDyn.getLong("id"));
    }

    @Override
    public void updateSTRL(ShardingTaskRunLog stRunLog) {
        DynamicObject strlDyn = strlDao.loadSingle((Object)stRunLog.getId());
        this.copySTRLAttr(stRunLog, strlDyn, false);
        strlDao.updateOne(strlDyn);
    }

    @Override
    public ShardingTaskRunLog loadSTRLForProgress(long stRunLogId) {
        ShardingTaskRunLog strlFormCache = this.loadSTRLFormCache(stRunLogId);
        if (strlFormCache == null) {
            strlFormCache = this.loadSTRL(stRunLogId);
            this.updateSTRLCache(strlFormCache);
        }
        return strlFormCache;
    }

    private ShardingTaskRunLog loadSTRLFormCache(long stRunLogId) {
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        String strLog = (String)redis.get(TaskRepositoryImpl.getKey(String.valueOf(stRunLogId)));
        if (HRStringUtils.isNotEmpty((String)strLog)) {
            return (ShardingTaskRunLog)JSON.parseObject((String)strLog, ShardingTaskRunLog.class);
        }
        return null;
    }

    @Override
    public void updateSTRLForProgress(ShardingTaskRunLog stRunLog) {
        int progress = stRunLog.getProgress();
        if (progress >= 100 || progress == 0) {
            this.updateSTRL(stRunLog);
        }
        this.updateSTRLCache(stRunLog);
    }

    private void updateSTRLCache(ShardingTaskRunLog stRunLog) {
        DistributeSessionlessCache redis = WTCCacheUtils.getCache();
        redis.put(TaskRepositoryImpl.getKey(String.valueOf(stRunLog.getId())), (Object)JSON.toJSONString((Object)stRunLog), 120);
    }

    private static String getKey(String key) {
        return WTCCacheUtils.getKey((String)"wtbs", (String)(PREFIX + key));
    }

    @Override
    public ShardingTaskRunLog loadSTRL(long stRunLogId) {
        DynamicObject strlDyn = strlDao.loadSingle((Object)stRunLogId);
        if (strlDyn == null) {
            return null;
        }
        ShardingTaskRunLog strl = new ShardingTaskRunLog();
        this.copySTRLAttr(strlDyn, strl, true);
        return strl;
    }

    @Override
    public ShardingTaskRunLog loadLastFailSTRL(long shardingTaskId) {
        QFilter and = new QFilter("shardingtaskid", "=", (Object)shardingTaskId).and("iscurrent", "=", (Object)Boolean.FALSE);
        DynamicObject[] dynArr = strlDao.loadDynamicObjectArray(new QFilter[]{and});
        if (dynArr.length == 0) {
            return null;
        }
        List strlEndTimeASCList = Arrays.stream(dynArr).map(dyn -> {
            ShardingTaskRunLog strl = new ShardingTaskRunLog();
            this.copySTRLAttr((DynamicObject)dyn, strl, true);
            return strl;
        }).sorted(Comparator.comparing(ShardingTaskRunLog::getEndTime)).collect(Collectors.toList());
        return (ShardingTaskRunLog)strlEndTimeASCList.get(strlEndTimeASCList.size() - 1);
    }

    @Override
    public ShardingTaskRunLog loadEffectiveSTRL(long shardingTaskId) {
        QFilter and = new QFilter("shardingtaskid", "=", (Object)shardingTaskId).and("iscurrent", "=", (Object)Boolean.TRUE);
        DynamicObject dyn = strlDao.loadDynamicObject(and);
        if (dyn == null) {
            return null;
        }
        ShardingTaskRunLog shardingTaskRunLog = new ShardingTaskRunLog();
        this.copySTRLAttr(dyn, shardingTaskRunLog, true);
        return shardingTaskRunLog;
    }

    @Override
    public List<ShardingTaskRunLog> loadAllEffectiveSTRL(long mainTaskId) {
        QFilter and = new QFilter("maintaskid", "=", (Object)mainTaskId).and("iscurrent", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynArr = strlDao.loadDynamicObjectArray(new QFilter[]{and});
        ArrayList<ShardingTaskRunLog> res = new ArrayList<ShardingTaskRunLog>(dynArr.length);
        for (DynamicObject dyn : dynArr) {
            ShardingTaskRunLog strl = new ShardingTaskRunLog();
            this.copySTRLAttr(dyn, strl, true);
            res.add(strl);
        }
        return res;
    }

    @Override
    public List<ShardingTaskRunLog> loadAllSTRL(long mainTaskId) {
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId);
        DynamicObject[] dynArr = strlDao.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList<ShardingTaskRunLog> res = new ArrayList<ShardingTaskRunLog>(dynArr.length);
        for (DynamicObject dyn : dynArr) {
            ShardingTaskRunLog strl = new ShardingTaskRunLog();
            this.copySTRLAttr(dyn, strl, true);
            res.add(strl);
        }
        return res;
    }

    @Override
    public Map<Long, Integer> queryAllSTRunTimes(long mainTaskId) {
        HashMap<Long, Integer> res = new HashMap<Long, Integer>(16);
        QFilter qFilter = new QFilter("maintaskid", "=", (Object)mainTaskId);
        DataSet queryAllSTRunTimes = strlDao.queryDataSet("queryAllSTRunTimes", "id,shardingtaskid", qFilter.toArray());
        while (queryAllSTRunTimes.hasNext()) {
            Row row = queryAllSTRunTimes.next();
            Long shardingTaskId = row.getLong("shardingtaskid");
            Integer cnt = res.getOrDefault(shardingTaskId, 0);
            res.put(shardingTaskId, cnt + 1);
        }
        return res;
    }

    @Override
    public void saveSTEL(ShardingTaskExLog stExLog) {
        DynamicObject dyn = TaskRepositoryImpl.newSTELDyn();
        this.copySTELAttr(stExLog, dyn, false);
        stelDao.saveOne(dyn);
        stExLog.setId(dyn.getLong("id"));
    }

    @Override
    public int countAllSTEL(long shardingTaskId) {
        QFilter qFilter = new QFilter("shardingtaskid", "=", (Object)shardingTaskId);
        return stDao.count(ST_EL_ENTITY_NUMBER, new QFilter[]{qFilter});
    }

    @Override
    public int countSTEL(long shardingTaskId, boolean existSTRLID) {
        QFilter qFilter = new QFilter("shardingtaskid", "=", (Object)shardingTaskId);
        QFilter qFilter1 = new QFilter("strunlogid", "=", (Object)0L);
        if (existSTRLID) {
            qFilter1 = new QFilter("strunlogid", "!=", (Object)0L);
        }
        return stDao.count(ST_EL_ENTITY_NUMBER, new QFilter[]{qFilter, qFilter1});
    }

    @Override
    public int countSTRL(long shardingTaskId) {
        QFilter qFilter = new QFilter("shardingtaskid", "=", (Object)shardingTaskId);
        return stDao.count(ST_RL_ENTITY_NUMBER, new QFilter[]{qFilter});
    }

    public static DynamicObject newMTDyn() {
        return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)MT_ENTITY_NUMBER));
    }

    public static DynamicObject newSTDyn() {
        return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ST_ENTITY_NUMBER));
    }

    public static DynamicObject[] newSTDyn(int size) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ST_ENTITY_NUMBER);
        DynamicObject[] list = new DynamicObject[size];
        for (int i = 0; i < size; ++i) {
            list[i] = new DynamicObject((DynamicObjectType)dataEntityType);
        }
        return list;
    }

    public static DynamicObject newMTRLDyn() {
        return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)MT_RL_ENTITY_NUMBER));
    }

    public static DynamicObject newSTRLDyn() {
        return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ST_RL_ENTITY_NUMBER));
    }

    public static DynamicObject newSTELDyn() {
        return new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)ST_EL_ENTITY_NUMBER));
    }

    private void copyMTAttr(MainTask from, DynamicObject target, boolean copyId) {
        if (copyId) {
            target.set("id", (Object)from.getId());
        }
        target.set("taskreqstr_tag", (Object)from.getTaskReqStr());
        target.set("biztaskid", (Object)from.getBizTaskId());
        target.set("category", (Object)from.getCategory());
        target.set("hasshardingtask", (Object)from.isHasShardingTask());
        target.set("startdate", (Object)WTCDateUtils.toDate((LocalDateTime)from.getStartDate()));
        target.set("enddate", (Object)WTCDateUtils.toDate((LocalDateTime)from.getEndDate()));
        target.set("taskstatus", (Object)from.getTaskStatus().code);
        target.set("timecost", (Object)from.getTimeCost());
        target.set("totalshardingtask", (Object)from.getTotalShardingTask());
        target.set("finishedshardingtask", (Object)from.getFinishedShardingTask());
        target.set("updatetime", (Object)WTCDateUtils.toDate((LocalDateTime)from.getUpdateTime()));
        target.set("timeoutinsecond", (Object)from.getTimeoutInSecond());
        target.set("creator", (Object)from.getCreatorId());
        target.set("createtime", (Object)WTCDateUtils.toDate((LocalDateTime)from.getCreateTime()));
    }

    private void copyMTAttr(DynamicObject from, MainTask target, boolean copyId) {
        if (copyId) {
            target.setId(from.getLong("id"));
        }
        target.setTaskReqStr(from.getString("taskreqstr_tag"));
        target.setBizTaskId(from.getLong("biztaskid"));
        target.setCategory(from.getString("category"));
        target.setHasShardingTask(from.getBoolean("hasshardingtask"));
        target.setStartDate(WTCDateUtils.toLocalDateTime((Date)from.getDate("startdate")));
        target.setEndDate(WTCDateUtils.toLocalDateTime((Date)from.getDate("enddate")));
        target.setTaskStatus(WTCTaskStatus.from(from.getString("taskstatus")));
        target.setTimeCost(from.getLong("timecost"));
        target.setTotalShardingTask(from.getInt("totalshardingtask"));
        target.setFinishedShardingTask(from.getInt("finishedshardingtask"));
        target.setUpdateTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("updatetime")));
        target.setTimeoutInSecond(from.getInt("timeoutinsecond"));
        target.setCreatorId(from.getLong("creator.id"));
        target.setCreateTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("createtime")));
    }

    private void copySTAttr(ShardingTask from, DynamicObject target, boolean copyId) {
        if (copyId) {
            target.set("id", (Object)from.getId());
        }
        target.set("dispatchreqstr_tag", (Object)from.getDispatchReqStr());
        target.set("maintaskid", (Object)from.getMainTaskId());
        target.set("bizsubtaskid", (Object)from.getBizSubTaskId());
        target.set("index", (Object)from.getIndex());
        target.set("createtime", (Object)WTCDateUtils.toDate((LocalDateTime)from.getCreateTime()));
        target.set("enddate", (Object)WTCDateUtils.toDate((LocalDateTime)from.getEndDate()));
        target.set("subtaskstatus", (Object)from.getSubTaskStatus().getCode());
        target.set("updatetime", (Object)WTCDateUtils.toDate((LocalDateTime)from.getUpdateTime()));
    }

    private void copySTAttr(DynamicObject from, ShardingTask target, boolean copyId) {
        if (copyId) {
            target.setId(from.getLong("id"));
        }
        target.setDispatchReqStr(from.getString("dispatchreqstr_tag"));
        target.setMainTaskId(from.getLong("maintaskid"));
        target.setBizSubTaskId(from.getLong("bizsubtaskid"));
        target.setIndex(from.getInt("index"));
        target.setCreateTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("createtime")));
        target.setEndDate(WTCDateUtils.toLocalDateTime((Date)from.getDate("enddate")));
        target.setSubTaskStatus(WTCSubTaskStatus.from(from.getString("subtaskstatus")));
        target.setUpdateTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("updatetime")));
    }

    private void copyMTRLAttr(MainTaskRunLog from, DynamicObject target, boolean copyId) {
        if (copyId) {
            target.set("id", (Object)from.getId());
        }
        target.set("maintaskid", (Object)from.getMainTaskId());
        target.set("progress", (Object)from.getProgress());
        target.set("updatetime", (Object)WTCDateUtils.toDate((LocalDateTime)from.getUpdateTime()));
        target.set("executorid", (Object)from.getExecutorId());
        target.set("iscurrent", (Object)from.isCurrent());
        target.set("taskinfoid", (Object)from.getTaskInfoId());
        target.set("reportdata_tag", (Object)from.getReportData());
    }

    private void copyMTRLAttr(DynamicObject from, MainTaskRunLog target, boolean copyId) {
        if (copyId) {
            target.setId(from.getLong("id"));
        }
        target.setMainTaskId(from.getLong("maintaskid"));
        target.setProgress(from.getInt("progress"));
        target.setUpdateTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("updatetime")));
        target.setExecutorId(from.getString("executorid"));
        target.setCurrent(from.getBoolean("iscurrent"));
        target.setTaskInfoId(from.getString("taskinfoid"));
        target.setReportData(from.getString("reportdata_tag"));
    }

    private void copySTRLAttr(ShardingTaskRunLog from, DynamicObject target, boolean copyId) {
        if (copyId) {
            target.set("id", (Object)from.getId());
        }
        target.set("maintaskid", (Object)from.getMainTaskId());
        target.set("shardingtaskid", (Object)from.getShardingTaskId());
        target.set("executorid", (Object)from.getExecutorId());
        target.set("progress", (Object)from.getProgress());
        target.set("iscurrent", (Object)from.isCurrent());
        target.set("reportdata_tag", (Object)from.getReportData());
        target.set("createtime", (Object)WTCDateUtils.toDate((LocalDateTime)from.getCreateTime()));
        target.set("startdate", (Object)WTCDateUtils.toDate((LocalDateTime)from.getStartTime()));
        target.set("enddate", (Object)WTCDateUtils.toDate((LocalDateTime)from.getEndTime()));
        target.set("updatetime", (Object)WTCDateUtils.toDate((LocalDateTime)from.getUpdateTime()));
    }

    private void copySTRLAttr(DynamicObject from, ShardingTaskRunLog target, boolean copyId) {
        if (copyId) {
            target.setId(from.getLong("id"));
        }
        target.setMainTaskId(from.getLong("maintaskid"));
        target.setShardingTaskId(from.getLong("shardingtaskid"));
        target.setExecutorId(from.getString("executorid"));
        target.setProgress(from.getInt("progress"));
        target.setCurrent(from.getBoolean("iscurrent"));
        target.setReportData(from.getString("reportdata_tag"));
        target.setCreateTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("createtime")));
        target.setStartTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("startdate")));
        target.setEndTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("enddate")));
        target.setUpdateTime(WTCDateUtils.toLocalDateTime((Date)from.getDate("updatetime")));
    }

    private void copySTELAttr(ShardingTaskExLog from, DynamicObject target, boolean copyId) {
        if (copyId) {
            target.set("id", (Object)from.getId());
        }
        target.set("shardingtaskid", (Object)from.getShardingTaskId());
        target.set("strunlogid", (Object)from.getStRunLogId());
        target.set("exstr_tag", (Object)from.getExStr());
    }
}

