/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBackWraper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.TaskProgressFormEdit;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.MainTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class WTCBackgroundTaskSubscriber
implements Runnable {
    private static final TaskRepositoryImpl taskRepository = TaskRepositoryImpl.getInstance();
    private static final MainTaskDetector mtDetector = new MainTaskDetectorImpl(taskRepository);
    private Log log = LogFactory.getLog(WTCBackgroundTaskSubscriber.class);
    private static final int DEFCIRCLEINTEVAL = 5;
    private long mainTaskId;
    private RequestContext rc;
    private JobFormInfo jobFormInfo;
    private String taskId;
    private TaskInfo lastTaskInfo;
    private Date lastTime;

    public WTCBackgroundTaskSubscriber(long mainTaskId, RequestContext rc, JobFormInfo jobFormInfo, String taskId) {
        this.mainTaskId = mainTaskId;
        this.rc = rc;
        this.jobFormInfo = jobFormInfo;
        this.taskId = taskId;
    }

    public JobFormInfo getJobFormInfo() {
        return this.jobFormInfo;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getCircleInteval() {
        String circleInteval = System.getProperty("backgroundtask.querytask.inteval");
        if (StringUtils.isBlank((Object)circleInteval)) {
            return 5;
        }
        int inteval = Integer.parseInt(circleInteval.toString());
        return inteval <= 10 && inteval >= 1 ? inteval : 2;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        try {
            this.execute();
        }
        catch (Throwable var3) {
            this.log.error(var3);
            TaskInfo taskInfo = new TaskInfo();
            taskInfo.setId(this.getTaskId());
            taskInfo.setStatus("FAILED");
            taskInfo.setDesc(String.format(ResManager.loadKDString((String)"\u51fa\u9519\uff1a%s", (String)"WTCBackgroundTaskSubscriber_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), StringUtils.isBlank((CharSequence)var3.getMessage()) ? var3.getClass().getSimpleName() : var3.getMessage()));
            TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, (List)null);
        }
    }

    public void execute() {
        block9: {
            TaskInfo taskInfo;
            long timeout_MS = 1000L * (long)this.getJobFormInfo().getTimeout();
            long circleInteval_MS = this.getCircleInteval() * 1000;
            long beginat_MS = System.currentTimeMillis();
            int fastTimes = 5;
            while (true) {
                if (fastTimes > 0) {
                    this.sleep(1000L, beginat_MS);
                    beginat_MS = System.currentTimeMillis();
                    --fastTimes;
                } else {
                    this.sleep(circleInteval_MS, beginat_MS);
                    beginat_MS = System.currentTimeMillis();
                }
                taskInfo = ScheduleServiceHelper.queryTask((String)this.getTaskId());
                if (taskInfo == null) {
                    taskInfo = new TaskInfo();
                    taskInfo.setId(this.getTaskId());
                    taskInfo.setStatus("FAILED");
                    taskInfo.setDesc(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u672a\u53d6\u5230\u4efb\u52a1\u72b6\u6001", (String)"WTCBackgroundTaskSubscriber_2", (String)"wtc-wtbs-business", (Object[])new Object[0]));
                }
                if (mtDetector.isEnd(this.mainTaskId)) {
                    taskInfo.setProgress(100);
                    if (!taskInfo.isTaskEnd()) {
                        taskInfo.setStatus("COMPLETED");
                    }
                    MainTaskRunLog mainTaskRunLog = taskRepository.loadEffectiveMTRL(this.mainTaskId);
                    Map reportData = null;
                    if (WTCStringUtils.isNotEmpty((String)mainTaskRunLog.getReportData())) {
                        reportData = (Map)WTCSerializationUtils.deSerializeFromBase64((String)mainTaskRunLog.getReportData());
                        taskInfo.setData(WTCSerializationUtils.toJsonString((Object)reportData));
                    }
                    TaskDao taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
                    taskDao.updateProgress(this.taskId, taskInfo.getProgress(), taskInfo.getDesc(), reportData);
                    taskDao.updateCustomData(this.taskId, reportData);
                    taskDao.updateStatus(this.taskId, taskInfo.getStatus());
                    List<Map<String, Object>> formActions = this.closeCallBack(taskInfo);
                    TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, formActions);
                    break block9;
                }
                boolean taskEnd = taskInfo.isTaskEnd();
                int progress = mtDetector.getProgress(this.mainTaskId);
                progress = progress >= 100 ? 99 : (progress > 0 ? progress : 1);
                taskInfo.setStatus("SCHEDULED");
                taskInfo.setProgress(progress);
                if (taskEnd) {
                    TaskDao taskDao = ScheduleService.getInstance().getObjectFactory().getTaskDao();
                    taskDao.updateStatus(this.taskId, "SCHEDULED");
                    taskDao.updateStatus(this.taskId, "BEGIN");
                    taskDao.updateProgress(this.taskId, progress);
                }
                if (this.compareTaskInfo(taskInfo)) {
                    TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, (List)null);
                    continue;
                }
                long offset_MS = System.currentTimeMillis() - this.lastTime.getTime();
                if (offset_MS > timeout_MS) break;
            }
            taskInfo = new TaskInfo();
            taskInfo.setId(this.getTaskId());
            taskInfo.setStatus("FAILED");
            taskInfo.setDesc(ResManager.loadKDString((String)"\u5f02\u5e38\uff1a\u957f\u65f6\u95f4\u6ca1\u6709\u8fdb\u5c55", (String)"WTCBackgroundTaskSubscriber_3", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            TaskClientProxy.feedbackProgress((JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo, (List)null);
        }
    }

    private List<Map<String, Object>> closeCallBack(TaskInfo taskInfo) {
        IFormView progressView;
        if (!TaskClientProxy.isExistTask((String)this.getTaskId())) {
            return null;
        }
        String progressPageId = TaskClientProxy.getProgressPageId((String)this.getTaskId());
        if (StringUtils.isNotBlank((CharSequence)progressPageId) && (progressView = SessionManager.getCurrent().getViewNoPlugin(progressPageId)) != null) {
            return null;
        }
        if (this.getJobFormInfo().getCloseCallBack() == null) {
            return null;
        }
        Map returnData = TaskProgressFormEdit.packageReturnResult((TaskInfo)taskInfo);
        if (returnData == null) {
            return null;
        }
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(this.getJobFormInfo().getParentPageId());
        if (parentViewParameter == null) {
            return null;
        }
        CloseCallBackWraper closeCallBackWraper = new CloseCallBackWraper(this.getJobFormInfo().getParentPageId(), this.getJobFormInfo().getCloseCallBack(), null, false);
        closeCallBackWraper.setReturnData((Object)returnData);
        List acts = (List)DispatchServiceHelper.invokeBOSService((String)parentViewParameter.getServiceAppId(), (String)"FormService", (String)"closeCallBack", (Object[])new Object[]{closeCallBackWraper});
        if (acts == null) {
            return null;
        }
        HashMap<String, Object> arg = new HashMap<String, Object>();
        arg.put("pageId", this.getJobFormInfo().getParentPageId());
        arg.put("actions", acts);
        ArrayList<HashMap<String, Object>> paras = new ArrayList<HashMap<String, Object>>();
        paras.add(arg);
        HashMap<String, Object> sendParentViewAction = new HashMap<String, Object>();
        sendParentViewAction.put("a", "sendDynamicFormAction");
        sendParentViewAction.put("p", paras);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        list.add(sendParentViewAction);
        return list;
    }

    private boolean compareTaskInfo(TaskInfo taskInfo) {
        boolean equals;
        if (null == taskInfo && null == this.lastTaskInfo) {
            return false;
        }
        if (null == this.lastTaskInfo) {
            this.lastTaskInfo = taskInfo;
            this.lastTime = new Date();
            return true;
        }
        if (null == taskInfo) {
            this.lastTaskInfo = null;
            this.lastTime = new Date();
            return true;
        }
        boolean bl = equals = StringUtils.equals((CharSequence)taskInfo.getStatus(), (CharSequence)this.lastTaskInfo.getStatus()) && StringUtils.equals((CharSequence)taskInfo.getDesc(), (CharSequence)this.lastTaskInfo.getDesc()) && StringUtils.equals((CharSequence)taskInfo.getData(), (CharSequence)this.lastTaskInfo.getData()) && taskInfo.getProgress() == this.lastTaskInfo.getProgress();
        if (!equals) {
            this.lastTaskInfo = taskInfo;
            this.lastTime = new Date();
        }
        return !equals;
    }

    private void sleep(long circleInteval_MS, long beginat_MS) {
        long sleeptime = circleInteval_MS - (System.currentTimeMillis() - beginat_MS);
        if (sleeptime > 0L) {
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException var8) {
                this.log.error((Throwable)var8);
            }
        }
    }
}

