/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.base;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.dao.dbImpl.DbJobDao;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.formtask.TaskFormProcessorService;
import kd.wtc.wtbs.business.formtask.WTCTaskForm;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.WTCDistributeTaskPreHandler;
import kd.wtc.wtbs.business.task.WTCTaskExtHelper;
import kd.wtc.wtbs.business.task.WTCTaskObjectFactory;
import kd.wtc.wtbs.business.task.base.BootTaskRes;
import kd.wtc.wtbs.business.task.base.ErrorMsgUtils;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.MainTaskLifeCycleCallBack;
import kd.wtc.wtbs.business.task.base.MainTaskRunLog;
import kd.wtc.wtbs.business.task.base.ShardingTask;
import kd.wtc.wtbs.business.task.base.ShardingTaskDetector;
import kd.wtc.wtbs.business.task.base.ShardingTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.ShardingTaskExLog;
import kd.wtc.wtbs.business.task.base.ShardingTaskProgressReporter;
import kd.wtc.wtbs.business.task.base.ShardingTaskProgressReporterImpl;
import kd.wtc.wtbs.business.task.base.ShardingTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.business.task.base.WTCBackgroundTaskSubscriber;
import kd.wtc.wtbs.business.task.base.WTCTaskLockUtils;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.converter.WTCTaskConverter;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.task.executor.WTCInstrumentedDispatcher;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.task.sharding.WTCTaskShardingService;
import kd.wtc.wtbs.common.helper.WTCValidatorHelper;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.WTCAssert;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public final class WTCDistributeTaskHelper {
    private static final Log log = LogFactory.getLog(WTCDistributeTaskHelper.class);
    private static final int MAX_ERROR_MSG_LINE = Integer.parseInt(System.getProperty("wtc.task.st.max.stacktrace", "50"));
    private static final TaskRepository taskRepository = TaskRepositoryImpl.getInstance();
    private static final ShardingTaskDetector stDetector = new ShardingTaskDetectorImpl(taskRepository);
    private static final ShardingTaskProgressReporter stReporter = new ShardingTaskProgressReporterImpl(taskRepository);
    private static final MainTaskDetector mtDetector = new MainTaskDetectorImpl(taskRepository);

    public static WTCDistributeTaskPreHandler getPreShardStorageHandler(WTCTaskRequest request) {
        WTCTaskObjectFactory wtcTaskObjectFactory = WTCTaskInstanceHelper.getObjectFactory(request);
        WTCTaskConverter converter = wtcTaskObjectFactory.getConverter();
        WTCTaskShardingService shardingService = wtcTaskObjectFactory.getShardingService();
        shardingService.setTaskRequest(request);
        WTCTaskRepository repository = wtcTaskObjectFactory.getRepository();
        WTCDistributeTaskPreHandler dispatcher = wtcTaskObjectFactory.getTaskPreHandler();
        dispatcher.setRequest(request);
        dispatcher.setTaskConverter(converter);
        dispatcher.setShardingService(shardingService);
        dispatcher.setRepository(repository);
        return dispatcher;
    }

    public static List<WTCTaskDispatchRequest> shardingSaveAndSlimReqStd(WTCTaskRequestStd request) {
        WTCDistributeTaskPreHandler preHandler = WTCDistributeTaskHelper.getPreShardStorageHandler(request);
        preHandler.prepareEvnForDispatch();
        List<WTCTaskDispatchRequest> subTaskDispatchRequestList = preHandler.getDispatchRequests();
        subTaskDispatchRequestList.forEach(stDReq -> stDReq.getShardingTask().setTaskShardingDetails(Collections.emptyList()));
        request.setDetail(Collections.emptyList());
        return subTaskDispatchRequestList;
    }

    /*
     * Loose catch block
     */
    public static long saveTask(Map<String, Object> params) {
        String taskReqStr = (String)params.get("WTCTaskRequestJsonStr");
        if (StringUtils.isBlank((CharSequence)taskReqStr)) {
            throw new WTCException(WTCStringUtils.format((String)"WTCMainTaskExecutor could not get taskReq[%s] in task params", (Object[])new Object[]{"WTCTaskRequestJsonStr"}));
        }
        MainTask mainTask = WTCInstrumentedDispatcher.genBaseMainTask(taskReqStr);
        long bizTaskId = mainTask.getBizTaskId();
        String category = mainTask.getCategory();
        DLock lock = null;
        boolean locked = false;
        try {
            lock = WTCTaskLockUtils.getMainTaskLock4SaveTask(bizTaskId, category);
            locked = lock.tryLock();
            if (!locked) {
                long l = 0L;
                return l;
            }
            if (mtDetector.existSameTask(bizTaskId, category)) {
                long l = 0L;
                return l;
            }
            Throwable throwable = null;
            try (TXHandle txHandle = TX.requiresNew();){
                taskRepository.saveMT(mainTask);
                long mtId = mainTask.getId();
                int stCount = WTCInstrumentedDispatcher.genAndSaveShardingTaskList(params, mtId);
                mainTask.setTotalShardingTask(stCount);
                taskRepository.updateMT(mainTask);
                long l = mtId;
                return l;
            }
            catch (Exception exp) {
                try {
                    txHandle.markRollback();
                    throw exp;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            {
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
        finally {
            if (lock != null) {
                if (locked) {
                    lock.unlock();
                }
                lock.close();
            }
        }
    }

    public static JobInfo getMainTaskExecutorJobInfo(WTCTaskRequest taskRequest, List<WTCTaskDispatchRequest> subTaskDispatchRequestList) {
        DbJobDao jobDao = new DbJobDao();
        JobInfo jobInfo = jobDao.get("2RJTZMQTSS1U");
        jobInfo.setNumber(WTCDistributeTaskHelper.genNumber(taskRequest));
        jobInfo.setName(WTCDistributeTaskHelper.genName(taskRequest));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setAppId(taskRequest.getAppId());
        jobInfo.setTaskClassname("kd.wtc.wtbs.business.task.executor.WTCInstrumentedDispatcher");
        jobInfo.setTimeout(taskRequest.getTimeoutInSecond());
        jobInfo.setRunConcurrently(true);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("WTCTaskRequestJsonStr", WTCSerializationUtils.serializeToBase64((Object)taskRequest));
        params.put("WTCTaskDispatchRequest", WTCSerializationUtils.serializeToBase64(subTaskDispatchRequestList));
        jobInfo.setParams(params);
        jobInfo.setSuccessNotify(false);
        jobInfo.setFailNotify(false);
        jobInfo.setOverTime(false);
        return jobInfo;
    }

    private static String genName(WTCTaskRequest taskRequest) {
        return WTCDistributeTaskHelper.genNumber(taskRequest);
    }

    private static String genNumber(WTCTaskRequest taskRequest) {
        return TaskCategoryEnum.of(taskRequest.getCategory()).getDescription() + "-" + taskRequest.getVersion();
    }

    public static String showProgress(IFormView view, CloseCallBack closeCallBack, String caption, String category, Object params) {
        WTCAssert.nonNull((Object)view, (String)"view could not be null");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wtbs_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        showParameter.setCaption(caption);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getCustomParams().put("params", WTCSerializationUtils.serializeToBase64((Object)params));
        showParameter.getCustomParams().put("category", category);
        view.showForm(showParameter);
        return showParameter.getPageId();
    }

    public static JobFormInfo genJobInfo(WTCTaskForm taskForm, IFormView view) {
        WTCValidatorHelper.verify((Object)taskForm);
        JobInfo jobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo(taskForm.getTaskRequest(), taskForm.getSubTaskDispatchRequestList());
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(taskForm.getCaption());
        jobFormInfo.setCloseCallBack(taskForm.getCloseCallBack());
        jobFormInfo.setCanBackground(taskForm.isCanBackground());
        jobFormInfo.setCanStop(taskForm.isCanStop());
        jobFormInfo.setClickClassName(taskForm.getClickClassName());
        jobFormInfo.setTimeout(taskForm.getBallTimeoutSecond());
        jobFormInfo.getParams().put("wtcTaskId", taskForm.getTaskRequest().getTaskId());
        jobFormInfo.getParams().put("category", taskForm.getTaskRequest().getCategory());
        String enableTask = System.getProperty("wtc.task.enable", "true");
        if ("true".equals(enableTask)) {
            jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
            jobFormInfo.setParentPageId(view.getPageId());
        }
        return jobFormInfo;
    }

    public static void setLoginIp(WTCTaskForm taskForm) {
        if (taskForm.getTaskRequest() == null) {
            return;
        }
        Map<String, Object> customParams = taskForm.getTaskRequest().getParams();
        if (!CollectionUtils.isEmpty(customParams)) {
            customParams.put("loginIP", RequestContext.get().getLoginIP());
        } else {
            customParams = new HashMap<String, Object>(2);
            customParams.put("loginIP", RequestContext.get().getLoginIP());
            taskForm.getTaskRequest().setParams(customParams);
        }
    }

    public static List<BootTaskRes> batchRunTaskBackground(IFormView view, String category, Collection<Object> params) {
        return params.stream().map(param -> WTCDistributeTaskHelper.runTaskBackground(view, category, param)).collect(Collectors.toList());
    }

    private static BootTaskRes runTaskBackground(IFormView view, String category, Object params) {
        BootTaskRes res = new BootTaskRes();
        TaskFormProcessorService processorService = TaskConfig.getProcessorService(category);
        processorService.beforeGenTaskForm(params);
        WTCTaskForm taskForm = processorService.genTaskForm(params);
        WTCDistributeTaskHelper.setLoginIp(taskForm);
        res.setRequestTaskId(taskForm.getTaskRequest().getTaskId());
        res.setWarnMsg(taskForm.getWarnMsg());
        if (!StringUtils.isBlank((CharSequence)taskForm.getErrMsg())) {
            res.markBizError(taskForm.getErrMsg());
            return res;
        }
        JobFormInfo jobFormInfo = WTCDistributeTaskHelper.genJobInfo(taskForm, view);
        long mtId = WTCDistributeTaskHelper.saveTask(jobFormInfo.getJobInfo().getParams());
        if (mtId == 0L) {
            String errMsg = processorService.onStartDistributeFailed(params, taskForm);
            if (errMsg != null) {
                res.markBizError(taskForm.getErrMsg());
            } else {
                res.markSysError(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\u3002", (String)"WTCDistributeTaskHelper_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            return res;
        }
        if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(view.getFormShowParameter().getServiceAppId());
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        processorService.afterGenTaskForm(taskForm);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskClientProxy.addTask((JobFormInfo)jobFormInfo, (TaskInfo)taskInfo, null);
            WTCBackgroundTaskSubscriber subscriber = new WTCBackgroundTaskSubscriber(mtId, RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
        return res;
    }

    public static BootTaskRes runTaskBackground(String category, Object params) {
        BootTaskRes res = new BootTaskRes();
        TaskFormProcessorService processorService = TaskConfig.getProcessorService(category);
        processorService.beforeGenTaskForm(params);
        WTCTaskForm taskForm = processorService.genTaskForm(params);
        WTCDistributeTaskHelper.setLoginIp(taskForm);
        res.setRequestTaskId(taskForm.getTaskRequest().getTaskId());
        res.setWarnMsg(taskForm.getWarnMsg());
        if (!StringUtils.isBlank((CharSequence)taskForm.getErrMsg())) {
            res.markBizError(taskForm.getErrMsg());
            return res;
        }
        JobInfo jobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo(taskForm.getTaskRequest(), taskForm.getSubTaskDispatchRequestList());
        long mtId = WTCDistributeTaskHelper.saveTask(jobInfo.getParams());
        if (mtId == 0L) {
            String errMsg = processorService.onStartDistributeFailed(params, taskForm);
            if (errMsg != null) {
                res.markBizError(taskForm.getErrMsg());
            } else {
                res.markSysError(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\u3002", (String)"WTCDistributeTaskHelper_0", (String)"wtc-wtbs-business", (Object[])new Object[0]));
            }
            return res;
        }
        ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
        processorService.afterGenTaskForm(taskForm);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminateTask(long bizTaskId, String category) {
        TaskRepositoryImpl taskRepository = TaskRepositoryImpl.getInstance();
        MainTask mainTask = taskRepository.loadMT(bizTaskId, category);
        DLock mtLock = null;
        try {
            mtLock = WTCTaskLockUtils.getMainTaskLock(mainTask.getId());
            mtLock.lock();
            mainTask = taskRepository.loadMT(bizTaskId, category);
            if (!mainTask.getTaskStatus().isEnd()) {
                WTCDistributeTaskHelper.advanceMTStatus(mainTask, WTCTaskStatus.TERMINATING, false);
                MainTaskLifeCycleCallBack mtLifeCycleCallBack = TaskConfig.getMainTaskLifeCycleCallBack(mainTask.getCategory());
                mtLifeCycleCallBack.onAcceptTerminating(bizTaskId, category);
            }
        }
        catch (Exception exp) {
            log.error("stop task error", (Throwable)exp);
        }
        finally {
            if (mtLock != null) {
                mtLock.unlock();
                mtLock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean terminateTask(long mtId) {
        TaskRepositoryImpl taskRepository = TaskRepositoryImpl.getInstance();
        MainTask mainTask = taskRepository.loadMT(mtId);
        DLock mtLock = null;
        try {
            mtLock = WTCTaskLockUtils.getMainTaskLock(mainTask.getId());
            mtLock.lock();
            mainTask = taskRepository.loadMT(mtId);
            if (!mainTask.getTaskStatus().isEnd()) {
                WTCDistributeTaskHelper.advanceMTStatus(mainTask, WTCTaskStatus.TERMINATING, false);
                MainTaskLifeCycleCallBack mtLifeCycleCallBack = TaskConfig.getMainTaskLifeCycleCallBack(mainTask.getCategory());
                mtLifeCycleCallBack.onAcceptTerminating(mainTask.getBizTaskId(), mainTask.getCategory());
                boolean bl = true;
                return bl;
            }
            boolean mtLifeCycleCallBack = false;
            return mtLifeCycleCallBack;
        }
        catch (Exception exp) {
            log.error("stop task error", (Throwable)exp);
            boolean bl = false;
            return bl;
        }
        finally {
            if (mtLock != null) {
                mtLock.unlock();
                mtLock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroyShardingTaskWithLock(long shardingTaskId) {
        DLock shardingTaskLock = null;
        TXHandle txHandle = null;
        try {
            block14: {
                shardingTaskLock = WTCTaskLockUtils.getShardingTaskLock(shardingTaskId);
                shardingTaskLock.lock();
                ShardingTaskRunLog stRunLog = taskRepository.loadEffectiveSTRL(shardingTaskId);
                if (stRunLog != null && WTCStringUtils.isNotEmpty((String)stRunLog.getExecutorId()) && !stDetector.isCrash(stRunLog)) {
                    boolean bl = false;
                    return bl;
                }
                txHandle = TX.required();
                ShardingTask newestST = taskRepository.loadST(shardingTaskId);
                if (stDetector.isEnd(newestST)) break block14;
                newestST.setSubTaskStatus(WTCSubTaskStatus.ERROR);
                newestST.setUpdateTime(LocalDateTime.now());
                if (stRunLog != null) {
                    WTCDistributeTaskHelper.recycleShardingTaskOwnership(stRunLog);
                }
                WTCDistributeTaskHelper.newAndSaveSTRL(shardingTaskId, newestST.getMainTaskId(), true);
                taskRepository.updateST(newestST);
                txHandle.commit();
                boolean bl = true;
                return bl;
            }
            try {
                txHandle.commit();
            }
            catch (Exception exp) {
                log.error("WTCMainTaskExecutor destroyShardingTaskWithLock error in transaction.", (Throwable)exp);
                txHandle.markRollback();
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            log.error("WTCMainTaskExecutor destroyShardingTaskWithLock error", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (txHandle != null) {
                txHandle.close();
            }
            if (shardingTaskLock != null) {
                shardingTaskLock.unlock();
                shardingTaskLock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean destroyShardingTaskUnLock(long shardingTaskId) {
        try (TXHandle txHandle = null;){
            block10: {
                txHandle = TX.required();
                ShardingTask newestST = taskRepository.loadST(shardingTaskId);
                if (stDetector.isEnd(newestST)) break block10;
                newestST.setSubTaskStatus(WTCSubTaskStatus.ERROR);
                newestST.setUpdateTime(LocalDateTime.now());
                WTCDistributeTaskHelper.newAndSaveSTRL(shardingTaskId, newestST.getMainTaskId(), true);
                taskRepository.updateST(newestST);
                txHandle.commit();
                boolean bl = true;
                return bl;
            }
            try {
                txHandle.commit();
            }
            catch (Exception exp) {
                log.error("WTCMainTaskExecutor destroyShardingTaskWithLock error in transaction.", (Throwable)exp);
                txHandle.markRollback();
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void measureProgressAndDoEndCallback(long mainTaskId) {
        DLock mtLock = null;
        try {
            mtLock = WTCTaskLockUtils.getMainTaskLock(mainTaskId);
            mtLock.lock();
            MainTask mainTask = taskRepository.loadMT(mainTaskId);
            if (mainTask.getTaskStatus().isEnd()) {
                return;
            }
            MainTaskLifeCycleCallBack mtLifeCycleCallBack = TaskConfig.getMainTaskLifeCycleCallBack(mainTask.getCategory());
            int allST = taskRepository.countST(mainTaskId);
            int notEndST = taskRepository.countNotEndST(mainTaskId);
            int progress = 100;
            if (allST != 0) {
                progress = (allST - notEndST) * 100 / allST;
            }
            MainTaskRunLog mtRL = taskRepository.loadEffectiveMTRL(mainTaskId);
            if (notEndST == 0) {
                mtLifeCycleCallBack.onMeasureOneTimeEnd(mainTask.getBizTaskId(), progress);
                WTCTaskRequestStd taskReq = (WTCTaskRequestStd)WTCSerializationUtils.deSerializeFromBase64((String)mainTask.getTaskReqStr());
                WTCTaskStatus tarStatus = WTCDistributeTaskHelper.judgeTaskEndStatus(mainTask);
                List<ShardingTaskRunLog> strlList = taskRepository.loadAllEffectiveSTRL(mainTaskId);
                MainTaskLifeCycleCallBack.reqParamsHolder.set(taskReq.getParams());
                Map<String, Object> returnData = mtLifeCycleCallBack.onMainTaskEnd0(mainTask.getBizTaskId(), mainTask.getCategory(), tarStatus, strlList);
                MainTaskLifeCycleCallBack.reqParamsHolder.remove();
                WTCTaskExtHelper.afterTaskEnd(mainTask.getBizTaskId(), mainTask.getCategory());
                if (returnData != null && mtRL != null) {
                    mtRL.setReportData(WTCSerializationUtils.serializeToBase64(returnData));
                }
                if (mtRL != null) {
                    mtRL.setUpdateTime(LocalDateTime.now());
                    mtRL.setProgress(progress);
                    taskRepository.updateMTRL(mtRL);
                }
                WTCDistributeTaskHelper.advanceMTStatus(mainTask, tarStatus, true);
                return;
            }
            if (mtRL != null) {
                mtRL.setUpdateTime(LocalDateTime.now());
                mtRL.setProgress(progress);
                taskRepository.updateMTRL(mtRL);
            }
            mtLifeCycleCallBack.onMeasureOneTimeEnd(mainTask.getBizTaskId(), progress);
        }
        catch (Exception exp) {
            log.warn("WTCDistributeTaskHelper:", (Throwable)exp);
        }
        finally {
            if (mtLock != null) {
                mtLock.unlock();
                mtLock.close();
            }
        }
    }

    public static void advanceMTStatus(long mainTaskId, WTCTaskStatus status, boolean isEnd) {
        MainTask mainTask = taskRepository.loadMT(mainTaskId);
        WTCDistributeTaskHelper.advanceMTStatus(mainTask, status, isEnd);
    }

    public static void advanceMTStatus(MainTask mainTask, WTCTaskStatus status, boolean isEnd) {
        LocalDateTime now = LocalDateTime.now();
        if (isEnd) {
            mainTask.setEndDate(now);
            mainTask.setTimeCost(WTCDistributeTaskHelper.getMillisBetween(mainTask.getStartDate(), now));
            int notEndSTCount = taskRepository.countNotEndST(mainTask.getId());
            mainTask.setFinishedShardingTask(mainTask.getTotalShardingTask() - notEndSTCount);
        }
        mainTask.setTaskStatus(status);
        mainTask.setUpdateTime(now);
        taskRepository.updateMT(mainTask);
    }

    private static WTCTaskStatus judgeTaskEndStatus(MainTask mainTask) {
        WTCTaskStatus curStatus;
        WTCTaskStatus tarStatus = curStatus = mainTask.getTaskStatus();
        if (!curStatus.isEnd() && !taskRepository.existNotEndST(mainTask.getId())) {
            if (curStatus == WTCTaskStatus.TERMINATING) {
                tarStatus = WTCTaskStatus.TERMINATED;
            } else {
                int stCount = taskRepository.countST(mainTask.getId());
                int errorSTCount = taskRepository.countErrorST(mainTask.getId());
                tarStatus = stCount == 0 ? WTCTaskStatus.ALL_FINISHED : (stCount == errorSTCount ? WTCTaskStatus.ALL_ERROR : (errorSTCount != 0 ? WTCTaskStatus.PARTIALLY_FINISHED : WTCTaskStatus.ALL_FINISHED));
            }
        }
        return tarStatus;
    }

    public static ShardingTaskRunLog newAndSaveSTRL(long shardingTaskId, long mainTaskId, boolean fillExecutorId) {
        ShardingTaskRunLog lastSTRL = taskRepository.loadLastFailSTRL(shardingTaskId);
        String preTimeReportData = null;
        if (lastSTRL != null) {
            preTimeReportData = lastSTRL.getReportData();
        }
        ShardingTaskRunLog stRunLog = ShardingTaskRunLog.newInstance(mainTaskId, shardingTaskId, preTimeReportData);
        if (fillExecutorId) {
            stRunLog.setProgress(100);
            stRunLog.setExecutorId(Instance.getInstanceId());
        }
        taskRepository.saveSTRL(stRunLog);
        return stRunLog;
    }

    public static void newAndSaveSTCrashLog(ShardingTaskRunLog stRunLog) {
        ShardingTaskExLog exLog = new ShardingTaskExLog();
        exLog.setShardingTaskId(stRunLog.getShardingTaskId());
        exLog.setStRunLogId(stRunLog.getId());
        exLog.setExStr("Detected WTCShardingTaskExecutor[" + stRunLog.getExecutorId() + "] carshed.");
        taskRepository.saveSTEL(exLog);
    }

    public static void recycleShardingTaskOwnership(ShardingTaskRunLog stRunLog) {
        LocalDateTime now = LocalDateTime.now();
        stRunLog.setCurrent(false);
        stRunLog.setEndTime(now);
        stRunLog.setUpdateTime(now);
        taskRepository.updateSTRL(stRunLog);
    }

    public static void advanceSTRL2End(ShardingTaskRunLog stRunLog) {
        LocalDateTime now = LocalDateTime.now();
        stRunLog.setProgress(100);
        stRunLog.setEndTime(now);
        stRunLog.setUpdateTime(now);
        stReporter.reportProgress(stRunLog);
    }

    public static void advanceST2End(ShardingTask shardingTask, WTCSubTaskStatus shardingTaskStatus) {
        LocalDateTime now = LocalDateTime.now();
        shardingTask.setEndDate(now);
        shardingTask.setSubTaskStatus(shardingTaskStatus);
        shardingTask.setUpdateTime(now);
        taskRepository.updateST(shardingTask);
    }

    public static ShardingTaskExLog genSTExLog(long shardingTaskId, ShardingTaskRunLog stRunLog, String preDesc, Throwable throwable, boolean exclusiveLog) {
        ShardingTaskExLog exLog = new ShardingTaskExLog();
        exLog.setShardingTaskId(shardingTaskId);
        if (exclusiveLog) {
            exLog.setStRunLogId(stRunLog == null ? 0L : stRunLog.getId());
        }
        String builder = preDesc + '\n' + WTCDistributeTaskHelper.getStackTraceMessage(throwable);
        exLog.setExStr(builder);
        return exLog;
    }

    public static String getStackTraceMessage(Throwable throwable) {
        return ErrorMsgUtils.getStackTraceMessage(throwable, MAX_ERROR_MSG_LINE);
    }

    private static long getMillisBetween(LocalDateTime begin, LocalDateTime end) {
        long beginTime = WTCDateUtils.toDate((LocalDateTime)begin).getTime();
        long endTime = WTCDateUtils.toDate((LocalDateTime)end).getTime();
        return endTime - beginTime;
    }

    public static boolean isTerminated(long mtId) {
        return mtDetector.isTerminated(mtId);
    }
}

