/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.base.biz;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskLifeCycleCallBack;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class QTTieTaskStatusCallBack
implements MainTaskLifeCycleCallBack {
    public static final String CLEAR_DIRTY_RECORD = "CLEAR_DIRTY_RECORD";
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_RUNNING = Sets.newHashSet((Object[])new WTCTaskStatus[]{WTCTaskStatus.NEW, WTCTaskStatus.RUNNING});
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_FINISHED = Sets.newHashSet((Object[])new WTCTaskStatus[]{WTCTaskStatus.PARTIALLY_FINISHED, WTCTaskStatus.ALL_FINISHED, WTCTaskStatus.ALL_ERROR});
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_TERMINATING = Collections.singleton(WTCTaskStatus.TERMINATING);
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_TERMINATED = Sets.newHashSet((Object[])new WTCTaskStatus[]{WTCTaskStatus.TERMINATED});
    public static final HRBaseServiceHelper dirtyRecord = new HRBaseServiceHelper("wtp_needrecalqtld");

    @Override
    public void onMainTaskBootSuccess(MainTask mainTask) {
        WTCTaskStateTransfer.transferToSpecialState((Long)mainTask.getBizTaskId(), WTCTaskStatus.RUNNING, mainTask.getCategory());
        this.statusChangeCallBack(mainTask.getBizTaskId(), WTCTaskStatus.RUNNING, mainTask.getCategory());
    }

    @Override
    public Map<String, Object> onMainTaskEnd(Long bizTaskId, String category, WTCTaskStatus wtcTaskStatus, List<String> shardingCustomDataList) {
        WTCTaskStateTransfer.transferToSpecialState(bizTaskId, wtcTaskStatus, category);
        this.statusChangeCallBack(bizTaskId, wtcTaskStatus, category);
        Map paramMap = (Map)reqParamsHolder.get();
        if (paramMap.containsKey(CLEAR_DIRTY_RECORD)) {
            DynamicObject[] arr;
            QFilter qFilter = new QFilter("taskid", "=", (Object)bizTaskId);
            for (DynamicObject dyn : arr = dirtyRecord.loadDynamicObjectArray(qFilter.toArray())) {
                dyn.set("deleted", (Object)Boolean.TRUE);
            }
            dirtyRecord.update(arr);
        }
        return null;
    }

    private void statusChangeCallBack(Long taskId, WTCTaskStatus wtcTaskStatus, String category) {
        Map<String, Object> params = this.takeReqParams();
        HRBaseServiceHelper calResultDao = QTAccountModeHelper.getDaoByAccountMode((String)params.get("accountmode"));
        this.statusChangeCallBack(calResultDao, taskId, wtcTaskStatus, category);
    }

    public void statusChangeCallBack(HRBaseServiceHelper calResultDao, Long taskId, WTCTaskStatus wtcTaskStatus, String category) {
        DynamicObject calBusinessDyn = calResultDao.loadDynamicObject(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        this.setCalTaskStatus(taskId, calBusinessDyn, category);
        this.setTieTaskStatus(wtcTaskStatus, calBusinessDyn);
        calResultDao.updateOne(calBusinessDyn);
    }

    private void setTieTaskStatus(WTCTaskStatus wtcTaskStatus, DynamicObject calBusinessDyn) {
        String statusCode = null;
        if (TIE_TASK_STATUS_RUNNING.contains((Object)wtcTaskStatus)) {
            statusCode = "RUNNING";
        } else if (TIE_TASK_STATUS_FINISHED.contains((Object)wtcTaskStatus)) {
            statusCode = "FINISHED";
        } else if (TIE_TASK_STATUS_TERMINATING.contains((Object)wtcTaskStatus)) {
            statusCode = "TERMINATING";
        } else if (TIE_TASK_STATUS_TERMINATED.contains((Object)wtcTaskStatus)) {
            statusCode = "TERMINATED";
        }
        calBusinessDyn.set("tietaskstatus", (Object)statusCode);
    }

    private void setCalTaskStatus(Long taskId, DynamicObject calBusinessDyn, String category) {
        WTCTaskBusinessStatusEnum wtcTaskBusinessStatusEnum = WTCTaskServiceHelper.getWTCTaskBusinessStatusEnumByTaskId(category, taskId);
        calBusinessDyn.set("calstatus", (Object)wtcTaskBusinessStatusEnum.getSign());
    }

    @Override
    public void onShardingTaskReportEx(long bizTaskId, long bizSubTaskId, String cause) {
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.QT_TIE.getCode(), Collections.singletonList(bizSubTaskId));
    }

    @Override
    public void onShardingTaskCrash(long bizTaskId, long bizSubTaskId) {
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.QT_TIE.getCode(), Collections.singletonList(bizSubTaskId));
    }

    @Override
    public void onShardingTaskBeJudgedError(long bizTaskId, long bizSubTaskId) {
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.QT_TIE.getCode(), Collections.singletonList(bizSubTaskId));
    }
}

