/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.base.biz;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskLifeCycleCallBack;
import kd.wtc.wtbs.business.task.base.TaskMonitorConfig;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskBusinessStatusEnum;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class TieTaskStatusCallBack
implements MainTaskLifeCycleCallBack {
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_RUNNING = Sets.newHashSet((Object[])new WTCTaskStatus[]{WTCTaskStatus.NEW, WTCTaskStatus.RUNNING});
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_FINISHED = Sets.newHashSet((Object[])new WTCTaskStatus[]{WTCTaskStatus.PARTIALLY_FINISHED, WTCTaskStatus.ALL_FINISHED, WTCTaskStatus.ALL_ERROR});
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_TERMINATING = Collections.singleton(WTCTaskStatus.TERMINATING);
    private static Set<WTCTaskStatus> TIE_TASK_STATUS_TERMINATED = Sets.newHashSet((Object[])new WTCTaskStatus[]{WTCTaskStatus.TERMINATED});

    @Override
    public TaskMonitorConfig beforeMainTaskBoot() {
        return this.getTaskMonitorConfig();
    }

    @Override
    public TaskMonitorConfig getTaskMonitorConfig() {
        return new TaskMonitorConfig(){

            @Override
            public boolean alwaysRetryWhenSTECrashed() {
                return false;
            }

            @Override
            public int maxRetryTimes() {
                return 4;
            }
        };
    }

    @Override
    public void onMainTaskBootSuccess(MainTask mainTask, boolean restart) {
        WTCCalTaskEntity task;
        WTCCalTaskRepository repository;
        List<WTCSubTaskEntity> subTaskList;
        WTCTaskStateTransfer.transferToSpecialState((Long)mainTask.getBizTaskId(), WTCTaskStatus.RUNNING, mainTask.getCategory());
        this.statusChangeCallBack(mainTask.getBizTaskId(), WTCTaskStatus.RUNNING, mainTask.getCategory());
        if (restart && !(subTaskList = (repository = (WTCCalTaskRepository)WTCTaskInstanceHelper.getRepository("wtte_tie")).batchLoadSubTaskByTaskId((task = (WTCCalTaskEntity)repository.loadTaskByTaskId(mainTask.getBizTaskId(), null)).getTaskId(), null)).isEmpty()) {
            WTCTaskStateTransfer.statisticsTask(subTaskList, task, true);
            repository.updateTask(task);
        }
    }

    @Override
    public Map<String, Object> onMainTaskEnd(Long bizTaskId, String category, WTCTaskStatus wtcTaskStatus, List<String> shardingCustomDataList) {
        WTCTaskStateTransfer.transferToSpecialState(bizTaskId, wtcTaskStatus, category);
        this.statusChangeCallBack(bizTaskId, wtcTaskStatus, category);
        return null;
    }

    private void statusChangeCallBack(Long taskId, WTCTaskStatus wtcTaskStatus, String category) {
        HRBaseServiceHelper calResultDao = new HRBaseServiceHelper("wtte_calresult");
        DynamicObject calBusinessDyn = calResultDao.loadDynamicObject(new QFilter[]{new QFilter("taskid", "=", (Object)taskId)});
        this.setCalTaskStatus(taskId, calBusinessDyn, category);
        this.setTieTaskStatus(wtcTaskStatus, calBusinessDyn);
        calResultDao.updateOne(calBusinessDyn);
    }

    private void setTieTaskStatus(WTCTaskStatus wtcTaskStatus, DynamicObject calBusinessDyn) {
        String statusCode = null;
        if (TIE_TASK_STATUS_RUNNING.contains((Object)wtcTaskStatus)) {
            statusCode = "RUNNING";
        } else if (TIE_TASK_STATUS_FINISHED.contains((Object)wtcTaskStatus)) {
            statusCode = "FINISHED";
        } else if (TIE_TASK_STATUS_TERMINATING.contains((Object)wtcTaskStatus)) {
            statusCode = "TERMINATING";
        } else if (TIE_TASK_STATUS_TERMINATED.contains((Object)wtcTaskStatus)) {
            statusCode = "TERMINATED";
        }
        calBusinessDyn.set("tietaskstatus", (Object)statusCode);
    }

    private void setCalTaskStatus(Long taskId, DynamicObject calBusinessDyn, String category) {
        WTCTaskBusinessStatusEnum wtcTaskBusinessStatusEnum = WTCTaskServiceHelper.getWTCTaskBusinessStatusEnumByTaskId(category, taskId);
        calBusinessDyn.set("calstatus", (Object)wtcTaskBusinessStatusEnum.getSign());
    }

    @Override
    public void onMeasureOneTimeEnd(long bizTaskId, int curProgress) {
        WTCCalTaskRepository repository = (WTCCalTaskRepository)WTCTaskInstanceHelper.getRepository("wtte_tie");
        WTCCalTaskEntity task = (WTCCalTaskEntity)repository.loadTaskByTaskId(bizTaskId, null);
        List<WTCSubTaskEntity> subTaskList = repository.batchLoadSubTaskByTaskId(bizTaskId, null);
        WTCTaskStateTransfer.statisticsTask(subTaskList, task, false);
        repository.updateTask(task);
    }

    @Override
    public void onShardingTaskReportEx(long bizTaskId, long bizSubTaskId, String cause) {
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.WTTE_TIE.getCode(), Collections.singletonList(bizSubTaskId));
    }

    @Override
    public void onShardingTaskCrash(long bizTaskId, long bizSubTaskId) {
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.WTTE_TIE.getCode(), Collections.singletonList(bizSubTaskId));
        WTCTaskStateTransfer.transferToSpecialStateSub((Long)bizSubTaskId, (Long)bizTaskId, WTCSubTaskStatus.NEW, TaskCategoryEnum.WTTE_TIE.getCode());
    }

    @Override
    public void onShardingTaskBeJudgedError(long bizTaskId, long bizSubTaskId) {
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.WTTE_TIE.getCode(), Collections.singletonList(bizSubTaskId));
    }
}

