/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.common;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;

public class WTCTaskStateTransfer {
    private static final Log logger = LogFactory.getLog(WTCTaskStateTransfer.class);

    public static boolean transferToSpecialState(Long taskId, WTCTaskStatus wtcTaskStatus, String taskCategory) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(taskCategory);
        WTCTaskRequest request = new WTCTaskRequest();
        request.setCategory(taskCategory);
        return WTCTaskStateTransfer.changeState(taskId, wtcTaskStatus, repository, request);
    }

    private static boolean changeState(Long taskId, WTCTaskStatus wtcTaskStatus, WTCTaskRepository repository, WTCTaskRequest taskRequest) {
        WTCTaskEntity wtcTaskEntity = repository.loadTaskByTaskId(taskId, null);
        wtcTaskEntity.setTaskStatus(wtcTaskStatus);
        WTCTaskStateTransfer.beforeStateChange(taskId, wtcTaskStatus, wtcTaskEntity, repository);
        String lockKey = "wtc_changeState" + taskId;
        boolean lockSuccess = false;
        try (DLock lock = DLock.create((String)lockKey, (String)"wtc_changeState");){
            int lockTimes = 3000;
            for (int i = 0; i < 3; ++i) {
                if (!lock.tryLock((long)lockTimes)) continue;
                repository.updateTask(wtcTaskEntity);
                lockSuccess = true;
                break;
            }
        }
        catch (Exception ex) {
            logger.error("updateTask failed", (Throwable)ex);
            return false;
        }
        if (lockSuccess) {
            return true;
        }
        logger.error("DLock tryLock failed");
        return false;
    }

    private static void beforeStateChange(Long taskId, WTCTaskStatus wtcTaskStatus, WTCTaskEntity wtcTaskEntity, WTCTaskRepository repository) {
        Date now = new Date();
        wtcTaskEntity.setRefreshTime(now);
        if (wtcTaskStatus.isEnd()) {
            wtcTaskEntity.setEndDate(now);
            wtcTaskEntity.setTimeCost(now.getTime() - wtcTaskEntity.getStartDate().getTime());
        }
        WTCTaskStateTransfer.statisticsTask(wtcTaskEntity, repository);
    }

    private static void statisticsTask(WTCTaskEntity task, WTCTaskRepository repository) {
        List<WTCSubTaskEntity> subTaskList = repository.batchLoadSubTaskByTaskId(task.getTaskId(), null);
        if (!(task instanceof WTCCalTaskEntity)) {
            return;
        }
        WTCCalTaskEntity calTask = (WTCCalTaskEntity)task;
        WTCTaskStateTransfer.statisticsTask(subTaskList, calTask, false);
    }

    public static void statisticsTask(List<WTCSubTaskEntity> subTaskList, WTCCalTaskEntity calTask, boolean inc) {
        int totalAttFile = 0;
        int totalAttPerson = 0;
        int runAttFile = 0;
        int succeedAttFile = 0;
        int failedAttFile = 0;
        int notRunAttFile = 0;
        int runAttPerson = 0;
        int succeedAttPerson = 0;
        int failedAttPerson = 0;
        int notRunAttPerson = 0;
        int finishShading = 0;
        totalAttFile = calTask.getTotalAttFile();
        totalAttPerson = calTask.getTotalAttPerson();
        if (inc) {
            runAttFile = calTask.getRunAttFile();
            succeedAttFile = calTask.getSucceedAttFile();
            failedAttFile = calTask.getFailedAttFile();
            notRunAttFile = calTask.getNotRunAttFile();
            runAttPerson = calTask.getRunAttPerson();
            succeedAttPerson = calTask.getSucceedAttPerson();
            failedAttPerson = calTask.getFailedAttPerson();
            notRunAttPerson = calTask.getNotRunAttPerson();
            finishShading = calTask.getFinishedSubTask();
        }
        for (WTCSubTaskEntity wtcSubTaskEntity : subTaskList) {
            WTCCalSubTaskEntity subTask = (WTCCalSubTaskEntity)wtcSubTaskEntity;
            runAttFile += subTask.getRunAttFile();
            succeedAttFile += subTask.getSucceedAttFile();
            failedAttFile += subTask.getFailedAttFile();
            notRunAttFile += subTask.getNotRunAttFile();
            runAttPerson += subTask.getRunAttPerson();
            succeedAttPerson += subTask.getSucceedAttPerson();
            failedAttPerson += subTask.getFailedAttPerson();
            notRunAttPerson += subTask.getNotRunAttPerson();
            finishShading = subTask.getSubTaskStatus().isEnd() ? finishShading + 1 : finishShading;
        }
        calTask.setTotalAttFile(totalAttFile);
        calTask.setRunAttFile(runAttFile);
        calTask.setSucceedAttFile(succeedAttFile);
        calTask.setFailedAttFile(failedAttFile);
        calTask.setNotRunAttFile(notRunAttFile);
        calTask.setTotalAttPerson(totalAttPerson);
        calTask.setRunAttPerson(runAttPerson);
        calTask.setSucceedAttPerson(succeedAttPerson);
        calTask.setFailedAttPerson(failedAttPerson);
        calTask.setNotRunAttPerson(notRunAttPerson);
        calTask.setFinishedSubTask(finishShading);
    }

    public static boolean transferToSpecialStateSub(Long subTaskId, Long taskId, WTCSubTaskStatus wtcSubTaskStatus, String taskCategory) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(taskCategory);
        return WTCTaskStateTransfer.changeStateSub(subTaskId, taskId, wtcSubTaskStatus, repository, taskCategory);
    }

    public static boolean transferToSpecialStateSub(Long subTaskId, Long taskId, WTCSubTaskEntity wtcSubTaskEntity, String taskCategory) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(taskCategory);
        return WTCTaskStateTransfer.doChangeStateSub(subTaskId, taskId, repository, taskCategory, wtcSubTaskEntity);
    }

    private static boolean changeStateSub(Long subTaskId, Long taskId, WTCSubTaskStatus wtcSubTaskStatus, WTCTaskRepository repository, String taskCategory) {
        WTCSubTaskEntity wtcSubTaskEntity = repository.loadSubTaskByTaskId(subTaskId);
        wtcSubTaskEntity.setSubTaskStatus(wtcSubTaskStatus);
        return WTCTaskStateTransfer.doChangeStateSub(subTaskId, taskId, repository, taskCategory, wtcSubTaskEntity);
    }

    private static boolean doChangeStateSub(Long subTaskId, Long taskId, WTCTaskRepository repository, String taskCategory, WTCSubTaskEntity wtcSubTaskEntity) {
        DynamicObject subTaskDyn = repository.loadSubTaskDynByTaskId(subTaskId);
        WTCSubTaskStatus wtcSubTaskStatus = wtcSubTaskEntity.getSubTaskStatus();
        WTCSubTaskStatus preSubTaskStatus = WTCSubTaskStatus.from(subTaskDyn.getString("subtaskstatus"));
        if (preSubTaskStatus == wtcSubTaskStatus) {
            return true;
        }
        wtcSubTaskEntity.setSubTaskStatus(wtcSubTaskStatus);
        WTCTaskStateTransfer.beforeStateChangedSub(subTaskId, taskId, wtcSubTaskStatus, taskCategory, wtcSubTaskEntity);
        repository.getWTCTaskConverter().transferSubTaskInfoAttribute(wtcSubTaskEntity, subTaskDyn);
        repository.updateSubTaskDyn(subTaskDyn);
        WTCTaskStateTransfer.afterStateChangedSub(subTaskId, taskId, wtcSubTaskStatus, taskCategory);
        return true;
    }

    private static void beforeStateChangedSub(Long subTaskId, Long taskId, WTCSubTaskStatus wtcSubTaskStatus, String taskCategory, WTCSubTaskEntity wtcSubTaskEntity) {
        Date now = new Date();
        wtcSubTaskEntity.setRefreshTime(now);
        if (wtcSubTaskStatus == WTCSubTaskStatus.RUNNING) {
            wtcSubTaskEntity.setStartDate(now);
        } else if (wtcSubTaskStatus == WTCSubTaskStatus.FINISHED || wtcSubTaskStatus == WTCSubTaskStatus.ERROR || wtcSubTaskStatus == WTCSubTaskStatus.TERMINATED || wtcSubTaskStatus == WTCSubTaskStatus.DISPATCH_FAILED) {
            wtcSubTaskEntity.setEndDate(now);
        }
    }

    private static void afterStateChangedSub(Long subTaskId, Long taskId, WTCSubTaskStatus wtcSubTaskStatus, String taskCategory) {
    }

    @Deprecated
    public static boolean transferToSpecialState(Long taskId, WTCTaskStatus wtcTaskStatus, WTCTaskRequest request) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(request.getCategory());
        return WTCTaskStateTransfer.changeState(taskId, wtcTaskStatus, repository, request);
    }

    @Deprecated
    public static boolean transferToSpecialStateSub(Long subTaskId, WTCSubTaskStatus wtcSubTaskStatus, WTCTaskRequest request) {
        WTCTaskRepository repository = WTCTaskInstanceHelper.getRepository(request.getCategory());
        return WTCTaskStateTransfer.changeStateSub(subTaskId, request.getTaskId(), wtcSubTaskStatus, repository, request.getCategory());
    }
}

