/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.common;

import kd.wtc.wtbs.common.MultiLangEnumBridge;

public enum WTCTaskStatus {
    NEW("NEW", new MultiLangEnumBridge("\u65b0\u5efa", "WTCTaskStatus_0", "wtc-wtbs-business")),
    RUNNING("RUNNING", new MultiLangEnumBridge("\u8fd0\u884c\u4e2d", "WTCTaskStatus_3", "wtc-wtbs-business")),
    ALL_FINISHED("ALL_FINISHED", new MultiLangEnumBridge("\u5df2\u5b8c\u6210", "WTCTaskStatus_4", "wtc-wtbs-business")),
    PARTIALLY_FINISHED("PARTIALLY_FINISHED", new MultiLangEnumBridge("\u90e8\u5206\u5b8c\u6210", "WTCTaskStatus_5", "wtc-wtbs-business")),
    ALL_ERROR("ALL_ERROR", new MultiLangEnumBridge("\u5168\u90e8\u51fa\u9519", "WTCTaskStatus_6", "wtc-wtbs-business")),
    TERMINATING("TERMINATING", new MultiLangEnumBridge("\u7ec8\u6b62\u4e2d", "WTCTaskStatus_7", "wtc-wtbs-business")),
    TERMINATED("TERMINATED", new MultiLangEnumBridge("\u5df2\u7ec8\u6b62", "WTCTaskStatus_8", "wtc-wtbs-business"));

    public final String code;
    public final MultiLangEnumBridge desc;

    private WTCTaskStatus(String code, MultiLangEnumBridge desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc.loadKDString();
    }

    public static WTCTaskStatus from(String code) {
        WTCTaskStatus[] statusEnumArr;
        for (WTCTaskStatus statusEnum : statusEnumArr = WTCTaskStatus.values()) {
            if (!statusEnum.code.equals(code)) continue;
            return statusEnum;
        }
        throw new IllegalArgumentException("Argument:code can not be " + code);
    }

    public boolean isRunnable() {
        return this == NEW;
    }

    public boolean isEnd() {
        return this == ALL_FINISHED || this == PARTIALLY_FINISHED || this == ALL_ERROR || this == TERMINATED;
    }

    public boolean isTerminate() {
        return this == TERMINATING || this == TERMINATED;
    }
}

