/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.concurrencyctrl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.trace.TaskTraceConfig;
import kd.wtc.wtbs.business.task.trace.TaskTraceConfigUtils;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.DistributeLockUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class TaskConcurrencyCtrlHelper {
    private static final TaskConcurrencyCtrlHelper INSTANCE = (TaskConcurrencyCtrlHelper)WTCAppContextHelper.getBean(TaskConcurrencyCtrlHelper.class);
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_concurrencyctrl");
    private static final boolean IS_CONCURRENCY_CTRL_ENABLE = true;
    private static final int TIME_OUT = 5;
    private static final int RETRY_TIMES = 3;
    private static final String LOCK_KEY_PREFIX = RequestContext.get().getAccountId() + '_' + "TaskConcurrencyCtrl";

    public static TaskConcurrencyCtrlHelper getInstance() {
        return INSTANCE;
    }

    public Set<Long> getRunningKeyList(String taskType, List<Long> keyList, Long taskId, Long subTaskId) {
        HashSet excludeBoIdList;
        block19: {
            TaskTraceConfig taskTraceConfig = TaskTraceConfigUtils.getTaskTraceConfig(taskType);
            boolean enableTaskConcurrencyCtrl = taskTraceConfig.isEnableTaskConcurrencyCtrl();
            if (!enableTaskConcurrencyCtrl) {
                return Collections.emptySet();
            }
            excludeBoIdList = Sets.newHashSetWithExpectedSize((int)16);
            HashSet<Long> enableBoIdList = Sets.newHashSetWithExpectedSize((int)16);
            String lockKey = LOCK_KEY_PREFIX + '_' + taskType;
            int retryTimes = taskTraceConfig.getSpanThresholdConfig().getOrDefault("retrytimes", 3);
            long timeOut = taskTraceConfig.getSpanThresholdConfig().getOrDefault("timeout", 5).intValue();
            try (DLock lock = DistributeLockUtils.getLock((String)lockKey, (String)"TaskConcurrencyCtrl");){
                boolean locked = DistributeLockUtils.tryLock((DLock)lock, (int)retryTimes, (long)(timeOut * 1000L));
                if (locked) {
                    Set<Long> existKeySet = this.getExistKeySet(taskType, keyList);
                    if (existKeySet.isEmpty()) {
                        enableBoIdList = new HashSet<Long>(keyList);
                    } else {
                        for (Long key : keyList) {
                            if (existKeySet.contains(key)) {
                                excludeBoIdList.add(key);
                                continue;
                            }
                            enableBoIdList.add(key);
                        }
                    }
                    if (!enableBoIdList.isEmpty()) {
                        this.inertKeys(enableBoIdList, taskId, subTaskId, taskType);
                    }
                    break block19;
                }
                throw new KDBizException("TaskConcurrencyCtrl tryLock failed");
            }
        }
        return excludeBoIdList;
    }

    private Set<Long> getExistKeySet(String taskType, List<Long> keyList) {
        DynamicObject[] dynamicObjects = this.queryByKeys(taskType, keyList);
        return Arrays.stream(dynamicObjects).map(e -> e.getLong("key")).collect(Collectors.toSet());
    }

    public DynamicObject[] queryByKeys(String taskType, List<Long> keyList) {
        QFilter[] qFilters = new QFilter[]{new QFilter("tasktype", "=", (Object)taskType), new QFilter("key", "in", keyList)};
        return serviceHelper.query("key", qFilters);
    }

    public void deleteByTaskIds(String taskType, List<Long> taskIdList) {
        QFilter[] qFilters = new QFilter[]{new QFilter("tasktype", "=", (Object)taskType), new QFilter("taskid", "in", taskIdList)};
        serviceHelper.deleteByFilter(qFilters);
    }

    public void deleteBySubTaskIds(String taskType, List<Long> subTaskIdList) {
        QFilter[] qFilters = new QFilter[]{new QFilter("tasktype", "=", (Object)taskType), new QFilter("subtaskid", "in", subTaskIdList)};
        serviceHelper.deleteByFilter(qFilters);
    }

    public void inertKeys(Set<Long> keySet, Long taskId, Long subTaskId, String taskType) {
        DynamicObject[] dynamicObjects = new DynamicObject[keySet.size()];
        int index = 0;
        for (Long key : keySet) {
            dynamicObjects[index] = this.generateDy(key, taskId, subTaskId, taskType);
            ++index;
        }
        serviceHelper.save(dynamicObjects);
    }

    private DynamicObject generateDy(Long key, Long taskId, Long subTaskId, String taskType) {
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("key", (Object)key);
        dynamicObject.set("taskid", (Object)taskId);
        dynamicObject.set("subtaskid", (Object)subTaskId);
        dynamicObject.set("tasktype", (Object)taskType);
        dynamicObject.set("createtime", (Object)new Date());
        return dynamicObject;
    }

    public void clearResentKeys(int minutes) {
        QFilter[] qFilters = new QFilter[]{new QFilter("createtime", "<=", (Object)WTCDateUtils.add((Date)new Date(), (int)12, (int)(-minutes)))};
        serviceHelper.deleteByFilter(qFilters);
    }
}

