/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.converter;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.converter.WTCTaskConverter;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;

public abstract class AbstractWTCTaskConverter
implements WTCTaskConverter {
    @Override
    public abstract WTCTaskEntity generateTask();

    public abstract void afterTransferTaskAttribute(WTCTaskEntity var1, DynamicObject var2);

    public abstract void afterConvert2TaskDyn(WTCTaskEntity var1, DynamicObject var2);

    public abstract void afterConvert2Task(DynamicObject var1, WTCTaskEntity var2);

    public abstract void afterConvert2Task(WTCTaskRequest var1, WTCTaskEntity var2);

    @Override
    public abstract WTCSubTaskEntity generateSubTask();

    public abstract void afterTransferSubTaskAttribute(WTCSubTaskEntity var1, DynamicObject var2);

    public abstract void afterTransferSubTaskCoreAttribute(WTCSubTaskEntity var1, DynamicObject var2);

    public abstract void afterTransferSubTaskInfoAttribute(WTCSubTaskEntity var1, DynamicObject var2);

    public abstract void afterConvert2SubTaskDyn(WTCSubTaskEntity var1, DynamicObject var2);

    public abstract void afterConvert2SubTask(DynamicObject var1, WTCSubTaskEntity var2);

    public abstract void afterConvert2SubTask(WTCShardingTask var1, WTCSubTaskEntity var2);

    @Override
    public void transferTaskAttribute(WTCTaskEntity task, DynamicObject taskDyn, boolean transferID) {
        this.setTaskDynAttribute(task, taskDyn, transferID);
        this.afterTransferTaskAttribute(task, taskDyn);
    }

    @Override
    public DynamicObject convert2TaskDyn(WTCTaskEntity task, String taskEntityNumber) {
        DynamicObject dyn = this.getDynByEntityNumber(taskEntityNumber);
        this.transferTaskAttribute(task, dyn, true);
        this.afterConvert2TaskDyn(task, dyn);
        return dyn;
    }

    @Override
    public WTCTaskEntity convert2Task(DynamicObject taskDyn) {
        WTCTaskEntity task = this.generateTask();
        this.setTaskAttribute(taskDyn, task);
        this.afterConvert2Task(taskDyn, task);
        return task;
    }

    @Override
    public WTCTaskEntity convert2Task(WTCTaskRequest request) {
        WTCTaskEntity task = this.generateTask();
        task.setId(request.getTaskId());
        Object number = request.getParam("number");
        if (number == null) {
            number = String.valueOf(request.getTaskId());
        }
        task.setNumber(number.toString());
        Object name = request.getParam("name");
        if (name == null) {
            name = request.getCategory();
        }
        task.setName(name.toString());
        task.setTaskId(request.getTaskId());
        task.setVersion(request.getVersion());
        task.setSource(WTCSource.from(request.getSource()));
        task.setCategory(request.getCategory());
        task.setHasSubTask(false);
        Date now = new Date();
        task.setStartDate(now);
        task.setEndDate(null);
        task.setTaskStatus(WTCTaskStatus.NEW);
        task.setTimeCost(0L);
        task.setTaskDesc(request.getDesc());
        task.setTotalSubTask(0);
        task.setFinishedSubTask(0);
        task.setRefreshTime(now);
        task.setProgress(BigDecimal.ZERO);
        task.setCreatorId(request.getCreatorId());
        task.setCreateTime(now);
        this.afterConvert2Task(request, task);
        return task;
    }

    @Override
    public void transferSubTaskAttribute(WTCSubTaskEntity subTask, DynamicObject subTaskDyn, boolean transferID) {
        this.transferSubTaskCoreAttribute(subTask, subTaskDyn, transferID);
        this.transferSubTaskInfoAttribute(subTask, subTaskDyn);
        this.afterTransferSubTaskAttribute(subTask, subTaskDyn);
    }

    @Override
    public void transferSubTaskCoreAttribute(WTCSubTaskEntity subTask, DynamicObject subTaskDyn, boolean transferID) {
        this.setSubTaskDynCoreAttribute(subTask, subTaskDyn, transferID);
        this.afterTransferSubTaskCoreAttribute(subTask, subTaskDyn);
    }

    @Override
    public void transferSubTaskInfoAttribute(WTCSubTaskEntity subTask, DynamicObject subTaskDyn) {
        this.setSubTaskDynInfoAttribute(subTask, subTaskDyn);
        this.afterTransferSubTaskInfoAttribute(subTask, subTaskDyn);
    }

    @Override
    public DynamicObject convert2SubTaskDyn(WTCSubTaskEntity subTask, String subTaskEntityNumber) {
        DynamicObject dyn = this.getDynByEntityNumber(subTaskEntityNumber);
        this.transferSubTaskAttribute(subTask, dyn, true);
        this.afterConvert2SubTaskDyn(subTask, dyn);
        return dyn;
    }

    @Override
    public WTCSubTaskEntity convert2SubTask(DynamicObject subTaskDyn) {
        WTCSubTaskEntity subTask = this.generateSubTask();
        this.setSubTaskAttribute(subTaskDyn, subTask);
        this.afterConvert2SubTask(subTaskDyn, subTask);
        return subTask;
    }

    @Override
    public WTCSubTaskEntity convert2SubTask(WTCShardingTask shardingTask) {
        WTCSubTaskEntity subTask = this.generateSubTask();
        Date now = new Date();
        subTask.setId(shardingTask.getSubTaskId());
        subTask.setTaskId(shardingTask.getTaskId());
        subTask.setStartDate(now);
        subTask.setEndDate(null);
        subTask.setSubTaskStatus(WTCSubTaskStatus.NEW);
        subTask.setRefreshTime(now);
        subTask.setIndex(shardingTask.getIndex());
        this.afterConvert2SubTask(shardingTask, subTask);
        return subTask;
    }

    @Override
    public WTCTaskDispatchRequest convert2WTCTaskDispatchRequest(WTCShardingTask sharding, WTCTaskRequest request) {
        WTCTaskDispatchRequest dispatchRequest = new WTCTaskDispatchRequest();
        dispatchRequest.setShardingTask(sharding);
        dispatchRequest.setTaskRequest(request);
        return dispatchRequest;
    }
}

