/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.converter;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.converter.WTCTaskGenerator;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;

public interface WTCTaskConverter
extends WTCTaskGenerator {
    public static final int DEFAULT_STR_LEN = 200;

    public void transferTaskAttribute(WTCTaskEntity var1, DynamicObject var2, boolean var3);

    public DynamicObject convert2TaskDyn(WTCTaskEntity var1, String var2);

    public WTCTaskEntity convert2Task(DynamicObject var1);

    public WTCTaskEntity convert2Task(WTCTaskRequest var1);

    public void transferSubTaskAttribute(WTCSubTaskEntity var1, DynamicObject var2, boolean var3);

    public void transferSubTaskCoreAttribute(WTCSubTaskEntity var1, DynamicObject var2, boolean var3);

    public void transferSubTaskInfoAttribute(WTCSubTaskEntity var1, DynamicObject var2);

    public DynamicObject convert2SubTaskDyn(WTCSubTaskEntity var1, String var2);

    public WTCSubTaskEntity convert2SubTask(DynamicObject var1);

    public WTCSubTaskEntity convert2SubTask(WTCShardingTask var1);

    public WTCTaskDispatchRequest convert2WTCTaskDispatchRequest(WTCShardingTask var1, WTCTaskRequest var2);

    default public String trimString(String str, int len) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() <= len) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str.substring(0, len));
        if (len >= 3) {
            builder.setCharAt(len - 1, '.');
            builder.setCharAt(len - 2, '.');
            builder.setCharAt(len - 3, '.');
        }
        return builder.toString();
    }

    default public DynamicObject getDynByEntityNumber(String entityNumber) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        return new DynamicObject((DynamicObjectType)entityType);
    }

    default public void setTaskDynAttribute(WTCTaskEntity task, DynamicObject taskDyn, boolean setID) {
        if (setID) {
            taskDyn.set("id", (Object)task.getId());
        }
        taskDyn.set("number", (Object)task.getNumber());
        taskDyn.set("name", (Object)task.getName());
        taskDyn.set("taskid", (Object)task.getTaskId());
        taskDyn.set("version", (Object)task.getVersion());
        taskDyn.set("source", (Object)task.getSource().code);
        taskDyn.set("category", (Object)task.getCategory());
        taskDyn.set("hassubtask", (Object)task.isHasSubTask());
        taskDyn.set("startdate", (Object)task.getStartDate());
        taskDyn.set("enddate", (Object)task.getEndDate());
        taskDyn.set("taskstatus", (Object)task.getTaskStatus().code);
        taskDyn.set("timecost", (Object)task.getTimeCost());
        taskDyn.set("taskdesc", (Object)task.getTaskDesc());
        taskDyn.set("errcause", (Object)this.trimString(task.getErrCause(), 200));
        taskDyn.set("errcause_tag", (Object)task.getErrCause());
        taskDyn.set("totalsubtask", (Object)task.getTotalSubTask());
        taskDyn.set("finishedsubtask", (Object)task.getFinishedSubTask());
        taskDyn.set("refreshtime", (Object)task.getRefreshTime());
        taskDyn.set("progress", (Object)task.getProgress());
        taskDyn.set("creator", (Object)task.getCreatorId());
        taskDyn.set("createtime", (Object)task.getCreateTime());
    }

    default public void setTaskAttribute(DynamicObject taskDyn, WTCTaskEntity task) {
        task.setId(taskDyn.getLong("id"));
        task.setNumber(taskDyn.getString("number"));
        task.setName(taskDyn.getString("name"));
        task.setTaskId(taskDyn.getLong("taskid"));
        task.setVersion(taskDyn.getString("version"));
        task.setSource(WTCSource.from(taskDyn.getString("source")));
        task.setCategory(taskDyn.getString("category"));
        task.setHasSubTask(taskDyn.getBoolean("hassubtask"));
        task.setStartDate(taskDyn.getDate("startdate"));
        task.setEndDate(taskDyn.getDate("enddate"));
        task.setTaskStatus(WTCTaskStatus.from(taskDyn.getString("taskstatus")));
        task.setTimeCost(taskDyn.getLong("timecost"));
        task.setTaskDesc(taskDyn.getString("taskdesc"));
        task.setErrCause(taskDyn.getString("errcause_tag"));
        task.setTotalSubTask(taskDyn.getInt("totalsubtask"));
        task.setFinishedSubTask(taskDyn.getInt("finishedsubtask"));
        task.setRefreshTime(taskDyn.getDate("refreshtime"));
        task.setProgress(taskDyn.getBigDecimal("progress"));
        task.setCreatorId(taskDyn.getLong("creator.id"));
        task.setCreateTime(taskDyn.getDate("createtime"));
    }

    default public void setSubTaskDynInfoAttribute(WTCSubTaskEntity subTask, DynamicObject subTaskDyn) {
        if (null != subTask.getStartDate()) {
            subTaskDyn.set("startdate", (Object)subTask.getStartDate());
        }
        subTaskDyn.set("enddate", (Object)subTask.getEndDate());
        subTaskDyn.set("subtaskstatus", (Object)subTask.getSubTaskStatus().getCode());
        subTaskDyn.set("refreshtime", (Object)subTask.getRefreshTime());
    }

    default public void setSubTaskDynCoreAttribute(WTCSubTaskEntity subTask, DynamicObject subTaskDyn, boolean setID) {
        if (setID) {
            subTaskDyn.set("id", (Object)subTask.getId());
        }
        subTaskDyn.set("taskid", (Object)subTask.getTaskId());
        subTaskDyn.set("index", (Object)subTask.getIndex());
    }

    default public void setSubTaskAttribute(DynamicObject subTaskDyn, WTCSubTaskEntity subTask) {
        subTask.setId(subTaskDyn.getLong("id"));
        subTask.setTaskId(subTaskDyn.getLong("taskid"));
        subTask.setStartDate(subTaskDyn.getDate("startdate"));
        subTask.setEndDate(subTaskDyn.getDate("enddate"));
        subTask.setSubTaskStatus(WTCSubTaskStatus.from(subTaskDyn.getString("subtaskstatus")));
        subTask.setRefreshTime(subTaskDyn.getDate("refreshtime"));
        subTask.setIndex(subTaskDyn.getInt("index"));
    }
}

