/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.dispatch;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.dispatch.DispatchInfo;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchService;
import kd.wtc.wtbs.business.task.mq.TaskMessagePublisher;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;

public class TaskDispatchServiceWTCMQ
implements WTCTaskDispatchService {
    protected final Log log = LogFactory.getLog(this.getClass());

    @Override
    public DispatchInfo dispatch(WTCTaskDispatchRequest dispatchRequest) {
        WTCTaskRequest taskRequest = dispatchRequest.getTaskRequest();
        WTCShardingTask shardingTask = dispatchRequest.getShardingTask();
        Map<String, Object> shardingParam = dispatchRequest.removeParams();
        Map<String, Object> customParam = this.getCustomParam(taskRequest, shardingTask);
        this.log.info("before dispatch, init params {}", customParam);
        customParam.putAll(shardingParam);
        customParam.putAll(taskRequest.getParams());
        this.log.info("before dispatch, final params {}", customParam);
        String queueName = TaskConfig.getQueueName(taskRequest.getCategory());
        TaskMessagePublisher.publish(queueName, customParam);
        return null;
    }

    private Map<String, Object> getCustomParam(WTCTaskRequest taskRequest, WTCShardingTask shardingTask) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("mainTaskId", taskRequest.getTaskId());
        params.put("trial", taskRequest.isTrial());
        params.put("version", taskRequest.getVersion());
        params.put("source", taskRequest.getSource());
        params.put("creatorId", taskRequest.getCreatorId());
        params.put("category", taskRequest.getCategory());
        params.put("subTaskId", shardingTask.getSubTaskId());
        params.put("index", shardingTask.getIndex());
        List<Object> taskShardingDetails = shardingTask.getTaskShardingDetails();
        if (taskShardingDetails != null && !taskShardingDetails.isEmpty()) {
            params.put("taskShardingDetailListJsonStr", WTCSerializationUtils.toJsonString(taskShardingDetails));
        }
        if (taskRequest instanceof WTCTaskRequestStd) {
            WTCTaskRequestStd taskRequestStd = (WTCTaskRequestStd)taskRequest;
            params.put("startDate", WTCDateUtils.date2Str((Date)taskRequestStd.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            params.put("endDate", WTCDateUtils.date2Str((Date)taskRequestStd.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return params;
    }
}

