/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.dispatch;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.dao.dbImpl.DbJobDao;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.dispatch.DispatchInfo;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchService;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;
import kd.wtc.wtbs.common.util.WTCDateUtils;

@Deprecated
public class TaskSlimDispatchServiceKDPlatform
implements WTCTaskDispatchService {
    protected final Log log = LogFactory.getLog(this.getClass());

    @Override
    public DispatchInfo dispatch(WTCTaskDispatchRequest dispatchRequest) {
        WTCTaskRequest taskRequest = dispatchRequest.getTaskRequest();
        WTCShardingTask shardingTask = dispatchRequest.getShardingTask();
        Map<String, Object> shardingParam = dispatchRequest.removeParams();
        JobInfo job = this.getJobTemplateFromDB(taskRequest.getCategory());
        long subTaskId = shardingTask.getSubTaskId();
        job.setShareIndex(shardingTask.getIndex());
        job.setRunByOrgId(RequestContext.get().getOrgId());
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setRunByLang(RequestContext.get().getLang());
        Map<String, Object> customParam = this.getCustomParam(taskRequest, shardingTask);
        this.log.info("before dispatch, init params {}", customParam);
        customParam.putAll(shardingParam);
        customParam.putAll(taskRequest.getParams());
        this.log.info("before dispatch, final params {}", customParam);
        job.setParams(customParam);
        dispatchRequest.setTaskRequest(null);
        dispatchRequest.setShardingTask(null);
        dispatchRequest.setShardingTask(null);
        String taskInfoId = ScheduleServiceHelper.dispatch((JobInfo)job);
        return new DispatchInfo(taskInfoId, subTaskId);
    }

    private Map<String, Object> getCustomParam(WTCTaskRequest taskRequest, WTCShardingTask shardingTask) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("mainTaskId", taskRequest.getTaskId());
        params.put("trial", taskRequest.isTrial());
        params.put("version", taskRequest.getVersion());
        params.put("source", taskRequest.getSource());
        params.put("creatorId", taskRequest.getCreatorId());
        params.put("category", taskRequest.getCategory());
        params.put("subTaskId", shardingTask.getSubTaskId());
        params.put("index", shardingTask.getIndex());
        if (taskRequest instanceof WTCTaskRequestStd) {
            WTCTaskRequestStd taskRequestStd = (WTCTaskRequestStd)taskRequest;
            params.put("startDate", WTCDateUtils.date2Str((Date)taskRequestStd.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            params.put("endDate", WTCDateUtils.date2Str((Date)taskRequestStd.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return params;
    }

    private JobInfo getJobTemplateFromDB(String category) {
        DbJobDao jobDao = new DbJobDao();
        JobInfo job = jobDao.get(this.getJobId(category));
        if (job == null) {
            throw new IllegalArgumentException("can not find Job for category[" + category + "]");
        }
        return job;
    }

    private String getJobId(String category) {
        if ("wtpm_match".equals(category)) {
            return "2QVAJGR+33NC";
        }
        if ("wtpm_signcard".equals(category) || "wtpm_supsign".equals(category)) {
            return "2QVAUNSZR5KV";
        }
        if ("wts_roster".equals(category)) {
            return "2QYOHWKY3PKX";
        }
        if ("wtis_payatt".equals(category)) {
            return "2QZ984VRR+N0";
        }
        if ("wtte_tie".equals(category)) {
            return "2QVB3D4B7XVS";
        }
        return "2QU8+2E0X2U0";
    }
}

