/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.executor;

import java.lang.ref.WeakReference;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.TaskHelper;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.task.WTCTaskExtHelper;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.MainTaskLifeCycleCallBack;
import kd.wtc.wtbs.business.task.base.MainTaskRunLog;
import kd.wtc.wtbs.business.task.base.ShardingTask;
import kd.wtc.wtbs.business.task.base.ShardingTaskDetector;
import kd.wtc.wtbs.business.task.base.ShardingTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.ShardingTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.base.TaskMonitorConfig;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.base.WTCTaskLockUtils;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchService;
import kd.wtc.wtbs.business.task.executor.DefaultMonitorConfig;
import kd.wtc.wtbs.business.task.executor.WTCInstrumentedTask;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCInstrumentedDispatcher
extends WTCInstrumentedTask {
    private static final Log log = LogFactory.getLog(WTCInstrumentedDispatcher.class);
    private static final int ST_BATCH_STORE_SIZE = Integer.parseInt(System.getProperty("wtc.task.st.batch.store.size", "50"));
    private static final int DEFAULT_TIMEOUT_IN_SECOND = Integer.parseInt(System.getProperty("wtc.task.mt.default.timeout.second", "18000"));
    private static final TaskRepository TASK_REPOSITORY = TaskRepositoryImpl.getInstance();
    private static final MainTaskDetector MT_DETECTOR = new MainTaskDetectorImpl(TASK_REPOSITORY);
    private static final ShardingTaskDetector ST_DETECTOR = new ShardingTaskDetectorImpl(TASK_REPOSITORY);
    private TaskMonitorConfig monitorConfig = new DefaultMonitorConfig();
    long mainTaskId;
    long bizTaskId;
    String category;
    LocalDateTime timeoutTime;
    WTCTaskDispatchService dispatchService;
    MainTaskLifeCycleCallBack mtLifeCycleCallBack;
    private WTCTaskRequestStd taskReq;
    List<ShardingTaskRunLog> runningSTRLList = new ArrayList<ShardingTaskRunLog>(16);
    List<Long> ownershipRepublishQueue = new ArrayList<Long>(16);
    List<Long> redispatchQueue = new ArrayList<Long>(16);
    Map<Long, WeakReference<WTCTaskDispatchRequest>> dispatchReqFastHolder = new HashMap<Long, WeakReference<WTCTaskDispatchRequest>>(16);
    Map<Long, STDispatchInfo> dispatchInfoMap = new HashMap<Long, STDispatchInfo>(16);
    Map<Long, Long> bizSubTaskIdMap = new HashMap<Long, Long>(16);

    @Override
    protected boolean executeTask(RequestContext requestContext, Map<String, Object> params) {
        List<Long> needBootShardingTaskIdList;
        log.info("WTCMainTaskExecutor receive taskReq={}", params);
        this.reportProgress(1, ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u4e2d", (String)"WTCInstrumentedDispatcher_3", (String)"wtc-wtbs-business", (Object[])new Object[0]), null);
        Boolean isRestart = this.restartDetectAndSaveTask(params);
        if (isRestart == null) {
            return true;
        }
        this.initTaskEvn();
        TaskMonitorConfig taskMonitorConfig = this.mtLifeCycleCallBack.beforeMainTaskBoot();
        if (taskMonitorConfig != null) {
            this.monitorConfig = taskMonitorConfig;
        }
        if ((needBootShardingTaskIdList = this.boot(isRestart)) == null) {
            return true;
        }
        MainTaskLifeCycleCallBack.reqParamsHolder.set(this.taskReq.getParams());
        this.mtLifeCycleCallBack.onMainTaskBootSuccess(TASK_REPOSITORY.loadMT(this.mainTaskId), isRestart);
        MainTaskLifeCycleCallBack.reqParamsHolder.remove();
        this.bootShardingTask(needBootShardingTaskIdList);
        WTCDistributeTaskHelper.advanceMTStatus(this.mainTaskId, WTCTaskStatus.RUNNING, false);
        this.mtLifeCycleCallBack.onAllShardingTaskDispatched(this.bizTaskId);
        WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean restartDetectAndSaveTask(Map<String, Object> params) {
        String taskReqStr = (String)params.remove("WTCTaskRequestJsonStr");
        if (StringUtils.isBlank((CharSequence)taskReqStr)) {
            throw new WTCException(WTCStringUtils.format((String)"WTCMainTaskExecutor could not get taskReq[%s] in task params", (Object[])new Object[]{"WTCTaskRequestJsonStr"}));
        }
        MainTask mainTask = WTCInstrumentedDispatcher.genBaseMainTask(taskReqStr);
        this.remainReqCusParams(taskReqStr);
        this.bizTaskId = mainTask.getBizTaskId();
        this.category = mainTask.getCategory();
        taskReqStr = null;
        DLock lock = null;
        boolean locked = false;
        try {
            lock = WTCTaskLockUtils.getMainTaskLock4SaveTask(this.bizTaskId, this.category);
            locked = lock.tryLock();
            if (!locked) {
                log.warn("WTCMainTaskExecutor try to save task, but detected other executor have been do it.");
                Boolean bl = null;
                return bl;
            }
            boolean restart = MT_DETECTOR.existSameTask(this.bizTaskId, this.category);
            if (!restart) {
                try (TXHandle txHandle = TX.requiresNew();){
                    try {
                        TASK_REPOSITORY.saveMT(mainTask);
                        long mtId = mainTask.getId();
                        int stCount = WTCInstrumentedDispatcher.genAndSaveShardingTaskList(params, mtId);
                        mainTask.setTotalShardingTask(stCount);
                        TASK_REPOSITORY.updateMT(mainTask);
                    }
                    catch (Exception exp) {
                        txHandle.markRollback();
                        throw exp;
                    }
                }
            }
            Boolean bl = restart;
            return bl;
        }
        finally {
            if (lock != null) {
                if (locked) {
                    lock.unlock();
                }
                lock.close();
            }
        }
    }

    private void remainReqCusParams(String taskReqStr) {
        this.taskReq = (WTCTaskRequestStd)WTCSerializationUtils.deSerializeFromBase64((String)taskReqStr);
    }

    private void initTaskEvn() {
        MainTask mainTask = TASK_REPOSITORY.loadMT(this.bizTaskId, this.category);
        int timeoutInSecond = mainTask.getTimeoutInSecond();
        timeoutInSecond = timeoutInSecond > 0 ? timeoutInSecond : DEFAULT_TIMEOUT_IN_SECOND;
        this.mainTaskId = mainTask.getId();
        this.bizTaskId = mainTask.getBizTaskId();
        this.category = mainTask.getCategory();
        this.timeoutTime = mainTask.getStartDate().plusSeconds(timeoutInSecond);
        this.dispatchService = TaskConfig.getDispatchService(this.category);
        this.mtLifeCycleCallBack = TaskConfig.getMainTaskLifeCycleCallBack(this.category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> boot(boolean restart) {
        DLock lock = null;
        boolean locked = false;
        try {
            lock = WTCTaskLockUtils.getMainTaskLock(this.mainTaskId);
            locked = lock.tryLock();
            if (!locked) {
                log.warn("WTCMainTaskExecutor try to boot task[mtid={}], but detected other executor have been do it.", (Object)this.mainTaskId);
                List<Long> list = null;
                return list;
            }
            boolean executorAlive = MT_DETECTOR.isExecutorAlive(this.mainTaskId);
            boolean end = MT_DETECTOR.isEnd(this.mainTaskId);
            if (end || executorAlive) {
                log.warn("WTCMainTaskExecutor try to boot task[mtid={}], but detected task finished={} or still running={}.", new Object[]{this.mainTaskId, end, executorAlive});
                List<Long> list = null;
                return list;
            }
            TXHandle handle = TX.requiresNew();
            try {
                MainTaskRunLog oldML = TASK_REPOSITORY.loadEffectiveMTRL(this.mainTaskId);
                MainTaskRunLog mtRunLog = MainTaskRunLog.newLog(this.mainTaskId, Instance.getInstanceId(), this.taskId);
                if (oldML != null) {
                    mtRunLog.setProgress(oldML.getProgress());
                    mtRunLog.setReportData(oldML.getReportData());
                    oldML.setCurrent(false);
                    TASK_REPOSITORY.updateMTRL(oldML);
                }
                TASK_REPOSITORY.saveMTRL(mtRunLog);
                handle.commit();
            }
            catch (Throwable exp) {
                List<Long> list;
                try {
                    log.warn("WTCMainTaskExecutor try to boot task[mtid={}], but newRunLog failed{}", (Object)this.mainTaskId, (Object)exp);
                    handle.markRollback();
                    list = null;
                }
                catch (Throwable throwable) {
                    handle.close();
                    throw throwable;
                }
                handle.close();
                if (lock != null) {
                    if (locked) {
                        lock.unlock();
                    }
                    lock.close();
                }
                return list;
            }
            handle.close();
        }
        finally {
            if (lock != null) {
                if (locked) {
                    lock.unlock();
                }
                lock.close();
            }
        }
        List<DynamicObject> stList = TASK_REPOSITORY.queryST(this.mainTaskId, null, "id,bizsubtaskid");
        for (DynamicObject st : stList) {
            long shardingTaskId = st.getLong("id");
            long bizSubTaskId = st.getLong("bizsubtaskid");
            this.bizSubTaskIdMap.put(shardingTaskId, bizSubTaskId);
        }
        List<ShardingTaskRunLog> effectiveSTRLList = TASK_REPOSITORY.loadAllEffectiveSTRL(this.mainTaskId);
        this.runningSTRLList.addAll(effectiveSTRLList);
        this.fastRebootSTWhichMaybeLost(effectiveSTRLList);
        Set excludeSTID = effectiveSTRLList.stream().map(ShardingTaskRunLog::getShardingTaskId).collect(Collectors.toSet());
        log.info("WTCMainTaskExecutor booting, detected have been booted ShardingTask's ID Collections:{}.", excludeSTID);
        Map<Long, Integer> stRunTimesMap = TASK_REPOSITORY.queryAllSTRunTimes(this.mainTaskId);
        for (Map.Entry<Long, Integer> entry : stRunTimesMap.entrySet()) {
            this.dispatchInfoMap.put(entry.getKey(), STDispatchInfo.newOne(entry.getValue()));
        }
        return stList.stream().map(ele -> ele.getLong("id")).filter(stId -> !excludeSTID.contains(stId)).collect(Collectors.toList());
    }

    private void fastRebootSTWhichMaybeLost(List<ShardingTaskRunLog> effectiveSTRLList) {
        List<Long> fastRebootSTIDList = effectiveSTRLList.stream().filter(strl -> WTCStringUtils.isEmpty((String)strl.getExecutorId())).map(ShardingTaskRunLog::getShardingTaskId).collect(Collectors.toList());
        this.dispatchShardingTask(fastRebootSTIDList);
    }

    private void bootShardingTask(List<Long> shardingTaskIdList) {
        HashSet<Long> dispatchRecord = new HashSet<Long>(shardingTaskIdList.size());
        for (Long shardingTaskId : shardingTaskIdList) {
            if (dispatchRecord.contains(shardingTaskId)) continue;
            dispatchRecord.add(shardingTaskId);
            WTCTaskDispatchRequest dispatchReq = this.getDispatchReqFast(shardingTaskId);
            STDispatchInfo stDispatchInfo = this.dispatchInfoMap.computeIfAbsent(shardingTaskId, key -> STDispatchInfo.newOne());
            if (stDispatchInfo.reachLimit(this.monitorConfig.maxRetryTimes())) {
                log.warn("WTCMainTaskExecutor detected the shardingTask[id={}] publish ownership reach max limit times:{}, now judged it can not be finished, so destroy it.", (Object)shardingTaskId, (Object)this.monitorConfig.maxRetryTimes());
                this.destroyShardingTaskWithoutLock(shardingTaskId);
                this.mtLifeCycleCallBack.onShardingTaskBeJudgedError(this.bizTaskId, this.bizSubTaskIdMap.get(shardingTaskId));
                WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskIdMap.get(shardingTaskId), this.category);
                continue;
            }
            try {
                dispatchReq.putParam("WTCShardingTaskId", shardingTaskId);
                dispatchReq.putParam("category", this.category);
                this.dispatchService.dispatch(dispatchReq);
            }
            catch (Exception exp) {
                log.error("WTCMainTaskExecutor booting shardingTask[id={}], but dispatch it failed, exp=\n", (Object)shardingTaskId, (Object)exp);
                this.push2OwnershipRepublishQueue(shardingTaskId);
            }
        }
    }

    private void dispatchShardingTask(List<Long> shardingTaskIdList) {
        HashSet<Long> dispatchRecord = new HashSet<Long>(shardingTaskIdList.size());
        for (Long shardingTaskId : shardingTaskIdList) {
            if (dispatchRecord.contains(shardingTaskId)) continue;
            dispatchRecord.add(shardingTaskId);
            WTCTaskDispatchRequest dispatchReq = this.getDispatchReqFast(shardingTaskId);
            STDispatchInfo stDispatchInfo = this.dispatchInfoMap.computeIfAbsent(shardingTaskId, key -> STDispatchInfo.newOne());
            stDispatchInfo.refreshDispatchTime();
            stDispatchInfo.refreshResponseTime();
            try {
                dispatchReq.putParam("WTCShardingTaskId", shardingTaskId);
                this.dispatchService.dispatch(dispatchReq);
            }
            catch (Exception exp) {
                log.error("WTCMainTaskExecutor dispatch shardingTask[id={}], but dispatch it failed, exp=\n", (Object)shardingTaskId, (Object)exp);
                this.push2RedispatchQueue(shardingTaskId);
            }
        }
    }

    private ShardingTask destroyShardingTaskWithoutLock(long shardingTaskId) {
        try (TXHandle txHandle = TX.required();){
            ShardingTask newestST = null;
            try {
                newestST = TASK_REPOSITORY.loadST(shardingTaskId);
                if (!ST_DETECTOR.isEnd(newestST)) {
                    newestST.setSubTaskStatus(WTCSubTaskStatus.ERROR);
                    newestST.setUpdateTime(LocalDateTime.now());
                    this.newAndSaveSTRL(shardingTaskId, this.mainTaskId, true);
                    TASK_REPOSITORY.updateST(newestST);
                }
            }
            catch (Exception exp) {
                txHandle.markRollback();
                this.push2OwnershipRepublishQueue(shardingTaskId);
            }
            ShardingTask shardingTask = newestST;
            return shardingTask;
        }
    }

    @Override
    protected int measureProgress() {
        return 100;
    }

    protected boolean isStop() {
        boolean stop = MT_DETECTOR.isStop(this.mainTaskId);
        if (stop) {
            return true;
        }
        if (LocalDateTime.now().isAfter(this.timeoutTime)) {
            log.info("WTCMainTaskExecutor detected mainTask[id={}] timeout, now stop it.", (Object)this.mainTaskId);
        } else if (!TaskHelper.isStop((String)this.taskId)) {
            return false;
        }
        if (this.stopNow()) {
            WTCDistributeTaskHelper.advanceMTStatus(this.mainTaskId, WTCTaskStatus.TERMINATED, true);
        } else {
            WTCDistributeTaskHelper.advanceMTStatus(this.mainTaskId, WTCTaskStatus.TERMINATING, false);
            this.mtLifeCycleCallBack.onAcceptTerminating(this.bizTaskId, this.category);
            this.reportProgress(1, ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u4e2d", (String)"WTCInstrumentedDispatcher_4", (String)"wtc-wtbs-business", (Object[])new Object[0]), null);
        }
        return true;
    }

    private WTCTaskDispatchRequest getDispatchReqFast(Long shardingTaskId) {
        WTCTaskDispatchRequest dispatchReq;
        WeakReference<WTCTaskDispatchRequest> dispatchReqWrapper = this.dispatchReqFastHolder.get(shardingTaskId);
        WTCTaskDispatchRequest wTCTaskDispatchRequest = dispatchReq = dispatchReqWrapper == null ? null : (WTCTaskDispatchRequest)dispatchReqWrapper.get();
        if (dispatchReq == null) {
            ShardingTask shardingTask = TASK_REPOSITORY.loadST(shardingTaskId);
            dispatchReq = (WTCTaskDispatchRequest)WTCSerializationUtils.deSerializeFromBase64((String)shardingTask.getDispatchReqStr());
            this.dispatchReqFastHolder.put(shardingTaskId, new WeakReference<WTCTaskDispatchRequest>(dispatchReq));
        }
        dispatchReq.setTaskRequest(this.taskReq);
        return dispatchReq;
    }

    private ShardingTaskRunLog newAndSaveSTRL(long shardingTaskId, long mainTaskId, boolean fillExecutorId) {
        ShardingTaskRunLog lastSTRL = TASK_REPOSITORY.loadLastFailSTRL(shardingTaskId);
        String preTimeReportData = null;
        if (lastSTRL != null) {
            preTimeReportData = lastSTRL.getReportData();
        }
        ShardingTaskRunLog stRunLog = ShardingTaskRunLog.newInstance(mainTaskId, shardingTaskId, preTimeReportData);
        if (fillExecutorId) {
            stRunLog.setProgress(100);
            stRunLog.setExecutorId(Instance.getInstanceId());
        }
        TASK_REPOSITORY.saveSTRL(stRunLog);
        return stRunLog;
    }

    private void push2RedispatchQueue(long shardingTaskId) {
        this.redispatchQueue.add(shardingTaskId);
    }

    private void push2OwnershipRepublishQueue(long shardingTaskId) {
        this.ownershipRepublishQueue.add(shardingTaskId);
    }

    public static MainTask genBaseMainTask(String taskReqStr) {
        WTCTaskRequestStd taskReq = (WTCTaskRequestStd)WTCSerializationUtils.deSerializeFromBase64((String)taskReqStr);
        LocalDateTime now = LocalDateTime.now();
        MainTask mainTask = new MainTask();
        mainTask.setTaskReqStr(taskReqStr);
        mainTask.setId(0L);
        mainTask.setBizTaskId(taskReq.getTaskId());
        mainTask.setCategory(taskReq.getCategory());
        mainTask.setTimeoutInSecond(taskReq.getTimeoutInSecond());
        mainTask.setHasShardingTask(true);
        mainTask.setTotalShardingTask(0);
        mainTask.setCreatorId(taskReq.getCreatorId());
        mainTask.setCreateTime(now);
        mainTask.setStartDate(now);
        mainTask.setEndDate(null);
        mainTask.setTimeCost(0L);
        mainTask.setTaskStatus(WTCTaskStatus.NEW);
        mainTask.setFinishedShardingTask(0);
        mainTask.setUpdateTime(now);
        return mainTask;
    }

    public static int genAndSaveShardingTaskList(Map<String, Object> params, long mtId) {
        String dispatchReqListStr = (String)params.remove("WTCTaskDispatchRequest");
        if (StringUtils.isBlank((CharSequence)dispatchReqListStr)) {
            throw new WTCException(WTCStringUtils.format((String)"WTCMainTaskExecutor could not get dispatchReq[%s] in task params", (Object[])new Object[]{"WTCTaskDispatchRequest"}));
        }
        LocalDateTime now = LocalDateTime.now();
        List dispatchReqList = (List)WTCSerializationUtils.deSerializeFromBase64((String)dispatchReqListStr);
        dispatchReqListStr = null;
        int cnt = 0;
        ArrayList<ShardingTask> tmp = new ArrayList<ShardingTask>(16);
        Iterator iterator = dispatchReqList.iterator();
        while (iterator.hasNext()) {
            WTCTaskDispatchRequest req = (WTCTaskDispatchRequest)iterator.next();
            iterator.remove();
            ShardingTask shardingTask = new ShardingTask();
            shardingTask.setDispatchReqStr(WTCSerializationUtils.serializeToBase64((Object)req));
            shardingTask.setId(0L);
            shardingTask.setMainTaskId(mtId);
            shardingTask.setBizSubTaskId(req.getShardingTask().getSubTaskId());
            shardingTask.setIndex(req.getShardingTask().getIndex());
            shardingTask.setCreateTime(now);
            shardingTask.setSubTaskStatus(WTCSubTaskStatus.NEW);
            shardingTask.setUpdateTime(now);
            tmp.add(shardingTask);
            if (tmp.size() < ST_BATCH_STORE_SIZE) continue;
            TASK_REPOSITORY.saveST(tmp);
            cnt += tmp.size();
            tmp.clear();
        }
        if (!tmp.isEmpty()) {
            TASK_REPOSITORY.saveST(tmp);
            cnt += tmp.size();
        }
        return cnt;
    }

    @Deprecated
    public static List<ShardingTask> genShardingTaskList(String dispatchReqListStr) {
        LocalDateTime now = LocalDateTime.now();
        List dispatchReqList = (List)WTCSerializationUtils.deSerializeFromBase64((String)dispatchReqListStr);
        log.info("WTCMainTaskExecutor accept shardingList:{}", (Object)dispatchReqList);
        return dispatchReqList.stream().map(req -> {
            ShardingTask shardingTask = new ShardingTask();
            shardingTask.setDispatchReqStr(WTCSerializationUtils.serializeToBase64((Object)req));
            shardingTask.setId(0L);
            shardingTask.setMainTaskId(0L);
            shardingTask.setBizSubTaskId(req.getShardingTask().getSubTaskId());
            shardingTask.setIndex(req.getShardingTask().getIndex());
            shardingTask.setCreateTime(now);
            shardingTask.setSubTaskStatus(WTCSubTaskStatus.NEW);
            shardingTask.setUpdateTime(now);
            return shardingTask;
        }).collect(Collectors.toList());
    }

    private static class STDispatchInfo {
        private LocalDateTime lastResponseTime;
        private LocalDateTime lastDispatchTime;
        private int publishOwnershipTimes;

        public STDispatchInfo() {
            LocalDateTime now;
            this.lastResponseTime = now = LocalDateTime.now();
            this.lastDispatchTime = now;
            this.publishOwnershipTimes = 0;
        }

        public static STDispatchInfo newOne() {
            return new STDispatchInfo();
        }

        public static STDispatchInfo newOne(int dispatchTimes) {
            STDispatchInfo stDispatchInfo = new STDispatchInfo();
            stDispatchInfo.publishOwnershipTimes = dispatchTimes;
            return stDispatchInfo;
        }

        public void refreshDispatchTime() {
            this.lastDispatchTime = LocalDateTime.now();
        }

        public void refreshResponseTime() {
            this.lastResponseTime = LocalDateTime.now();
        }

        public boolean reachLimit(int limit) {
            return this.publishOwnershipTimes >= limit;
        }

        public LocalDateTime getLastResponseTime() {
            return this.lastResponseTime;
        }

        public LocalDateTime getLastDispatchTime() {
            return this.lastDispatchTime;
        }
    }
}

