/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.executor;

import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.wtc.wtbs.business.task.executor.ProgressReporter;

public abstract class WTCInstrumentedTask
extends AbstractTask
implements ProgressReporter {
    private static final Log LOGGER = LogFactory.getLog(WTCInstrumentedTask.class);
    private static boolean LOG_EX_PROGRESS = Boolean.parseBoolean(System.getProperty("wtc.task.mt.enable.log.ex.progress", "false"));
    private static final long MEASURE_INTERVAL = Long.parseLong(System.getProperty("wtc.task.mt.measure.interval.nanos", "1000000000"));
    private static boolean SOFT_TERMINATE = Boolean.parseBoolean(System.getProperty("wtc.task.mt.enable.soft.terminate", "true"));
    public static final int MAX_PROGRESS = 100;
    private int reportedProgress = 0;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean stopFlag = false;
        try {
            boolean shouldExist = this.executeTask(requestContext, map);
            if (shouldExist) {
                return;
            }
            while (!this.isDone()) {
                if (this.isStop()) {
                    if (!stopFlag) {
                        stopFlag = true;
                        this.stop();
                    }
                    if (this.stopNow()) break;
                }
                this.reportProgress(this.getMeasureProgress());
                this.waitProgressForward();
            }
            this.done(stopFlag);
        }
        catch (Exception exp) {
            LOGGER.error(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0crequestContext={}\uff0cmap={}\u3002", (String)"WTCInstrumentedTask_0", (String)"wtc-wtbs-business", (Object[])new Object[0]), new Object[]{requestContext, map, exp});
            this.error(exp);
        }
    }

    protected boolean stopNow() {
        return !SOFT_TERMINATE;
    }

    private int getMeasureProgress() {
        return Math.min(this.measureProgress(), 100);
    }

    private boolean forwardProgress(int progress) {
        if (progress < this.reportedProgress) {
            if (LOG_EX_PROGRESS) {
                LOGGER.info(ResManager.loadKDString((String)"\u8fdb\u5ea6\u62a5\u9053\u5f02\u5e38\uff1a\u5df2\u4e0a\u62a5\u8fdb\u5ea6\u4e3a{}%\uff0c\u5f53\u524d\u6b32\u4e0a\u62a5\u8fdb\u5ea6\u4e3a{}%\u3002", (String)"WTCInstrumentedTask_1", (String)"wtc-wtbs-business", (Object[])new Object[0]), (Object)this.reportedProgress, (Object)progress);
            }
            return false;
        }
        if (progress > 100) {
            if (LOG_EX_PROGRESS) {
                LOGGER.info(ResManager.loadKDString((String)"\u8fdb\u5ea6\u62a5\u9053\u5f02\u5e38\uff1a\u5f53\u524d\u8fdb\u5ea6\u4e3a{}%\uff0c\u76ee\u6807\u8fdb\u5ea6\u5c06\u8c03\u6574\u4e3a{}\u3002", (String)"WTCInstrumentedTask_2", (String)"wtc-wtbs-business", (Object[])new Object[0]), (Object)progress, (Object)100);
            }
            progress = 100;
        }
        this.reportedProgress = progress;
        return true;
    }

    protected abstract boolean executeTask(RequestContext var1, Map<String, Object> var2);

    protected abstract int measureProgress();

    public void stop() {
    }

    protected void error(Exception exp) {
    }

    protected void done(boolean stopFlag) {
    }

    protected boolean isDone() {
        return this.reportedProgress == 100;
    }

    protected boolean waitProgressForward() {
        LockSupport.parkNanos(LockSupport.getBlocker(Thread.currentThread()), MEASURE_INTERVAL);
        return Thread.interrupted();
    }

    @Override
    public int getReportedProgress() {
        return this.reportedProgress;
    }

    @Override
    public void reportProgress(int progress, String desc, Map<String, Object> customData) {
        if (this.forwardProgress(progress)) {
            this.feedbackProgress(progress, desc, customData);
        }
    }

    @Override
    public void reportProgress(int progress) {
        if (this.forwardProgress(progress)) {
            this.feedbackProgress(progress);
        }
    }

    @Override
    public void reportCustomData(Map<String, Object> customData) {
        this.feedbackCustomdata(customData);
    }
}

