/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.executor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.schedule.api.ShardingTask;
import kd.bos.schedule.executor.AbstractTask;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.WTCTaskExtHelper;
import kd.wtc.wtbs.business.task.WTCTaskObjectFactory;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.MainTaskLifeCycleCallBack;
import kd.wtc.wtbs.business.task.base.ShardingTaskDetector;
import kd.wtc.wtbs.business.task.base.ShardingTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.ShardingTaskExLog;
import kd.wtc.wtbs.business.task.base.ShardingTaskProgressReporter;
import kd.wtc.wtbs.business.task.base.ShardingTaskProgressReporterImpl;
import kd.wtc.wtbs.business.task.base.ShardingTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.base.TaskMonitorConfig;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.base.WTCTaskLockUtils;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.executor.DefaultMonitorConfig;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.business.task.sharding.std.WTCTaskCalShardingDetail;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public abstract class WTCShardingAbleTask
extends AbstractTask
implements ShardingTask {
    protected static final Log log = LogFactory.getLog(WTCShardingAbleTask.class);
    private static long PARK_NANOS_BEFORE_DENY_MESSAGE = Long.parseLong(System.getProperty("wtc.task.st.park.nanos.befoer.deny", "30000000000"));
    private static final TaskRepository taskRepository = TaskRepositoryImpl.getInstance();
    private static final MainTaskDetector mtDetector = new MainTaskDetectorImpl(taskRepository);
    private static final ShardingTaskDetector stDetector = new ShardingTaskDetectorImpl(taskRepository);
    private static final ShardingTaskProgressReporter stReporter = new ShardingTaskProgressReporterImpl(taskRepository);
    private MainTaskLifeCycleCallBack mtLifeCycleCallBack;
    private TaskMonitorConfig monitorConfig = new DefaultMonitorConfig();
    private long mainTaskId;
    private long bizTaskId;
    private String category;
    private kd.wtc.wtbs.business.task.base.ShardingTask shardingTask;
    private long shardingTaskId;
    private long bizSubTaskId;
    private ShardingTaskRunLog stRunLog;
    private MessageAcker messageAcker;
    private String messageId;
    private static final String TASK_STOPPED_BY_USER = "TASK_STOPED_BY_USER";

    public void setMessageAckInfo(MessageAcker messageAcker, String messageId) {
        if (messageAcker == null || messageId == null) {
            throw new IllegalArgumentException("Can not allow null arguments, messageAcker=" + messageAcker + ", messageId=" + messageId);
        }
        this.messageAcker = messageAcker;
        this.messageId = messageId;
    }

    private void denyST() {
        if (this.messageAcker != null) {
            LockSupport.parkNanos(PARK_NANOS_BEFORE_DENY_MESSAGE);
            this.messageAcker.deny(this.messageId);
            log.info("WTCShardingExecutor deny shardingTask:{}, messageId{}", (Object)this.shardingTaskId, (Object)this.messageId);
        }
    }

    private void ackST() {
        if (this.messageAcker != null) {
            this.messageAcker.ack(this.messageId);
            log.info("WTCShardingExecutor ack shardingTask:{}, messageId{}", (Object)this.shardingTaskId, (Object)this.messageId);
        }
    }

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.execute(requestContext, params, null);
    }

    public void execute(RequestContext requestContext, Map<String, Object> params, ShardingParam shardingParam) throws KDException {
        WTCTaskParam taskParam;
        this.initPreEvn(params);
        try {
            log.info("WTCShardingExecutor accept task[shardingTaskId={}] and then begin parse param.\n requestContext:{}\n params:{}\n shardingParam:{}", new Object[]{this.shardingTaskId, requestContext, params, shardingParam});
            taskParam = this.parseParams(params, shardingParam);
            log.info("WTCShardingExecutor parse param success, taskParam:{}", (Object)taskParam);
        }
        catch (Throwable throwable) {
            log.warn("WTCShardingExecutor parse param failed, now exist execute. throwable:", throwable);
            ShardingTaskExLog exLog = new ShardingTaskExLog();
            exLog.setShardingTaskId(this.shardingTaskId);
            exLog.setExStr(WTCDistributeTaskHelper.getStackTraceMessage(throwable));
            stReporter.reportError(exLog);
            this.judgeSTErrorBeforeInitEvn();
            return;
        }
        this.doExecute(requestContext, taskParam);
    }

    private void judgeSTErrorBeforeInitEvn() {
        if (WTCDistributeTaskHelper.destroyShardingTaskWithLock(this.shardingTaskId)) {
            this.onShardingTaskBeJudgedError();
            WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
            this.ackST();
        } else {
            this.denyST();
        }
    }

    private void onShardingTaskBeJudgedError() {
        kd.wtc.wtbs.business.task.base.ShardingTask shardingTask = taskRepository.loadST(this.shardingTaskId);
        MainTask mainTask = taskRepository.loadMT(shardingTask.getMainTaskId());
        this.mtLifeCycleCallBack.onShardingTaskBeJudgedError(mainTask.getBizTaskId(), shardingTask.getBizSubTaskId());
        WTCTaskExtHelper.afterSubTaskEnd(mainTask.getBizTaskId(), shardingTask.getBizSubTaskId(), mainTask.getCategory());
    }

    private void initPreEvn(Map<String, Object> params) {
        this.shardingTaskId = (Long)params.getOrDefault("WTCShardingTaskId", 0L);
        String category = (String)params.getOrDefault("category", "");
        this.mtLifeCycleCallBack = TaskConfig.getMainTaskLifeCycleCallBack(category);
        TaskMonitorConfig taskMonitorConfig = this.mtLifeCycleCallBack.getTaskMonitorConfig();
        if (taskMonitorConfig != null) {
            this.monitorConfig = taskMonitorConfig;
            log.info("WTCShardingExecutor replace monitorConfig for shardingTask[id={}], maxRetryTimes={}", (Object)this.shardingTaskId, (Object)this.monitorConfig.maxRetryTimes());
        }
    }

    private void initRunEvn(WTCTaskParam taskParam) {
        MainTask mainTask = taskRepository.loadMT(taskParam.getMainTaskId(), taskParam.getTaskCategory());
        if (mainTask == null) {
            throw new IllegalStateException("WTCShardingExecutor can not find mainTask by bizTaskId=" + taskParam.getMainTaskId() + ", category=" + taskParam.getTaskCategory());
        }
        kd.wtc.wtbs.business.task.base.ShardingTask chkShardingTask = taskRepository.loadST(mainTask.getId(), taskParam.getTaskId());
        if (chkShardingTask == null) {
            throw new IllegalStateException("WTCShardingExecutor can not find shardingTask by mainTaskId=" + mainTask.getId() + ", bizSubTaskId=" + taskParam.getTaskId());
        }
        this.mainTaskId = mainTask.getId();
        this.bizTaskId = taskParam.getMainTaskId();
        this.category = taskParam.getTaskCategory();
        this.shardingTask = chkShardingTask;
        this.shardingTaskId = this.shardingTask.getId();
        this.bizSubTaskId = taskParam.getTaskId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(RequestContext requestContext, WTCTaskParam taskParam) {
        try {
            this.initRunEvn(taskParam);
            log.info("WTCShardingExecutor init run time environment success, mainTaskId={}, shardingTask={}, shardingTaskId={}, bizSubTaskId={}", new Object[]{this.mainTaskId, this.shardingTask, this.shardingTaskId, this.bizSubTaskId});
        }
        catch (Throwable throwable) {
            log.warn("WTCShardingExecutor init run time environment failed, now exist execute. throwable:", throwable);
            ShardingTaskExLog stExLog = WTCDistributeTaskHelper.genSTExLog(this.shardingTaskId, this.stRunLog, "WTCShardingExecutor init run time environment failed.", throwable, false);
            stReporter.reportError(stExLog);
            this.judgeSTErrorBeforeInitEvn();
            return;
        }
        boolean shouldExecute = false;
        try {
            WTCSubTaskStatus shardingTaskStatus;
            shouldExecute = this.selfDetect();
            log.info("WTCShardingExecutor try to preempt executive power of shardingTask[id={}], preempt result:{}", (Object)this.shardingTaskId, (Object)shouldExecute);
            if (!shouldExecute) {
                log.info("WTCShardingExecutor can not preempt executive power, taskParam:{}", (Object)taskParam);
                return;
            }
            if (this.isStop() || this.isTimeOut()) {
                boolean stillExecuteBizCode = true;
                try {
                    stillExecuteBizCode = this.onSubTaskTerminatedBeforeExecute0(taskParam);
                }
                catch (Throwable throwable) {
                    log.info("WTCShardingExecutor execute onSubTaskTerminatedBeforeExecute failed, taskParam:{}. ", (Object)taskParam);
                }
                if (!stillExecuteBizCode) {
                    log.info("WTCShardingExecutor detected shardingTask should be terminate, taskParam:{}. decision skip execute the bizCode", (Object)taskParam);
                    WTCDistributeTaskHelper.advanceSTRL2End(this.stRunLog);
                    WTCDistributeTaskHelper.advanceST2End(this.shardingTask, WTCSubTaskStatus.TERMINATED);
                    this.mtLifeCycleCallBack.onShardingTaskBusinessEnd(this.bizTaskId, this.bizSubTaskId, this.stRunLog.getReportData());
                    WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskId, this.category);
                    WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
                    this.ackST();
                    return;
                }
                log.info("WTCShardingExecutor detected shardingTask should be terminate, taskParam:{}. but decision still execute the bizCode", (Object)taskParam);
            }
            WTCShardingTaskHelper.holder.put(this.bizSubTaskId, this);
            try {
                log.info("WTCShardingExecutor is all ready to execute biz code.");
                this.execute(requestContext, taskParam);
                log.info("WTCShardingExecutor execute biz code success.");
                shardingTaskStatus = WTCSubTaskStatus.FINISHED;
            }
            catch (Throwable throwable) {
                log.warn("WTCShardingExecutor biz error. shardingTask={}, taskParam={}, requestContext={}, ex={}", new Object[]{this.shardingTask, taskParam, requestContext, throwable});
                shardingTaskStatus = WTCSubTaskStatus.ERROR;
                if (this.isUserTerminate(throwable)) {
                    stReporter.reportError(WTCDistributeTaskHelper.genSTExLog(this.shardingTaskId, this.stRunLog, "WTCShardingExecutor biz response terminate.", throwable, true));
                    shardingTaskStatus = WTCSubTaskStatus.TERMINATED;
                } else {
                    boolean retry = this.retry0(taskParam, throwable);
                    if (retry) {
                        log.info("WTCShardingExecutor biz error, but biz want retry this sharding. shardingTask={}, taskParam={}, requestContext={}", new Object[]{this.shardingTask, taskParam, requestContext});
                        throw throwable;
                    }
                    boolean toEnd = this.onBizCodeError0(taskParam, throwable);
                    if (toEnd) {
                        log.info("WTCShardingExecutor biz error, but biz want this sharding to finish state. shardingTask={}, taskParam={}, requestContext={}", new Object[]{this.shardingTask, taskParam, requestContext});
                        shardingTaskStatus = WTCSubTaskStatus.FINISHED;
                    }
                    stReporter.reportError(WTCDistributeTaskHelper.genSTExLog(this.shardingTaskId, this.stRunLog, "WTCShardingExecutor biz error.", throwable, true));
                }
            }
            finally {
                WTCShardingTaskHelper.holder.remove(this.bizSubTaskId);
            }
            WTCDistributeTaskHelper.advanceSTRL2End(this.stRunLog);
            WTCDistributeTaskHelper.advanceST2End(this.shardingTask, shardingTaskStatus);
            this.mtLifeCycleCallBack.onShardingTaskBusinessEnd(this.bizTaskId, this.bizSubTaskId, this.stRunLog.getReportData());
            WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskId, this.category);
            WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
            this.ackST();
        }
        catch (Throwable throwable) {
            log.warn("WTCShardingExecutor executor error. shardingTask={}, taskParam={}, requestContext={}, exp={}", new Object[]{this.shardingTask, taskParam, requestContext, throwable});
            stReporter.reportError(WTCDistributeTaskHelper.genSTExLog(this.shardingTaskId, this.stRunLog, "WTCShardingExecutor executor error.", throwable, shouldExecute));
            if (shouldExecute) {
                this.clearSTRL(this.stRunLog);
                this.mtLifeCycleCallBack.onShardingTaskReportEx(this.bizTaskId, this.bizSubTaskId, null);
            }
            this.denyST();
        }
    }

    private boolean isBizEnd0(long subTaskId) {
        try {
            return this.isBizEnd(subTaskId);
        }
        catch (Throwable exp) {
            log.warn("WTCShardingExecutor execute biz isBizEnd error, subTaskId={}", (Object)subTaskId, (Object)exp);
            return false;
        }
    }

    private boolean retry0(WTCTaskParam taskParam, Throwable throwable) {
        try {
            return this.retry(taskParam, throwable);
        }
        catch (Throwable exp) {
            log.warn("WTCShardingExecutor execute biz onBizCodeError error, taskParam={}, throwable={}\n", new Object[]{taskParam, throwable, exp});
            return false;
        }
    }

    private boolean onBizCodeError0(WTCTaskParam taskParam, Throwable throwable) {
        try {
            return this.onBizCodeError(taskParam, throwable);
        }
        catch (Throwable exp) {
            log.warn("WTCShardingExecutor execute biz onBizCodeError error, taskParam={}, throwable={}\n", new Object[]{taskParam, throwable, exp});
            return false;
        }
    }

    private boolean onSubTaskTerminatedBeforeExecute0(WTCTaskParam taskParam) {
        try {
            return this.onSubTaskTerminatedBeforeExecute(taskParam);
        }
        catch (Throwable exp) {
            log.warn("WTCShardingExecutor execute biz onBizCodeError error, taskParam={}\n", (Object)taskParam, (Object)exp);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean selfDetect() {
        DLock lock = null;
        boolean locked = false;
        boolean shouldLockExecuteAuthority = false;
        try {
            lock = WTCTaskLockUtils.getShardingTaskLock(this.shardingTaskId);
            locked = lock.tryLock();
            if (!locked) {
                this.denyST();
                boolean bl = false;
                return bl;
            }
            this.stRunLog = taskRepository.loadEffectiveSTRL(this.shardingTaskId);
            if (stDetector.isEnd(this.shardingTaskId)) {
                log.info("WTCShardingExecutor detected shardingTask[id={}] have been finished, now exist", (Object)this.bizSubTaskId);
                if (this.stRunLog != null) {
                    this.mtLifeCycleCallBack.onShardingTaskBusinessEnd(this.bizTaskId, this.bizSubTaskId, this.stRunLog.getReportData());
                    WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskId, this.category);
                } else {
                    log.info("WTCShardingExecutor detected shardingTask[id={}] have been finished, but not effective STRL", (Object)this.bizSubTaskId);
                }
                WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
                this.ackST();
                boolean bl = false;
                return bl;
            }
            if (this.stRunLog == null && !this.tryCreateSTRL()) {
                this.mtLifeCycleCallBack.onShardingTaskBeJudgedError(this.bizTaskId, this.bizSubTaskId);
                WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskId, this.category);
                WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
                this.ackST();
                boolean bl = false;
                return bl;
            }
            if (!WTCStringUtils.isEmpty((String)this.stRunLog.getExecutorId())) {
                if (!stDetector.isCrash(this.stRunLog)) {
                    log.info("WTCShardingExecutor detected shardingTask has been preempted, subTaskId:{}", (Object)this.bizSubTaskId);
                    this.denyST();
                    boolean bl = false;
                    return bl;
                }
                if (stDetector.isEnd(this.shardingTaskId)) {
                    this.mtLifeCycleCallBack.onShardingTaskBusinessEnd(this.bizTaskId, this.bizSubTaskId, this.stRunLog.getReportData());
                    WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskId, this.category);
                    WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
                    this.ackST();
                    boolean bl = false;
                    return bl;
                }
                WTCDistributeTaskHelper.newAndSaveSTCrashLog(this.stRunLog);
                WTCDistributeTaskHelper.recycleShardingTaskOwnership(this.stRunLog);
                this.mtLifeCycleCallBack.onShardingTaskCrash(this.bizTaskId, this.bizSubTaskId);
                if (!this.tryCreateSTRL()) {
                    this.mtLifeCycleCallBack.onShardingTaskBeJudgedError(this.bizTaskId, this.bizSubTaskId);
                    WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskId, this.category);
                    WTCDistributeTaskHelper.measureProgressAndDoEndCallback(this.mainTaskId);
                    this.ackST();
                    boolean bl = false;
                    return bl;
                }
            }
            if (this.isBizEnd0(this.bizSubTaskId)) {
                log.info("WTCShardingExecutor detected shardingTask's biz code has been run end, subTaskId:{}", (Object)this.bizSubTaskId);
                this.stRunLog.setExecutorId(Instance.getInstanceId());
                this.stRunLog.setStartTime(LocalDateTime.now());
                WTCDistributeTaskHelper.advanceSTRL2End(this.stRunLog);
                WTCDistributeTaskHelper.advanceST2End(this.shardingTask, WTCSubTaskStatus.FINISHED);
                this.mtLifeCycleCallBack.onShardingTaskBusinessEnd(this.bizTaskId, this.bizSubTaskId, this.stRunLog.getReportData());
                WTCTaskExtHelper.afterSubTaskEnd(this.bizTaskId, this.bizSubTaskId, this.category);
                this.ackST();
                boolean bl = false;
                return bl;
            }
            shouldLockExecuteAuthority = true;
            LocalDateTime now = LocalDateTime.now();
            this.stRunLog.setExecutorId(Instance.getInstanceId());
            this.stRunLog.setReportData(null);
            this.stRunLog.setStartTime(now);
            this.stRunLog.setUpdateTime(now);
            this.shardingTask.setSubTaskStatus(WTCSubTaskStatus.RUNNING);
            this.shardingTask.setUpdateTime(now);
            stReporter.reportProgress(this.stRunLog);
            taskRepository.updateST(this.shardingTask);
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            log.warn("WTCShardingExecutor occur unBiz ex in selfDetect, shardingTaskId={}.", (Object)this.bizSubTaskId, (Object)e);
            stReporter.reportError(WTCDistributeTaskHelper.genSTExLog(this.shardingTaskId, this.stRunLog, "WTCShardingExecutor occur unBiz ex in selfDetect.", e, true));
            if (shouldLockExecuteAuthority) {
                log.warn("WTCShardingExecutor occur unBiz ex in selfDetect, shardingTaskId={}, now clear RunLog for shardingTask.", (Object)this.bizSubTaskId, (Object)e);
                this.clearSTRL(this.stRunLog);
                this.mtLifeCycleCallBack.onShardingTaskReportEx(this.bizTaskId, this.bizSubTaskId, null);
            }
            this.denyST();
            boolean bl = false;
            return bl;
        }
        finally {
            if (lock != null) {
                if (locked) {
                    lock.unlock();
                }
                lock.close();
            }
        }
    }

    private boolean tryCreateSTRL() {
        int tryCnt = taskRepository.countSTRL(this.shardingTaskId);
        if (tryCnt >= this.monitorConfig.maxRetryTimes()) {
            log.info("WTCShardingExecutor tryCreateSTRL for shardingTask[id={}], buf detected tryCnt[{}] >= maxRetryTimes[{}], now try destroyShardingTaskUnLock", new Object[]{this.shardingTaskId, tryCnt, this.monitorConfig.maxRetryTimes()});
            if (WTCDistributeTaskHelper.destroyShardingTaskUnLock(this.shardingTaskId)) {
                log.info("WTCShardingExecutor destroyShardingTaskUnLock for shardingTask[id={}] false", (Object)this.shardingTaskId);
                return false;
            }
        }
        this.stRunLog = WTCDistributeTaskHelper.newAndSaveSTRL(this.shardingTaskId, this.mainTaskId, false);
        return true;
    }

    private WTCTaskParam parseParams(Map<String, Object> params, ShardingParam shardingParam) {
        WTCTaskParam taskParam = new WTCTaskParam();
        taskParam.setSharding(Boolean.parseBoolean(String.valueOf(params.remove("sharding"))));
        taskParam.setMainTaskId(Long.parseLong(String.valueOf(params.remove("mainTaskId"))));
        taskParam.setTaskId(Long.parseLong(String.valueOf(params.remove("subTaskId"))));
        taskParam.setCreatorId(Long.parseLong(String.valueOf(params.remove("creatorId"))));
        taskParam.setShardingIndex(Integer.parseInt(String.valueOf(params.remove("index"))));
        taskParam.setNumOfSharding(Integer.parseInt(String.valueOf(params.remove("numOfSharding"))));
        taskParam.setTaskVersion(String.valueOf(params.remove("version")));
        taskParam.setTrialTask(Boolean.parseBoolean(String.valueOf(params.remove("trial"))));
        taskParam.setTaskSource(String.valueOf(params.remove("source")));
        taskParam.setTaskCategory(String.valueOf(params.remove("category")));
        taskParam.setShardingParam(shardingParam);
        Object taskShardingDetailListJsonStr = params.remove("taskShardingDetailListJsonStr");
        boolean isSlimRequest = taskShardingDetailListJsonStr == null;
        List<Object> shardingDetailList = isSlimRequest ? this.getSlimShardingDetailList(taskParam.getMainTaskId(), taskParam.getTaskId(), taskParam.getTaskCategory()) : this.getShardingDetailList(String.valueOf(taskShardingDetailListJsonStr));
        taskParam.setTaskShardingDetails(shardingDetailList);
        taskParam.setParams(params);
        return taskParam;
    }

    private List<Object> getSlimShardingDetailList(long mainTaskId, long subTaskId, String category) {
        List<Object> shardingDetailList = null;
        try {
            shardingDetailList = this.doGetShardingDetailList(mainTaskId, subTaskId, category);
        }
        catch (Throwable exp) {
            log.warn("WTCShardingExecutor detected biz code doGetShardingDetailList occur error. bizMainTaskId={}, bizSubTaskId={}, bizCategory={}", new Object[]{mainTaskId, subTaskId, category, exp});
        }
        if (shardingDetailList == null) {
            WTCTaskObjectFactory objectFactory = WTCTaskInstanceHelper.getObjectFactory(category);
            WTCCalTaskRepository repository = (WTCCalTaskRepository)objectFactory.getRepository();
            List<WTCCalTaskDetailEntity> detailList = repository.batchLoadTaskDetailByTaskIdAndSubTaskId(mainTaskId, subTaskId, null);
            shardingDetailList = detailList.stream().map(detail -> repository.getWTCCalTaskConverter().convert2ShardingDetail((WTCCalTaskDetailEntity)detail)).collect(Collectors.toList());
        }
        return shardingDetailList;
    }

    private List<Object> getShardingDetailList(String taskShardingDetailListJsonStr) {
        List<Object> shardingDetailList = null;
        try {
            shardingDetailList = this.convert2ShardingDetailList(taskShardingDetailListJsonStr);
        }
        catch (Throwable exp) {
            log.warn("WTCShardingExecutor detected biz code doGetShardingDetailList occur error. taskShardingDetailListJsonStr={}", (Object)taskShardingDetailListJsonStr, (Object)exp);
        }
        if (shardingDetailList == null) {
            shardingDetailList = WTCSerializationUtils.fromJsonStringToList((String)taskShardingDetailListJsonStr, WTCTaskCalShardingDetail.class).stream().map(obj -> obj).collect(Collectors.toList());
        }
        return shardingDetailList;
    }

    private void clearSTRL(ShardingTaskRunLog stRunLog) {
        LocalDateTime now = LocalDateTime.now();
        stRunLog.setCurrent(false);
        stRunLog.setEndTime(now);
        stRunLog.setUpdateTime(now);
        stReporter.reportProgress(stRunLog);
    }

    public boolean isStop() throws KDException {
        return mtDetector.isStop(this.mainTaskId);
    }

    private boolean isTimeOut() {
        return mtDetector.isStop(this.mainTaskId);
    }

    private boolean isUserTerminate(Throwable e) {
        return e instanceof KDException && TASK_STOPPED_BY_USER.equals(((KDException)e).getErrorCode().getCode());
    }

    protected List<Object> doGetShardingDetailList(long mainTaskId, long subTaskId, String category) {
        return null;
    }

    protected List<Object> convert2ShardingDetailList(String taskShardingDetailListJsonStr) {
        return null;
    }

    protected abstract void execute(RequestContext var1, WTCTaskParam var2);

    protected boolean isBizEnd(long subTaskId) {
        return false;
    }

    protected boolean onSubTaskTerminatedBeforeExecute(WTCTaskParam taskParam) {
        return true;
    }

    protected boolean retry(WTCTaskParam taskParam, Throwable throwable) {
        return false;
    }

    protected boolean onBizCodeError(WTCTaskParam taskParam, Throwable throwable) {
        return false;
    }

    public static final class WTCShardingTaskHelper {
        private static final Map<Long, WTCShardingAbleTask> holder = new ConcurrentHashMap<Long, WTCShardingAbleTask>();

        private static WTCShardingAbleTask getExecutor(long subTaskId) {
            WTCShardingAbleTask executor = holder.get(subTaskId);
            if (executor == null) {
                throw new IllegalArgumentException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728SubTaskId=%s\u7684\u4efb\u52a1\u3002", (String)"WTCShardingAbleTask_0", (String)"wtc-wtbs-business", (Object[])new Object[]{subTaskId}));
            }
            return executor;
        }

        public static void reportProgress(long subTaskId, int progress) {
            WTCShardingAbleTask executor = WTCShardingTaskHelper.getExecutor(subTaskId);
            if (progress > 100) {
                progress = 100;
            }
            if (progress > executor.stRunLog.getProgress()) {
                executor.stRunLog.setUpdateTime(LocalDateTime.now());
                executor.stRunLog.setProgress(progress);
                stReporter.reportProgress(executor.stRunLog);
            }
        }

        public static void reportProgress(long subTaskId, int progress, String reportData) {
            WTCShardingAbleTask executor = WTCShardingTaskHelper.getExecutor(subTaskId);
            if (progress > 100) {
                progress = 100;
            }
            if (progress < executor.stRunLog.getProgress()) {
                progress = executor.stRunLog.getProgress();
            }
            executor.stRunLog.setUpdateTime(LocalDateTime.now());
            executor.stRunLog.setProgress(progress);
            executor.stRunLog.setReportData(reportData);
            stReporter.reportProgress(executor.stRunLog);
        }

        public static void stop(String msg) throws KDException {
            ErrorCode ec = new ErrorCode(WTCShardingAbleTask.TASK_STOPPED_BY_USER, msg);
            throw new KDException(ec, new Object[0]);
        }

        public static boolean isStop(long subTaskId) {
            return WTCShardingTaskHelper.getExecutor(subTaskId).isStop();
        }

        public static boolean isTimeOut(long subTaskId) {
            return WTCShardingTaskHelper.getExecutor(subTaskId).isTimeOut();
        }
    }
}

