/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.executor.center;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.wtc.wtbs.business.task.base.MainTask;
import kd.wtc.wtbs.business.task.base.MainTaskDetector;
import kd.wtc.wtbs.business.task.base.MainTaskDetectorImpl;
import kd.wtc.wtbs.business.task.base.MainTaskRunLog;
import kd.wtc.wtbs.business.task.base.TaskRepository;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public final class WTCMainExecutorRecycler
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(WTCMainExecutorRecycler.class);
    private static final TaskRepository taskRepository = TaskRepositoryImpl.getInstance();
    private static final MainTaskDetector mtDetector = new MainTaskDetectorImpl(taskRepository);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<MainTask> mainTaskList = taskRepository.loadAllNotEndMT();
        if (mainTaskList.isEmpty()) {
            return;
        }
        List<MainTaskRunLog> mainTaskRunLogs = taskRepository.loadEffectiveMTRL(mainTaskList.stream().map(MainTask::getId).collect(Collectors.toList()));
        Map<Long, MainTaskRunLog> mtrlCluster = mainTaskRunLogs.stream().collect(Collectors.toMap(MainTaskRunLog::getMainTaskId, mtrl -> mtrl, (oldEle, newEle) -> newEle));
        for (MainTask mainTask : mainTaskList) {
            long mainTaskId = mainTask.getId();
            MainTaskRunLog mtrl2 = mtrlCluster.get(mainTaskId);
            if (mtrl2 != null && mtDetector.isExecutorAlive(mtrl2)) continue;
            LOGGER.info("WTCMainExecutorRecycler determine to restart MT[id={}].", (Object)mainTaskId);
            WTCMainExecutorRecycler.bootMT(mainTask);
        }
    }

    public static void tryBootMT(long mtId) {
        MainTask mainTask = taskRepository.loadMT(mtId);
        if (mainTask.getTaskStatus().isEnd()) {
            return;
        }
        MainTaskRunLog mtrl = taskRepository.loadEffectiveMTRL(mtId);
        if (mtrl != null && mtDetector.isExecutorAlive(mtrl)) {
            return;
        }
        WTCMainExecutorRecycler.bootMT(mainTask);
    }

    private static void bootMT(MainTask mainTask) {
        WTCTaskRequest taskRequest = (WTCTaskRequest)WTCSerializationUtils.deSerializeFromBase64((String)mainTask.getTaskReqStr());
        String appId = taskRequest.getAppId();
        if (WTCStringUtils.isEmpty((String)appId)) {
            String guessAppId = WTCMainExecutorRecycler.getAppId(taskRequest.getCategory());
            if (guessAppId == null) {
                LOGGER.info("WTCMainExecutorRecycler can not find appId for restart MT={}\n, taskReq={}.", (Object)mainTask, (Object)taskRequest);
            }
            taskRequest.setAppId(guessAppId);
        }
        JobInfo mainTaskExecutorJobInfo = WTCDistributeTaskHelper.getMainTaskExecutorJobInfo(taskRequest, null);
        ScheduleServiceHelper.dispatch((JobInfo)mainTaskExecutorJobInfo);
    }

    private static String getAppId(String category) {
        if ("wtte_tie".equals(category)) {
            return "wtte";
        }
        if ("wtpm_match".equals(category)) {
            return "wtpm";
        }
        if ("wts_roster".equals(category)) {
            return "wts";
        }
        if ("wtis_payatt".equals(category)) {
            return "wts";
        }
        if ("wtpm_supsign".equals(category)) {
            return "wtpm";
        }
        if ("wtpm_signcard".equals(category)) {
            return "wtpm";
        }
        if ("wtte_qttie".equals(category)) {
            return "wtte";
        }
        if ("wtte_settle".equals(category)) {
            return "wtte";
        }
        if ("wtp_period".equals(category)) {
            return "wtp";
        }
        if ("wtpm_billtask".equals(category)) {
            return "wtpm";
        }
        return null;
    }
}

