/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.executor.center;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;

public final class WTCShardingExecutorManager {
    private static boolean ENABLE_NODE_MAX_CONCURRENT_LIMIT = Boolean.parseBoolean(System.getProperty("wtc.task.st.enable.max.concurrent", "false"));
    private static final int MAX_CONCURRENT = Integer.parseInt(System.getProperty("wtc.task.st.max.concurrent", "8"));
    private static final Map<Long, WTCShardingAbleTask> holder = new ConcurrentHashMap<Long, WTCShardingAbleTask>(16);
    private static final AtomicInteger state = new AtomicInteger(0);

    public static boolean tryExecute(long shardingTaskId, WTCShardingAbleTask stExecutor) {
        int tar;
        if (!ENABLE_NODE_MAX_CONCURRENT_LIMIT) {
            return true;
        }
        int count = state.get();
        if (count < MAX_CONCURRENT && state.compareAndSet(count, tar = count + 1)) {
            holder.put(shardingTaskId, stExecutor);
            return true;
        }
        return false;
    }

    public static void end(long shardingTaskId) {
        if (ENABLE_NODE_MAX_CONCURRENT_LIMIT && holder.remove(shardingTaskId) != null) {
            state.getAndDecrement();
        }
    }
}

