/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.executor.center;

import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.wtc.wtbs.business.task.base.ErrorMsgUtils;
import kd.wtc.wtbs.business.task.base.ShardingTaskExLog;
import kd.wtc.wtbs.business.task.base.ShardingTaskProgressReporter;
import kd.wtc.wtbs.business.task.base.ShardingTaskProgressReporterImpl;
import kd.wtc.wtbs.business.task.base.TaskConfig;
import kd.wtc.wtbs.business.task.base.TaskRepositoryImpl;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.center.WTCShardingExecutorManager;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class WTCTaskConsumer
implements MessageConsumer {
    protected static final Log log = LogFactory.getLog(WTCTaskConsumer.class);
    private static long PARK_NANOS_BEFORE_DENY_MESSAGE = Long.parseLong(System.getProperty("wtc.task.st.park.nanos.befoer.deny", "5000000000"));
    private static volatile boolean BASED_RELIABLE_CHANNEL = Boolean.parseBoolean(System.getProperty("wtc.task.st.enable.reliable.channel", "true"));
    private static final ShardingTaskProgressReporter stReporter = new ShardingTaskProgressReporterImpl(TaskRepositoryImpl.getInstance());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        WTCShardingAbleTask shardingTaskExecutor;
        Map params = (Map)message;
        long tmpShardingTaskId = params.getOrDefault("WTCShardingTaskId", 0L);
        log.info("WTCTaskConsumer accept task[shardingTaskId={}] and then begin parse param.", (Object)tmpShardingTaskId);
        String category = String.valueOf(params.get("category"));
        if (WTCStringUtils.isEmpty((String)category)) {
            String errMsg = String.format("WTCTaskConsumer detected message illegal, the message field category=%s", category);
            log.info(errMsg);
            WTCTaskConsumer.reportError(tmpShardingTaskId, errMsg);
            messageAcker.deny(messageId);
            return;
        }
        try {
            shardingTaskExecutor = TaskConfig.getShardingTaskExecutor(category);
        }
        catch (Throwable exp) {
            String stackTraceMessage = "WTCTaskConsumer getShardingTaskExecutor error.\n" + ErrorMsgUtils.getStackTraceMessage(exp, 50);
            log.info(stackTraceMessage);
            WTCTaskConsumer.reportError(tmpShardingTaskId, stackTraceMessage);
            messageAcker.deny(messageId);
            return;
        }
        if (shardingTaskExecutor == null) {
            String errMsg = String.format("WTCTaskConsumer can not find ShardingTaskExecutor by category=%s", category);
            log.info(errMsg);
            WTCTaskConsumer.reportError(tmpShardingTaskId, errMsg);
            messageAcker.deny(messageId);
            return;
        }
        if (!WTCShardingExecutorManager.tryExecute(tmpShardingTaskId, shardingTaskExecutor)) {
            log.info("WTCTaskConsumer tryExecute shardingTask[shardingTaskId={}] fail, now deny it.", (Object)tmpShardingTaskId);
            LockSupport.parkNanos(PARK_NANOS_BEFORE_DENY_MESSAGE);
            messageAcker.deny(messageId);
            return;
        }
        try {
            if (!BASED_RELIABLE_CHANNEL) {
                messageAcker.ack(messageId);
            } else {
                shardingTaskExecutor.setMessageAckInfo(messageAcker, messageId);
            }
            log.info("WTCTaskConsumer all ready execute shardingTask[shardingTaskId={}]", (Object)tmpShardingTaskId);
            shardingTaskExecutor.execute(RequestContext.get(), params, null);
        }
        finally {
            WTCShardingExecutorManager.end(tmpShardingTaskId);
        }
    }

    private static void reportError(long shardingTaskId, String errMsg) {
        ShardingTaskExLog exLog = new ShardingTaskExLog();
        exLog.setShardingTaskId(shardingTaskId);
        exLog.setExStr(errMsg);
        stReporter.reportError(exLog);
    }

    public static boolean isBasedReliableChannel() {
        return BASED_RELIABLE_CHANNEL;
    }

    public static void setBasedReliableChannel(boolean basedReliableChannel) {
        BASED_RELIABLE_CHANNEL = basedReliableChannel;
    }
}

