/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskEntity;
import kd.wtc.wtbs.business.task.converter.WTCTaskConverter;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;

public abstract class AbstractWTCTaskRepository
implements WTCTaskRepository {
    private volatile HRBaseServiceHelper taskService;
    private volatile HRBaseServiceHelper subTaskService;
    protected volatile WTCTaskConverter wtcTaskConverter;

    public abstract String getTaskEntityNumber();

    public abstract String getSubTaskEntityNumber();

    public abstract void beforeSaveTask(WTCTaskEntity var1, DynamicObject var2);

    public abstract void beforeUpdateTask(WTCTaskEntity var1, DynamicObject var2);

    public abstract void beforeBatchSaveSubTask(List<WTCSubTaskEntity> var1, List<DynamicObject> var2);

    public abstract void beforeBatchUpdateSubTask(List<WTCSubTaskEntity> var1, List<DynamicObject> var2);

    public abstract void beforeUpdateSubTask(WTCSubTaskEntity var1, DynamicObject var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRBaseServiceHelper getTaskService() {
        if (this.taskService == null) {
            AbstractWTCTaskRepository abstractWTCTaskRepository = this;
            synchronized (abstractWTCTaskRepository) {
                if (this.taskService == null) {
                    this.taskService = new HRBaseServiceHelper(this.getTaskEntityNumber());
                }
            }
        }
        return this.taskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRBaseServiceHelper getSubTaskService() {
        if (this.subTaskService == null) {
            AbstractWTCTaskRepository abstractWTCTaskRepository = this;
            synchronized (abstractWTCTaskRepository) {
                if (this.subTaskService == null) {
                    this.subTaskService = new HRBaseServiceHelper(this.getSubTaskEntityNumber());
                }
            }
        }
        return this.subTaskService;
    }

    @Override
    public WTCTaskConverter getWTCTaskConverter() {
        return this.wtcTaskConverter;
    }

    @Override
    public void setWTCTaskConverter(WTCTaskConverter converter) {
        this.wtcTaskConverter = converter;
    }

    @Override
    public void saveTask(WTCTaskEntity task) {
        if (task == null) {
            return;
        }
        DynamicObject taskDyn = this.getWTCTaskConverter().convert2TaskDyn(task, this.getTaskEntityNumber());
        this.beforeSaveTask(task, taskDyn);
        this.saveTaskDyn(taskDyn);
        task.setId(taskDyn.getLong("id"));
    }

    @Override
    public void saveTaskDyn(DynamicObject taskDyn) {
        if (taskDyn == null) {
            return;
        }
        this.checkEntityType(taskDyn, this.getTaskEntityNumber());
        this.getTaskService().saveOne(taskDyn);
    }

    @Override
    public void updateTask(WTCTaskEntity task) {
        if (task == null) {
            return;
        }
        DynamicObject taskDyn = this.loadTaskDynByTaskId(task.getTaskId(), null);
        this.getWTCTaskConverter().transferTaskAttribute(task, taskDyn, false);
        this.beforeUpdateTask(task, taskDyn);
        this.updateTaskDyn(taskDyn);
    }

    @Override
    public void updateTaskDyn(DynamicObject taskDyn) {
        if (taskDyn == null) {
            return;
        }
        this.checkEntityType(taskDyn, this.getTaskEntityNumber());
        this.getTaskService().updateOne(taskDyn);
    }

    @Override
    public WTCTaskEntity loadTaskByTaskId(long taskId, QFilter customCondition) {
        DynamicObject taskDyn = this.loadTaskDynByTaskId(taskId, customCondition);
        return taskDyn == null ? null : this.getWTCTaskConverter().convert2Task(taskDyn);
    }

    @Override
    public DynamicObject loadTaskDynByTaskId(long taskId, QFilter customCondition) {
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        if (customCondition != null) {
            qFilter.and(customCondition);
        }
        return this.getTaskService().loadDynamicObject(qFilter);
    }

    @Override
    public void batchSaveSubTask(List<WTCSubTaskEntity> subTaskList) {
        if (subTaskList == null || subTaskList.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(subTaskList.size());
        HashMap<DynamicObject, WTCSubTaskEntity> map = new HashMap<DynamicObject, WTCSubTaskEntity>(subTaskList.size());
        for (WTCSubTaskEntity subTask : subTaskList) {
            DynamicObject dyn = this.getWTCTaskConverter().convert2SubTaskDyn(subTask, this.getSubTaskEntityNumber());
            dynList.add(dyn);
            map.put(dyn, subTask);
        }
        this.beforeBatchSaveSubTask(subTaskList, dynList);
        this.batchSaveSubTaskDyn(dynList);
        for (DynamicObject dyn : dynList) {
            WTCSubTaskEntity subTask = (WTCSubTaskEntity)map.get(dyn);
            if (subTask == null) continue;
            subTask.setId(dyn.getLong("id"));
        }
    }

    @Override
    public void batchSaveSubTaskDyn(List<DynamicObject> subTaskDynList) {
        if (subTaskDynList == null || subTaskDynList.isEmpty()) {
            return;
        }
        DynamicObjectCollection collection = this.checkEntityTypeAndCollectNotNullElement(subTaskDynList, this.getSubTaskEntityNumber());
        if (collection.isEmpty()) {
            return;
        }
        this.getSubTaskService().save(collection);
    }

    @Override
    public void updateSubTask(WTCSubTaskEntity subTask) {
        if (subTask == null) {
            return;
        }
        DynamicObject subTaskDyn = this.loadSubTaskDynByTaskId(subTask.getId());
        this.getWTCTaskConverter().transferSubTaskInfoAttribute(subTask, subTaskDyn);
        this.beforeUpdateSubTask(subTask, subTaskDyn);
        this.updateSubTaskDyn(subTaskDyn);
    }

    @Override
    public void updateSubTaskDyn(DynamicObject subTaskDyn) {
        if (subTaskDyn == null) {
            return;
        }
        this.checkEntityType(subTaskDyn, this.getSubTaskEntityNumber());
        this.getSubTaskService().updateOne(subTaskDyn);
    }

    @Override
    public void batchUpdateSubTask(List<WTCSubTaskEntity> subTaskList) {
        DynamicObject[] subTaskDynArr;
        if (subTaskList == null || subTaskList.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject[]> map = new HashMap<Long, DynamicObject[]>(subTaskList.size());
        Object[] subTaskPks = new Object[subTaskList.size()];
        for (int i = 0; i < subTaskList.size(); ++i) {
            DynamicObject[] subTask = subTaskList.get(i);
            subTaskPks[i] = subTask.getId();
            map.put(subTask.getId(), subTask);
        }
        for (DynamicObject subTaskDyn : subTaskDynArr = this.batchLoadSubTaskDynByPK(subTaskPks)) {
            WTCSubTaskEntity subTask = (WTCSubTaskEntity)map.get(subTaskDyn.getLong("id"));
            this.getWTCTaskConverter().transferSubTaskInfoAttribute(subTask, subTaskDyn);
        }
        List<DynamicObject> subTaskDynList = Arrays.stream(subTaskDynArr).collect(Collectors.toList());
        this.beforeBatchUpdateSubTask(subTaskList, subTaskDynList);
        this.batchUpdateSubTaskDyn(subTaskDynList);
    }

    @Override
    public void batchUpdateSubTaskDyn(List<DynamicObject> subTaskDynList) {
        if (subTaskDynList == null || subTaskDynList.isEmpty()) {
            return;
        }
        DynamicObjectCollection collection = this.checkEntityTypeAndCollectNotNullElement(subTaskDynList, this.getSubTaskEntityNumber());
        if (collection.isEmpty()) {
            return;
        }
        DynamicObject[] dynArr = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
        this.getSubTaskService().update(dynArr);
    }

    @Override
    public WTCSubTaskEntity loadSubTaskByTaskId(long subTaskId) {
        DynamicObject subTaskDyn = this.loadSubTaskDynByTaskId(subTaskId);
        return this.getWTCTaskConverter().convert2SubTask(subTaskDyn);
    }

    @Override
    public DynamicObject loadSubTaskDynByTaskId(long subTaskId) {
        return this.getSubTaskService().queryOne((Object)subTaskId);
    }

    @Override
    public DynamicObject[] batchLoadSubTaskDynByPK(Object[] pks) {
        return this.getSubTaskService().loadDynamicObjectArray(pks);
    }

    @Override
    public List<WTCSubTaskEntity> batchLoadSubTaskByTaskId(long taskId, QFilter customCondition) {
        return this.batchLoadSubTaskDynByTaskId(taskId, customCondition).stream().map(dyn -> this.getWTCTaskConverter().convert2SubTask((DynamicObject)dyn)).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> batchLoadSubTaskDynByTaskId(long taskId, QFilter customCondition) {
        DynamicObject[] subTaskDynArr;
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        if (customCondition != null) {
            qFilter.and(customCondition);
        }
        if ((subTaskDynArr = this.getSubTaskService().loadDynamicObjectArray(new QFilter[]{qFilter})).length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(subTaskDynArr).collect(Collectors.toList());
    }

    @Override
    public List<Long> batchLoadSubTaskIdByTaskId(long taskId, QFilter customCondition) {
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        if (customCondition != null) {
            qFilter.and(customCondition);
        }
        DynamicObject[] subTaskDynArr = this.getSubTaskService().query(new QFilter[]{qFilter});
        return Arrays.stream(subTaskDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public int countSubTask(long taskId, QFilter customCondition) {
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        if (customCondition != null) {
            qFilter.and(customCondition);
        }
        return this.getSubTaskService().count(this.getSubTaskEntityNumber(), new QFilter[]{qFilter});
    }

    protected void checkEntityType(DynamicObject dyn, String entityNumber) {
        if (!entityNumber.equals(dyn.getDataEntityType().getName())) {
            throw new IllegalArgumentException();
        }
    }

    protected DynamicObjectCollection checkEntityTypeAndCollectNotNullElement(List<DynamicObject> list, String entityNumber) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        if (list == null || list.isEmpty() || entityNumber == null || entityNumber.length() == 0) {
            return collection;
        }
        for (DynamicObject dyn : list) {
            if (dyn == null) continue;
            if (!entityNumber.equals(dyn.getDataEntityType().getName())) {
                throw new IllegalArgumentException();
            }
            collection.add((Object)dyn);
        }
        return collection;
    }
}

