/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.repository.std;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.converter.WTCTaskConverter;
import kd.wtc.wtbs.business.task.converter.std.WTCCalTaskConverter;
import kd.wtc.wtbs.business.task.converter.std.WTCTaskConverterStd;
import kd.wtc.wtbs.business.task.repository.AbstractWTCTaskRepository;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;

public abstract class AbstractWTCCalTaskRepository
extends AbstractWTCTaskRepository
implements WTCCalTaskRepository {
    private static final Log LOGGER = LogFactory.getLog(AbstractWTCCalTaskRepository.class);
    private volatile HRBaseServiceHelper taskDetailService;

    public abstract String getTaskDetailEntityNumber();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRBaseServiceHelper getTaskDetailService() {
        if (this.taskDetailService == null) {
            AbstractWTCCalTaskRepository abstractWTCCalTaskRepository = this;
            synchronized (abstractWTCCalTaskRepository) {
                if (this.taskDetailService == null) {
                    this.taskDetailService = new HRBaseServiceHelper(this.getTaskDetailEntityNumber());
                }
            }
        }
        return this.taskDetailService;
    }

    public abstract void beforeBatchSaveTaskDetail(List<WTCCalTaskDetailEntity> var1, List<DynamicObject> var2);

    public abstract void beforeBatchUpdateTaskDetail(List<WTCCalTaskDetailEntity> var1, List<DynamicObject> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WTCTaskConverter getWTCTaskConverter() {
        if (this.wtcTaskConverter == null) {
            AbstractWTCCalTaskRepository abstractWTCCalTaskRepository = this;
            synchronized (abstractWTCCalTaskRepository) {
                if (this.wtcTaskConverter == null) {
                    this.wtcTaskConverter = new WTCTaskConverterStd();
                }
            }
        }
        return this.wtcTaskConverter;
    }

    @Override
    public WTCCalTaskConverter getWTCCalTaskConverter() {
        return (WTCCalTaskConverter)this.getWTCTaskConverter();
    }

    @Override
    public void setWTCCalTaskConverter(WTCCalTaskConverter converter) {
        super.setWTCTaskConverter(converter);
    }

    @Override
    public Map<WTCTaskDetailStatus, Integer> countTaskDetailState(long taskId, long subTaskId) {
        if (taskId <= 0L && subTaskId <= 0L) {
            return new HashMap<WTCTaskDetailStatus, Integer>(16);
        }
        QFilter qFilter = null;
        if (taskId > 0L) {
            qFilter = new QFilter("taskid", "=", (Object)taskId);
        }
        if (subTaskId > 0L) {
            if (qFilter == null) {
                qFilter = new QFilter("subtaskid", "=", (Object)subTaskId);
            } else {
                qFilter.and("subtaskid", "=", (Object)subTaskId);
            }
        }
        DynamicObject[] query = this.getTaskDetailService().query("taskdetailstate", new QFilter[]{qFilter});
        int successCnt = 0;
        int failCun = 0;
        int noAccountCnt = 0;
        int accountingCnt = 0;
        for (DynamicObject dyn : query) {
            String state = dyn.getString("taskdetailstate");
            if (WTCTaskDetailStatus.SUCCESS.code.equals(state)) {
                ++successCnt;
                continue;
            }
            if (WTCTaskDetailStatus.FAIL.code.equals(state)) {
                ++failCun;
                continue;
            }
            if (WTCTaskDetailStatus.NOT_ACCOUNT.code.equals(state)) {
                ++noAccountCnt;
                continue;
            }
            if (!WTCTaskDetailStatus.ACCOUNTING.code.equals(state)) continue;
            ++accountingCnt;
        }
        HashMap<WTCTaskDetailStatus, Integer> res = new HashMap<WTCTaskDetailStatus, Integer>(16);
        res.put(WTCTaskDetailStatus.SUCCESS, successCnt);
        res.put(WTCTaskDetailStatus.FAIL, failCun);
        res.put(WTCTaskDetailStatus.NOT_ACCOUNT, noAccountCnt);
        res.put(WTCTaskDetailStatus.ACCOUNTING, accountingCnt);
        return res;
    }

    @Override
    public Map<String, Integer> taskDetailStateCount(long taskId, long subTaskId) {
        if (taskId <= 0L && subTaskId <= 0L) {
            return new HashMap<String, Integer>(16);
        }
        QFilter qFilter = null;
        if (taskId > 0L) {
            qFilter = new QFilter("taskid", "=", (Object)taskId);
        }
        if (subTaskId > 0L) {
            if (qFilter == null) {
                qFilter = new QFilter("subtaskid", "=", (Object)subTaskId);
            } else {
                qFilter.and("subtaskid", "=", (Object)subTaskId);
            }
        }
        String select = "taskdetailstate,attperson.id";
        DynamicObject[] query = this.getTaskDetailService().query(select, new QFilter[]{qFilter});
        int successCnt = 0;
        int failCun = 0;
        int noAccountCnt = 0;
        int accountingCnt = 0;
        for (DynamicObject dyn2 : query) {
            String state = dyn2.getString("taskdetailstate");
            if (WTCTaskDetailStatus.SUCCESS.code.equals(state)) {
                ++successCnt;
                continue;
            }
            if (WTCTaskDetailStatus.FAIL.code.equals(state)) {
                ++failCun;
                continue;
            }
            if (WTCTaskDetailStatus.NOT_ACCOUNT.code.equals(state)) {
                ++noAccountCnt;
                continue;
            }
            if (!WTCTaskDetailStatus.ACCOUNTING.code.equals(state)) continue;
            ++accountingCnt;
        }
        int successPerson = 0;
        int failPerson = 0;
        int noAccountPerson = 0;
        Map<Long, List<DynamicObject>> listMap = Arrays.asList(query).stream().collect(Collectors.groupingBy(dy -> dy.getLong("attperson.id")));
        for (Map.Entry entry : listMap.entrySet()) {
            List value = (List)entry.getValue();
            long notAccountBo = value.stream().filter(dyn -> WTCTaskDetailStatus.NOT_ACCOUNT.getCode().equals(dyn.getString("taskdetailstate"))).count();
            if (notAccountBo == (long)value.size()) {
                ++noAccountPerson;
                continue;
            }
            long successBo = value.stream().filter(dyn -> WTCTaskDetailStatus.SUCCESS.getCode().equals(dyn.getString("taskdetailstate"))).count();
            if (successBo == (long)value.size()) {
                ++successPerson;
                continue;
            }
            ++failPerson;
        }
        HashMap<String, Integer> res = new HashMap<String, Integer>(16);
        res.put("succeedattfile", successCnt);
        res.put("failedattfile", failCun);
        res.put("notrunattfile", noAccountCnt);
        res.put("totalattfile", query.length);
        res.put("totalattperson", listMap.size());
        res.put("succeedattperson", successPerson);
        res.put("failedattperson", failPerson);
        res.put("notrunattperson", noAccountPerson);
        return res;
    }

    @Override
    public void batchSaveTaskDetail(List<WTCCalTaskDetailEntity> taskDetailList) {
        if (taskDetailList == null || taskDetailList.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(taskDetailList.size());
        HashMap<DynamicObject, WTCCalTaskDetailEntity> map = new HashMap<DynamicObject, WTCCalTaskDetailEntity>(taskDetailList.size());
        for (WTCCalTaskDetailEntity taskDetail : taskDetailList) {
            DynamicObject dyn = this.getWTCCalTaskConverter().convert2TaskDetailDyn(taskDetail, this.getTaskDetailEntityNumber());
            dynList.add(dyn);
            map.put(dyn, taskDetail);
        }
        this.beforeBatchSaveTaskDetail(taskDetailList, dynList);
        this.batchSaveTaskDetailDyn(dynList);
        for (DynamicObject dyn : dynList) {
            WTCCalTaskDetailEntity taskDetail = (WTCCalTaskDetailEntity)map.get(dyn);
            if (taskDetail == null) continue;
            taskDetail.setId(dyn.getLong("id"));
        }
    }

    @Override
    public void batchSaveTaskDetailDyn(List<DynamicObject> taskDetailDynList) {
        if (taskDetailDynList == null || taskDetailDynList.isEmpty()) {
            return;
        }
        DynamicObjectCollection collection = this.checkEntityTypeAndCollectNotNullElement(taskDetailDynList, this.getTaskDetailEntityNumber());
        if (collection.isEmpty()) {
            return;
        }
        this.getTaskDetailService().save(collection);
    }

    @Override
    public void updateTaskDetailInfoByCustomQFilter(WTCCalTaskDetailEntity taskDetail, QFilter customQFilter) {
        if (customQFilter == null) {
            return;
        }
        List<DynamicObject> dynList = this.batchLoadTaskDetailDynByTaskIdAndSubTaskId(0L, 0L, customQFilter);
        if (dynList.isEmpty()) {
            return;
        }
        for (DynamicObject dyn : dynList) {
            this.getWTCCalTaskConverter().transferTaskDetailDynInfoAttribute(taskDetail, dyn);
        }
        this.batchUpdateTaskDetailDyn(dynList);
    }

    @Override
    public void batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId(List<WTCCalTaskDetailEntity> taskDetailList) {
        if (taskDetailList.isEmpty()) {
            return;
        }
        Function<WTCCalTaskDetailEntity, String> keyGenerator4Detail = detail -> detail.getSubTaskId() + "-" + detail.getAttFileBoId();
        Function<DynamicObject, String> keyGenerator4Dyn = dyn -> dyn.getLong("subtaskid") + "-" + dyn.getLong("attfileboid.id");
        HashMap<String, WTCCalTaskDetailEntity> map = new HashMap<String, WTCCalTaskDetailEntity>(taskDetailList.size());
        HashSet<Long> expectUpdateBoID = new HashSet<Long>(taskDetailList.size());
        for (WTCCalTaskDetailEntity detail2 : taskDetailList) {
            expectUpdateBoID.add(detail2.getAttFileBoId());
            map.put(keyGenerator4Detail.apply(detail2), detail2);
        }
        long taskId = taskDetailList.get(0).getTaskId();
        long subTaskId = taskDetailList.get(0).getSubTaskId();
        QFilter qFilter = new QFilter("attfileboid.id", "in", expectUpdateBoID);
        List<DynamicObject> dynList = this.batchLoadTaskDetailDynByTaskIdAndSubTaskId(taskId, subTaskId, qFilter);
        int expectUpdateBoIDCnt = expectUpdateBoID.size();
        for (DynamicObject dyn2 : dynList) {
            WTCCalTaskDetailEntity detail3 = (WTCCalTaskDetailEntity)map.get(keyGenerator4Dyn.apply(dyn2));
            if (detail3 == null) continue;
            expectUpdateBoID.remove(detail3.getAttFileBoId());
            this.getWTCCalTaskConverter().transferTaskDetailDynInfoAttribute(detail3, dyn2);
        }
        if (expectUpdateBoID.size() > 0) {
            LOGGER.warn("detail_update_warn: expectUpdateBoID size={}, but occur can't update fileBo={}", (Object)expectUpdateBoIDCnt, expectUpdateBoID);
            List collect = taskDetailList.stream().filter(ele -> expectUpdateBoID.contains(ele.getAttFileBoId())).collect(Collectors.toList());
            LOGGER.warn("detail_update_warn: can't update fileBo={}", collect);
        }
        this.batchUpdateTaskDetailDyn(dynList);
    }

    @Override
    public void batchUpdateTaskDetailById(List<WTCCalTaskDetailEntity> taskDetailList) {
        DynamicObject[] dynList;
        if (taskDetailList.isEmpty()) {
            return;
        }
        Map taskDetailEntityMap = taskDetailList.stream().collect(Collectors.toMap(WTCCalTaskDetailEntity::getId, Function.identity()));
        for (DynamicObject dyn : dynList = this.batchLoadTaskDetailDynByPK(taskDetailEntityMap.keySet().toArray())) {
            WTCCalTaskDetailEntity detailEntity = (WTCCalTaskDetailEntity)taskDetailEntityMap.get(dyn.getLong("id"));
            if (detailEntity == null) continue;
            this.getWTCCalTaskConverter().transferTaskDetailDynInfoAttribute(detailEntity, dyn);
        }
        this.batchUpdateTaskDetailDyn(Arrays.asList(dynList));
    }

    @Override
    public void batchUpdateTaskDetailInfoBySubTaskIdAndAttFileId(List<WTCCalTaskDetailEntity> taskDetailList) {
        if (taskDetailList.isEmpty()) {
            return;
        }
        long taskId = taskDetailList.get(0).getTaskId();
        long subTaskId = taskDetailList.get(0).getSubTaskId();
        Function<WTCCalTaskDetailEntity, String> keyGenerator4Detail = detail -> detail.getSubTaskId() + "-" + detail.getAttFileId();
        Function<DynamicObject, String> keyGenerator4Dyn = dyn -> dyn.getLong("subtaskid") + "-" + dyn.getLong("attfile.id");
        HashMap<String, WTCCalTaskDetailEntity> map = new HashMap<String, WTCCalTaskDetailEntity>(taskDetailList.size());
        ArrayList<Long> attFileVidList = new ArrayList<Long>(taskDetailList.size());
        for (WTCCalTaskDetailEntity detail2 : taskDetailList) {
            attFileVidList.add(detail2.getAttFileId());
            map.put(keyGenerator4Detail.apply(detail2), detail2);
        }
        QFilter qFilter = new QFilter("attfile", "in", attFileVidList);
        List<DynamicObject> dynList = this.batchLoadTaskDetailDynByTaskIdAndSubTaskId(taskId, subTaskId, qFilter);
        for (DynamicObject dyn2 : dynList) {
            WTCCalTaskDetailEntity detail3 = (WTCCalTaskDetailEntity)map.get(keyGenerator4Dyn.apply(dyn2));
            if (detail3 == null) continue;
            this.getWTCCalTaskConverter().transferTaskDetailDynInfoAttribute(detail3, dyn2);
        }
        this.batchUpdateTaskDetailDyn(dynList);
    }

    @Override
    public void batchUpdateTaskDetailPermBySubTaskIdAndAttFileXId(List<WTCCalTaskDetailEntity> taskDetailList, boolean useFileBoId) {
        if (taskDetailList.isEmpty()) {
            return;
        }
        Function<WTCCalTaskDetailEntity, String> keyGenerator4Detail = detail -> detail.getSubTaskId() + "-" + detail.getAttFileBoId();
        Function<DynamicObject, String> keyGenerator4Dyn = dyn -> dyn.getLong("subtaskid") + "-" + dyn.getLong("attfileboid.id");
        if (!useFileBoId) {
            keyGenerator4Detail = detail -> detail.getSubTaskId() + "-" + detail.getAttFileId();
            keyGenerator4Dyn = dyn -> dyn.getLong("subtaskid") + "-" + dyn.getLong("attfile.id");
        }
        HashMap<String, WTCCalTaskDetailEntity> map = new HashMap<String, WTCCalTaskDetailEntity>(taskDetailList.size());
        QFilter qFilter = null;
        for (WTCCalTaskDetailEntity detail2 : taskDetailList) {
            QFilter tmpQFilter = new QFilter("subtaskid", "=", (Object)detail2.getSubTaskId()).and("attfile", "=", (Object)detail2.getAttFileId());
            if (qFilter == null) {
                qFilter = tmpQFilter;
            } else {
                qFilter.or(tmpQFilter);
            }
            map.put(keyGenerator4Detail.apply(detail2), detail2);
        }
        List<DynamicObject> dynList = this.batchLoadTaskDetailDynByTaskIdAndSubTaskId(0L, 0L, qFilter);
        for (DynamicObject dyn2 : dynList) {
            WTCCalTaskDetailEntity detail3 = (WTCCalTaskDetailEntity)map.get(keyGenerator4Dyn.apply(dyn2));
            if (detail3 == null) continue;
            this.getWTCCalTaskConverter().transferTaskDetailDynPermAttribute(detail3, dyn2);
        }
        this.batchUpdateTaskDetailDyn(dynList);
    }

    @Override
    public void batchUpdateTaskDetail(List<WTCCalTaskDetailEntity> taskDetailList) {
        DynamicObject[] detailDynArr;
        if (taskDetailList == null || taskDetailList.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject[]> map = new HashMap<Long, DynamicObject[]>(taskDetailList.size());
        Object[] detailPkArr = new Object[taskDetailList.size()];
        for (int i = 0; i < taskDetailList.size(); ++i) {
            DynamicObject[] detail = taskDetailList.get(i);
            detailPkArr[i] = detail.getId();
            map.put(detail.getId(), detail);
        }
        for (DynamicObject detailDyn : detailDynArr = this.batchLoadTaskDetailDynByPK(detailPkArr)) {
            WTCCalTaskDetailEntity detail = (WTCCalTaskDetailEntity)map.get(detailDyn.getLong("id"));
            this.getWTCCalTaskConverter().transferTaskDetailDynAttribute(detail, detailDyn, false);
        }
        List<DynamicObject> taskDetailDynList = Arrays.stream(detailDynArr).collect(Collectors.toList());
        this.beforeBatchUpdateTaskDetail(taskDetailList, taskDetailDynList);
        this.batchUpdateTaskDetailDyn(taskDetailDynList);
    }

    @Override
    public void batchUpdateTaskDetailDyn(List<DynamicObject> taskDetailDynList) {
        if (taskDetailDynList == null || taskDetailDynList.isEmpty()) {
            return;
        }
        DynamicObjectCollection collection = this.checkEntityTypeAndCollectNotNullElement(taskDetailDynList, this.getTaskDetailEntityNumber());
        if (collection.isEmpty()) {
            return;
        }
        DynamicObject[] dynArr = (DynamicObject[])collection.toArray((Object[])new DynamicObject[0]);
        this.getTaskDetailService().update(dynArr);
    }

    @Override
    public DynamicObject[] batchLoadTaskDetailDynByPK(Object[] pks) {
        return this.getTaskDetailService().loadDynamicObjectArray(pks);
    }

    @Override
    public List<WTCCalTaskDetailEntity> batchLoadTaskDetailByPK(Object[] pks) {
        DynamicObject[] detailArr = this.batchLoadTaskDetailDynByPK(pks);
        return Arrays.stream(detailArr).map(detailDyn -> this.getWTCCalTaskConverter().convert2TaskDetail((DynamicObject)detailDyn)).collect(Collectors.toList());
    }

    @Override
    public List<WTCCalTaskDetailEntity> batchLoadTaskDetailByTaskIdAndSubTaskId(long taskId, long subTaskId, QFilter customCondition) {
        return this.batchLoadTaskDetailDynByTaskIdAndSubTaskId(taskId, subTaskId, customCondition).stream().map(dyn -> this.getWTCCalTaskConverter().convert2TaskDetail((DynamicObject)dyn)).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> batchLoadTaskDetailDynByTaskIdAndSubTaskId(long taskId, long subTaskId, QFilter customCondition) {
        if (taskId <= 0L && subTaskId <= 0L && customCondition == null) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("taskid", ">", (Object)0);
        if (taskId > 0L) {
            qFilter = new QFilter("taskid", "=", (Object)taskId);
        }
        if (subTaskId > 0L) {
            qFilter.and("subtaskid", "=", (Object)subTaskId);
        }
        if (customCondition != null) {
            qFilter.and(customCondition);
        }
        return Arrays.stream(this.getTaskDetailService().loadDynamicObjectArray(new QFilter[]{qFilter})).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> batchLoadTaskDetailDyn(String selectKey, long taskId, long subTaskId, QFilter customCondition, String orderBys) {
        if (selectKey == null) {
            return this.batchLoadTaskDetailDynByTaskIdAndSubTaskId(taskId, subTaskId, customCondition);
        }
        if (taskId <= 0L && subTaskId <= 0L && customCondition == null) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("taskid", ">", (Object)0);
        if (taskId > 0L) {
            qFilter = new QFilter("taskid", "=", (Object)taskId);
        }
        if (subTaskId > 0L) {
            qFilter.and("subtaskid", "=", (Object)subTaskId);
        }
        if (customCondition != null) {
            qFilter.and(customCondition);
        }
        if (orderBys != null) {
            return Arrays.stream(this.getTaskDetailService().queryOriginalArray(selectKey, qFilter.toArray(), orderBys)).collect(Collectors.toList());
        }
        return Arrays.stream(this.getTaskDetailService().queryOriginalArray(selectKey, qFilter.toArray())).collect(Collectors.toList());
    }
}

