/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.sharding;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;

public class WTCTaskShardingConfig
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(WTCTaskShardingConfig.class);
    private static final long serialVersionUID = 9127385010840174796L;
    private static final Double GB = 1.073741824E9;
    private static final Double MEMORY_BASE = WTCAppContextHelper.getProjectParams().getDouble("wtc.task.memory.base", Double.valueOf(5.5));
    private static final Double CORE_BASE = WTCAppContextHelper.getProjectParams().getDouble("wtc.task.core.base", Double.valueOf(2.0));
    private static final Double RECORD_COUNT_BASE = WTCAppContextHelper.getProjectParams().getDouble("wtc.task.record.count.base", Double.valueOf(400.0));
    private static final int SHARDING_LIMIT_BASE = WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.task.shardingLimit", 250);

    public int getShardingLimit() {
        return WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.task.shardingLimit", 250);
    }

    public int getShardingLimitByHardware() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        double jVMmaxMemory = (double)Runtime.getRuntime().maxMemory() / GB;
        int recordCountOneDay = this.getRecordCountOfMonth();
        double coefficientA = Math.min((double)availableProcessors / CORE_BASE, 1.0) * Math.min(jVMmaxMemory / MEMORY_BASE, 1.0);
        double coefficientB = Math.min(RECORD_COUNT_BASE / (double)recordCountOneDay, 1.0);
        int times = (int)Math.round((double)SHARDING_LIMIT_BASE * (coefficientA * coefficientB) / 50.0);
        LOGGER.info("times={},availableProcessors={},jVMmaxMemory={},recordCountOneDay={}", new Object[]{times, availableProcessors, jVMmaxMemory, recordCountOneDay});
        return Math.max(50, 50 * times);
    }

    private int getRecordCountOfMonth() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_sysstat");
        QFilter[] qFilters = new QFilter[]{new QFilter("key", "=", (Object)"recordCountAvgMonth")};
        DynamicObject dynamicObject = serviceHelper.queryOne("content", qFilters, "createtime desc");
        if (dynamicObject != null) {
            String content = dynamicObject.getString("content");
            return Integer.parseInt(content);
        }
        return 300;
    }

    public int getEnableShardingThreadHold() {
        return WTCAppContextHelper.getProjectParams().getIntValue("kd.wtc.wtbs.task.enableShardingThreadHold", 50);
    }

    public List<String> getShardingKeys() {
        List shardingKeys = (List)JSONObject.parseObject((String)WTCAppContextHelper.getProjectParams().getString("kd.wtc.wtbs.task.shardingKeys", "[\"attPersonId\"]"), List.class);
        return shardingKeys;
    }
}

