/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.sharding.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.id.IDService;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.common.WTCTaskRequest;
import kd.wtc.wtbs.business.task.sharding.AbsWTCTaskShardingService;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;
import kd.wtc.wtbs.business.task.sharding.WTCTaskShardingConfig;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class WTCCalTaskShardingServiceImpl
extends AbsWTCTaskShardingService {
    private WTCTaskRequest taskRequest;

    @Override
    public List<WTCShardingTask> shard() {
        List<Map<String, Object>> detail = this.taskRequest.getDetail();
        Map<Object, List<Map>> personGroup = detail.stream().collect(Collectors.groupingBy(x$0 -> super.getShardingKeys((Map<String, Object>)x$0)));
        int count = detail.size();
        int pageSize = this.getCalTaskSharingConfig().getShardingLimit();
        int countStep = (count + pageSize - 1) / pageSize;
        ArrayList<Object> listGroupKeys = new ArrayList<Object>(personGroup.keySet());
        listGroupKeys.sort(Comparator.comparing(Object::toString));
        ArrayList shardResult = Lists.newArrayListWithExpectedSize((int)countStep);
        AtomicInteger personSkip = new AtomicInteger();
        long[] ids = IDService.get().genLongIds(countStep);
        for (int val = 0; val < countStep; ++val) {
            WTCShardingTask task = new WTCShardingTask();
            task.setTaskId(this.taskRequest.getTaskId());
            task.setSubTaskId(ids[val]);
            task.setIndex(val + 1);
            ArrayList taskDetails = Lists.newArrayList();
            List matchIds = listGroupKeys.stream().skip(personSkip.get()).collect(Collectors.toList());
            for (Object groupKey : matchIds) {
                personSkip.getAndIncrement();
                taskDetails.addAll((Collection)personGroup.get(groupKey));
                if (taskDetails.size() < pageSize) continue;
                break;
            }
            if (CollectionUtils.isEmpty((Collection)taskDetails)) continue;
            task.setTaskShardingDetails(this.listShardingDetails(taskDetails));
            shardResult.add(task);
        }
        return shardResult;
    }

    public List<Object> listShardingDetails(List<Map<String, Object>> taskDetails) {
        return taskDetails.stream().map(this::shardingDetail).collect(Collectors.toList());
    }

    @Override
    public boolean isShardingNecessary() {
        return true;
    }

    @Override
    public void setTaskRequest(WTCTaskRequest taskRequest) {
        this.taskRequest = taskRequest;
    }

    @Override
    protected WTCTaskShardingConfig getCalTaskSharingConfig() {
        return WTCTaskInstanceHelper.getObjectFactory(this.taskRequest).getShardingConfig();
    }
}

