/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.trace;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.report.TieReportSaveRequest;
import kd.wtc.wtbs.business.report.calreport.Label;
import kd.wtc.wtbs.business.report.calreport.LabelTypeEnum;
import kd.wtc.wtbs.business.report.calreport.ReportNode;
import kd.wtc.wtbs.business.task.trace.SpanData;
import kd.wtc.wtbs.business.task.trace.SpanImpl;
import kd.wtc.wtbs.business.task.trace.TaskDesc;
import kd.wtc.wtbs.business.task.trace.TaskTraceConfig;
import kd.wtc.wtbs.business.task.trace.TraceLabel;
import kd.wtc.wtbs.business.task.trace.TraceLevel;
import kd.wtc.wtbs.business.util.TieCalReportUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;

public class ReportNodePortable {
    private Map<Long, ReportNode> nodeMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
    private TieReportSaveRequest reportSaveRequest;
    private ReportNode rootNode;

    public void rootReportNode(TaskDesc taskDesc, TaskTraceConfig taskTraceConfig, SpanImpl rootSpan) {
        this.reportSaveRequest = new TieReportSaveRequest();
        this.reportSaveRequest.setTaskVersion(taskDesc.getVersion());
        this.reportSaveRequest.setTaskId(taskDesc.getMainTaskId());
        this.reportSaveRequest.setSubTaskId(taskDesc.getSubTaskId());
        this.reportSaveRequest.setShardingIndex(taskDesc.getShardingIndex());
        this.reportSaveRequest.setCreatorId(taskDesc.getCreatorId());
        this.reportSaveRequest.setCategory(taskDesc.getType());
    }

    public void saveReport() {
        this.reportSaveRequest.setReportNode(this.rootNode);
        this.rootNode.setVersion(this.reportSaveRequest.getTaskVersion());
        this.fillRootReportNode(this.rootNode);
        this.linkAllNode(this.nodeMap);
        TieCalReportUtil.markElapsedTop(this.rootNode, 3);
        TieCalReportUtil.saveCalculateReport(this.reportSaveRequest);
    }

    private void linkAllNode(Map<Long, ReportNode> nodeMap) {
        for (ReportNode node : nodeMap.values()) {
            long parentId = node.getParentId();
            ReportNode parentNode = nodeMap.get(parentId);
            if (parentNode == null) continue;
            parentNode.appendChildren(node);
        }
    }

    public synchronized void addSpanData(SpanData spanData) {
        ReportNode reportNode = this.spanDataToReportNode(spanData);
        this.nodeMap.put(reportNode.getId(), reportNode);
        this.rootNode = reportNode;
    }

    ReportNode spanDataToReportNode(SpanData spanData) {
        ReportNode reportNode = new ReportNode();
        long startTime = WTCDateUtils.toDate((LocalDateTime)spanData.getStartTime()).getTime();
        reportNode.setStartTime(startTime);
        reportNode.setEndTime(startTime + spanData.getDurationInMillis());
        reportNode.setCreateId(this.reportSaveRequest.getCreatorId());
        reportNode.setGroup(spanData.getName());
        List<TraceLabel> labels = spanData.getLabels();
        this.appendLabels(labels, reportNode);
        reportNode.setId(spanData.getSpanId());
        reportNode.setParentId(spanData.getParentSpanId());
        this.fillNormalReportNode(reportNode);
        return reportNode;
    }

    private void appendLabels(List<TraceLabel> labels, ReportNode reportNode) {
        for (TraceLabel label : labels) {
            reportNode.appendLabel(this.toLabel(label));
            if (TraceLevel.ERROR != label.getLevel()) continue;
            reportNode.setColor("#DC143C");
        }
    }

    private void fillNormalReportNode(ReportNode reportNode) {
        reportNode.appendLabel(TieCalReportUtil.newLabel(CalcReportConstants.START_TIME, new SimpleDateFormat("HH:mm:ss").format(reportNode.getStartTime())));
        reportNode.appendLabel(TieCalReportUtil.generalElapsedLabel(reportNode.getElapsedMilliSecond()));
    }

    private void fillRootReportNode(ReportNode rootNode) {
        rootNode.appendLabel(TieCalReportUtil.newLabel(CalcReportConstants.VERSION, rootNode.getVersion()));
        rootNode.appendLabel(TieCalReportUtil.newLabel(CalcReportConstants.END_TIME, new SimpleDateFormat("HH:mm:ss").format(rootNode.getEndTime())));
        if (null != rootNode.getRemark()) {
            rootNode.appendLabel(TieCalReportUtil.newLabel(CalcReportConstants.RESULT_FAILED_REMARK, rootNode.getRemark()));
            rootNode.setColor("#DC143C");
            rootNode.setRemark(null);
        }
        rootNode.appendLabel(TieCalReportUtil.newLabel(CalcReportConstants.CREATOR, rootNode.getCreateId()));
    }

    Label toLabel(TraceLabel traceLabel) {
        Label label = TieCalReportUtil.newLabel(traceLabel.getKey(), traceLabel.getValue());
        label.setType(traceLabel.isHuge() ? LabelTypeEnum.CLICK.getType() : LabelTypeEnum.VIEW.getType());
        label.setVid(String.valueOf(traceLabel.getValueId()));
        return label;
    }
}

