/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.trace;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.wtc.wtbs.business.task.trace.LabelValueSupplier;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.SpanData;
import kd.wtc.wtbs.business.task.trace.TaskTraceSupport;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.business.task.trace.TraceLabel;
import kd.wtc.wtbs.business.task.trace.TraceLabelType;
import kd.wtc.wtbs.business.task.trace.TraceLevel;
import kd.wtc.wtbs.common.lang.WTCException;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

abstract class SpanImpl
implements Span,
Cloneable {
    SpanData data = new SpanData();

    public SpanImpl(String name, long spanId, long parentSpanId, int depth) {
        this.data.spanId = spanId;
        this.data.parentSpanId = parentSpanId;
        this.data.name = name;
        this.data.depth = depth;
        RequestContext requestContext = RequestContext.get();
        if (requestContext != null) {
            this.data.kdTraceId = requestContext.getTraceId();
        }
        if (this.data.kdTraceId == null) {
            this.data.kdTraceId = "";
        }
    }

    public SpanImpl clone() {
        try {
            SpanImpl clone = (SpanImpl)super.clone();
            clone.data.labels = new ArrayList<TraceLabel>();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new WTCException((Throwable)e);
        }
    }

    static class Exceed
    extends SpanImpl {
        public Exceed(String name, long spanId, long parentSpanId, int depth) {
            super(name, spanId, parentSpanId, depth);
        }

        @Override
        public Span debug(String key, Object value) {
            return this;
        }

        @Override
        public Span info(String key, Object value) {
            return this;
        }

        @Override
        public Span warn(String key, Object value) {
            return this;
        }

        @Override
        public Span error(String key, Object value) {
            return this;
        }

        @Override
        public Span dataInDebug(String key, Object value) {
            return this;
        }

        @Override
        public Span dataInInfo(String key, Object value) {
            return this;
        }

        @Override
        public Span dataInWarn(String key, Object value) {
            return this;
        }

        @Override
        public Span dataInError(String key, Object value) {
            return null;
        }

        @Override
        public Span startTime(LocalDateTime startTime) {
            return this;
        }

        @Override
        public Span durationInMills(long durationInMills) {
            return this;
        }

        @Override
        public void close() {
            TaskTracer taskTracer = TaskTracer.getLocal();
            taskTracer.closeSpan(this);
            this.data.labels = null;
        }
    }

    static class Debug
    extends Info {
        public Debug(String name, long spanId, long parentSpanId, int depth) {
            super(name, spanId, parentSpanId, depth);
        }

        @Override
        public Span debug(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.PLAIN, TraceLevel.DEBUG);
            return this;
        }

        @Override
        public Span dataInDebug(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.JSON, TraceLevel.DEBUG);
            return this;
        }
    }

    static class Info
    extends SpanImpl {
        int presentLabelCount;
        static final int LABEL_VAL_SHORT_LEN = 50;
        static final int MAX_LABEL_COUNT = 100;

        public Info(String name, long spanId, long parentSpanId, int depth) {
            super(name, spanId, parentSpanId, depth);
            this.data.startTime = LocalDateTime.now();
        }

        protected void appendLabel(String key, Object value, TraceLabelType labelType, TraceLevel level) {
            TraceLabel label;
            if (++this.presentLabelCount > 100) {
                return;
            }
            String valStr = labelType == TraceLabelType.PLAIN ? (value instanceof String ? (String)value : (value instanceof LabelValueSupplier ? (String)((LabelValueSupplier)value).get() : WTCStringUtils.toStr((Object)value))) : (value instanceof String ? (String)value : (value instanceof LabelValueSupplier ? (String)((LabelValueSupplier)value).get() : (value == null ? "{}" : WTCSerializationUtils.toJsonString((Object)value))));
            if (TaskTraceSupport.isHugeLabelValue(valStr)) {
                long valueId = TaskTraceSupport.saveHugeLabelValue(this.data.spanId, valStr);
                String sortVal = WTCStringUtils.subStr((String)valStr, (int)50);
                label = new TraceLabel(key, sortVal, valueId, labelType, level);
            } else {
                label = new TraceLabel(key, valStr, labelType, level);
            }
            this.data.addLabel(label);
        }

        @Override
        public Span debug(String key, Object value) {
            return this;
        }

        @Override
        public Span info(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.PLAIN, TraceLevel.INFO);
            return this;
        }

        @Override
        public Span warn(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.PLAIN, TraceLevel.WARN);
            return this;
        }

        @Override
        public Span error(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.PLAIN, TraceLevel.ERROR);
            return this;
        }

        @Override
        public Span dataInDebug(String key, Object value) {
            return this;
        }

        @Override
        public Span dataInInfo(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.JSON, TraceLevel.INFO);
            return this;
        }

        @Override
        public Span dataInWarn(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.JSON, TraceLevel.WARN);
            return this;
        }

        @Override
        public Span dataInError(String key, Object value) {
            this.appendLabel(key, value, TraceLabelType.JSON, TraceLevel.ERROR);
            return this;
        }

        @Override
        public Span startTime(LocalDateTime startTime) {
            this.data.startTime = startTime;
            return this;
        }

        @Override
        public Span durationInMills(long durationInMills) {
            this.data.durationInMillis = durationInMills;
            return this;
        }

        @Override
        public void close() {
            if (this.data.durationInMillis == 0L) {
                this.data.durationInMillis = Duration.between(this.data.startTime, LocalDateTime.now()).toMillis();
            }
            TaskTracer taskTracer = TaskTracer.getLocal();
            taskTracer.closeSpan(this);
            this.data.labels = null;
        }
    }
}

