/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.trace;

import java.util.Map;
import kd.wtc.wtbs.business.task.trace.TraceLevel;
import kd.wtc.wtbs.common.util.WTCMaps;

public class TaskTraceConfig {
    private final TraceLevel level;
    private final boolean enabled;
    private final boolean enabledTaskConcurrencyCtrl;
    private final String taskType;
    private final Map<String, Integer> spanThresholdConfig;

    public TaskTraceConfig(String taskType, TraceLevel level, boolean enabled, boolean enabledTaskConcurrencyCtrl, Map<String, Integer> spanThresholdConfig) {
        this.level = level;
        this.enabled = enabled;
        this.taskType = taskType;
        this.enabledTaskConcurrencyCtrl = enabledTaskConcurrencyCtrl;
        this.spanThresholdConfig = spanThresholdConfig;
    }

    public TraceLevel getLevel() {
        return this.level;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public boolean isDebug() {
        return TraceLevel.DEBUG == this.level;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnableTaskConcurrencyCtrl() {
        return this.enabledTaskConcurrencyCtrl;
    }

    public boolean hasThresholdConfig() {
        return WTCMaps.isNotEmpty(this.spanThresholdConfig);
    }

    public Map<String, Integer> getSpanThresholdConfig() {
        return WTCMaps.unmodifiableMap(this.spanThresholdConfig);
    }
}

