/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.trace;

import java.util.HashMap;
import kd.bos.id.ID;
import kd.wtc.wtbs.business.calreport.CalReportParaHolder;
import kd.wtc.wtbs.business.task.trace.HugeLabelPublisher;
import kd.wtc.wtbs.business.task.trace.TaskTraceConfig;
import kd.wtc.wtbs.business.task.trace.TraceLevel;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;

class TaskTraceSupport {
    private static final int LABEL_VAL_MAX_LEN = 20000;
    private static final int LABEL_VAL_TRUNCATION_LEN = 200000;
    private static final String QUEUE_NAME = "wtbs_hugeLabel_queue";

    TaskTraceSupport() {
    }

    static boolean isHugeLabelValue(String labelValue) {
        return labelValue != null && labelValue.length() > 20000;
    }

    static long saveHugeLabelValue(long spanId, String labelValue) {
        long vid = ID.genLongId();
        HugeLabelPublisher.publish(QUEUE_NAME, new Tuple((Object)vid, (Object)TaskTraceSupport.truncatStr(labelValue)));
        return vid;
    }

    static String truncatStr(String originalStr) {
        if (originalStr.length() > 200000) {
            return WTCStringUtils.subStr((String)originalStr, (int)200000);
        }
        return originalStr;
    }

    static TaskTraceConfig getTaskTraceConfig(String taskType) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CalReportParaHolder calReportParaHolder = new CalReportParaHolder(taskType);
        map.put(CalcReportConstants.CALCULATE_PIPELINE, calReportParaHolder.getReportLineLimit());
        map.put("timeout", calReportParaHolder.getTimeOut());
        map.put("retrytimes", calReportParaHolder.getRetryTimes());
        return new TaskTraceConfig(taskType, TraceLevel.valueOf(calReportParaHolder.getLevel().name()), calReportParaHolder.isEnable(), calReportParaHolder.isEnableTaskConcurrencyCtrl(), map);
    }
}

