/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.task.trace;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import kd.bos.id.ID;
import kd.wtc.wtbs.business.task.trace.NoopSpan;
import kd.wtc.wtbs.business.task.trace.ReportNodePortable;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.SpanData;
import kd.wtc.wtbs.business.task.trace.SpanImpl;
import kd.wtc.wtbs.business.task.trace.TaskDesc;
import kd.wtc.wtbs.business.task.trace.TaskTraceConfig;
import kd.wtc.wtbs.business.task.trace.TaskTraceSupport;
import kd.wtc.wtbs.business.task.trace.TraceLevel;
import kd.wtc.wtbs.common.util.WTCAssert;

public class TaskTracer
implements AutoCloseable {
    final TaskDesc taskDesc;
    final TaskTraceConfig taskTraceConfig;
    private Stack<SpanImpl> spanStack;
    private Map<Long, Threshold> presentChildSpanCount;
    private static final ThreadLocal<TaskTracer> spanContext = new ThreadLocal();
    private final int index;
    private final Map<String, Integer> childTracerCountMap = new HashMap<String, Integer>(16);
    private static final int MAX_CHILD_SPAN = 50;
    ReportNodePortable reportNodePortable = new ReportNodePortable();

    TaskTracer(TaskDesc taskDesc, TaskTraceConfig taskTraceConfig, int index) {
        WTCAssert.nonNull((Object)taskDesc, (String)"taskDesc could not be null");
        WTCAssert.nonNull((Object)taskTraceConfig, (String)"taskTraceConfig could not be null");
        this.taskDesc = taskDesc;
        this.taskTraceConfig = taskTraceConfig;
        this.index = index;
        if (taskTraceConfig.isEnabled()) {
            this.spanStack = new Stack();
            this.presentChildSpanCount = new HashMap<Long, Threshold>();
        }
    }

    Span makeRootSpan() {
        if (this.isEnabled()) {
            long spanId = this.genId();
            String spanName = this.taskDesc.getVersion();
            SpanImpl.Info span = this.isDebugEnabled() ? new SpanImpl.Debug(spanName, spanId, this.taskDesc.getParentSpanId(), 0) : new SpanImpl.Info(spanName, spanId, this.taskDesc.getParentSpanId(), 0);
            this.reportNodePortable.rootReportNode(this.taskDesc, this.taskTraceConfig, span);
            this.spanStack.push(span);
            return span;
        }
        return new NoopSpan();
    }

    private long genId() {
        return ID.genLongId();
    }

    Span makeSpan(String spanName) {
        if (this.isEnabled()) {
            long spanId = this.genId();
            SpanImpl parentSpan = this.spanStack.peek();
            long parentSpanId = parentSpan.data.spanId;
            int depth = parentSpan.data.depth + 1;
            SpanImpl span = parentSpan instanceof SpanImpl.Exceed ? new SpanImpl.Exceed(spanName, spanId, parentSpanId, depth) : (this.checkExceed(spanName, parentSpanId) ? new SpanImpl.Exceed(spanName, spanId, parentSpanId, depth) : (this.isDebugEnabled() ? new SpanImpl.Debug(spanName, spanId, parentSpanId, depth) : new SpanImpl.Info(spanName, spanId, parentSpanId, depth)));
            this.spanStack.push(span);
            return span;
        }
        return new NoopSpan();
    }

    private boolean checkExceed(String spanName, long parentSpanId) {
        boolean exceed = false;
        Threshold threshold = this.presentChildSpanCount.computeIfAbsent(parentSpanId, pid -> new Threshold());
        if (threshold.childSpanCnt > 50 || this.index >= 50) {
            exceed = true;
        } else {
            if (this.taskTraceConfig.hasThresholdConfig()) {
                for (Map.Entry<String, Integer> spanThresholdConfig : this.taskTraceConfig.getSpanThresholdConfig().entrySet()) {
                    if (!spanName.contains(spanThresholdConfig.getKey())) continue;
                    int presentCount = threshold.childSpanCntWithSpecialName.getOrDefault(spanThresholdConfig.getKey(), 0) + 1;
                    if (spanThresholdConfig.getValue() < presentCount || spanThresholdConfig.getValue() <= this.index) {
                        exceed = true;
                        break;
                    }
                    threshold.childSpanCntWithSpecialName.put(spanThresholdConfig.getKey(), presentCount);
                    break;
                }
            }
            if (!exceed) {
                ++threshold.childSpanCnt;
            }
        }
        return exceed;
    }

    public boolean isDebugEnabled() {
        return TraceLevel.DEBUG.isNotBefore(this.taskTraceConfig.getLevel());
    }

    public boolean isEnabled() {
        return this.taskTraceConfig.isEnabled();
    }

    @Override
    public void close() {
        spanContext.remove();
        if (this.isEnabled()) {
            this.reportNodePortable.saveReport();
        }
    }

    public static TaskTracer makeTracer(TaskDesc taskDesc) {
        TaskTraceConfig taskTraceConfig = TaskTraceSupport.getTaskTraceConfig(taskDesc.getType());
        TaskTracer taskTracer = new TaskTracer(taskDesc, taskTraceConfig, 0);
        spanContext.set(taskTracer);
        return taskTracer;
    }

    public static Span newRootSpan() {
        TaskTracer local = TaskTracer.getLocal();
        if (local == null) {
            return new SpanImpl.Exceed("", 0L, 0L, 0);
        }
        return local.makeRootSpan();
    }

    public static Span newSpan(String spanName) {
        TaskTracer local = TaskTracer.getLocal();
        if (local == null) {
            return new SpanImpl.Exceed(spanName, 0L, 0L, 0);
        }
        return local.makeSpan(spanName);
    }

    public static TaskTracer getLocal() {
        return spanContext.get();
    }

    public TaskTraceConfig getTaskTraceConfig(String taskType) {
        return this.taskTraceConfig;
    }

    public static Runnable wrap(Runnable command) {
        return new TracerRunner(command, null);
    }

    public static Runnable wrap(Runnable command, String tracerType) {
        return new TracerRunner(command, tracerType);
    }

    public static <V> Callable<V> wrap(Callable<V> caller) {
        return new TraceCaller<V>(caller, null);
    }

    public static <V> Callable<V> wrap(Callable<V> caller, String tracerType) {
        return new TraceCaller<V>(caller, tracerType);
    }

    static TaskTracer childTracer(String tracerType) {
        TaskTracer parentTracer = spanContext.get();
        if (parentTracer == null) {
            return null;
        }
        int childIndex = 0;
        if (tracerType != null) {
            Map<String, Integer> childTracerCountMap = parentTracer.childTracerCountMap;
            Integer tracerCount = childTracerCountMap.getOrDefault(tracerType, 0);
            childIndex = tracerCount;
            childTracerCountMap.put(tracerType, tracerCount + 1);
        }
        TaskTracer taskTracer = new TaskTracer(parentTracer.taskDesc, parentTracer.taskTraceConfig, childIndex);
        taskTracer.reportNodePortable = parentTracer.reportNodePortable;
        if (parentTracer.taskTraceConfig.isEnabled()) {
            taskTracer.spanStack.push(parentTracer.spanStack.peek());
        }
        return taskTracer;
    }

    void closeSpan(Span span) {
        if (!(span instanceof SpanImpl.Exceed)) {
            this.reportNodePortable.addSpanData(((SpanImpl)span).data);
        }
        SpanData data = this.spanStack.pop().data;
        this.presentChildSpanCount.remove(data.spanId);
    }

    static class Threshold {
        Map<String, Integer> childSpanCntWithSpecialName = new HashMap<String, Integer>();
        int childSpanCnt = 0;

        Threshold() {
        }
    }

    static class TraceCaller<V>
    implements Callable<V> {
        TaskTracer taskTracer;
        Callable<V> caller;

        public TraceCaller(Callable<V> caller, String tracerType) {
            this.taskTracer = TaskTracer.childTracer(tracerType);
            this.caller = caller;
        }

        @Override
        public V call() throws Exception {
            spanContext.set(this.taskTracer);
            try {
                V v = this.caller.call();
                return v;
            }
            finally {
                spanContext.remove();
            }
        }
    }

    static class TracerRunner
    implements Runnable {
        TaskTracer taskTracer;
        Runnable command;

        public TracerRunner(Runnable command, String tracerType) {
            this.taskTracer = TaskTracer.childTracer(tracerType);
            this.command = command;
        }

        @Override
        public void run() {
            spanContext.set(this.taskTracer);
            try {
                this.command.run();
            }
            finally {
                spanContext.remove();
            }
        }
    }
}

