/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.business.timeseq;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqSupport;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;

public abstract class AbstractTimeSeqBo<T extends TimeSeqVersion>
implements TimeSeqBo<T> {
    @Override
    public long getBid() {
        if (this.isEmpty()) {
            return 0L;
        }
        return WTCCollectionIndexUtil.getEleFromList(this.getVersions(), (int)0).isPresent() ? ((TimeSeqVersion)WTCCollectionIndexUtil.getEleFromList(this.getVersions(), (int)0).get()).getBid() : 0L;
    }

    @Override
    public String getNumber() {
        if (this.isEmpty()) {
            return "";
        }
        return WTCCollectionIndexUtil.getEleFromList(this.getVersions(), (int)0).isPresent() ? ((TimeSeqVersion)WTCCollectionIndexUtil.getEleFromList(this.getVersions(), (int)0).get()).getNumber() : "";
    }

    @Override
    public boolean isEmpty() {
        return this.getVersions().isEmpty();
    }

    @Override
    public T getBoVersion() {
        return this.getVersionByDate(LocalDate.now());
    }

    @Override
    public T getVersionByDate(LocalDate inDate) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.isTimeSeq()) {
            return TimeSeqSupport.sliceVersionByDate(this.getVersions(), inDate);
        }
        return (T)((TimeSeqVersion)this.getVersions().get(0));
    }

    @Override
    public List<T> getVersionsBetweenDate(LocalDate fromDate, LocalDate toDate) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.isTimeSeq()) {
            return TimeSeqSupport.sliceVersionBetweenDate(this.getVersions(), fromDate, toDate);
        }
        return this.getVersions();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSeqBo)) {
            return false;
        }
        TimeSeqBo timeSeqBo = (TimeSeqBo)o;
        return this.isTimeSeq() == timeSeqBo.isTimeSeq() && this.getVersions().equals(timeSeqBo.getVersions());
    }

    public int hashCode() {
        return Objects.hash(this.isTimeSeq(), this.getVersions());
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        return "{bid=" + this.getBid() + ", number=" + this.getNumber() + ", versions=" + this.getVersions() + "}";
    }
}

